/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.tags;

import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.jsp.tagext.TagSupport;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.comparators.InstructionalOfferingComparator;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.security.rights.Right;

public class OfferingLocks
extends TagSupport {
    private static CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = 7947787141769725429L;

    public SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.pageContext.getServletContext());
    }

    public String getOfferingLocksWarning(SessionContext context, Session session) {
        if (!session.getStatusType().canLockOfferings()) {
            return null;
        }
        ArrayList<InstructionalOffering> lockedOfferings = new ArrayList<InstructionalOffering>();
        if (session.getLockedOfferings() == null) {
            return null;
        }
        for (Long offeringId : session.getLockedOfferings()) {
            InstructionalOffering io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(offeringId);
            if (io == null || !context.hasPermission(io, Right.OfferingCanUnlock)) continue;
            lockedOfferings.add(io);
        }
        if (lockedOfferings.isEmpty()) {
            return null;
        }
        Collections.sort(lockedOfferings, new InstructionalOfferingComparator(null));
        String course1 = null;
        String course2 = null;
        for (InstructionalOffering io : lockedOfferings) {
            if (course1 == null) {
                course1 = "<a href='instructionalOfferingDetail.do?io=" + io.getUniqueId() + "'>" + io.getCourseName() + "</a>";
                continue;
            }
            if (course2 != null) {
                course1 = course1 + ", " + course2;
            }
            course2 = "<a href='instructionalOfferingDetail.do?io=" + io.getUniqueId() + "'>" + io.getCourseName() + "</a>";
        }
        return course2 == null ? MSG.lockedCourse(course1) : MSG.lockedCourses(course1, course2);
    }

    public int doStartTag() {
        try {
            UserContext user = this.getSessionContext().getUser();
            if (user == null || user.getCurrentAcademicSessionId() == null || !user.getCurrentAuthority().hasRight(Right.OfferingCanUnlock)) {
                return 0;
            }
            Session acadSession = (Session)SessionDAO.getInstance().get(user.getCurrentAcademicSessionId());
            if (acadSession == null) {
                return 0;
            }
            String warns = this.getOfferingLocksWarning(this.getSessionContext(), acadSession);
            if (warns != null) {
                this.pageContext.getOut().println("<div class='unitime-PageWarn'>");
                this.pageContext.getOut().println(warns);
                this.pageContext.getOut().println("</div>");
            }
            return 0;
        }
        catch (Exception e) {
            Debug.error(e);
            return 0;
        }
    }

    public int doEndTag() {
        return 6;
    }
}

