/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.gwt;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.UnexpectedException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.gwt.shared.PageAccessException;

public class GwtDispatcherServlet
extends RemoteServiceServlet {
    private static final long serialVersionUID = 1L;

    public String processCall(String payload) throws SerializationException {
        try {
            Object handler = this.getBean(this.getThreadLocalRequest());
            RPCRequest rpcRequest = RPC.decodeRequest((String)payload, handler.getClass(), (SerializationPolicyProvider)this);
            this.onAfterRequestDeserialized(rpcRequest);
            try {
                return RPC.invokeAndEncodeResponse((Object)handler, (Method)rpcRequest.getMethod(), (Object[])rpcRequest.getParameters(), (SerializationPolicy)rpcRequest.getSerializationPolicy());
            }
            catch (UnexpectedException ex) {
                if (ex.getCause() instanceof AccessDeniedException) {
                    return RPC.encodeResponseForFailure((Method)rpcRequest.getMethod(), (Throwable)new PageAccessException(ex.getCause().getMessage()), (SerializationPolicy)rpcRequest.getSerializationPolicy());
                }
                throw ex;
            }
        }
        catch (IncompatibleRemoteServiceException ex) {
            return RPC.encodeResponseForFailure(null, (Throwable)ex);
        }
    }

    protected String getService(HttpServletRequest request) {
        String url = request.getRequestURI();
        String service = url.substring(url.lastIndexOf("/") + 1);
        return service;
    }

    protected Object getBean(HttpServletRequest request) {
        String service = this.getService(request);
        Object bean = this.getBean(service);
        return bean;
    }

    protected Object getBean(String name) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        return applicationContext.getBean(name);
    }
}

