/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.studentsct;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.ParallelSolver;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.Callback;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressListener;
import org.cpsolver.ifs.util.ProgressWriter;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.StudentSectioningXMLLoader;
import org.cpsolver.studentsct.StudentSectioningXMLSaver;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.online.expectations.NeverOverExpected;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.cpsolver.studentsct.report.SectionConflictTable;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.match.StudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.solver.remote.BackupFileFilter;
import org.unitime.timetable.solver.studentsct.StudentSectioningDatabaseLoader;
import org.unitime.timetable.solver.studentsct.StudentSectioningDatabaseSaver;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.MemoryCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentSolver
extends ParallelSolver<Request, Enrollment>
implements StudentSolverProxy {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static Log sLog = LogFactory.getLog(StudentSolver.class);
    private int iDebugLevel = 3;
    private boolean iWorking = false;
    private Date iLoadedDate = null;
    private StudentSolverDisposeListener iDisposeListener = null;
    private long iLastTimeStamp = System.currentTimeMillis();
    private boolean iIsPassivated = false;
    private Map iProgressBeforePassivation = null;
    private Map<String, String> iCurrentSolutionInfoBeforePassivation = null;
    private Map<String, String> iBestSolutionInfoBeforePassivation = null;
    private File iPassivationFolder = null;
    private String iPassivationPuid = null;
    private Thread iWorkThread = null;
    private transient Map<Long, XCourse> iCourseInfoCache = null;
    private Map<String, Object> iOnlineProperties = new HashMap<String, Object>();
    private AcademicSessionInfo iSession = null;
    private DistanceMetric iDistanceMetric = null;

    public StudentSolver(DataProperties properties, StudentSolverDisposeListener disposeListener) {
        super(properties);
        this.iDisposeListener = disposeListener;
    }

    @Override
    public Date getLoadedDate() {
        List log;
        if (this.iLoadedDate == null && !this.isPassivated() && (log = Progress.getInstance((Object)this.currentSolution().getModel()).getLog()) != null && !log.isEmpty()) {
            this.iLoadedDate = ((Progress.Message)log.get(0)).getDate();
        }
        return this.iLoadedDate;
    }

    @Override
    public String getLog() {
        return Progress.getInstance((Object)this.currentSolution().getModel()).getHtmlLog(this.iDebugLevel, true);
    }

    @Override
    public String getLog(int level, boolean includeDate) {
        return Progress.getInstance((Object)this.currentSolution().getModel()).getHtmlLog(level, includeDate);
    }

    @Override
    public String getLog(int level, boolean includeDate, String fromStage) {
        return Progress.getInstance((Object)this.currentSolution().getModel()).getHtmlLog(level, includeDate, fromStage);
    }

    @Override
    public void setDebugLevel(int level) {
        this.iDebugLevel = level;
    }

    @Override
    public int getDebugLevel() {
        return this.iDebugLevel;
    }

    @Override
    public boolean isWorking() {
        if (this.isRunning()) {
            return true;
        }
        return this.iWorking;
    }

    @Override
    public void restoreBest() {
        this.currentSolution().restoreBest();
    }

    @Override
    public void saveBest() {
        this.currentSolution().saveBest();
        if (this.currentSolution().getBestInfo() != null) {
            this.currentSolution().getBestInfo().putAll(this.currentSolution().getModel().getExtendedInfo(this.currentSolution().getAssignment()));
        }
    }

    @Override
    public Map getProgress() {
        if (this.isPassivated()) {
            return this.iProgressBeforePassivation;
        }
        try {
            Hashtable<String, Object> ret = new Hashtable<String, Object>();
            Progress p = Progress.getInstance((Object)super.currentSolution().getModel());
            ret.put("STATUS", p.getStatus());
            ret.put("PHASE", p.getPhase());
            ret.put("PROGRESS", new Long(p.getProgress()));
            ret.put("MAX_PROGRESS", new Long(p.getProgressMax()));
            ret.put("VERSION", Constants.getVersion());
            return ret;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setProperties(DataProperties properties) {
        this.activateIfNeeded();
        this.getProperties().putAll((Map)properties);
    }

    @Override
    public void dispose() {
        this.disposeNoInherit(true);
    }

    private void disposeNoInherit(boolean unregister) {
        super.dispose();
        if (this.currentSolution() != null && this.currentSolution().getModel() != null) {
            Progress.removeInstance((Object)this.currentSolution().getModel());
        }
        this.setInitalSolution(null);
        if (unregister && this.iDisposeListener != null) {
            this.iDisposeListener.onDispose();
        }
        this.clearCourseInfoTable();
    }

    @Override
    public String getHost() {
        return "local";
    }

    @Override
    public String getUser() {
        return this.getProperties().getProperty("General.OwnerPuid");
    }

    public Object exec(Object[] cmd) throws Exception {
        Class[] types = new Class[(cmd.length - 3) / 2];
        Object[] args = new Object[(cmd.length - 3) / 2];
        for (int i = 0; i < types.length; ++i) {
            types[i] = (Class)cmd[2 * i + 3];
            args[i] = cmd[2 * i + 4];
        }
        return this.getClass().getMethod((String)cmd[0], types).invoke((Object)this, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> currentSolutionInfo() {
        if (this.isPassivated()) {
            return this.iCurrentSolutionInfoBeforePassivation;
        }
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Map map = super.currentSolution().getExtendedInfo();
            Object var4_3 = null;
            lock.unlock();
            return map;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> bestSolutionInfo() {
        if (this.isPassivated()) {
            return this.iBestSolutionInfoBeforePassivation;
        }
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Map map = super.currentSolution().getBestInfo();
            Object var4_3 = null;
            lock.unlock();
            return map;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFinish() {
        super.onFinish();
        try {
            this.iWorking = true;
            if (this.currentSolution().getBestInfo() != null) {
                this.currentSolution().restoreBest();
            }
            if (this.currentSolution().getBestInfo() != null && this.getProperties().getPropertyBoolean("General.Save", false)) {
                StudentSectioningDatabaseSaver saver = new StudentSectioningDatabaseSaver((Solver)this);
                Lock lock = this.currentSolution().getLock().readLock();
                lock.lock();
                try {
                    try {
                        saver.save();
                    }
                    catch (Exception e) {
                        Progress.getInstance((Object)this.currentSolution().getModel()).error(e.getMessage(), (Throwable)e);
                        Object var5_4 = null;
                        lock.unlock();
                    }
                    Object var5_3 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            if (this.getProperties().getPropertyBoolean("General.Unload", false)) {
                this.dispose();
            } else {
                Progress.getInstance((Object)this.currentSolution().getModel()).setStatus("Awaiting commands ...");
            }
            Object var7_8 = null;
            this.iWorking = false;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.iWorking = false;
            throw throwable;
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.currentSolution().getBestInfo() != null) {
            this.currentSolution().restoreBest();
        }
    }

    @Override
    public void save() {
        this.iWorking = true;
        StudentSectioningDatabaseSaver saver = new StudentSectioningDatabaseSaver((Solver)this);
        saver.setCallback(this.getSavingDoneCallback());
        this.iWorkThread = new Thread((Runnable)((Object)saver));
        this.iWorkThread.setPriority(THREAD_PRIORITY);
        this.iWorkThread.start();
    }

    @Override
    public void load(DataProperties properties) {
        this.setProperties(properties);
        StudentSectioningModel model = new StudentSectioningModel(this.getProperties());
        Progress.getInstance((Object)model).addProgressListener((ProgressListener)new ProgressWriter(System.out));
        this.iWorking = true;
        this.setInitalSolution(new Solution((Model)model, (Assignment)new DefaultSingleAssignment()));
        this.initSolver();
        StudentSectioningDatabaseLoader loader = new StudentSectioningDatabaseLoader(model, (Assignment<Request, Enrollment>)this.currentSolution().getAssignment());
        loader.setCallback(this.getLoadingDoneCallback());
        this.iWorkThread = new Thread((Runnable)((Object)loader));
        this.iWorkThread.setPriority(THREAD_PRIORITY);
        this.iWorkThread.start();
    }

    @Override
    public void reload(DataProperties properties) {
        if (this.currentSolution() == null || this.currentSolution().getModel() == null) {
            this.load(properties);
            return;
        }
        Callback callBack = this.getReloadingDoneCallback();
        this.setProperties(properties);
        StudentSectioningModel model = new StudentSectioningModel(this.getProperties());
        this.iWorking = true;
        Progress.changeInstance((Object)this.currentSolution().getModel(), (Object)model);
        this.setInitalSolution(new Solution((Model)model, (Assignment)new DefaultSingleAssignment()));
        this.initSolver();
        StudentSectioningDatabaseLoader loader = new StudentSectioningDatabaseLoader(model, (Assignment<Request, Enrollment>)this.currentSolution().getAssignment());
        loader.setCallback(callBack);
        this.iWorkThread = new Thread((Runnable)((Object)loader));
        this.iWorkThread.start();
    }

    public Callback getLoadingDoneCallback() {
        return new LoadingDoneCallback();
    }

    public Callback getReloadingDoneCallback() {
        return new ReloadingDoneCallback();
    }

    public Callback getSavingDoneCallback() {
        return new SavingDoneCallback();
    }

    protected void afterSave() {
    }

    protected void afterLoad() {
    }

    protected void afterFinalSectioning() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean backup(File folder, String puid) {
        boolean bl;
        folder.mkdirs();
        if (this.currentSolution() == null) {
            return false;
        }
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        this.getProperties().setProperty("Xml.SaveBest", "true");
        this.getProperties().setProperty("Xml.SaveInitial", "true");
        this.getProperties().setProperty("Xml.SaveCurrent", "true");
        File outXmlFile = new File(folder, "sct_" + puid + BackupFileFilter.sXmlExtension);
        File outPropertiesFile = new File(folder, "sct_" + puid + BackupFileFilter.sPropertiesExtension);
        try {
            new StudentSectioningXMLSaver((Solver)this).save(outXmlFile);
            Iterator i = this.getProperties().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                if (!(entry.getKey() instanceof String)) {
                    sLog.error((Object)("Configuration key " + entry.getKey() + " is not of type String (" + entry.getKey().getClass() + ")"));
                    i.remove();
                    continue;
                }
                if (entry.getValue() instanceof String) continue;
                sLog.error((Object)("Value of configuration key " + entry.getKey() + " is not of type String (" + entry.getValue() + " is of type " + entry.getValue().getClass() + ")"));
                i.remove();
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(outPropertiesFile);
                this.getProperties().store((OutputStream)fos, "Backup file");
                fos.flush();
                fos.close();
                fos = null;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
            bl = true;
        }
        catch (Exception e) {
            try {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                if (outXmlFile.exists()) {
                    outXmlFile.delete();
                }
                if (outPropertiesFile.exists()) {
                    outPropertiesFile.delete();
                }
                Object var12_16 = null;
                lock.unlock();
                return false;
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                lock.unlock();
                throw throwable;
            }
        }
        Object var12_15 = null;
        lock.unlock();
        return bl;
    }

    @Override
    public boolean restore(File folder, String puid) {
        return this.restore(folder, puid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean restore(File folder, String puid, boolean removeFiles) {
        sLog.debug((Object)("restore(folder=" + folder + "," + puid + ",sct)"));
        File inXmlFile = new File(folder, "sct_" + puid + BackupFileFilter.sXmlExtension);
        File inPropertiesFile = new File(folder, "sct_" + puid + BackupFileFilter.sPropertiesExtension);
        StudentSectioningModel model = null;
        try {
            block8: {
                if (this.isRunning()) {
                    this.stopSolver();
                }
                this.disposeNoInherit(false);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(inPropertiesFile);
                    this.getProperties().load((InputStream)fis);
                    Object var9_9 = null;
                    if (fis == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (fis != null) {
                        fis.close();
                    }
                    throw throwable;
                }
                fis.close();
            }
            model = new StudentSectioningModel(this.getProperties());
            Progress.getInstance((Object)model).addProgressListener((ProgressListener)new ProgressWriter(System.out));
            this.setInitalSolution(new Solution((Model)model, (Assignment)new DefaultSingleAssignment()));
            this.initSolver();
            this.getProperties().setProperty("Xml.LoadBest", "true");
            this.getProperties().setProperty("Xml.LoadInitial", "true");
            this.getProperties().setProperty("Xml.LoadCurrent", "true");
            StudentSectioningXMLLoader loader = new StudentSectioningXMLLoader(model, this.currentSolution().getAssignment());
            loader.setInputFile(inXmlFile);
            loader.setCallback(new Callback(){

                public void execute() {
                    StudentSolver.this.saveBest();
                }
            });
            loader.load();
            Progress.getInstance((Object)model).setStatus("Awaiting commands ...");
            if (removeFiles) {
                inXmlFile.delete();
                inPropertiesFile.delete();
            }
            return true;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            if (model != null) {
                Progress.removeInstance(model);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            for (Request request : this.currentSolution().getModel().variables()) {
                this.currentSolution().getAssignment().unassign(0L, (Variable)request);
            }
            this.currentSolution().clearBest();
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Long getSessionId() {
        return this.getProperties().getPropertyLong("General.SessionId", null);
    }

    public Solution<Request, Enrollment> currentSolution() {
        this.activateIfNeeded();
        return super.currentSolution();
    }

    @Override
    public void start() {
        this.activateIfNeeded();
        super.start();
    }

    @Override
    public synchronized boolean isPassivated() {
        return this.iIsPassivated;
    }

    @Override
    public synchronized long timeFromLastUsed() {
        return System.currentTimeMillis() - this.iLastTimeStamp;
    }

    @Override
    public synchronized boolean activateIfNeeded() {
        this.iLastTimeStamp = System.currentTimeMillis();
        if (!this.isPassivated()) {
            return false;
        }
        sLog.debug((Object)("<activate " + this.iPassivationPuid + ">"));
        this.iIsPassivated = false;
        System.gc();
        sLog.debug((Object)(" -- memory usage before activation:" + Debug.getMem()));
        this.restore(this.iPassivationFolder, this.iPassivationPuid, true);
        System.gc();
        sLog.debug((Object)(" -- memory usage after activation:" + Debug.getMem()));
        return true;
    }

    @Override
    public synchronized boolean passivate(File folder, String puid) {
        if (this.isPassivated() || super.currentSolution() == null || super.currentSolution().getModel() == null) {
            return false;
        }
        sLog.debug((Object)("<passivate " + puid + ">"));
        System.gc();
        sLog.debug((Object)(" -- memory usage before passivation:" + Debug.getMem()));
        this.iProgressBeforePassivation = this.getProgress();
        if (this.iProgressBeforePassivation != null) {
            this.iProgressBeforePassivation.put("STATUS", "Pasivated");
        }
        this.iCurrentSolutionInfoBeforePassivation = this.currentSolutionInfo();
        this.iBestSolutionInfoBeforePassivation = this.bestSolutionInfo();
        this.iPassivationFolder = folder;
        this.iPassivationPuid = puid;
        this.backup(this.iPassivationFolder, this.iPassivationPuid);
        this.disposeNoInherit(false);
        System.gc();
        sLog.debug((Object)(" -- memory usage after passivation:" + Debug.getMem()));
        this.iIsPassivated = true;
        return true;
    }

    @Override
    public synchronized boolean passivateIfNeeded(File folder, String puid) {
        long inactiveTimeToPassivate = 60000L * (long)ApplicationProperty.SolverPasivationTime.intValue().intValue();
        if (this.isPassivated() || inactiveTimeToPassivate <= 0L || this.timeFromLastUsed() < inactiveTimeToPassivate || this.isWorking()) {
            return false;
        }
        return this.passivate(folder, puid);
    }

    @Override
    public Date getLastUsed() {
        return new Date(this.iLastTimeStamp);
    }

    @Override
    public void interrupt() {
        try {
            if (this.iSolverThread != null) {
                this.iStop = true;
                if (this.iSolverThread.isAlive() && !this.iSolverThread.isInterrupted()) {
                    this.iSolverThread.interrupt();
                }
            }
            if (this.iWorkThread != null && this.iWorkThread.isAlive() && !this.iWorkThread.isInterrupted()) {
                this.iWorkThread.interrupt();
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to interrupt the solver, reason: " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> statusSolutionInfo() {
        if (this.isPassivated()) {
            return this.iBestSolutionInfoBeforePassivation == null ? this.iCurrentSolutionInfoBeforePassivation : this.iBestSolutionInfoBeforePassivation;
        }
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            Map info = super.currentSolution().getBestInfo();
            try {
                if (info == null || this.getSolutionComparator().isBetterThanBestSolution(super.currentSolution())) {
                    info = super.currentSolution().getModel().getInfo(super.currentSolution().getAssignment());
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            Map map = info;
            Object var5_5 = null;
            lock.unlock();
            return map;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcademicSessionInfo getAcademicSession() {
        if (this.iSession == null) {
            org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();
            try {
                this.iSession = new AcademicSessionInfo((Session)SessionDAO.getInstance().get(this.getSessionId(), hibSession));
                this.iSession.setSectioningEnabled(false);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            {
            }
        }
        return this.iSession;
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        if (this.iDistanceMetric == null) {
            this.iDistanceMetric = new DistanceMetric(this.getProperties());
            TravelTime.populateTravelTimes(this.iDistanceMetric);
        }
        return this.iDistanceMetric;
    }

    @Override
    public DataProperties getConfig() {
        return this.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, XCourse> getCourseInfoTable() {
        if (this.iCourseInfoCache == null) {
            org.hibernate.Session hibSession = CourseOfferingDAO.getInstance().createNewSession();
            try {
                this.iCourseInfoCache = new Hashtable<Long, XCourse>();
                for (CourseOffering course : hibSession.createQuery("from CourseOffering x where x.subjectArea.session.uniqueId = :sessionId").setLong("sessionId", this.getSessionId().longValue()).setCacheable(true).list()) {
                    this.iCourseInfoCache.put(course.getUniqueId(), new XCourse(course));
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            {
            }
        }
        return this.iCourseInfoCache;
    }

    private void clearCourseInfoTable() {
        this.iCourseInfoCache = null;
    }

    public Collection<XCourseId> findCourses(String query, Integer limit, CourseMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        ArrayList<XCourseId> ret = new ArrayList<XCourseId>(limit == null ? 100 : limit);
        String queryInLowerCase = query.toLowerCase();
        for (XCourse c : this.getCourseInfoTable().values()) {
            if (c.matchCourseName(queryInLowerCase) && (matcher == null || matcher.match(c))) {
                ret.add(c);
            }
            if (limit == null || ret.size() != limit.intValue()) continue;
            return ret;
        }
        if (queryInLowerCase.length() > 2) {
            for (XCourse c : this.getCourseInfoTable().values()) {
                if (c.matchTitle(queryInLowerCase) && (matcher == null || matcher.match(c))) {
                    ret.add(c);
                }
                if (limit == null || ret.size() != limit.intValue()) continue;
                return ret;
            }
        }
        return ret;
    }

    public Collection<XCourseId> findCourses(CourseMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        ArrayList<XCourseId> ret = new ArrayList<XCourseId>();
        for (XCourse c : this.getCourseInfoTable().values()) {
            if (!matcher.match(c)) continue;
            ret.add(c);
        }
        return ret;
    }

    public Collection<XStudentId> findStudents(StudentMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        ArrayList<XStudentId> ret = new ArrayList<XStudentId>();
        for (Student student : ((StudentSectioningModel)this.currentSolution().getModel()).getStudents()) {
            if (student.isDummy()) continue;
            XStudentId s = new XStudentId(student);
            if (student.isDummy() || !matcher.match(s)) continue;
            ret.add(s);
        }
        return ret;
    }

    @Override
    public XCourse getCourse(Long courseId) {
        return this.getCourseInfoTable().get(courseId);
    }

    @Override
    public XCourse getCourse(String courseName) {
        for (Offering offering : ((StudentSectioningModel)this.currentSolution().getModel()).getOfferings()) {
            for (Course course : offering.getCourses()) {
                if (!course.getName().equalsIgnoreCase(courseName)) continue;
                return this.getCourse(course.getId());
            }
        }
        return null;
    }

    @Override
    public XStudent getStudent(Long studentId) {
        for (Student student : ((StudentSectioningModel)this.currentSolution().getModel()).getStudents()) {
            if (student.isDummy() || student.getId() != studentId.longValue()) continue;
            return new XStudent(student, (Assignment<Request, Enrollment>)this.currentSolution().getAssignment());
        }
        return null;
    }

    @Override
    public XOffering getOffering(Long offeringId) {
        for (Offering offering : ((StudentSectioningModel)this.currentSolution().getModel()).getOfferings()) {
            if (offering.getId() != offeringId.longValue()) continue;
            return new XOffering(offering, ((StudentSectioningModel)this.currentSolution().getModel()).getLinkedSections());
        }
        return null;
    }

    @Override
    public <X extends OnlineSectioningAction> X createAction(Class<X> clazz) {
        try {
            return (X)((OnlineSectioningAction)clazz.newInstance());
        }
        catch (InstantiationException e) {
            throw new SectioningException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SectioningException(e.getMessage(), e);
        }
    }

    @Override
    public <E> E execute(OnlineSectioningAction<E> action, OnlineSectioningLog.Entity user) throws SectioningException {
        E e;
        OnlineSectioningHelper h;
        block18: {
            long c0 = OnlineSectioningHelper.getCpuTime();
            h = new OnlineSectioningHelper(user);
            try {
                h.addMessageHandler(new OnlineSectioningHelper.DefaultMessageLogger(LogFactory.getLog((String)(action.getClass().getName() + "." + action.name() + "[" + this.getAcademicSession().toCompactString() + "]"))));
                h.addAction(action, this.getAcademicSession());
                E ret = action.execute(this, h);
                if (h.getAction() != null && !h.getAction().hasResult()) {
                    if (ret == null) {
                        h.getAction().setResult(OnlineSectioningLog.Action.ResultType.NULL);
                    } else if (ret instanceof Boolean) {
                        h.getAction().setResult((Boolean)ret != false ? OnlineSectioningLog.Action.ResultType.TRUE : OnlineSectioningLog.Action.ResultType.FALSE);
                    } else {
                        h.getAction().setResult(OnlineSectioningLog.Action.ResultType.SUCCESS);
                    }
                }
                e = ret;
                Object var9_8 = null;
                if (h.getAction() == null) break block18;
                h.getAction().setEndTime(System.currentTimeMillis()).setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
            }
            catch (Exception e2) {
                try {
                    if (e2 instanceof SectioningException) {
                        if (e2.getCause() == null) {
                            h.info("Execution failed: " + e2.getMessage());
                        } else {
                            h.warn("Execution failed: " + e2.getMessage(), e2.getCause());
                        }
                    } else {
                        h.error("Execution failed: " + e2.getMessage(), e2);
                    }
                    if (h.getAction() != null) {
                        h.getAction().setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                        if (e2.getCause() != null && e2 instanceof SectioningException) {
                            h.getAction().addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e2.getCause().getClass().getName() + ": " + e2.getCause().getMessage()));
                        } else {
                            h.getAction().addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e2.getMessage() == null ? "null" : e2.getMessage()));
                        }
                    }
                    if (e2 instanceof SectioningException) {
                        throw (SectioningException)e2;
                    }
                    throw new SectioningException(MSG.exceptionUnknown(e2.getMessage()), e2);
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (h.getAction() != null) {
                        h.getAction().setEndTime(System.currentTimeMillis()).setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                    }
                    sLog.debug((Object)("Executed: " + h.getLog() + " (" + h.getLog().toByteArray().length + " bytes)"));
                    throw throwable;
                }
            }
        }
        sLog.debug((Object)("Executed: " + h.getLog() + " (" + h.getLog().toByteArray().length + " bytes)"));
        return e;
    }

    @Override
    public <E> void execute(OnlineSectioningAction<E> action, OnlineSectioningLog.Entity user, OnlineSectioningServer.ServerCallback<E> callback) throws SectioningException {
        try {
            callback.onSuccess(this.execute(action, user));
        }
        catch (Throwable t) {
            callback.onFailure(t);
        }
    }

    @Override
    public void clearAll() {
    }

    @Override
    public void clearAllStudents() {
    }

    @Override
    public OnlineSectioningServer.Lock readLock() {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock writeLock() {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockAll() {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockStudent(Long studentId, Collection<Long> offeringIds, String actionName) {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockOffering(Long offeringId, Collection<Long> studentIds, String actionName) {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockRequest(CourseRequestInterface request, String actionName) {
        return new NoLock();
    }

    @Override
    public boolean isOfferingLocked(Long offeringId) {
        return false;
    }

    @Override
    public void lockOffering(Long offeringId) {
    }

    @Override
    public void unlockOffering(Long offeringId) {
    }

    @Override
    public Collection<Long> getLockedOfferings() {
        return null;
    }

    @Override
    public void releaseAllOfferingLocks() {
    }

    @Override
    public void persistExpectedSpaces(Long offeringId) {
    }

    @Override
    public List<Long> getOfferingsToPersistExpectedSpaces(long minimalAge) {
        return null;
    }

    @Override
    public void unload() {
    }

    @Override
    public boolean needPersistExpectedSpaces(Long offeringId) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] exportXml() throws Exception {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            File temp = File.createTempFile("student-" + this.getSessionId(), ".xml");
            boolean anonymize = ApplicationProperty.SolverXMLExportNames.isFalse();
            boolean idconv = ApplicationProperty.SolverXMLExportConvertIds.isTrue();
            this.getProperties().setProperty("Xml.SaveBest", "true");
            this.getProperties().setProperty("Xml.SaveInitial", "true");
            this.getProperties().setProperty("Xml.SaveCurrent", "true");
            if (anonymize) {
                this.getProperties().setProperty("Xml.ConvertIds", idconv ? "true" : "false");
                this.getProperties().setProperty("Xml.SaveOnlineSectioningInfo", "true");
                this.getProperties().setProperty("Xml.SaveStudentInfo", "false");
                this.getProperties().setProperty("Xml.ShowNames", "false");
            }
            StudentSectioningXMLSaver saver = new StudentSectioningXMLSaver((Solver)this);
            ByteArrayOutputStream ret = new ByteArrayOutputStream();
            try {
                saver.save(temp);
                FileInputStream fis = new FileInputStream(temp);
                byte[] buf = new byte[16384];
                int read = 0;
                while ((read = fis.read(buf, 0, buf.length)) > 0) {
                    ret.write(buf, 0, read);
                }
                ret.flush();
                ret.close();
                fis.close();
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
            }
            temp.delete();
            if (anonymize) {
                this.getProperties().setProperty("Xml.ConvertIds", "false");
                this.getProperties().setProperty("Xml.SaveOnlineSectioningInfo", "true");
                this.getProperties().setProperty("Xml.SaveStudentInfo", "true");
                this.getProperties().setProperty("Xml.ShowNames", "true");
            }
            byte[] byArray = ret.toByteArray();
            Object var11_11 = null;
            lock.unlock();
            return byArray;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public boolean isMaster() {
        return true;
    }

    @Override
    public void releaseMasterLockIfHeld() {
    }

    @Override
    public Collection<XCourseRequest> getRequests(Long offeringId) {
        ArrayList<XCourseRequest> ret = new ArrayList<XCourseRequest>();
        for (Offering offering : ((StudentSectioningModel)this.currentSolution().getModel()).getOfferings()) {
            if (offering.getId() != offeringId.longValue()) continue;
            for (Course course : offering.getCourses()) {
                for (CourseRequest req : course.getRequests()) {
                    if (req.getStudent().isDummy()) continue;
                    ret.add(new XCourseRequest(req, (Enrollment)this.currentSolution().getAssignment().getValue((Variable)req)));
                }
            }
        }
        return ret;
    }

    @Override
    public XEnrollments getEnrollments(Long offeringId) {
        return new XEnrollments(offeringId, this.getRequests(offeringId));
    }

    @Override
    public XExpectations getExpectations(Long offeringId) {
        for (Offering offering : ((StudentSectioningModel)this.currentSolution().getModel()).getOfferings()) {
            if (offering.getId() != offeringId.longValue()) continue;
            return new XExpectations(offering);
        }
        return null;
    }

    @Override
    public void update(XExpectations expectations) {
    }

    @Override
    public void remove(XStudent student) {
    }

    @Override
    public void update(XStudent student, boolean updateRequests) {
    }

    @Override
    public void remove(XOffering offering) {
    }

    @Override
    public void update(XOffering offering) {
    }

    @Override
    public XCourseRequest assign(XCourseRequest request, XEnrollment enrollment) {
        return request;
    }

    @Override
    public XCourseRequest waitlist(XCourseRequest request, boolean waitlist) {
        return request;
    }

    @Override
    public boolean checkDeadline(Long courseId, XTime sectionTime, OnlineSectioningServer.Deadline type) {
        return true;
    }

    @Override
    public String getCourseDetails(Long courseId, CourseDetailsProvider provider) {
        XCourse course = this.getCourse(courseId);
        return course == null ? null : course.getDetails(this.getAcademicSession(), provider);
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public long getMemUsage() {
        return new MemoryCounter().estimate(this);
    }

    @Override
    public <E> E getProperty(String name, E defaultValue) {
        Object ret = this.iOnlineProperties.get(name);
        return (E)(ret == null ? defaultValue : ret);
    }

    @Override
    public <E> void setProperty(String name, E value) {
        if (value == null) {
            this.iOnlineProperties.remove(name);
        } else {
            this.iOnlineProperties.put(name, value);
        }
    }

    @Override
    public CSVFile getReport(DataProperties parameters) {
        try {
            String name = parameters.getProperty("report", SectionConflictTable.class.getName());
            Class<?> clazz = Class.forName(name);
            StudentSectioningReport report = (StudentSectioningReport)clazz.getConstructor(StudentSectioningModel.class).newInstance(this.currentSolution().getModel());
            return report.create(this.currentSolution().getAssignment(), parameters);
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage(), e);
        }
    }

    @Override
    public OverExpectedCriterion getOverExpectedCriterion() {
        return new NeverOverExpected(this.getConfig());
    }

    public static class NoLock
    implements OnlineSectioningServer.Lock {
        public void release() {
        }
    }

    public static interface StudentSolverDisposeListener {
        public void onDispose();
    }

    public class SavingDoneCallback
    implements Callback {
        public void execute() {
            StudentSolver.this.iWorking = false;
            StudentSolver.this.afterSave();
            Progress.getInstance((Object)StudentSolver.this.currentSolution().getModel()).setStatus("Awaiting commands ...");
        }
    }

    public class LoadingDoneCallback
    implements Callback {
        public void execute() {
            StudentSolver.this.iLoadedDate = new Date();
            StudentSolver.this.iWorking = false;
            StudentSolver.this.afterLoad();
            Progress.getInstance((Object)StudentSolver.this.currentSolution().getModel()).setStatus("Awaiting commands ...");
            if (StudentSolver.this.getProperties().getPropertyBoolean("General.StartSolver", false)) {
                StudentSolver.this.start();
            }
        }
    }

    public class ReloadingDoneCallback
    implements Callback {
        Map<Long, Map<Long, Enrollment>> iCurrentAssignmentTable = new Hashtable<Long, Map<Long, Enrollment>>();
        Map<Long, Map<Long, Enrollment>> iBestAssignmentTable = new Hashtable<Long, Map<Long, Enrollment>>();
        Map<Long, Map<Long, Enrollment>> iInitialAssignmentTable = new Hashtable<Long, Map<Long, Enrollment>>();
        String iSolutionId = null;
        Progress iProgress = null;

        public ReloadingDoneCallback() {
            this.iSolutionId = StudentSolver.this.getProperties().getProperty("General.SolutionId");
            for (Request request : StudentSolver.this.currentSolution().getModel().variables()) {
                Map<Long, Enrollment> assignments;
                Enrollment enrollment = (Enrollment)StudentSolver.this.currentSolution().getAssignment().getValue((Variable)request);
                if (enrollment != null) {
                    assignments = this.iCurrentAssignmentTable.get(request.getStudent().getId());
                    if (assignments == null) {
                        assignments = new Hashtable<Long, Enrollment>();
                        this.iCurrentAssignmentTable.put(request.getStudent().getId(), assignments);
                    }
                    assignments.put(request.getId(), enrollment);
                }
                if (request.getBestAssignment() != null) {
                    assignments = this.iBestAssignmentTable.get(request.getStudent().getId());
                    if (assignments == null) {
                        assignments = new Hashtable<Long, Enrollment>();
                        this.iBestAssignmentTable.put(request.getStudent().getId(), assignments);
                    }
                    assignments.put(request.getId(), (Enrollment)request.getBestAssignment());
                }
                if (request.getInitialAssignment() == null) continue;
                assignments = this.iInitialAssignmentTable.get(request.getStudent().getId());
                if (assignments == null) {
                    assignments = new Hashtable<Long, Enrollment>();
                    this.iInitialAssignmentTable.put(request.getStudent().getId(), assignments);
                }
                assignments.put(request.getId(), (Enrollment)request.getInitialAssignment());
            }
        }

        private Enrollment getEnrollment(Request request, Enrollment enrollment) {
            if (request instanceof FreeTimeRequest) {
                return ((FreeTimeRequest)request).createEnrollment();
            }
            CourseRequest cr = (CourseRequest)request;
            HashSet<Section> sections = new HashSet<Section>();
            for (Section s : enrollment.getSections()) {
                Section section = cr.getSection(s.getId());
                if (section == null) {
                    this.iProgress.warn("WARNING: Section " + s.getName() + " is not available for " + cr.getName());
                    return null;
                }
                sections.add(section);
            }
            return cr.createEnrollment(StudentSolver.this.currentSolution().getAssignment(), sections);
        }

        private void assign(Enrollment enrollment) {
            Map conflictConstraints = StudentSolver.this.currentSolution().getModel().conflictConstraints(StudentSolver.this.currentSolution().getAssignment(), (Value)enrollment);
            if (conflictConstraints.isEmpty()) {
                StudentSolver.this.currentSolution().getAssignment().assign(0L, (Value)enrollment);
            } else {
                this.iProgress.warn("Unable to assign " + ((Request)enrollment.variable()).getName() + " := " + enrollment.getName());
                this.iProgress.warn("&nbsp;&nbsp;Reason:");
                for (Constraint c : conflictConstraints.keySet()) {
                    Set vals = (Set)conflictConstraints.get(c);
                    for (Enrollment enrl : vals) {
                        this.iProgress.warn("&nbsp;&nbsp;&nbsp;&nbsp;" + enrl.getRequest().getName() + " = " + enrl.getName());
                    }
                    this.iProgress.debug("&nbsp;&nbsp;&nbsp;&nbsp;in constraint " + c);
                }
            }
        }

        private void unassignAll() {
            for (Request request : StudentSolver.this.currentSolution().getModel().variables()) {
                StudentSolver.this.currentSolution().getAssignment().unassign(0L, (Variable)request);
            }
        }

        public void execute() {
            Enrollment enrollment;
            Request request;
            Map r;
            this.iProgress = Progress.getInstance((Object)StudentSolver.this.currentSolution().getModel());
            Hashtable<Long, Hashtable<Long, Request>> requests = new Hashtable<Long, Hashtable<Long, Request>>();
            for (Request request2 : StudentSolver.this.currentSolution().getModel().variables()) {
                r = (Hashtable<Long, Request>)requests.get(request2.getStudent().getId());
                if (r == null) {
                    r = new Hashtable<Long, Request>();
                    requests.put(request2.getStudent().getId(), (Hashtable<Long, Request>)r);
                }
                r.put(request2.getId(), request2);
            }
            if (!this.iBestAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating best assignment ...", (long)this.iBestAssignmentTable.size());
                this.unassignAll();
                for (Map.Entry entry : this.iBestAssignmentTable.entrySet()) {
                    r = (Map)requests.get(entry.getKey());
                    this.iProgress.incProgress();
                    if (r == null) continue;
                    for (Map.Entry e2 : ((Map)entry.getValue()).entrySet()) {
                        request = (Request)r.get(e2.getKey());
                        if (request == null || (enrollment = this.getEnrollment(request, (Enrollment)e2.getValue())) == null) continue;
                        this.assign(enrollment);
                    }
                }
                StudentSolver.this.currentSolution().saveBest();
            }
            if (!this.iInitialAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating initial assignment ...", (long)this.iInitialAssignmentTable.size());
                for (Map.Entry entry : this.iInitialAssignmentTable.entrySet()) {
                    r = (Map)requests.get(entry.getKey());
                    this.iProgress.incProgress();
                    if (r == null) continue;
                    for (Map.Entry e2 : ((Map)entry.getValue()).entrySet()) {
                        request = (Request)r.get(e2.getKey());
                        if (request == null || (enrollment = this.getEnrollment(request, (Enrollment)e2.getValue())) == null) continue;
                        request.setInitialAssignment((Value)enrollment);
                    }
                }
            }
            if (!this.iCurrentAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating current assignment ...", (long)this.iCurrentAssignmentTable.size());
                this.unassignAll();
                for (Map.Entry entry : this.iCurrentAssignmentTable.entrySet()) {
                    r = (Map)requests.get(entry.getKey());
                    this.iProgress.incProgress();
                    if (r == null) continue;
                    for (Map.Entry e2 : ((Map)entry.getValue()).entrySet()) {
                        request = (Request)r.get(e2.getKey());
                        if (request == null || (enrollment = this.getEnrollment(request, (Enrollment)e2.getValue())) == null) continue;
                        this.assign(enrollment);
                    }
                }
            }
            this.iCurrentAssignmentTable.clear();
            this.iBestAssignmentTable.clear();
            this.iInitialAssignmentTable.clear();
            this.iProgress = null;
            if (this.iSolutionId != null) {
                StudentSolver.this.getProperties().setProperty("General.SolutionId", this.iSolutionId);
            }
            StudentSolver.this.iLoadedDate = new Date();
            StudentSolver.this.iWorking = false;
            StudentSolver.this.afterLoad();
            Progress.getInstance((Object)StudentSolver.this.currentSolution().getModel()).setStatus("Awaiting commands ...");
        }
    }
}

