/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.studentsct;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningLoader;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.AcademicAreaCode;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Transaction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.model.AcademicAreaClassification;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SectioningInfo;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.model.base.BaseAcademicClassification;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.base.BaseStudent;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.solver.TimetableDatabaseLoader;
import org.unitime.timetable.solver.curricula.LastLikeStudentCourseDemands;
import org.unitime.timetable.solver.curricula.ProjectedStudentCourseDemands;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.NameFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentSectioningDatabaseLoader
extends StudentSectioningLoader {
    private static Log sLog = LogFactory.getLog(StudentSectioningDatabaseLoader.class);
    private boolean iIncludeCourseDemands = true;
    private boolean iIncludeUseCommittedAssignments = false;
    private boolean iMakeupAssignmentsFromRequiredPrefs = false;
    private boolean iLoadStudentInfo = true;
    private String iInitiative = null;
    private String iTerm = null;
    private String iYear = null;
    private Long iSessionId = null;
    private long iMakeupAssignmentId = 0L;
    private BitSet iFreeTimePattern = null;
    private Date iDatePatternFirstDate = null;
    private boolean iTweakLimits = false;
    private boolean iLoadSectioningInfos = false;
    private boolean iProjections = false;
    private boolean iFixWeights = true;
    private boolean iCheckForNoBatchStatus = true;
    private boolean iCheckEnabledForScheduling = true;
    private boolean iLoadRequestGroups = false;
    private Progress iProgress = null;
    private StudentCourseDemands iStudentCourseDemands = null;
    private boolean iUseAmPm = true;
    Map<Long, Map<String, Integer>> iCourse2Curricula2Weight = new Hashtable<Long, Map<String, Integer>>();

    public StudentSectioningDatabaseLoader(StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
        super(model, assignment);
        this.iIncludeCourseDemands = model.getProperties().getPropertyBoolean("Load.IncludeCourseDemands", this.iIncludeCourseDemands);
        this.iIncludeUseCommittedAssignments = model.getProperties().getPropertyBoolean("Load.IncludeUseCommittedAssignments", this.iIncludeUseCommittedAssignments);
        this.iLoadStudentInfo = model.getProperties().getPropertyBoolean("Load.LoadStudentInfo", this.iLoadStudentInfo);
        this.iMakeupAssignmentsFromRequiredPrefs = model.getProperties().getPropertyBoolean("Load.MakeupAssignmentsFromRequiredPrefs", this.iMakeupAssignmentsFromRequiredPrefs);
        this.iInitiative = model.getProperties().getProperty("Data.Initiative");
        this.iYear = model.getProperties().getProperty("Data.Year");
        this.iTerm = model.getProperties().getProperty("Data.Term");
        this.iSessionId = model.getProperties().getPropertyLong("General.SessionId", null);
        this.iTweakLimits = model.getProperties().getPropertyBoolean("Load.TweakLimits", this.iTweakLimits);
        this.iLoadSectioningInfos = model.getProperties().getPropertyBoolean("Load.LoadSectioningInfos", this.iLoadSectioningInfos);
        this.iProgress = Progress.getInstance((Object)this.getModel());
        this.iFixWeights = model.getProperties().getPropertyBoolean("Load.FixWeights", this.iFixWeights);
        this.iCheckForNoBatchStatus = model.getProperties().getPropertyBoolean("Load.CheckForNoBatchStatus", this.iCheckForNoBatchStatus);
        this.iCheckEnabledForScheduling = model.getProperties().getPropertyBoolean("Load.CheckEnabledForScheduling", this.iCheckEnabledForScheduling);
        this.iLoadRequestGroups = model.getProperties().getPropertyBoolean("Load.RequestGroups", this.iLoadRequestGroups);
        try {
            String studentCourseDemandsClassName = this.getModel().getProperties().getProperty("StudentSct.ProjectedCourseDemadsClass", LastLikeStudentCourseDemands.class.getName());
            if (studentCourseDemandsClassName.indexOf(32) >= 0) {
                studentCourseDemandsClassName = studentCourseDemandsClassName.replace(" ", "");
            }
            if (studentCourseDemandsClassName.indexOf(46) < 0) {
                studentCourseDemandsClassName = "org.unitime.timetable.solver.curricula." + studentCourseDemandsClassName;
            }
            Class<?> studentCourseDemandsClass = Class.forName(studentCourseDemandsClassName);
            this.iStudentCourseDemands = (StudentCourseDemands)studentCourseDemandsClass.getConstructor(DataProperties.class).newInstance(this.getModel().getProperties());
            this.iProgress.info("Projected demands: " + this.getModel().getProperties().getProperty("StudentSct.ProjectedCourseDemadsClass", LastLikeStudentCourseDemands.class.getName()));
        }
        catch (Exception e) {
            if (model.getProperties().getPropertyBoolean("Load.IncludeLastLikeStudents", false)) {
                this.iStudentCourseDemands = new ProjectedStudentCourseDemands(model.getProperties());
                this.iProgress.info("Projected demands: Projected Student Course Demands");
            }
            this.iProgress.info("Projected demands: None");
        }
        this.iProjections = "Projection".equals(model.getProperties().getProperty("StudentSctBasic.Mode", "Initial"));
        this.iUseAmPm = model.getProperties().getPropertyBoolean("General.UseAmPm", this.iUseAmPm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() {
        this.iProgress.setStatus("Loading input data ...");
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        try {
            try {
                hibSession = SessionDAO.getInstance().getSession();
                hibSession.setCacheMode(CacheMode.IGNORE);
                hibSession.setFlushMode(FlushMode.MANUAL);
                tx = hibSession.beginTransaction();
                Session session = null;
                if (this.iSessionId != null) {
                    session = (Session)SessionDAO.getInstance().get(this.iSessionId);
                    if (session != null) {
                        this.iYear = session.getAcademicYear();
                        this.iTerm = session.getAcademicTerm();
                        this.iInitiative = session.getAcademicInitiative();
                        this.getModel().getProperties().setProperty("Data.Year", this.iYear);
                        this.getModel().getProperties().setProperty("Data.Term", this.iTerm);
                        this.getModel().getProperties().setProperty("Data.Initiative", this.iInitiative);
                    }
                } else {
                    session = Session.getSessionUsingInitiativeYearTerm(this.iInitiative, this.iYear, this.iTerm);
                    if (session != null) {
                        this.iSessionId = session.getUniqueId();
                        this.getModel().getProperties().setProperty("General.SessionId", String.valueOf(this.iSessionId));
                    }
                }
                if (session == null) {
                    throw new Exception("Session " + this.iInitiative + " " + this.iTerm + this.iYear + " not found!");
                }
                this.iProgress.info("Loading data for " + this.iInitiative + " " + this.iTerm + this.iYear + "...");
                if (this.getModel().getDistanceConflict() != null) {
                    TravelTime.populateTravelTimes(this.getModel().getDistanceConflict().getDistanceMetric(), this.iSessionId, hibSession);
                }
                this.load(session, hibSession);
                tx.commit();
            }
            catch (Exception e) {
                this.iProgress.fatal("Unable to load sectioning problem, reason: " + e.getMessage(), (Throwable)e);
                sLog.error((Object)e.getMessage(), (Throwable)e);
                tx.rollback();
                Object var5_6 = null;
                if (hibSession == null) return;
                if (!hibSession.isOpen()) return;
                hibSession.close();
                return;
            }
            Object var5_5 = null;
            if (hibSession == null) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (hibSession == null) throw throwable;
            if (!hibSession.isOpen()) throw throwable;
            hibSession.close();
            throw throwable;
        }
        if (!hibSession.isOpen()) return;
        hibSession.close();
    }

    private String getInstructorIds(Class_ clazz) {
        if (!clazz.isDisplayInstructor().booleanValue()) {
            return null;
        }
        String ret = null;
        TreeSet<ClassInstructor> ts = new TreeSet<ClassInstructor>(clazz.getClassInstructors());
        for (ClassInstructor ci : ts) {
            if (!ci.isLead().booleanValue()) continue;
            if (ret == null) {
                ret = ci.getInstructor().getUniqueId().toString();
                continue;
            }
            ret = ret + ":" + ci.getInstructor().getUniqueId().toString();
        }
        return ret;
    }

    private String getInstructorNames(Class_ clazz) {
        if (!clazz.isDisplayInstructor().booleanValue()) {
            return null;
        }
        String ret = null;
        TreeSet<ClassInstructor> ts = new TreeSet<ClassInstructor>(clazz.getClassInstructors());
        for (ClassInstructor ci : ts) {
            if (!ci.isLead().booleanValue()) continue;
            if (ret == null) {
                ret = ci.getInstructor().nameShort();
                continue;
            }
            ret = ret + ":" + ci.getInstructor().nameShort();
        }
        return ret;
    }

    public TimeLocation makeupTime(Class_ c) {
        DatePattern datePattern = c.effectiveDatePattern();
        if (datePattern == null) {
            this.iProgress.warn("        -- makup time for " + c.getClassLabel() + ": no date pattern set");
            return null;
        }
        for (TimePref tp : c.getEffectiveTimePreferences()) {
            TimePatternModel pattern = tp.getTimePatternModel();
            if (pattern.isExactTime()) {
                int length = ExactTimeMins.getNrSlotsPerMtg(pattern.getExactDays(), c.getSchedulingSubpart().getMinutesPerWk());
                int breakTime = ExactTimeMins.getBreakTime(pattern.getExactDays(), c.getSchedulingSubpart().getMinutesPerWk());
                return new TimeLocation(pattern.getExactDays(), pattern.getExactStartSlot(), length, PreferenceLevel.sIntLevelNeutral, 0.0, datePattern.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), breakTime);
            }
            for (int time = 0; time < pattern.getNrTimes(); ++time) {
                for (int day = 0; day < pattern.getNrDays(); ++day) {
                    String pref = pattern.getPreference(day, time);
                    if (!pref.equals(PreferenceLevel.sRequired)) continue;
                    return new TimeLocation(pattern.getDayCode(day), pattern.getStartSlot(time), pattern.getSlotsPerMtg(), PreferenceLevel.prolog2int(pattern.getPreference(day, time)), pattern.getNormalizedPreference(day, time, 0.77), datePattern.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), pattern.getBreakTime());
                }
            }
        }
        if (c.getEffectiveTimePreferences().isEmpty()) {
            this.iProgress.warn("        -- makup time for " + c.getClassLabel() + ": no time preference set");
        } else {
            this.iProgress.warn("        -- makup time for " + c.getClassLabel() + ": no required time set");
        }
        return null;
    }

    public Vector makeupRooms(Class_ c) {
        Vector<RoomLocation> rooms = new Vector<RoomLocation>();
        for (RoomPref rp : c.getEffectiveRoomPreferences()) {
            if (!PreferenceLevel.sRequired.equals(rp.getPrefLevel().getPrefProlog())) {
                this.iProgress.warn("        -- makup room for " + c.getClassLabel() + ": preference for " + rp.getRoom().getLabel() + " is not required");
                continue;
            }
            Location room = rp.getRoom();
            RoomLocation roomLocation = new RoomLocation(room.getUniqueId(), room.getLabel(), room instanceof Room ? ((Room)room).getBuilding().getUniqueId() : null, 0, room.getCapacity().intValue(), room.getCoordinateX(), room.getCoordinateY(), room.isIgnoreTooFar().booleanValue(), null);
            rooms.addElement(roomLocation);
        }
        return rooms;
    }

    public Placement makeupPlacement(Class_ c) {
        TimeLocation time = this.makeupTime(c);
        if (time == null) {
            return null;
        }
        Vector rooms = this.makeupRooms(c);
        Vector<TimeLocation> times = new Vector<TimeLocation>(1);
        times.addElement(time);
        Lecture lecture = new Lecture(c.getUniqueId(), null, c.getSchedulingSubpart().getUniqueId(), c.getClassLabel(), times, (List)rooms, rooms.size(), new Placement(null, time, (List)rooms), 0, 0, 1.0);
        lecture.setNote(c.getNotes());
        Placement p = (Placement)lecture.getInitialAssignment();
        p.setAssignmentId(new Long(this.iMakeupAssignmentId++));
        lecture.setBestAssignment((Value)p, 0L);
        this.iProgress.trace("makup placement for " + c.getClassLabel() + ": " + p.getLongName(this.iUseAmPm));
        return p;
    }

    private Offering loadOffering(InstructionalOffering io, Hashtable<Long, Course> courseTable, Hashtable<Long, Section> classTable) {
        if (io.getInstrOfferingConfigs().isEmpty()) {
            return null;
        }
        String courseName = io.getCourseName();
        Offering offering = new Offering(io.getUniqueId().longValue(), courseName);
        for (CourseOffering co : io.getCourseOfferings()) {
            int projected = co.getProjectedDemand() == null ? 0 : co.getProjectedDemand();
            boolean unlimited = false;
            int limit = 0;
            for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
                if (ioc.isUnlimitedEnrollment().booleanValue()) {
                    unlimited = true;
                }
                limit += ioc.getLimit().intValue();
            }
            if (co.getReservation() != null) {
                limit = co.getReservation();
            }
            if (limit >= 9999) {
                unlimited = true;
            }
            if (unlimited) {
                limit = -1;
            }
            Course course = new Course(co.getUniqueId().longValue(), co.getSubjectArea().getSubjectAreaAbbreviation(), co.getCourseNbr(), offering, limit, projected);
            courseTable.put(co.getUniqueId(), course);
        }
        Hashtable<Long, Section> class2section = new Hashtable<Long, Section>();
        Hashtable<Long, Subpart> ss2subpart = new Hashtable<Long, Subpart>();
        DecimalFormat df = new DecimalFormat("000");
        for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
            int configLimit;
            int n = configLimit = ioc.isUnlimitedEnrollment() != false ? -1 : ioc.getLimit();
            if (configLimit >= 9999) {
                configLimit = -1;
            }
            Config config = new Config(ioc.getUniqueId().longValue(), configLimit, courseName + " [" + ioc.getName() + "]", offering);
            TreeSet subparts = new TreeSet(new SchedulingSubpartComparator());
            subparts.addAll(ioc.getSchedulingSubparts());
            Iterator iterator = subparts.iterator();
            while (iterator.hasNext()) {
                Subpart parentSubpart;
                SchedulingSubpart ss = (SchedulingSubpart)iterator.next();
                String sufix = ss.getSchedulingSubpartSuffix();
                Subpart subpart = parentSubpart = ss.getParentSubpart() == null ? null : (Subpart)ss2subpart.get(ss.getParentSubpart().getUniqueId());
                if (ss.getParentSubpart() != null && parentSubpart == null) {
                    this.iProgress.error("Subpart " + ss.getSchedulingSubpartLabel() + " has parent " + ss.getSchedulingSubpartLabel() + ", but the appropriate parent subpart is not loaded.");
                }
                Subpart subpart2 = new Subpart(ss.getUniqueId().longValue(), df.format(ss.getItype().getItype()) + sufix, ss.getItype().getAbbv().trim(), config, parentSubpart);
                subpart2.setAllowOverlap(ss.isStudentAllowOverlap().booleanValue());
                ss2subpart.put(ss.getUniqueId(), subpart2);
                for (Class_ c : ss.getClasses()) {
                    int maxLimit;
                    Section parentSection;
                    Section section = parentSection = c.getParentClass() == null ? null : (Section)class2section.get(c.getParentClass().getUniqueId());
                    if (c.getParentClass() != null && parentSection == null) {
                        this.iProgress.error("Class " + c.getClassLabel() + " has parent " + c.getClassLabel() + ", but the appropriate parent section is not loaded.");
                    }
                    org.unitime.timetable.model.Assignment a = c.getCommittedAssignment();
                    Placement p = null;
                    if (this.iMakeupAssignmentsFromRequiredPrefs) {
                        p = this.makeupPlacement(c);
                    } else if (a != null) {
                        p = a.getPlacement();
                    }
                    if (p != null && p.getTimeLocation() != null) {
                        p.getTimeLocation().setDatePattern(p.getTimeLocation().getDatePatternId(), this.datePatternName(p.getTimeLocation()), p.getTimeLocation().getWeekCode());
                    }
                    int minLimit = c.getExpectedCapacity();
                    int limit = maxLimit = c.getMaxExpectedCapacity().intValue();
                    if (minLimit < maxLimit && p != null) {
                        int roomLimit = (int)Math.floor((float)p.getRoomSize() / (c.getRoomRatio() == null ? 1.0f : c.getRoomRatio().floatValue()));
                        limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                    }
                    if (ioc.isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                        limit = -1;
                    }
                    if (this.iCheckEnabledForScheduling && !c.isEnabledForStudentScheduling().booleanValue()) {
                        limit = 0;
                    }
                    Section section2 = new Section(c.getUniqueId().longValue(), limit, c.getExternalUniqueId() == null ? (c.getClassSuffix() == null ? c.getSectionNumberString() : c.getClassSuffix()) : c.getExternalUniqueId(), subpart2, p, this.getInstructorIds(c), this.getInstructorNames(c), parentSection);
                    class2section.put(c.getUniqueId(), section2);
                    classTable.put(c.getUniqueId(), section2);
                }
            }
        }
        for (org.unitime.timetable.model.Reservation reservation : io.getReservations()) {
            ArrayList<Long> studentIds;
            ReservationOverride r = null;
            if (reservation instanceof OverrideReservation) {
                studentIds = new ArrayList<Long>();
                for (org.unitime.timetable.model.Student student : ((IndividualReservation)reservation).getStudents()) {
                    studentIds.add(student.getUniqueId());
                }
                r = new ReservationOverride(reservation.getUniqueId().longValue(), offering, studentIds);
                ReservationInterface.OverrideType type = ((OverrideReservation)reservation).getOverrideType();
                r.setMustBeUsed(type.isMustBeUsed());
                r.setAllowOverlap(type.isAllowTimeConflict());
                r.setCanAssignOverLimit(type.isAllowOverLimit());
            } else if (reservation instanceof IndividualReservation) {
                studentIds = new ArrayList();
                for (org.unitime.timetable.model.Student student : ((IndividualReservation)reservation).getStudents()) {
                    studentIds.add(student.getUniqueId());
                }
                r = new org.cpsolver.studentsct.reservation.IndividualReservation(reservation.getUniqueId().longValue(), offering, studentIds);
                r.setPriority(ApplicationProperty.ReservationPriorityIndividual.intValue().intValue());
                r.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapIndividual.isTrue());
                r.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitIndividual.isTrue());
                r.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedIndividual.isTrue());
            } else if (reservation instanceof StudentGroupReservation) {
                studentIds = new ArrayList();
                for (org.unitime.timetable.model.Student student : ((StudentGroupReservation)reservation).getGroup().getStudents()) {
                    studentIds.add(student.getUniqueId());
                }
                r = new GroupReservation(reservation.getUniqueId().longValue(), reservation.getLimit() == null ? -1.0 : (double)reservation.getLimit().intValue(), offering, studentIds);
                r.setPriority(ApplicationProperty.ReservationPriorityGroup.intValue().intValue());
                r.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapGroup.isTrue());
                r.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitGroup.isTrue());
                r.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedGroup.isTrue());
            } else if (reservation instanceof CurriculumReservation) {
                Object clasf2;
                CurriculumReservation cr = (CurriculumReservation)reservation;
                ArrayList classifications = new ArrayList();
                for (Object clasf2 : cr.getClassifications()) {
                    classifications.add(((BaseAcademicClassification)clasf2).getCode());
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                clasf2 = cr.getMajors().iterator();
                while (clasf2.hasNext()) {
                    PosMajor major = (PosMajor)clasf2.next();
                    arrayList.add(major.getCode());
                }
                r = new org.cpsolver.studentsct.reservation.CurriculumReservation(reservation.getUniqueId().longValue(), reservation.getLimit() == null ? -1.0 : (double)reservation.getLimit().intValue(), offering, cr.getArea().getAcademicAreaAbbreviation(), (Collection)classifications, arrayList);
                r.setPriority(ApplicationProperty.ReservationPriorityCurriculum.intValue().intValue());
                r.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapCurriculum.isTrue());
                r.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitCurriculum.isTrue());
                r.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedCurriculum.isTrue());
            } else if (reservation instanceof CourseReservation) {
                CourseOffering co = ((CourseReservation)reservation).getCourse();
                for (Course course : offering.getCourses()) {
                    if (!co.getUniqueId().equals(course.getId())) continue;
                    r = new org.cpsolver.studentsct.reservation.CourseReservation(reservation.getUniqueId().longValue(), course);
                }
                r.setPriority(ApplicationProperty.ReservationPriorityCourse.intValue().intValue());
                r.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapCourse.isTrue());
                r.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitCourse.isTrue());
                r.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedCourse.isTrue());
            }
            if (r == null) {
                this.iProgress.warn("Failed to load reservation " + reservation.getUniqueId() + ".");
                continue;
            }
            r.setExpired(reservation.isExpired());
            block12: for (InstrOfferingConfig ioc : reservation.getConfigurations()) {
                for (Config config : offering.getConfigs()) {
                    if (!ioc.getUniqueId().equals(config.getId())) continue;
                    r.addConfig(config);
                    continue block12;
                }
            }
            block14: for (Class_ c : reservation.getClasses()) {
                for (Config config : offering.getConfigs()) {
                    for (Subpart subpart : config.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            if (!c.getUniqueId().equals(section.getId())) continue;
                            r.addSection(section);
                            continue block14;
                        }
                    }
                }
            }
        }
        if (io.isByReservationOnly().booleanValue()) {
            new DummyReservation(offering);
        }
        return offering;
    }

    public void skipStudent(org.unitime.timetable.model.Student s, Hashtable<Long, Course> courseTable, Hashtable<Long, Section> classTable) {
        this.iProgress.debug("Skipping student " + s.getUniqueId() + " (id=" + s.getExternalUniqueId() + ", name=" + NameFormat.defaultFormat().format(s) + ")");
        HashMap assignment = new HashMap();
        for (StudentClassEnrollment studentClassEnrollment : s.getClassEnrollments()) {
            Section section = classTable.get(studentClassEnrollment.getClazz().getUniqueId());
            Course course = courseTable.get(studentClassEnrollment.getCourseOffering().getUniqueId());
            if (section == null || course == null) continue;
            ArrayList<Section> sections = (ArrayList<Section>)assignment.get(course);
            if (sections == null) {
                Config config;
                sections = new ArrayList<Section>();
                assignment.put(course, sections);
                if (course.getLimit() > 0) {
                    course.setLimit(course.getLimit() - 1);
                }
                if ((config = section.getSubpart().getConfig()).getLimit() > 0) {
                    config.setLimit(config.getLimit() - 1);
                }
            }
            if (section.getLimit() > 0) {
                section.setLimit(section.getLimit() - 1);
            }
            sections.add(section);
        }
        for (Map.Entry entry : assignment.entrySet()) {
            org.cpsolver.studentsct.reservation.CurriculumReservation c;
            Course course = (Course)entry.getKey();
            List sections = (List)entry.getValue();
            Reservation reservation = null;
            for (Reservation r : course.getOffering().getReservations()) {
                if (r.getLimit() >= 0.0 && r.getLimit() < 1.0 && !r.mustBeUsed()) continue;
                boolean applicable = false;
                if (r instanceof GroupReservation) {
                    applicable = ((GroupReservation)r).getStudentIds().contains(s.getUniqueId());
                } else if (r instanceof org.cpsolver.studentsct.reservation.IndividualReservation) {
                    applicable = ((org.cpsolver.studentsct.reservation.IndividualReservation)r).getStudentIds().contains(s.getUniqueId());
                } else if (r instanceof org.cpsolver.studentsct.reservation.CourseReservation) {
                    applicable = course.equals((Object)((org.cpsolver.studentsct.reservation.CourseReservation)r).getCourse());
                } else if (r instanceof org.cpsolver.studentsct.reservation.CurriculumReservation) {
                    org.cpsolver.studentsct.reservation.CurriculumReservation c2 = (org.cpsolver.studentsct.reservation.CurriculumReservation)r;
                    block3: for (AcademicAreaClassification aac : s.getAcademicAreaClassifications()) {
                        if (!aac.getAcademicArea().equals(c2.getAcademicArea()) || !c2.getClassifications().isEmpty() && !c2.getClassifications().contains(aac.getAcademicClassification().getCode())) continue;
                        if (c2.getMajors().isEmpty()) {
                            applicable = true;
                            break;
                        }
                        for (PosMajor major : aac.getAcademicArea().getPosMajors()) {
                            if (!s.getPosMajors().contains(major) || !c2.getMajors().contains(major.getCode())) continue;
                            applicable = true;
                            break block3;
                        }
                    }
                }
                if (!applicable) continue;
                if (!r.mustBeUsed()) {
                    boolean included = true;
                    for (Section section : sections) {
                        if (!r.getConfigs().isEmpty() && !r.getConfigs().contains(section.getSubpart().getConfig())) {
                            included = false;
                            break;
                        }
                        Set sectionsThisSubpart = r.getSections(section.getSubpart());
                        if (sectionsThisSubpart == null || sectionsThisSubpart.contains(section)) continue;
                        included = false;
                        break;
                    }
                    if (!included) continue;
                }
                if (reservation != null && r.compareTo(this.getAssignment(), reservation) >= 0) continue;
                reservation = r;
            }
            if (reservation == null) continue;
            if (reservation instanceof GroupReservation) {
                GroupReservation g = (GroupReservation)reservation;
                g.getStudentIds().remove(s.getUniqueId());
                if (!(g.getReservationLimit() >= 1.0)) continue;
                g.setReservationLimit(g.getReservationLimit() - 1.0);
                continue;
            }
            if (reservation instanceof org.cpsolver.studentsct.reservation.IndividualReservation) {
                org.cpsolver.studentsct.reservation.IndividualReservation i = (org.cpsolver.studentsct.reservation.IndividualReservation)reservation;
                i.getStudentIds().remove(s.getUniqueId());
                continue;
            }
            if (reservation instanceof org.cpsolver.studentsct.reservation.CourseReservation || !(reservation instanceof org.cpsolver.studentsct.reservation.CurriculumReservation) || !((c = (org.cpsolver.studentsct.reservation.CurriculumReservation)reservation).getReservationLimit() >= 1.0)) continue;
            c.setReservationLimit(c.getReservationLimit() - 1.0);
        }
        this.updateCurriculumCounts(s);
    }

    public Student loadStudent(org.unitime.timetable.model.Student s, Hashtable<Long, Course> courseTable, Hashtable<Long, Section> classTable) {
        if (this.iCheckForNoBatchStatus && s.hasSectioningStatusOption(StudentSectioningStatus.Option.nobatch)) {
            this.skipStudent(s, courseTable, classTable);
            return null;
        }
        NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingStudentNameFormat.value());
        this.iProgress.debug("Loading student " + s.getUniqueId() + " (id=" + s.getExternalUniqueId() + ", name=" + nameFormat.format(s) + ")");
        Student student = new Student(s.getUniqueId().longValue());
        student.setExternalId(s.getExternalUniqueId());
        student.setName(nameFormat.format(s));
        student.setStatus(s.getSectioningStatus() == null ? null : s.getSectioningStatus().getReference());
        if (this.iLoadStudentInfo) {
            this.loadStudentInfo(student, s);
        }
        TreeSet<CourseDemand> demands = new TreeSet<CourseDemand>(new Comparator<CourseDemand>(){

            @Override
            public int compare(CourseDemand d1, CourseDemand d2) {
                if (d1.isAlternative().booleanValue() && !d2.isAlternative().booleanValue()) {
                    return 1;
                }
                if (!d1.isAlternative().booleanValue() && d2.isAlternative().booleanValue()) {
                    return -1;
                }
                int cmp = d1.getPriority().compareTo(d2.getPriority());
                if (cmp != 0) {
                    return cmp;
                }
                return d1.getUniqueId().compareTo(d2.getUniqueId());
            }
        });
        demands.addAll(s.getCourseDemands());
        for (CourseDemand cd : demands) {
            if (cd.getFreeTime() != null) {
                TimeLocation ft = new TimeLocation(cd.getFreeTime().getDayCode().intValue(), cd.getFreeTime().getStartSlot().intValue(), cd.getFreeTime().getLength().intValue(), 0, 0.0, Long.valueOf(-1L), "", this.iFreeTimePattern, 0);
                new FreeTimeRequest(cd.getUniqueId().longValue(), cd.getPriority().intValue(), cd.isAlternative().booleanValue(), student, ft);
                continue;
            }
            if (cd.getCourseRequests().isEmpty()) continue;
            Iterator<WaitList> courses = new Vector();
            HashSet<Choice> selChoices = new HashSet<Choice>();
            HashSet<Choice> wlChoices = new HashSet<Choice>();
            HashSet<Section> assignedSections = new HashSet<Section>();
            Config assignedConfig = null;
            TreeSet<org.unitime.timetable.model.CourseRequest> crs = new TreeSet<org.unitime.timetable.model.CourseRequest>(new Comparator<org.unitime.timetable.model.CourseRequest>(){

                @Override
                public int compare(org.unitime.timetable.model.CourseRequest r1, org.unitime.timetable.model.CourseRequest r2) {
                    return r1.getOrder().compareTo(r2.getOrder());
                }
            });
            crs.addAll(cd.getCourseRequests());
            Iterator<org.unitime.timetable.model.CourseRequest> iterator = crs.iterator();
            while (iterator.hasNext()) {
                org.unitime.timetable.model.CourseRequest cr = iterator.next();
                Course course = courseTable.get(cr.getCourseOffering().getUniqueId());
                if (course == null) {
                    this.iProgress.warn("Student " + nameFormat.format(s) + " (" + s.getExternalUniqueId() + ") requests course " + cr.getCourseOffering().getCourseName() + " that is not loaded.");
                    continue;
                }
                for (ClassWaitList cwl : cr.getClassWaitLists()) {
                    Section section = course.getOffering().getSection(cwl.getClazz().getUniqueId().longValue());
                    if (section == null) continue;
                    if (cwl.getType().equals(ClassWaitList.TYPE_SELECTION)) {
                        selChoices.add(section.getChoice());
                        continue;
                    }
                    if (!cwl.getType().equals(ClassWaitList.TYPE_WAITLIST)) continue;
                    wlChoices.add(section.getChoice());
                }
                if (assignedConfig == null) {
                    HashSet<Long> subparts = new HashSet<Long>();
                    for (StudentClassEnrollment enrl : cr.getClassEnrollments()) {
                        Section section = course.getOffering().getSection(enrl.getClazz().getUniqueId().longValue());
                        if (section != null) {
                            if (this.getModel().isMPP()) {
                                selChoices.add(section.getChoice());
                            }
                            assignedSections.add(section);
                            if (assignedConfig != null && assignedConfig.getId() != section.getSubpart().getConfig().getId()) {
                                this.iProgress.error("There is a problem assigning " + course.getName() + " to " + nameFormat.format(s) + " (" + s.getExternalUniqueId() + "): classes from different configurations.");
                            }
                            assignedConfig = section.getSubpart().getConfig();
                            if (subparts.add(section.getSubpart().getId())) continue;
                            this.iProgress.error("There is a problem assigning " + course.getName() + " to " + nameFormat.format(s) + " (" + s.getExternalUniqueId() + "): two or more classes of the same subpart.");
                            continue;
                        }
                        this.iProgress.error("There is a problem assigning " + course.getName() + " to " + nameFormat.format(s) + " (" + s.getExternalUniqueId() + "): class " + enrl.getClazz().getClassLabel() + " not known.");
                    }
                }
                ((Vector)((Object)courses)).addElement((WaitList)course);
            }
            if (((Vector)((Object)courses)).isEmpty()) continue;
            CourseRequest request = new CourseRequest(cd.getUniqueId().longValue(), cd.getPriority().intValue(), cd.isAlternative().booleanValue(), student, courses, cd.isWaitlist().booleanValue(), Long.valueOf(cd.getTimestamp().getTime()));
            request.getSelectedChoices().addAll(selChoices);
            request.getWaitlistedChoices().addAll(wlChoices);
            if (assignedConfig != null && assignedSections.size() == assignedConfig.getSubparts().size()) {
                Enrollment enrollment = new Enrollment((Request)request, 0, assignedConfig, assignedSections, this.getAssignment());
                request.setInitialAssignment((Value)enrollment);
            }
            if (assignedConfig == null || assignedSections.size() == assignedConfig.getSubparts().size()) continue;
            this.iProgress.error("There is a problem assigning " + request.getName() + " to " + nameFormat.format(s) + " (" + s.getExternalUniqueId() + ") wrong number of classes (" + "has " + assignedSections.size() + ", expected " + assignedConfig.getSubparts().size() + ").");
        }
        if (!s.getClassEnrollments().isEmpty() || !s.getWaitlists().isEmpty()) {
            Course course2;
            TreeSet<Course> courses = new TreeSet<Course>(new Comparator<Course>(){

                @Override
                public int compare(Course c1, Course c2) {
                    return (c1.getSubjectArea() + " " + c1.getCourseNumber()).compareTo(c2.getSubjectArea() + " " + c2.getCourseNumber());
                }
            });
            Hashtable<Long, Long> timeStamp = new Hashtable<Long, Long>();
            for (StudentClassEnrollment enrl : s.getClassEnrollments()) {
                if (enrl.getCourseRequest() != null) continue;
                course2 = courseTable.get(enrl.getCourseOffering().getUniqueId());
                if (course2 == null) {
                    this.iProgress.warn("Student " + nameFormat.format(s) + " (" + s.getExternalUniqueId() + ") requests course " + enrl.getCourseOffering().getCourseName() + " that is not loaded.");
                    continue;
                }
                if (enrl.getTimestamp() != null) {
                    timeStamp.put(enrl.getCourseOffering().getUniqueId(), enrl.getTimestamp().getTime());
                }
                courses.add(course2);
            }
            for (WaitList w : s.getWaitlists()) {
                course2 = courseTable.get(w.getCourseOffering().getUniqueId());
                if (course2 == null) {
                    this.iProgress.warn("Student " + nameFormat.format(s) + " (" + s.getExternalUniqueId() + ") requests course " + w.getCourseOffering().getCourseName() + " that is not loaded.");
                    continue;
                }
                if (w.getTimestamp() != null) {
                    timeStamp.put(w.getCourseOffering().getUniqueId(), w.getTimestamp().getTime());
                }
                courses.add(course2);
            }
            int priority = 0;
            block6: for (Course course2 : courses) {
                Vector<Course> cx = new Vector<Course>();
                cx.add(course2);
                CourseRequest request = null;
                for (Request r : student.getRequests()) {
                    if (!(r instanceof CourseRequest) || this.getAssignment().getValue((Variable)r) != null || !((CourseRequest)r).getCourses().contains(course2)) continue;
                    request = (CourseRequest)r;
                    break;
                }
                if (request == null) {
                    request = new CourseRequest(course2.getId(), priority++, false, student, cx, true, (Long)timeStamp.get(course2.getId()));
                }
                HashSet<Section> assignedSections = new HashSet<Section>();
                Config assignedConfig = null;
                HashSet<Long> subparts = new HashSet<Long>();
                for (StudentClassEnrollment enrl : s.getClassEnrollments()) {
                    if (course2.getId() != enrl.getCourseOffering().getUniqueId().longValue()) continue;
                    Section section = course2.getOffering().getSection(enrl.getClazz().getUniqueId().longValue());
                    if (section != null) {
                        assignedSections.add(section);
                        if (assignedConfig != null && assignedConfig.getId() != section.getSubpart().getConfig().getId()) {
                            this.iProgress.error("There is a problem assigning " + request.getName() + " to " + nameFormat.format(s) + " (" + s.getExternalUniqueId() + "): classes from different configurations.");
                            continue block6;
                        }
                        assignedConfig = section.getSubpart().getConfig();
                        if (subparts.add(section.getSubpart().getId())) continue;
                        this.iProgress.error("There is a problem assigning " + request.getName() + " to " + nameFormat.format(s) + " (" + s.getExternalUniqueId() + "): two or more classes of the same subpart.");
                        continue block6;
                    }
                    this.iProgress.error("There is a problem assigning " + request.getName() + " to " + nameFormat.format(s) + " (" + s.getExternalUniqueId() + "): class " + enrl.getClazz().getClassLabel() + " not known.");
                    Section x = classTable.get(enrl.getClazz().getUniqueId());
                    if (x == null) continue block6;
                    this.iProgress.info("  but a class with the same id is loaded, but under offering " + x.getSubpart().getConfig().getOffering().getName() + " (id is " + x.getSubpart().getConfig().getOffering().getId() + ", expected " + course2.getOffering().getId() + ")");
                    continue block6;
                }
                if (assignedConfig != null && assignedSections.size() == assignedConfig.getSubparts().size()) {
                    Enrollment enrollment = new Enrollment((Request)request, 0, assignedConfig, assignedSections, this.getAssignment());
                    request.setInitialAssignment((Value)enrollment);
                }
                if (assignedConfig == null || assignedSections.size() == assignedConfig.getSubparts().size()) continue;
                this.iProgress.error("There is a problem assigning " + request.getName() + " to " + nameFormat.format(s) + " (" + s.getExternalUniqueId() + "): wrong number of classes (" + "has " + assignedSections.size() + ", expected " + assignedConfig.getSubparts().size() + ").");
            }
        }
        return student;
    }

    public void assignStudent(Student student) {
        for (Request r : student.getRequests()) {
            if (r.getInitialAssignment() == null || !r.getModel().conflictValues(this.getAssignment(), r.getInitialAssignment()).isEmpty()) continue;
            this.getAssignment().assign(0L, r.getInitialAssignment());
        }
        for (Request r : student.getRequests()) {
            if (!(r instanceof FreeTimeRequest)) continue;
            FreeTimeRequest ft = (FreeTimeRequest)r;
            Enrollment enrollment = ft.createEnrollment();
            if (!r.getModel().conflictValues(this.getAssignment(), (Value)enrollment).isEmpty()) continue;
            ft.setInitialAssignment((Value)enrollment);
            this.getAssignment().assign(0L, (Value)enrollment);
        }
    }

    public void checkForConflicts(Student student) {
        for (Request r : student.getRequests()) {
            if (this.getAssignment().getValue((Variable)r) != null || r.getInitialAssignment() == null || !(r instanceof CourseRequest)) continue;
            if (r.getModel().conflictValues(this.getAssignment(), r.getInitialAssignment()).isEmpty()) {
                this.getAssignment().assign(0L, r.getInitialAssignment());
                continue;
            }
            CourseRequest cr = (CourseRequest)r;
            Enrollment enrl = (Enrollment)r.getInitialAssignment();
            org.unitime.timetable.model.Student s = student.getId() >= 0L ? (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId()) : null;
            this.iProgress.error("There is a problem assigning " + cr.getName() + " to " + (s == null ? Long.valueOf(student.getId()) : NameFormat.defaultFormat().format(s) + " (" + s.getExternalUniqueId() + ")"));
            boolean hasLimit = false;
            boolean hasOverlap = false;
            for (Section section : enrl.getSections()) {
                if (section.getTime() != null) {
                    for (Request q : student.getRequests()) {
                        Enrollment enrlx = (Enrollment)this.getAssignment().getValue((Variable)q);
                        if (enrlx == null || !(q instanceof CourseRequest)) continue;
                        for (Section sectionx : enrlx.getSections()) {
                            if (sectionx.getTime() == null || !sectionx.isOverlapping((SctAssignment)section)) continue;
                            this.iProgress.info("  " + section.getSubpart().getName() + " " + section.getName() + " " + section.getTime().getLongName(this.iUseAmPm) + " overlaps with " + sectionx.getSubpart().getConfig().getOffering().getName() + " " + sectionx.getSubpart().getName() + " " + sectionx.getName() + " " + sectionx.getTime().getLongName(this.iUseAmPm));
                            hasOverlap = true;
                        }
                    }
                }
                if (section.getLimit() >= 0 && section.getLimit() < 1 + section.getEnrollments(this.getAssignment()).size()) {
                    this.iProgress.info("  " + section.getSubpart().getName() + " " + section.getName() + (section.getTime() == null ? "" : " " + section.getTime().getLongName(this.iUseAmPm)) + " has no space available (limit is " + section.getLimit() + ")");
                    if (this.iTweakLimits) {
                        section.setLimit(section.getEnrollments(this.getAssignment()).size() + 1);
                        section.clearReservationCache();
                        this.iProgress.info("    limit increased to " + section.getLimit());
                    }
                    hasLimit = true;
                }
                this.iProgress.info("  " + section.getSubpart().getName() + " " + section.getName() + (section.getTime() == null ? "" : " " + section.getTime().getLongName(this.iUseAmPm)));
            }
            if (enrl.getConfig().getLimit() >= 0 && enrl.getConfig().getLimit() < 1 + enrl.getConfig().getEnrollments(this.getAssignment()).size()) {
                this.iProgress.info("  config " + enrl.getConfig().getName() + " has no space available (limit is " + enrl.getConfig().getLimit() + ")");
                if (this.iTweakLimits) {
                    enrl.getConfig().setLimit(enrl.getConfig().getEnrollments(this.getAssignment()).size() + 1);
                    enrl.getConfig().clearReservationCache();
                    this.iProgress.info("    limit increased to " + enrl.getConfig().getLimit());
                }
                hasLimit = true;
            }
            if (enrl.getCourse() != null && enrl.getCourse().getLimit() >= 0 && enrl.getCourse().getLimit() < 1 + enrl.getCourse().getEnrollments(this.getAssignment()).size()) {
                this.iProgress.info("  course " + enrl.getCourse().getName() + " has no space available (limit is " + enrl.getCourse().getLimit() + ")");
                if (this.iTweakLimits) {
                    enrl.getCourse().setLimit(enrl.getCourse().getEnrollments(this.getAssignment()).size() + 1);
                    this.iProgress.info("    limit increased to " + enrl.getCourse().getLimit());
                }
                hasLimit = true;
            }
            if (!hasLimit && !hasOverlap) {
                for (Enrollment enrlx : r.getModel().conflictValues(this.getAssignment(), r.getInitialAssignment())) {
                    for (Section sectionx : enrlx.getSections()) {
                        this.iProgress.info("    conflicts with " + sectionx.getSubpart().getConfig().getOffering().getName() + " " + sectionx.getSubpart().getName() + " " + sectionx.getName() + (sectionx.getTime() == null ? "" : " " + sectionx.getTime().getLongName(this.iUseAmPm)));
                    }
                    if (enrlx.getRequest().getStudent().getId() == student.getId()) continue;
                    this.iProgress.info("    of a different student");
                }
            }
            if (!hasLimit || hasOverlap || !this.iTweakLimits || !r.getModel().conflictValues(this.getAssignment(), r.getInitialAssignment()).isEmpty()) continue;
            this.getAssignment().assign(0L, r.getInitialAssignment());
        }
    }

    private String curriculum(Student student) {
        return (student.getAcademicAreaClasiffications().isEmpty() ? "" : ((AcademicAreaCode)student.getAcademicAreaClasiffications().get(0)).getArea() + ":" + ((AcademicAreaCode)student.getAcademicAreaClasiffications().get(0)).getCode()) + ":" + (student.getMajors().isEmpty() ? "" : ((AcademicAreaCode)student.getMajors().get(0)).getCode());
    }

    private String curriculum(org.unitime.timetable.model.Student student) {
        String curriculum = "";
        Iterator<AcademicAreaClassification> iterator = student.getAcademicAreaClassifications().iterator();
        if (iterator.hasNext()) {
            AcademicAreaClassification aac = iterator.next();
            curriculum = aac.getAcademicArea().getAcademicAreaAbbreviation() + ":" + aac.getAcademicClassification().getCode();
            for (PosMajor major : aac.getAcademicArea().getPosMajors()) {
                if (!student.getPosMajors().contains(major)) continue;
                curriculum = curriculum + ":" + major.getCode();
                break;
            }
        }
        return curriculum;
    }

    private void updateCurriculumCounts(Student student) {
        String curriculum = this.curriculum(student);
        for (Request request : student.getRequests()) {
            Integer cx;
            if (!(request instanceof CourseRequest)) continue;
            Course course = request.getInitialAssignment() != null ? ((Enrollment)request.getInitialAssignment()).getCourse() : (Course)((CourseRequest)request).getCourses().get(0);
            Map<String, Integer> c2w = this.iCourse2Curricula2Weight.get(course.getId());
            if (c2w == null) {
                c2w = new Hashtable<String, Integer>();
                this.iCourse2Curricula2Weight.put(course.getId(), c2w);
            }
            c2w.put(curriculum, 1 + ((cx = c2w.get(curriculum)) == null ? 0 : cx));
        }
    }

    private void updateCurriculumCounts(org.unitime.timetable.model.Student student) {
        String curriculum = this.curriculum(student);
        HashSet<Long> courses = new HashSet<Long>();
        for (StudentClassEnrollment enrollment : student.getClassEnrollments()) {
            Integer cx;
            Long courseId = enrollment.getCourseOffering().getUniqueId();
            if (!courses.add(courseId)) continue;
            Map<String, Integer> c2w = this.iCourse2Curricula2Weight.get(courseId);
            if (c2w == null) {
                c2w = new Hashtable<String, Integer>();
                this.iCourse2Curricula2Weight.put(courseId, c2w);
            }
            c2w.put(curriculum, 1 + ((cx = (Integer)c2w.get(curriculum)) == null ? 0 : cx));
        }
        block1: for (CourseDemand demand : student.getCourseDemands()) {
            Integer cx;
            BaseCourseRequest request = null;
            for (org.unitime.timetable.model.CourseRequest r : demand.getCourseRequests()) {
                if (courses.contains(r.getCourseOffering().getUniqueId())) continue block1;
                if (request != null && r.getOrder() >= request.getOrder()) continue;
                request = r;
            }
            if (request == null) continue;
            Long courseId = request.getCourseOffering().getUniqueId();
            courses.add(courseId);
            Map<String, Integer> c2w = this.iCourse2Curricula2Weight.get(courseId);
            if (c2w == null) {
                c2w = new Hashtable<String, Integer>();
                this.iCourse2Curricula2Weight.put(courseId, c2w);
            }
            c2w.put(curriculum, 1 + ((cx = c2w.get(curriculum)) == null ? 0 : cx));
        }
    }

    private void fixWeights(org.hibernate.Session hibSession, Collection<Course> courses) {
        this.iProgress.setPhase("Computing projected request weights...", (long)courses.size());
        for (Course course : courses) {
            this.iProgress.incProgress();
            Map<String, Integer> cur2real = this.iCourse2Curricula2Weight.get(course.getId());
            if (cur2real != null) {
                Object real;
                Hashtable<String, Double> cur2proj = new Hashtable<String, Double>();
                for (CourseRequest request : course.getRequests()) {
                    if (!((Course)request.getCourses().get(0)).equals((Object)course) || !request.getStudent().isDummy()) continue;
                    Double proj = (Double)cur2proj.get(this.curriculum(request.getStudent()));
                    cur2proj.put(this.curriculum(request.getStudent()), request.getWeight() + (proj == null ? 0.0 : proj));
                }
                for (String cur : cur2proj.keySet()) {
                    double proj = (Double)cur2proj.get(cur);
                    real = cur2real.get(cur);
                    if (real == null) continue;
                    this.iProgress.debug("Projected demands for course " + course.getName() + ": " + cur.replace(':', ' ') + " multiplies by " + ((double)((Integer)real).intValue() >= proj ? 0.0 : (proj - (double)((Integer)real).intValue()) / proj) + " (projected=" + proj + ", real=" + real + ")");
                }
                for (CourseRequest request : course.getRequests()) {
                    if (!((Course)request.getCourses().get(0)).equals((Object)course) || !request.getStudent().isDummy()) continue;
                    double proj = (Double)cur2proj.get(this.curriculum(request.getStudent()));
                    real = cur2real.get(this.curriculum(request.getStudent()));
                    if (real == null) continue;
                    request.setWeight(request.getWeight() * ((double)((Integer)real).intValue() >= proj ? 0.0 : (proj - (double)((Integer)real).intValue()) / proj));
                }
            }
            double nrStudents = 0.0;
            double nrLastLike = 0.0;
            int lastLikeCount = 0;
            for (CourseRequest request : course.getRequests()) {
                if (!((Course)request.getCourses().get(0)).equals((Object)course)) continue;
                nrStudents += request.getWeight();
                if (!request.getStudent().isDummy()) continue;
                nrLastLike += request.getWeight();
                ++lastLikeCount;
            }
            double projected = course.getProjected();
            double limit = course.getLimit();
            if (limit >= 9999.0) {
                limit = -1.0;
            }
            int configLimit = 0;
            for (Config config : course.getOffering().getConfigs()) {
                if (config.getLimit() < 0 || config.getLimit() >= 9999) {
                    configLimit = -1;
                    break;
                }
                int cLimit = config.getLimit();
                for (Subpart subpart : config.getSubparts()) {
                    int subpartLimit = 0;
                    for (Section section : subpart.getSections()) {
                        if (section.getLimit() < 0 || section.getLimit() >= 9999) {
                            subpartLimit = -1;
                            break;
                        }
                        subpartLimit += section.getLimit();
                    }
                    if (subpartLimit < 0 || subpartLimit >= cLimit) continue;
                    cLimit = subpartLimit;
                }
                configLimit += cLimit;
            }
            if (course.getOffering().getCourses().size() > 1) {
                int offeringLimit = 0;
                for (Course c : course.getOffering().getCourses()) {
                    if (c.getLimit() < 0 || c.getLimit() >= 9999) {
                        offeringLimit = -1;
                        break;
                    }
                    offeringLimit += c.getLimit();
                }
                if (configLimit >= 0 && configLimit < offeringLimit) {
                    limit = limit * (double)configLimit / (double)offeringLimit;
                } else if (configLimit >= 0 && offeringLimit < 0) {
                    limit = configLimit / course.getOffering().getCourses().size();
                }
            } else if (configLimit >= 0 && ((double)configLimit < limit || limit < 0.0)) {
                limit = configLimit;
            }
            if (limit < 0.0) {
                this.iProgress.debug("Course " + course.getName() + " is unlimited.");
                continue;
            }
            if (projected <= 0.0) {
                this.iProgress.info("No projected demand for course " + course.getName() + ", using course limit (" + Math.round(limit) + ")");
                projected = limit;
            } else if (limit < projected) {
                if (!this.iProjections) {
                    this.iProgress.info("Projected number of students is over course limit for course " + course.getName() + " (" + Math.round(projected) + ">" + Math.round(limit) + ")");
                }
                projected = limit;
            }
            if (lastLikeCount <= 0) {
                this.iProgress.info("No projected course demands for course " + course.getName());
                continue;
            }
            double weight = nrLastLike <= 0.0 ? 0.0 : Math.max(0.0, projected - (nrStudents - nrLastLike)) / nrLastLike;
            this.iProgress.debug("Projected student weight for " + course.getName() + " is " + weight + " (projected=" + nrLastLike + ", real=" + (nrStudents - nrLastLike) + ", limit=" + projected + ")");
            int left = 0;
            for (CourseRequest request : new ArrayList(course.getRequests())) {
                if (!request.getStudent().isDummy()) continue;
                request.setWeight(weight * request.getWeight());
                if (request.getWeight() <= 0.0) {
                    Student student = request.getStudent();
                    this.getModel().removeVariable((Request)request);
                    student.getRequests().remove(request);
                    for (Course c : request.getCourses()) {
                        c.getRequests().remove(request);
                    }
                    if (!student.getRequests().isEmpty()) continue;
                    this.getModel().removeStudent(student);
                    continue;
                }
                ++left;
            }
            if (left > 0) continue;
            this.iProgress.info("No projected course demands needed for course " + course.getName());
        }
        this.getModel().requestWeightsChanged(this.getAssignment());
    }

    public void loadStudentInfo(Student student, org.unitime.timetable.model.Student s) {
        for (AcademicAreaClassification aac : s.getAcademicAreaClassifications()) {
            student.getAcademicAreaClasiffications().add(new AcademicAreaCode(aac.getAcademicArea().getAcademicAreaAbbreviation(), aac.getAcademicClassification().getCode()));
            for (PosMajor major : aac.getAcademicArea().getPosMajors()) {
                if (!s.getPosMajors().contains(major)) continue;
                student.getMajors().add(new AcademicAreaCode(aac.getAcademicArea().getAcademicAreaAbbreviation(), major.getCode()));
            }
        }
        for (StudentGroup g : s.getGroups()) {
            student.getMinors().add(new AcademicAreaCode("", g.getGroupAbbreviation()));
        }
        for (StudentAccomodation a : s.getAccomodations()) {
            student.getMinors().add(new AcademicAreaCode("A", a.getAbbreviation()));
        }
    }

    public void loadRequestGroups(Student student, org.unitime.timetable.model.Student s) {
        for (StudentGroup g : s.getGroups()) {
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                CourseRequest cr = (CourseRequest)r;
                Course course = (Course)cr.getCourses().get(0);
                RequestGroup group = null;
                for (RequestGroup rg : course.getRequestGroups()) {
                    if (rg.getId() != g.getUniqueId().longValue()) continue;
                    group = rg;
                    break;
                }
                if (group == null) {
                    group = new RequestGroup(g.getUniqueId().longValue(), g.getGroupName(), course);
                }
                cr.addRequestGroup(group);
            }
        }
    }

    public static BitSet getFreeTimeBitSet(Session session) {
        int startMonth = session.getPatternStartMonth();
        int endMonth = session.getPatternEndMonth();
        int size = DateUtils.getDayOfYear(0, endMonth + 1, session.getSessionStartYear()) - DateUtils.getDayOfYear(1, startMonth, session.getSessionStartYear());
        BitSet ret = new BitSet(size);
        for (int i = 0; i < size; ++i) {
            ret.set(i);
        }
        return ret;
    }

    private String datePatternName(TimeLocation time) {
        int idx;
        if (time.getWeekCode().isEmpty()) {
            return time.getDatePatternName();
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        cal.setTime(this.iDatePatternFirstDate);
        cal.add(6, idx);
        Date first = null;
        for (idx = time.getWeekCode().nextSetBit(0); idx < time.getWeekCode().size() && first == null; ++idx) {
            if (time.getWeekCode().get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((time.getDayCode() & DayCode.MON.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((time.getDayCode() & DayCode.TUE.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((time.getDayCode() & DayCode.WED.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((time.getDayCode() & DayCode.THU.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((time.getDayCode() & DayCode.FRI.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((time.getDayCode() & DayCode.SAT.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((time.getDayCode() & DayCode.SUN.getCode()) == 0) break;
                        first = cal.getTime();
                    }
                }
            }
            cal.add(6, 1);
        }
        if (first == null) {
            return time.getDatePatternName();
        }
        cal.setTime(this.iDatePatternFirstDate);
        cal.add(6, idx);
        Date last = null;
        for (idx = time.getWeekCode().length() - 1; idx >= 0 && last == null; --idx) {
            if (time.getWeekCode().get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((time.getDayCode() & DayCode.MON.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((time.getDayCode() & DayCode.TUE.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((time.getDayCode() & DayCode.WED.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((time.getDayCode() & DayCode.THU.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((time.getDayCode() & DayCode.FRI.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((time.getDayCode() & DayCode.SAT.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((time.getDayCode() & DayCode.SUN.getCode()) == 0) break;
                        last = cal.getTime();
                    }
                }
            }
            cal.add(6, -1);
        }
        if (last == null) {
            return time.getDatePatternName();
        }
        Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
        return dpf.format(first) + (first.equals(last) ? "" : " - " + dpf.format(last));
    }

    public static Date getDatePatternFirstDay(Session s) {
        return DateUtils.getDate(1, s.getPatternStartMonth(), s.getSessionStartYear());
    }

    public static List<Collection<Section>> getSections(DistributionPref pref, SectionProvider classTable) {
        int groupingType;
        ArrayList<Collection<Section>> ret = new ArrayList<Collection<Section>>();
        int n = groupingType = pref.getGrouping() == null ? 0 : pref.getGrouping();
        if (groupingType == 1) {
            int maxSize = 0;
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    maxSize = Math.max(maxSize, 1);
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                maxSize = Math.max(maxSize, ((SchedulingSubpart)distributionObject.getPrefGroup()).getClasses().size());
            }
            Set[] sections = new Set[maxSize];
            for (int i = 0; i < sections.length; ++i) {
                sections[i] = new HashSet();
            }
            ArrayList<DistributionObject> distributionObjects = new ArrayList<DistributionObject>(pref.getDistributionObjects());
            Collections.sort(distributionObjects, new TimetableDatabaseLoader.ChildrenFirstDistributionObjectComparator());
            for (DistributionObject distributionObject : distributionObjects) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Section section = classTable.get(distributionObject.getPrefGroup().getUniqueId());
                    if (section == null) continue;
                    for (int j = 0; j < sections.length; ++j) {
                        sections[j].add(section);
                    }
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                Collections.sort(classes, new ClassComparator(5));
                for (int j = 0; j < sections.length; ++j) {
                    Section section = null;
                    block5: for (Section s : sections[j]) {
                        for (Section p = s.getParent(); p != null; p = p.getParent()) {
                            if (p.getSubpart().getId() != subpart.getUniqueId().longValue()) continue;
                            section = s;
                            break block5;
                        }
                    }
                    if (section == null) {
                        section = classTable.get(((Class_)classes.get(j % classes.size())).getUniqueId());
                    }
                    if (section == null) continue;
                    sections[j].add(section);
                }
            }
            for (Set s : sections) {
                ret.add(s);
            }
        } else if (groupingType == 7) {
            ArrayList<Section> sections = new ArrayList<Section>();
            ArrayList<Integer> counts = new ArrayList<Integer>();
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                int count = 0;
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Section section = classTable.get(distributionObject.getPrefGroup().getUniqueId());
                    if (section != null) {
                        sections.add(section);
                        ++count;
                    }
                } else if (distributionObject.getPrefGroup() instanceof SchedulingSubpart) {
                    SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                    ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                    Collections.sort(classes, new ClassComparator(5));
                    for (Class_ clazz : classes) {
                        Section section = classTable.get(clazz.getUniqueId());
                        if (section == null) continue;
                        sections.add(section);
                        ++count;
                    }
                }
                if (count <= 0) continue;
                counts.add(count);
            }
            if (counts.size() > 1) {
                Enumeration e = DistributionPref.permutations(sections, counts);
                while (e.hasMoreElements()) {
                    ret.add(e.nextElement());
                }
            }
        } else {
            ArrayList<Section> sections = new ArrayList<Section>();
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Section section = classTable.get(distributionObject.getPrefGroup().getUniqueId());
                    if (section == null) continue;
                    sections.add(section);
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                Collections.sort(classes, new ClassComparator(5));
                for (Class_ clazz : classes) {
                    Section section = classTable.get(clazz.getUniqueId());
                    if (section == null) continue;
                    sections.add(section);
                }
            }
            if (groupingType == 6) {
                if (sections.size() >= 2) {
                    for (int idx1 = 0; idx1 < sections.size() - 1; ++idx1) {
                        Section s1 = (Section)sections.get(idx1);
                        for (int idx2 = idx1 + 1; idx2 < sections.size(); ++idx2) {
                            Section s2 = (Section)sections.get(idx2);
                            HashSet<Section> s = new HashSet<Section>();
                            s.add(s1);
                            s.add(s2);
                            ret.add(s);
                        }
                    }
                }
            } else if (groupingType == 0) {
                ret.add(sections);
            } else {
                ArrayList<Section> s = new ArrayList<Section>();
                for (Section section : sections) {
                    s.add(section);
                    if (s.size() != groupingType) continue;
                    ret.add(s);
                    s = new ArrayList();
                }
                if (s.size() >= 2) {
                    ret.add(new HashSet(s));
                }
            }
        }
        return ret;
    }

    public void load(Session session, org.hibernate.Session hibSession) {
        List distPrefs;
        this.iFreeTimePattern = StudentSectioningDatabaseLoader.getFreeTimeBitSet(session);
        this.iDatePatternFirstDate = StudentSectioningDatabaseLoader.getDatePatternFirstDay(session);
        Hashtable<Long, Course> courseTable = new Hashtable<Long, Course>();
        final Hashtable<Long, Section> classTable = new Hashtable<Long, Section>();
        List offerings = hibSession.createQuery("select distinct io from InstructionalOffering io left join fetch io.courseOfferings as co left join fetch io.instrOfferingConfigs as ioc left join fetch ioc.schedulingSubparts as ss left join fetch ss.classes as c left join fetch io.reservations as r where io.session.uniqueId = :sessionId and io.notOffered = false").setLong("sessionId", session.getUniqueId().longValue()).setFetchSize(1000).list();
        this.iProgress.setPhase("Loading course offerings...", (long)offerings.size());
        for (InstructionalOffering io : offerings) {
            this.iProgress.incProgress();
            Offering offering = this.loadOffering(io, courseTable, classTable);
            if (offering == null) continue;
            this.getModel().addOffering(offering);
        }
        if (this.iIncludeCourseDemands || this.iProjections) {
            List students = hibSession.createQuery("select distinct s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch cr.classWaitLists as cw left join fetch s.classEnrollments as e left join fetch s.waitlists as w " + (this.iLoadStudentInfo ? "left join fetch s.academicAreaClassifications as a left join fetch s.posMajors as mj left join fetch s.groups as g " : "") + "where s.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).setFetchSize(1000).list();
            this.iProgress.setPhase("Loading student requests...", (long)students.size());
            for (Object s : students) {
                Student student;
                this.iProgress.incProgress();
                if (((BaseStudent)s).getCourseDemands().isEmpty() && ((BaseStudent)s).getClassEnrollments().isEmpty() && ((BaseStudent)s).getWaitlists().isEmpty() || (student = this.loadStudent((org.unitime.timetable.model.Student)s, courseTable, classTable)) == null) continue;
                this.updateCurriculumCounts(student);
                if (this.iProjections) {
                    for (Request request : student.getRequests()) {
                        if (request.getInitialAssignment() != null && ((Enrollment)request.getInitialAssignment()).isCourseRequest()) {
                            Enrollment enrollment = (Enrollment)request.getInitialAssignment();
                            if (enrollment.getConfig().getLimit() > 0) {
                                enrollment.getConfig().setLimit(enrollment.getConfig().getLimit() - 1);
                            }
                            for (Section section : enrollment.getSections()) {
                                if (section.getLimit() <= 0) continue;
                                section.setLimit(section.getLimit() - 1);
                            }
                            if (enrollment.getCourse() != null && enrollment.getCourse().getLimit() > 0) {
                                enrollment.getCourse().setLimit(enrollment.getCourse().getLimit() - 1);
                            }
                            if (enrollment.getReservation() != null) {
                                if (enrollment.getReservation() instanceof GroupReservation && enrollment.getReservation().getReservationLimit() >= 1.0) {
                                    ((GroupReservation)enrollment.getReservation()).getStudentIds().remove(student.getId());
                                    ((GroupReservation)enrollment.getReservation()).setReservationLimit(((GroupReservation)enrollment.getReservation()).getReservationLimit() - 1.0);
                                } else if (enrollment.getReservation() instanceof org.cpsolver.studentsct.reservation.IndividualReservation) {
                                    ((org.cpsolver.studentsct.reservation.IndividualReservation)enrollment.getReservation()).getStudentIds().remove(student.getId());
                                } else if (enrollment.getReservation() instanceof org.cpsolver.studentsct.reservation.CurriculumReservation && enrollment.getReservation().getReservationLimit() >= 1.0) {
                                    ((org.cpsolver.studentsct.reservation.CurriculumReservation)enrollment.getReservation()).setReservationLimit(enrollment.getReservation().getReservationLimit() - 1.0);
                                }
                            }
                        }
                        if (!(request instanceof CourseRequest)) continue;
                        for (Course course : ((CourseRequest)request).getCourses()) {
                            course.getRequests().remove(request);
                        }
                    }
                    continue;
                }
                if (this.iLoadRequestGroups) {
                    this.loadRequestGroups(student, (org.unitime.timetable.model.Student)s);
                }
                this.getModel().addStudent(student);
                this.assignStudent(student);
            }
        }
        if (!(distPrefs = hibSession.createQuery("select p from DistributionPref p, Department d where p.distributionType.reference in (:ref1, :ref2) and d.session.uniqueId = :sessionId and p.owner = d and p.prefLevel.prefProlog = :pref").setString("ref1", GroupConstraint.ConstraintType.LINKED_SECTIONS.reference()).setString("ref2", "NO_CONFLICT").setString("pref", PreferenceLevel.sRequired).setLong("sessionId", this.iSessionId.longValue()).list()).isEmpty()) {
            this.iProgress.setPhase("Loading distribution preferences...", (long)distPrefs.size());
            SectionProvider p = new SectionProvider(){

                public Section get(Long classId) {
                    return (Section)classTable.get(classId);
                }
            };
            for (DistributionPref pref : distPrefs) {
                this.iProgress.incProgress();
                for (Collection<Section> sections : StudentSectioningDatabaseLoader.getSections(pref, p)) {
                    if (GroupConstraint.ConstraintType.LINKED_SECTIONS.reference().equals(pref.getDistributionType().getReference())) {
                        this.getModel().addLinkedSections(sections);
                        continue;
                    }
                    for (Section s1 : sections) {
                        for (Section s2 : sections) {
                            if (s1.equals((Object)s2)) continue;
                            s1.addIgnoreConflictWith(s2.getId());
                        }
                    }
                }
            }
        }
        this.iProgress.setPhase("Checking for student conflicts...", (long)this.getModel().getStudents().size());
        for (Student student : this.getModel().getStudents()) {
            this.iProgress.incProgress();
            this.checkForConflicts(student);
        }
        if (this.iStudentCourseDemands != null) {
            this.iStudentCourseDemands.init(hibSession, this.iProgress, (Session)SessionDAO.getInstance().get(this.iSessionId, hibSession), offerings);
            Hashtable<Long, Student> students = new Hashtable<Long, Student>();
            Hashtable<Long, HashSet<Long>> classAssignments = null;
            if (this.iIncludeUseCommittedAssignments && !this.iStudentCourseDemands.isMakingUpStudents()) {
                classAssignments = new Hashtable<Long, HashSet<Long>>();
                List enrollments = hibSession.createQuery("select distinct se.studentId, se.clazz.uniqueId from StudentEnrollment se where se.solution.commited=true and se.solution.owner.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).setFetchSize(1000).list();
                this.iProgress.setPhase("Loading projected class assignments...", (long)enrollments.size());
                for (Object[] o : enrollments) {
                    this.iProgress.incProgress();
                    Long studentId = (Long)o[0];
                    Long classId = (Long)o[1];
                    HashSet<Long> classIds = (HashSet<Long>)classAssignments.get(studentId);
                    if (classIds == null) {
                        classIds = new HashSet<Long>();
                        classAssignments.put(studentId, classIds);
                    }
                    classIds.add(classId);
                }
            }
            this.iProgress.setPhase("Loading projected course requests...", (long)offerings.size());
            long requestId = -1L;
            for (InstructionalOffering io : offerings) {
                this.iProgress.incProgress();
                for (CourseOffering co : io.getCourseOfferings()) {
                    Set<StudentCourseDemands.WeightedStudentId> demands;
                    Course course = courseTable.get(co.getUniqueId());
                    if (course == null || (demands = this.iStudentCourseDemands.getDemands(co)) == null) continue;
                    block13: for (StudentCourseDemands.WeightedStudentId demand : demands) {
                        Set classIds;
                        Student student = (Student)students.get(demand.getStudentId());
                        if (student == null) {
                            student = new Student(demand.getStudentId(), true);
                            if (demand.getArea() != null && demand.getClasf() != null) {
                                student.getAcademicAreaClasiffications().add(new AcademicAreaCode(demand.getArea(), demand.getClasf()));
                            }
                            if (demand.getArea() != null && demand.getMajor() != null && !demand.getMajor().isEmpty()) {
                                for (String mj : demand.getMajor().split("\\|")) {
                                    student.getMajors().add(new AcademicAreaCode(demand.getArea(), mj));
                                }
                            }
                            students.put(demand.getStudentId(), student);
                        }
                        ArrayList<Course> courses = new ArrayList<Course>();
                        courses.add(course);
                        CourseRequest request = new CourseRequest(requestId--, 0, false, student, courses, false, null);
                        request.setWeight((double)demand.getWeight());
                        if (classAssignments == null || classAssignments.isEmpty() || (classIds = (Set)classAssignments.get(demand.getStudentId())) == null) continue;
                        block15: for (Enrollment enrollment : request.values(this.getAssignment())) {
                            for (Section section : enrollment.getSections()) {
                                if (classIds.contains(section.getId())) continue;
                                continue block15;
                            }
                            request.setInitialAssignment((Value)enrollment);
                            continue block13;
                        }
                    }
                }
            }
            for (Student student : students.values()) {
                this.getModel().addStudent(student);
                this.assignStudent(student);
            }
            for (Student student : students.values()) {
                this.checkForConflicts(student);
            }
            if (this.iFixWeights) {
                this.fixWeights(hibSession, courseTable.values());
            }
            this.getModel().createAssignmentContexts(this.getAssignment(), true);
        }
        if (this.iLoadSectioningInfos) {
            List infos = hibSession.createQuery("select i from SectioningInfo i where i.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", this.iSessionId.longValue()).list();
            this.iProgress.setPhase("Loading sectioning infos...", (long)infos.size());
            for (SectioningInfo info : infos) {
                this.iProgress.incProgress();
                Section section = classTable.get(info.getClazz().getUniqueId());
                if (section == null) continue;
                section.setSpaceExpected(info.getNbrExpectedStudents().doubleValue());
                section.setSpaceHeld(info.getNbrHoldingStudents().doubleValue());
                if (section.getLimit() < 0 || !((double)(section.getLimit() - section.getEnrollments(this.getAssignment()).size()) <= section.getSpaceExpected())) continue;
                this.iProgress.info("Section " + section.getSubpart().getConfig().getOffering().getName() + " " + section.getSubpart().getName() + " " + section.getName() + " has high demand (limit: " + section.getLimit() + ", enrollment: " + section.getEnrollments(this.getAssignment()).size() + ", expected: " + section.getSpaceExpected() + ")");
            }
        }
        this.iProgress.setPhase("Done", 1L);
        this.iProgress.incProgress();
    }

    public static interface SectionProvider {
        public Section get(Long var1);
    }
}

