/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.mux.MuxRpcDispatcher;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.jgroups.AbstractSolverServer;
import org.unitime.timetable.solver.jgroups.RemoteSolver;
import org.unitime.timetable.solver.jgroups.RemoteSolverContainer;
import org.unitime.timetable.solver.jgroups.ReplicatedSolverContainer;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.solver.jgroups.SolverContainerWrapper;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummySolverServer
extends AbstractSolverServer
implements MessageListener {
    private static Log sLog = LogFactory.getLog(DummySolverServer.class);
    public static final RequestOptions sFirstResponse = new RequestOptions(ResponseMode.GET_FIRST, 0L).setFlags(new Message.Flag[]{Message.Flag.DONT_BUNDLE, Message.Flag.OOB});
    public static final RequestOptions sAllResponses = new RequestOptions(ResponseMode.GET_ALL, 0L).setFlags(new Message.Flag[]{Message.Flag.DONT_BUNDLE, Message.Flag.OOB});
    private JChannel iChannel = null;
    private RpcDispatcher iDispatcher;
    private RpcDispatcher iRoomAvailabilityDispatcher;
    protected Properties iProperties = null;
    private DummyContainer<SolverProxy> iCourseSolverContainer;
    private DummyContainer<ExamSolverProxy> iExamSolverContainer;
    private DummyContainer<StudentSolverProxy> iStudentSolverContainer;
    private DummyContainer<OnlineSectioningServer> iOnlineStudentSchedulingContainer;
    private SolverContainerWrapper<SolverProxy> iCourseSolverContainerWrapper;
    private SolverContainerWrapper<ExamSolverProxy> iExamSolverContainerWrapper;
    private SolverContainerWrapper<StudentSolverProxy> iStudentSolverContainerWrapper;
    private SolverContainerWrapper<OnlineSectioningServer> iOnlineStudentSchedulingContainerWrapper;

    public DummySolverServer(JChannel channel) {
        this.iChannel = channel;
        this.iDispatcher = new MuxRpcDispatcher(0, (Channel)channel, null, null, (Object)this);
        this.iCourseSolverContainer = new DummyContainer<SolverProxy>(channel, 1, SolverProxy.class);
        this.iExamSolverContainer = new DummyContainer<ExamSolverProxy>(channel, 2, ExamSolverProxy.class);
        this.iStudentSolverContainer = new DummyContainer<StudentSolverProxy>(channel, 3, StudentSolverProxy.class);
        this.iOnlineStudentSchedulingContainer = new ReplicatedDummyContainer<OnlineSectioningServer>(channel, 5, OnlineSectioningServer.class);
        this.iRoomAvailabilityDispatcher = new MuxRpcDispatcher(4, (Channel)channel, null, null, (Object)this);
        this.iCourseSolverContainerWrapper = new SolverContainerWrapper<SolverProxy>(this.iDispatcher, this.iCourseSolverContainer, false);
        this.iExamSolverContainerWrapper = new SolverContainerWrapper<ExamSolverProxy>(this.iDispatcher, this.iExamSolverContainer, false);
        this.iStudentSolverContainerWrapper = new SolverContainerWrapper<StudentSolverProxy>(this.iDispatcher, this.iStudentSolverContainer, false);
        this.iOnlineStudentSchedulingContainerWrapper = new SolverContainerWrapper<OnlineSectioningServer>(this.iDispatcher, this.iOnlineStudentSchedulingContainer, false);
    }

    public Properties getProperties() {
        if (this.iProperties == null) {
            this.iProperties = ApplicationProperties.getProperties();
        }
        return this.iProperties;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public Address getAddress() {
        return this.iChannel.getAddress();
    }

    @Override
    public Address getLocalAddress() {
        try {
            RspList ret = this.iDispatcher.callRemoteMethods(null, "isLocal", new Object[0], new Class[0], sAllResponses);
            for (Rsp local : ret) {
                if (!Boolean.TRUE.equals(local.getValue())) continue;
                return local.getSender();
            }
            return null;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to retrieve local address: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getHost() {
        return this.iChannel.getAddressAsString();
    }

    @Override
    public int getUsage() {
        return 0;
    }

    @Override
    public long getAvailableMemory() {
        return 0L;
    }

    @Override
    public long getMemoryLimit() {
        return 0L;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        return false;
    }

    @Override
    public SolverContainer<SolverProxy> getCourseSolverContainer() {
        return this.iCourseSolverContainerWrapper;
    }

    @Override
    public SolverContainer<ExamSolverProxy> getExamSolverContainer() {
        return this.iExamSolverContainerWrapper;
    }

    @Override
    public SolverContainer<StudentSolverProxy> getStudentSolverContainer() {
        return this.iStudentSolverContainerWrapper;
    }

    @Override
    public SolverContainer<OnlineSectioningServer> getOnlineStudentSchedulingContainer() {
        return this.iOnlineStudentSchedulingContainerWrapper;
    }

    @Override
    public RoomAvailabilityInterface getRoomAvailability() {
        Address local = this.getLocalAddress();
        if (local == null) {
            return null;
        }
        return (RoomAvailabilityInterface)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{RoomAvailabilityInterface.class}, (InvocationHandler)new RoomAvailabilityInvocationHandler(local));
    }

    public void receive(Message msg) {
        sLog.info((Object)("receive(" + msg + ", " + msg.getObject() + ")"));
    }

    public void getState(OutputStream output) throws Exception {
        this.getProperties().store(output, "UniTime Application Properties");
    }

    public void setState(InputStream input) throws Exception {
        if (this.iProperties == null) {
            this.iProperties = new Properties();
        } else {
            this.iProperties.clear();
        }
        this.iProperties.load(input);
    }

    @Override
    public boolean isCoordinator() {
        return false;
    }

    @Override
    public List<SolverServer> getServers(boolean onlyAvailable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SolverServer crateServerProxy(Address address) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReplicatedDummyContainer<T>
    extends DummyContainer<T>
    implements ReplicatedSolverContainer<T> {
        public ReplicatedDummyContainer(JChannel channel, short scope, Class<T> clazz) {
            super(channel, scope, clazz);
        }

        @Override
        public Object dispatch(Collection<Address> addresses, String sessionId, Method method, Object[] args) throws Exception {
            try {
                if (addresses.size() == 1) {
                    return this.dispatch((Address)ToolBox.random(addresses), sessionId, method, args);
                }
                Address address = (Address)ToolBox.random(addresses);
                CheckMaster ch = method.getAnnotation(CheckMaster.class);
                if (ch == null && "execute".equals(method.getName())) {
                    ch = args[0].getClass().getAnnotation(CheckMaster.class);
                }
                RspList ret = this.iDispatcher.callRemoteMethods(addresses, "hasMaster", new Object[]{sessionId}, new Class[]{String.class}, SolverServerImplementation.sAllResponses);
                if (ch != null && ch.value() == CheckMaster.Master.REQUIRED) {
                    for (Rsp rsp : ret) {
                        if (rsp == null || !((Boolean)rsp.getValue()).booleanValue()) continue;
                        address = rsp.getSender();
                        break;
                    }
                } else {
                    ArrayList<Address> slaves = new ArrayList<Address>();
                    for (Rsp rsp : ret) {
                        if (rsp == null || ((Boolean)rsp.getValue()).booleanValue()) continue;
                        slaves.add(rsp.getSender());
                    }
                    if (!slaves.isEmpty()) {
                        address = (Address)ToolBox.random(slaves);
                    }
                }
                return this.dispatch(address, sessionId, method, args);
            }
            catch (InvocationTargetException e) {
                throw (Exception)e.getTargetException();
            }
        }

        @Override
        public T createProxy(Collection<Address> addresses, String user) {
            ReplicatedServerInvocationHandler handler = new ReplicatedServerInvocationHandler(addresses, user);
            Object px = Proxy.newProxyInstance(this.iClazz.getClassLoader(), new Class[]{this.iClazz, RemoteSolver.class}, (InvocationHandler)handler);
            return (T)px;
        }

        @Override
        public boolean hasMaster(String user) {
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ReplicatedServerInvocationHandler
        implements InvocationHandler {
            private Collection<Address> iAddresses;
            private String iUser;

            private ReplicatedServerInvocationHandler(Collection<Address> addresses, String user) {
                this.iAddresses = addresses;
                this.iUser = user;
            }

            public String getHost() {
                return this.iAddresses.toString();
            }

            public String getUser() {
                return this.iUser;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
                }
                catch (NoSuchMethodException e) {
                    return ReplicatedDummyContainer.this.dispatch(this.iAddresses, this.iUser, method, args);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DummyContainer<T>
    implements RemoteSolverContainer<T> {
        protected RpcDispatcher iDispatcher;
        protected Class<T> iClazz;

        public DummyContainer(JChannel channel, short scope, Class<T> clazz) {
            this.iDispatcher = new MuxRpcDispatcher(scope, (Channel)channel, null, null, (Object)this);
            this.iClazz = clazz;
        }

        @Override
        public Set<String> getSolvers() {
            return new HashSet<String>();
        }

        @Override
        public T getSolver(String user) {
            return null;
        }

        @Override
        public long getMemUsage(String user) {
            return 0L;
        }

        @Override
        public boolean hasSolver(String user) {
            return false;
        }

        @Override
        public T createSolver(String user, DataProperties config) {
            return null;
        }

        @Override
        public void unloadSolver(String user) {
        }

        @Override
        public int getUsage() {
            return 0;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public boolean createRemoteSolver(String user, DataProperties config, Address caller) {
            return false;
        }

        @Override
        public RpcDispatcher getDispatcher() {
            return this.iDispatcher;
        }

        @Override
        public Object dispatch(Address address, String user, Method method, Object[] args) throws Exception {
            try {
                return this.iDispatcher.callRemoteMethod(address, "invoke", new Object[]{method.getName(), user, method.getParameterTypes(), args}, new Class[]{String.class, String.class, Class[].class, Object[].class}, SolverServerImplementation.sFirstResponse);
            }
            catch (Exception e) {
                sLog.debug((Object)("Excution of " + method.getName() + " on solver " + user + " failed: " + e.getMessage()), (Throwable)e);
                throw e;
            }
        }

        @Override
        public Object invoke(String method, String user, Class[] types, Object[] args) throws Exception {
            throw new Exception("Method " + method + " not implemented.");
        }

        @Override
        public T createProxy(Address address, String user) {
            SolverInvocationHandler handler = new SolverInvocationHandler(address, user);
            return (T)Proxy.newProxyInstance(this.iClazz.getClassLoader(), new Class[]{this.iClazz, RemoteSolver.class}, (InvocationHandler)handler);
        }

        public class SolverInvocationHandler
        implements InvocationHandler {
            private Address iAddress;
            private String iUser;

            private SolverInvocationHandler(Address address, String user) {
                this.iAddress = address;
                this.iUser = user;
            }

            public String getHost() {
                return this.iAddress.toString();
            }

            public String getUser() {
                return this.iUser;
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
                }
                catch (NoSuchMethodException e) {
                    return DummyContainer.this.dispatch(this.iAddress, this.iUser, method, args);
                }
            }
        }
    }

    public class RoomAvailabilityInvocationHandler
    implements InvocationHandler {
        private Address iAddress;

        private RoomAvailabilityInvocationHandler(Address address) {
            this.iAddress = address;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return DummySolverServer.this.iRoomAvailabilityDispatcher.callRemoteMethod(this.iAddress, "invoke", new Object[]{method.getName(), method.getParameterTypes(), args}, new Class[]{String.class, Class[].class, Object[].class}, SolverServerImplementation.sFirstResponse);
            }
            catch (Exception e) {
                sLog.error((Object)("Excution of room availability method " + method + " failed: " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
    }
}

