/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula.students;

import java.util.ArrayList;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.solver.curricula.students.CurModel;
import org.unitime.timetable.solver.curricula.students.CurSimpleAssignment;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurHillClimber
implements NeighbourSelection<CurVariable, CurValue> {
    protected CurHillClimber(DataProperties config) {
    }

    public void init(Solver<CurVariable, CurValue> solver) {
    }

    public Neighbour<CurVariable, CurValue> selectNeighbour(Solution<CurVariable, CurValue> solution) {
        CurModel model = (CurModel)solution.getModel();
        Assignment assignment = solution.getAssignment();
        ArrayList<CurValue> best = new ArrayList<CurValue>();
        double bestValue = 0.0;
        int ix = ToolBox.random((int)model.variables().size());
        for (int i = 0; i < model.variables().size(); ++i) {
            CurVariable course = (CurVariable)((Object)model.variables().get((ix + i) % model.variables().size()));
            CurValue current = (CurValue)assignment.getValue((Variable)course);
            if (!course.getCourse().isComplete((Assignment<CurVariable, CurValue>)assignment) && current != null) continue;
            int jx = ToolBox.random((int)course.values(solution.getAssignment()).size());
            if (current != null && current.getStudent().getCourses((Assignment<CurVariable, CurValue>)assignment).size() <= model.getStudentLimit().getMinLimit()) continue;
            for (int j = 0; j < course.values(solution.getAssignment()).size(); ++j) {
                CurValue student = (CurValue)((Object)course.values(solution.getAssignment()).get((j + jx) % course.values(solution.getAssignment()).size()));
                if (course.getCourse().getStudents((Assignment<CurVariable, CurValue>)assignment).contains((Object)student.getStudent()) || student.getStudent().getCourses((Assignment<CurVariable, CurValue>)assignment).size() >= model.getStudentLimit().getMaxLimit()) continue;
                if (course.getCourse().getSize((Assignment<CurVariable, CurValue>)assignment) + student.getStudent().getWeight() - (current == null ? 0.0 : current.getStudent().getWeight()) > course.getCourse().getMaxSize() || current != null && course.getCourse().getSize((Assignment<CurVariable, CurValue>)assignment) + student.getStudent().getWeight() - current.getStudent().getWeight() < course.getCourse().getMaxSize() - model.getMinStudentWidth()) continue;
                double value = student.toDouble((Assignment<CurVariable, CurValue>)assignment);
                if (best.isEmpty() || value < bestValue) {
                    if (value < 0.0) {
                        return new CurSimpleAssignment(student);
                    }
                    best.clear();
                    best.add(student);
                    bestValue = value;
                    continue;
                }
                if (value != bestValue) continue;
                best.add(student);
            }
        }
        CurValue student = (CurValue)((Object)ToolBox.random(best));
        if (bestValue > 0.0 && !((CurVariable)student.variable()).getCourse().isComplete((Assignment<CurVariable, CurValue>)assignment)) {
            return null;
        }
        return student == null ? null : new CurSimpleAssignment(student);
    }
}

