/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.Collection;
import java.util.Set;
import org.cpsolver.ifs.util.Progress;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.CourseOfferingDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface StudentCourseDemands {
    public void init(org.hibernate.Session var1, Progress var2, Session var3, Collection<InstructionalOffering> var4);

    public Set<WeightedStudentId> getDemands(CourseOffering var1);

    public Double getEnrollmentPriority(Long var1, Long var2);

    public boolean isMakingUpStudents();

    public boolean canUseStudentClassEnrollmentsAsSolution();

    public boolean isWeightStudentsToFillUpOffering();

    public Set<WeightedCourseOffering> getCourses(Long var1);

    public static class WeightedCourseOffering {
        private transient CourseOffering iCourseOffering = null;
        private long iCourseOfferingId;
        private float iWeight = 1.0f;

        public WeightedCourseOffering(CourseOffering courseOffering) {
            this.iCourseOffering = courseOffering;
            this.iCourseOfferingId = courseOffering.getUniqueId();
        }

        public WeightedCourseOffering(Long courseOfferingId) {
            this.iCourseOfferingId = courseOfferingId;
        }

        public WeightedCourseOffering(CourseOffering courseOffering, float weight) {
            this(courseOffering);
            this.iWeight = weight;
        }

        public WeightedCourseOffering(Long courseOfferingId, float weight) {
            this(courseOfferingId);
            this.iWeight = weight;
        }

        public Long getCourseOfferingId() {
            return this.iCourseOfferingId;
        }

        public CourseOffering getCourseOffering() {
            if (this.iCourseOffering == null) {
                this.iCourseOffering = (CourseOffering)CourseOfferingDAO.getInstance().get(this.iCourseOfferingId);
            }
            return this.iCourseOffering;
        }

        public float getWeight() {
            return this.iWeight;
        }
    }

    public static class WeightedStudentId {
        private long iStudentId;
        private float iWeight;
        private String iAreaAbbv;
        private String iClasfCode;
        private String iMajorCode;
        private String iCurriculum;

        public WeightedStudentId(long studentId, float weight) {
            this.iStudentId = studentId;
            this.iWeight = weight;
        }

        public WeightedStudentId(long studentId) {
            this(studentId, 1.0f);
        }

        public long getStudentId() {
            return this.iStudentId;
        }

        public float getWeight() {
            return this.iWeight;
        }

        public void setWeight(float weight) {
            this.iWeight = weight;
        }

        public void setStats(String areaAbbv, String clasfCode, String majorCode) {
            this.iAreaAbbv = areaAbbv;
            this.iClasfCode = clasfCode;
            this.iMajorCode = majorCode;
        }

        public void setCurriculum(String curriculum) {
            this.iCurriculum = curriculum;
        }

        public String getArea() {
            return this.iAreaAbbv;
        }

        public String getClasf() {
            return this.iClasfCode;
        }

        public String getMajor() {
            return this.iMajorCode;
        }

        public String getCurriculum() {
            return this.iCurriculum;
        }

        public boolean match(String areaAbbv, String clasfCode, String majorCode) {
            return areaAbbv.equals(this.iAreaAbbv) && clasfCode.equals(this.iClasfCode) && majorCode.equals(this.iMajorCode);
        }

        public boolean match(CurriculumClassification clasf) {
            if (!clasf.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation().equals(this.iAreaAbbv)) {
                return false;
            }
            if (!clasf.getAcademicClassification().getCode().equals(this.iClasfCode)) {
                return false;
            }
            if (clasf.getCurriculum().getMajors().isEmpty()) {
                return true;
            }
            for (PosMajor m : clasf.getCurriculum().getMajors()) {
                if (!m.getCode().equals(this.iMajorCode)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return new Long(this.getStudentId()).hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof WeightedStudentId)) {
                return false;
            }
            return this.getStudentId() == ((WeightedStudentId)o).getStudentId();
        }

        public String toString() {
            return String.valueOf(this.getStudentId());
        }
    }
}

