/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastLikeStudentCourseDemands
implements StudentCourseDemands {
    protected org.hibernate.Session iHibSession;
    protected Hashtable<String, Set<StudentCourseDemands.WeightedStudentId>> iDemandsForPemId = new Hashtable();
    protected Hashtable<Long, Hashtable<String, Set<StudentCourseDemands.WeightedStudentId>>> iDemandsForSubjectCourseNbr = new Hashtable();
    protected Hashtable<Long, Set<StudentCourseDemands.WeightedCourseOffering>> iStudentRequests = null;
    protected Long iSessionId = null;

    public LastLikeStudentCourseDemands(DataProperties properties) {
    }

    @Override
    public boolean isMakingUpStudents() {
        return false;
    }

    @Override
    public boolean canUseStudentClassEnrollmentsAsSolution() {
        return false;
    }

    @Override
    public boolean isWeightStudentsToFillUpOffering() {
        return false;
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        this.iHibSession = hibSession;
        this.iSessionId = session.getUniqueId();
    }

    public float getProjection(String areaAbbv, String clasfCode, String majorCode) {
        return 1.0f;
    }

    protected Hashtable<String, Set<StudentCourseDemands.WeightedStudentId>> loadSubject(SubjectArea subject) {
        Hashtable<String, Set<StudentCourseDemands.WeightedStudentId>> demandsForCourseNbr = new Hashtable<String, Set<StudentCourseDemands.WeightedStudentId>>();
        this.iDemandsForSubjectCourseNbr.put(subject.getUniqueId(), demandsForCourseNbr);
        for (Object[] d : this.iHibSession.createQuery("select d.courseNbr, s.uniqueId, d.coursePermId, a.academicAreaAbbreviation, f.code, m.code from LastLikeCourseDemand d inner join d.student s left outer join s.academicAreaClassifications c left outer join s.posMajors m left outer join c.academicArea a left outer join c.academicClassification f where d.subjectArea.uniqueId=:subjectAreaId").setLong("subjectAreaId", subject.getUniqueId().longValue()).setCacheable(true).list()) {
            String courseNbr = (String)d[0];
            String coursePermId = (String)d[2];
            String areaAbbv = (String)d[3];
            String clasfCode = (String)d[4];
            String majorCode = (String)d[5];
            StudentCourseDemands.WeightedStudentId studentId = new StudentCourseDemands.WeightedStudentId((Long)d[1], this.getProjection(areaAbbv, clasfCode, majorCode));
            studentId.setStats(areaAbbv, clasfCode, majorCode);
            studentId.setCurriculum(areaAbbv == null ? null : (majorCode == null ? areaAbbv : areaAbbv + "/" + majorCode));
            Set<StudentCourseDemands.WeightedStudentId> studentIds = demandsForCourseNbr.get(courseNbr);
            if (studentIds == null) {
                studentIds = new HashSet<StudentCourseDemands.WeightedStudentId>();
                demandsForCourseNbr.put(courseNbr, studentIds);
            }
            studentIds.add(studentId);
            if (coursePermId == null) continue;
            studentIds = this.iDemandsForPemId.get(coursePermId);
            if (studentIds == null) {
                studentIds = new HashSet<StudentCourseDemands.WeightedStudentId>();
                this.iDemandsForPemId.put(coursePermId, studentIds);
            }
            studentIds.add(studentId);
        }
        return demandsForCourseNbr;
    }

    @Override
    public Set<StudentCourseDemands.WeightedStudentId> getDemands(CourseOffering course) {
        Hashtable<String, Set<StudentCourseDemands.WeightedStudentId>> demandsForCourseNbr = this.iDemandsForSubjectCourseNbr.get(course.getSubjectArea().getUniqueId());
        if (demandsForCourseNbr == null) {
            demandsForCourseNbr = this.loadSubject(course.getSubjectArea());
        }
        Set<StudentCourseDemands.WeightedStudentId> studentIds = null;
        if (course.getPermId() != null) {
            studentIds = this.iDemandsForPemId.get(course.getPermId());
        }
        if (studentIds == null) {
            studentIds = demandsForCourseNbr.get(course.getCourseNbr());
        }
        if (course.getDemandOffering() != null && !course.getDemandOffering().equals(course)) {
            if (studentIds == null) {
                studentIds = this.getDemands(course.getDemandOffering());
            } else {
                studentIds = new HashSet<StudentCourseDemands.WeightedStudentId>(studentIds);
                studentIds.addAll(this.getDemands(course.getDemandOffering()));
            }
        }
        if (studentIds == null) {
            studentIds = new HashSet<StudentCourseDemands.WeightedStudentId>();
        }
        return studentIds;
    }

    @Override
    public Set<StudentCourseDemands.WeightedCourseOffering> getCourses(Long studentId) {
        if (this.iStudentRequests == null) {
            this.iStudentRequests = new Hashtable();
            for (Object[] o : this.iHibSession.createQuery("select s.uniqueId, co, a.academicAreaAbbreviation, f.code, m.code from LastLikeCourseDemand x inner join x.student s left outer join s.academicAreaClassifications c left outer join s.posMajors m left outer join c.academicArea a left outer join c.academicClassification f, CourseOffering co where x.subjectArea.session.uniqueId = :sessionId and co.subjectArea.uniqueId = x.subjectArea.uniqueId and ((x.coursePermId is not null and co.permId=x.coursePermId) or (x.coursePermId is null and co.courseNbr=x.courseNbr))").setLong("sessionId", this.iSessionId.longValue()).setCacheable(true).list()) {
                Long sid = (Long)o[0];
                CourseOffering co = (CourseOffering)o[1];
                String areaAbbv = (String)o[2];
                String clasfCode = (String)o[3];
                String majorCode = (String)o[4];
                Set<StudentCourseDemands.WeightedCourseOffering> courses = this.iStudentRequests.get(sid);
                if (courses == null) {
                    courses = new HashSet<StudentCourseDemands.WeightedCourseOffering>();
                    this.iStudentRequests.put(sid, courses);
                }
                courses.add(new StudentCourseDemands.WeightedCourseOffering(co, this.getProjection(areaAbbv, clasfCode, majorCode)));
            }
        }
        return this.iStudentRequests.get(studentId);
    }

    @Override
    public Double getEnrollmentPriority(Long studentId, Long courseId) {
        return null;
    }
}

