/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.IdGenerator;
import org.cpsolver.ifs.util.Progress;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumCourseGroup;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.solver.curricula.CurriculumEnrollmentPriorityProvider;
import org.unitime.timetable.solver.curricula.DefaultCurriculumEnrollmentPriorityProvider;
import org.unitime.timetable.solver.curricula.ParallelInitialization;
import org.unitime.timetable.solver.curricula.ProjectedStudentCourseDemands;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;
import org.unitime.timetable.solver.curricula.students.CurCourse;
import org.unitime.timetable.solver.curricula.students.CurModel;
import org.unitime.timetable.solver.curricula.students.CurStudent;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculaLastLikeCourseDemands
implements StudentCourseDemands {
    private static Log sLog = LogFactory.getLog(CurriculaLastLikeCourseDemands.class);
    private ProjectedStudentCourseDemands iProjectedDemands;
    private IdGenerator iLastStudentId = new IdGenerator();
    private Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>> iDemands = new Hashtable();
    private Hashtable<Long, Set<StudentCourseDemands.WeightedCourseOffering>> iStudentRequests = new Hashtable();
    private Hashtable<Long, Hashtable<String, Set<String>>> iLoadedCurricula = new Hashtable();
    private Hashtable<Long, Hashtable<Long, Double>> iEnrollmentPriorities = new Hashtable();
    private HashSet<Long> iCheckedCourses = new HashSet();
    private boolean iIncludeOtherStudents = true;
    private boolean iSetStudentCourseLimits = false;
    private CurriculumEnrollmentPriorityProvider iEnrollmentPriorityProvider = null;
    private DataProperties iProperties = null;

    public CurriculaLastLikeCourseDemands(DataProperties config) {
        this.iProperties = config;
        this.iProjectedDemands = new ProjectedStudentCourseDemands(config);
        this.iIncludeOtherStudents = config.getPropertyBoolean("CurriculaCourseDemands.IncludeOtherStudents", this.iIncludeOtherStudents);
        this.iSetStudentCourseLimits = config.getPropertyBoolean("CurriculaCourseDemands.SetStudentCourseLimits", this.iSetStudentCourseLimits);
        this.iEnrollmentPriorityProvider = new DefaultCurriculumEnrollmentPriorityProvider(config);
        if (config.getProperty("CurriculaCourseDemands.CurriculumEnrollmentPriorityProvider") != null) {
            try {
                this.iEnrollmentPriorityProvider = (CurriculumEnrollmentPriorityProvider)Class.forName(config.getProperty("CurriculaCourseDemands.CurriculumEnrollmentPriorityProvider")).getConstructor(DataProperties.class).newInstance(config);
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to use custom enrollment priority provider: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        this.iProjectedDemands.init(hibSession, progress, session, offerings);
        List curricula = null;
        if (offerings != null && offerings.size() <= 1000) {
            String courses = "";
            int nrCourses = 0;
            for (InstructionalOffering offering : offerings) {
                for (CourseOffering course : offering.getCourseOfferings()) {
                    if (!courses.isEmpty()) {
                        courses = courses + ",";
                    }
                    courses = courses + course.getUniqueId();
                    ++nrCourses;
                }
            }
            if (nrCourses <= 1000) {
                curricula = hibSession.createQuery("select distinct c from CurriculumCourse cc inner join cc.classification.curriculum c where c.academicArea.session.uniqueId = :sessionId and cc.course.uniqueId in (" + courses + ")").setLong("sessionId", session.getUniqueId().longValue()).list();
            }
        }
        if (curricula == null) {
            curricula = hibSession.createQuery("select c from Curriculum c where c.academicArea.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list();
        }
        ArrayList<Initialization> inits = new ArrayList<Initialization>();
        for (Curriculum curriculum : curricula) {
            Hashtable<String, Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>>> lastLike = this.loadClasfCourseMajor2ll(hibSession, curriculum);
            for (CurriculumClassification clasf : curriculum.getClassifications()) {
                inits.add(new Initialization(clasf, lastLike.get(clasf.getAcademicClassification().getCode())));
            }
        }
        new ParallelInitialization("Loading curricula", this.iProperties.getPropertyInt("CurriculaCourseDemands.NrThreads", 1), inits).execute(hibSession, progress);
    }

    private Hashtable<String, Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>>> loadClasfCourseMajor2ll(org.hibernate.Session hibSession, Curriculum curriculum) {
        String majorCodes = "";
        for (PosMajor major : curriculum.getMajors()) {
            if (!majorCodes.isEmpty()) {
                majorCodes = majorCodes + ",";
            }
            majorCodes = majorCodes + "'" + major.getCode() + "'";
        }
        Hashtable<String, Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>>> clasf2courseLl = new Hashtable<String, Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>>>();
        for (Object[] o : hibSession.createQuery("select f.code, co, m.code, s.uniqueId from LastLikeCourseDemand x inner join x.student s inner join s.academicAreaClassifications a inner join a.academicClassification f inner join s.posMajors m, CourseOffering co where x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv " + (majorCodes.isEmpty() ? "" : "and m.code in (" + majorCodes + ") ") + "and co.subjectArea.uniqueId = x.subjectArea.uniqueId and " + "((x.coursePermId is not null and co.permId=x.coursePermId) or (x.coursePermId is null and co.courseNbr=x.courseNbr))").setLong("sessionId", curriculum.getDepartment().getSession().getUniqueId().longValue()).setString("acadAbbv", curriculum.getAcademicArea().getAcademicAreaAbbreviation()).setCacheable(true).list()) {
            Set<StudentCourseDemands.WeightedStudentId> students;
            String clasfCode = (String)o[0];
            CourseOffering course = (CourseOffering)o[1];
            String majorCode = (String)o[2];
            Long studentId = (Long)o[3];
            StudentCourseDemands.WeightedStudentId student = new StudentCourseDemands.WeightedStudentId(studentId, this.iProjectedDemands.getProjection(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), clasfCode, majorCode));
            student.setStats(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), clasfCode, majorCode);
            student.setCurriculum(curriculum.getAbbv());
            Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> course2ll = clasf2courseLl.get(clasfCode);
            if (course2ll == null) {
                course2ll = new Hashtable();
                clasf2courseLl.put(clasfCode, course2ll);
            }
            if ((students = course2ll.get(course)) == null) {
                students = new HashSet<StudentCourseDemands.WeightedStudentId>();
                course2ll.put(course, students);
            }
            students.add(student);
        }
        return clasf2courseLl;
    }

    protected String getCacheName() {
        return "curriculum-lastlike-demands";
    }

    protected void computeTargetShare(CurriculumClassification clasf, CurModel model) {
        for (CurriculumCourse c1 : clasf.getCourses()) {
            double x1 = (float)clasf.getNrStudents().intValue() * c1.getPercShare().floatValue();
            HashSet[] group = new HashSet[]{new HashSet(), new HashSet()};
            LinkedList<CurriculumCourse> queue = new LinkedList<CurriculumCourse>();
            queue.add(c1);
            HashSet<CurriculumCourseGroup> done = new HashSet<CurriculumCourseGroup>();
            while (!queue.isEmpty()) {
                CurriculumCourse c = (CurriculumCourse)queue.poll();
                for (CurriculumCourseGroup g : c.getGroups()) {
                    if (!done.add(g)) continue;
                    for (CurriculumCourse x : clasf.getCourses()) {
                        if (x.equals(c) || x.equals(c1) || !x.getGroups().contains(g) || !group[group[0].contains(c) ? 0 : g.getType()].add(x)) continue;
                        queue.add(x);
                    }
                }
            }
            for (CurriculumCourse c2 : clasf.getCourses()) {
                double x2 = (float)clasf.getNrStudents().intValue() * c2.getPercShare().floatValue();
                if (c1.getUniqueId() >= c2.getUniqueId()) continue;
                double share = 0.0;
                Set<StudentCourseDemands.WeightedStudentId> s1 = this.iProjectedDemands.getDemands(c1.getCourse());
                Set<StudentCourseDemands.WeightedStudentId> s2 = this.iProjectedDemands.getDemands(c2.getCourse());
                double sharedStudents = 0.0;
                double lastLike = 0.0;
                if (s1 != null && !s1.isEmpty() && s2 != null && !s2.isEmpty()) {
                    for (StudentCourseDemands.WeightedStudentId s : s1) {
                        if (!s.match(clasf)) continue;
                        lastLike += (double)s.getWeight();
                        if (!s2.contains(s)) continue;
                        sharedStudents += (double)s.getWeight();
                    }
                }
                if (lastLike > 0.0) {
                    double requested = c1.getPercShare().floatValue() * (float)clasf.getNrStudents().intValue();
                    share = requested / lastLike * sharedStudents;
                } else {
                    share = c1.getPercShare().floatValue() * c2.getPercShare().floatValue() * (float)clasf.getNrStudents().intValue();
                }
                boolean opt = group[0].contains(c2);
                boolean req = !opt && group[1].contains(c2);
                model.setTargetShare(c1.getCourse().getUniqueId(), c2.getCourse().getUniqueId(), opt ? 0.0 : (req ? Math.min(x1, x2) : share), false);
            }
        }
    }

    @Override
    public Set<StudentCourseDemands.WeightedCourseOffering> getCourses(Long studentId) {
        Set<StudentCourseDemands.WeightedCourseOffering> courses = this.iStudentRequests.get(studentId);
        if (this.iIncludeOtherStudents && studentId >= 0L && courses == null) {
            return this.iProjectedDemands.getCourses(studentId);
        }
        return this.iStudentRequests.get(studentId);
    }

    @Override
    public Set<StudentCourseDemands.WeightedStudentId> getDemands(CourseOffering course) {
        if (this.iDemands.isEmpty()) {
            return this.iProjectedDemands.getDemands(course);
        }
        Set<StudentCourseDemands.WeightedStudentId> demands = this.iDemands.get(course.getUniqueId());
        if (!this.iIncludeOtherStudents) {
            return demands;
        }
        if (demands == null) {
            demands = new HashSet<StudentCourseDemands.WeightedStudentId>();
            this.iDemands.put(course.getUniqueId(), demands);
        }
        if (this.iCheckedCourses.add(course.getUniqueId())) {
            int was = demands.size();
            Hashtable<String, Set<String>> curricula = this.iLoadedCurricula.get(course.getUniqueId());
            Set<StudentCourseDemands.WeightedStudentId> other = this.iProjectedDemands.getDemands(course);
            if (other == null) {
                sLog.debug((Object)(course.getCourseName() + " has no students."));
            } else {
                if (curricula == null || curricula.isEmpty()) {
                    demands.addAll(other);
                } else {
                    for (StudentCourseDemands.WeightedStudentId student : other) {
                        Set<String> majors;
                        if (student.getArea() == null || (majors = curricula.get(student.getArea())) != null && majors.contains("") || majors != null && (student.getMajor() == null || majors.contains(student.getMajor()))) continue;
                        demands.add(student);
                    }
                }
                if (demands.size() > was) {
                    sLog.debug((Object)(course.getCourseName() + " has " + (demands.size() - was) + " other students (besides of the " + was + " curriculum students)."));
                }
            }
        }
        return demands;
    }

    @Override
    public boolean canUseStudentClassEnrollmentsAsSolution() {
        return false;
    }

    @Override
    public boolean isMakingUpStudents() {
        return false;
    }

    @Override
    public boolean isWeightStudentsToFillUpOffering() {
        return false;
    }

    @Override
    public Double getEnrollmentPriority(Long studentId, Long courseId) {
        Hashtable<Long, Double> priorities = this.iEnrollmentPriorities.get(studentId);
        return priorities == null ? null : priorities.get(courseId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Initialization
    implements ParallelInitialization.Task {
        private CurriculumClassification iClassification;
        private boolean iUpdateClassification = false;
        private Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> iLastLikeStudents;
        private CurModel iModel;
        private Hashtable<Long, CourseOffering> iCourses;
        private List<CurStudent> iCurStudents;
        private Hashtable<StudentCourseDemands.WeightedStudentId, Set<CourseOffering>> iStudents;
        private List<StudentCourseDemands.WeightedStudentId> iMadeUpStudents;
        private Hashtable<Long, StudentCourseDemands.WeightedStudentId> iStudentIds;
        private Assignment<CurVariable, CurValue> iAssignment;

        public Initialization(CurriculumClassification classification, Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> lastLikeStudents) {
            this.iClassification = classification;
            this.iLastLikeStudents = lastLikeStudents;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setup(org.hibernate.Session hibSession) {
            Element cache;
            sLog.debug((Object)("Processing " + this.iClassification.getCurriculum().getAbbv() + " " + this.iClassification.getName() + " ... (" + this.iClassification.getNrStudents() + " students, " + this.iClassification.getCourses().size() + " iCourses)"));
            this.iStudents = new Hashtable();
            if (this.iLastLikeStudents != null) {
                for (Map.Entry<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> entry : this.iLastLikeStudents.entrySet()) {
                    for (StudentCourseDemands.WeightedStudentId weightedStudentId : entry.getValue()) {
                        Set<CourseOffering> courses = this.iStudents.get(weightedStudentId);
                        if (courses == null) {
                            courses = new HashSet<CourseOffering>();
                            this.iStudents.put(weightedStudentId, courses);
                        }
                        courses.add(entry.getKey());
                    }
                }
            }
            float totalWeight = 0.0f;
            for (StudentCourseDemands.WeightedStudentId student : this.iStudents.keySet()) {
                totalWeight += student.getWeight();
            }
            sLog.debug((Object)("  last-like students: " + totalWeight + ", target: " + this.iClassification.getNrStudents()));
            this.iMadeUpStudents = new ArrayList<StudentCourseDemands.WeightedStudentId>();
            if (2.0f * totalWeight < (float)this.iClassification.getNrStudents().intValue()) {
                void var5_14;
                int n = Math.round((float)this.iClassification.getNrStudents().intValue() - totalWeight);
                sLog.debug((Object)("    making up " + n + " students"));
                Iterator<CurriculumCourse> majors = "";
                for (PosMajor major : this.iClassification.getCurriculum().getMajors()) {
                    if (!((String)((Object)majors)).isEmpty()) {
                        majors = (String)((Object)majors) + "|";
                    }
                    majors = (String)((Object)majors) + major.getCode();
                }
                boolean bl = false;
                while (var5_14 < n) {
                    StudentCourseDemands.WeightedStudentId student = new StudentCourseDemands.WeightedStudentId(-CurriculaLastLikeCourseDemands.this.iLastStudentId.newId());
                    student.setStats(this.iClassification.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation(), this.iClassification.getAcademicClassification().getCode(), (String)((Object)majors));
                    student.setCurriculum(this.iClassification.getCurriculum().getAbbv());
                    this.iStudents.put(student, new HashSet());
                    this.iMadeUpStudents.add(student);
                    ++var5_14;
                }
            } else {
                float f = (float)this.iClassification.getNrStudents().intValue() / totalWeight;
                sLog.debug((Object)("    changing student weight " + f + " times"));
                for (StudentCourseDemands.WeightedStudentId weightedStudentId : this.iStudents.keySet()) {
                    weightedStudentId.setWeight(weightedStudentId.getWeight() * f);
                }
            }
            this.iCurStudents = new ArrayList<CurStudent>();
            this.iStudentIds = new Hashtable();
            boolean bl = false;
            for (StudentCourseDemands.WeightedStudentId weightedStudentId : this.iStudents.keySet()) {
                void var3_9;
                this.iCurStudents.add(new CurStudent(weightedStudentId.getStudentId() < 0L ? (long)(-(++var3_9)) : weightedStudentId.getStudentId(), weightedStudentId.getWeight()));
                this.iStudentIds.put(weightedStudentId.getStudentId() < 0L ? (long)(-var3_9) : weightedStudentId.getStudentId(), weightedStudentId);
            }
            this.iModel = new CurModel(this.iCurStudents);
            this.iCourses = new Hashtable();
            for (CurriculumCourse curriculumCourse : this.iClassification.getCourses()) {
                HashSet<String> majors;
                this.iModel.addCourse(curriculumCourse.getCourse().getUniqueId(), curriculumCourse.getCourse().getCourseName(), (float)this.iClassification.getNrStudents().intValue() * curriculumCourse.getPercShare().floatValue(), CurriculaLastLikeCourseDemands.this.iEnrollmentPriorityProvider.getEnrollmentPriority(curriculumCourse));
                this.iCourses.put(curriculumCourse.getCourse().getUniqueId(), curriculumCourse.getCourse());
                Hashtable curricula = (Hashtable)CurriculaLastLikeCourseDemands.this.iLoadedCurricula.get(curriculumCourse.getCourse().getUniqueId());
                if (curricula == null) {
                    curricula = new Hashtable();
                    CurriculaLastLikeCourseDemands.this.iLoadedCurricula.put(curriculumCourse.getCourse().getUniqueId(), curricula);
                }
                if ((majors = (HashSet<String>)curricula.get(this.iClassification.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation())) == null) {
                    majors = new HashSet<String>();
                    curricula.put(this.iClassification.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation(), majors);
                }
                if (this.iClassification.getCurriculum().getMajors().isEmpty()) {
                    majors.add("");
                    continue;
                }
                for (PosMajor mj : this.iClassification.getCurriculum().getMajors()) {
                    majors.add(mj.getCode());
                }
            }
            CurriculaLastLikeCourseDemands.this.computeTargetShare(this.iClassification, this.iModel);
            if (CurriculaLastLikeCourseDemands.this.iSetStudentCourseLimits) {
                this.iModel.setStudentLimits();
            }
            Solution<CurVariable, CurValue> cachedSolution = null;
            this.iAssignment = new DefaultSingleAssignment();
            Document document = this.iClassification.getStudentsDocument();
            Element element = cache = document == null ? null : document.getRootElement();
            if (cache != null && cache.getName().equals(CurriculaLastLikeCourseDemands.this.getCacheName())) {
                cachedSolution = CurModel.loadFromXml(cache);
                if (CurriculaLastLikeCourseDemands.this.iSetStudentCourseLimits) {
                    ((CurModel)cachedSolution.getModel()).setStudentLimits();
                }
            }
            if (cachedSolution != null && ((CurModel)cachedSolution.getModel()).isSameModel((Object)this.iModel)) {
                sLog.debug((Object)"  using cached model...");
                this.iModel = (CurModel)cachedSolution.getModel();
                this.iAssignment = cachedSolution.getAssignment();
            } else {
                for (CurStudent student : this.iCurStudents) {
                    for (CourseOffering course : this.iStudents.get(this.iStudentIds.get(student.getStudentId()))) {
                        CurCourse curCourse = this.iModel.getCourse(course.getUniqueId());
                        if (curCourse == null) continue;
                        CurVariable var = null;
                        for (CurVariable v : curCourse.variables()) {
                            if (this.iAssignment.getValue((Variable)v) != null) continue;
                            var = v;
                            break;
                        }
                        if (var != null) {
                            CurValue val = new CurValue(var, student);
                            if (!this.iModel.inConflict(this.iAssignment, val)) {
                                this.iAssignment.assign(0L, (Value)val);
                                continue;
                            }
                            sLog.debug((Object)("Unable to assign " + (Object)((Object)student) + " to " + (Object)((Object)var)));
                            Map conf = this.iModel.conflictConstraints(this.iAssignment, val);
                            for (Map.Entry entry : conf.entrySet()) {
                                sLog.debug((Object)(entry.getKey() + ": " + entry.getValue()));
                            }
                            continue;
                        }
                        sLog.debug((Object)("No variable for " + (Object)((Object)student) + " to " + (Object)((Object)curCourse)));
                    }
                }
                this.iUpdateClassification = true;
            }
        }

        @Override
        public void execute() {
            if (this.iUpdateClassification) {
                sLog.debug((Object)("Initial: " + this.iModel.getInfo(this.iAssignment)));
                this.iModel.solve(CurriculaLastLikeCourseDemands.this.iProperties, this.iAssignment);
                sLog.debug((Object)("Final: " + this.iModel.getInfo(this.iAssignment)));
            }
        }

        @Override
        public void teardown(org.hibernate.Session hibSession) {
            if (this.iUpdateClassification) {
                Document doc = DocumentHelper.createDocument();
                this.iModel.saveAsXml(doc.addElement(CurriculaLastLikeCourseDemands.this.getCacheName()), this.iAssignment);
                this.iClassification.setStudentsDocument(doc);
                hibSession.update((Object)this.iClassification);
            }
            int idx = 0;
            for (CurStudent s : this.iModel.getStudents()) {
                StudentCourseDemands.WeightedStudentId student = null;
                student = s.getStudentId() < 0L ? this.iMadeUpStudents.get(idx++) : this.iStudentIds.get(s.getStudentId());
                HashSet<StudentCourseDemands.WeightedCourseOffering> studentCourses = new HashSet<StudentCourseDemands.WeightedCourseOffering>();
                CurriculaLastLikeCourseDemands.this.iStudentRequests.put(student.getStudentId(), studentCourses);
                Hashtable<Long, Double> priorities = new Hashtable<Long, Double>();
                CurriculaLastLikeCourseDemands.this.iEnrollmentPriorities.put(student.getStudentId(), priorities);
                for (CurCourse course : s.getCourses(this.iAssignment)) {
                    HashSet<StudentCourseDemands.WeightedStudentId> courseStudents;
                    CourseOffering co = this.iCourses.get(course.getCourseId());
                    if (course.getPriority() != null) {
                        priorities.put(co.getUniqueId(), course.getPriority());
                    }
                    if ((courseStudents = (HashSet<StudentCourseDemands.WeightedStudentId>)CurriculaLastLikeCourseDemands.this.iDemands.get(co.getUniqueId())) == null) {
                        courseStudents = new HashSet<StudentCourseDemands.WeightedStudentId>();
                        CurriculaLastLikeCourseDemands.this.iDemands.put(co.getUniqueId(), courseStudents);
                    }
                    courseStudents.add(student);
                    studentCourses.add(new StudentCourseDemands.WeightedCourseOffering(co, student.getWeight()));
                }
            }
        }
    }
}

