/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.ObjectNotFoundException;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.CommitedClassAssignmentProxy;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;

public class SolutionClassAssignmentProxy
extends CommitedClassAssignmentProxy {
    private Set iSolutionIds = new HashSet();
    private Hashtable iDepartmentIds = new Hashtable();

    public SolutionClassAssignmentProxy(Collection solutionIds) {
        Iterator i = solutionIds.iterator();
        while (i.hasNext()) {
            Solution solution = (Solution)new SolutionDAO().get((Long)i.next());
            if (solution == null) continue;
            this.iSolutionIds.add(solution.getUniqueId());
            Iterator<Department> j = solution.getOwner().getDepartments().iterator();
            while (j.hasNext()) {
                this.iDepartmentIds.put(j.next().getUniqueId(), solution.getUniqueId());
            }
        }
    }

    public SolutionClassAssignmentProxy(Solution solution) {
        this.iSolutionIds.add(solution.getUniqueId());
        Iterator<Department> j = solution.getOwner().getDepartments().iterator();
        while (j.hasNext()) {
            this.iDepartmentIds.put(j.next().getUniqueId(), solution.getUniqueId());
        }
    }

    public Long getSolutionId(Class_ clazz) {
        Department department = clazz.getManagingDept();
        if (department == null) {
            return null;
        }
        return (Long)this.iDepartmentIds.get(department.getUniqueId());
    }

    public Assignment getAssignment(Class_ clazz) throws Exception {
        Long solutionId = this.getSolutionId(clazz);
        if (solutionId == null) {
            return super.getAssignment(clazz);
        }
        Iterator<Assignment> i = null;
        try {
            i = clazz.getAssignments().iterator();
        }
        catch (ObjectNotFoundException e) {
            new _RootDAO().getSession().refresh((Object)clazz);
            i = clazz.getAssignments().iterator();
        }
        while (i.hasNext()) {
            Assignment a = i.next();
            if (!solutionId.equals(a.getSolution().getUniqueId())) continue;
            return a;
        }
        return null;
    }

    public AssignmentPreferenceInfo getAssignmentInfo(Class_ clazz) throws Exception {
        Long solutionId = this.getSolutionId(clazz);
        if (solutionId == null) {
            return super.getAssignmentInfo(clazz);
        }
        Assignment a = this.getAssignment(clazz);
        return a == null ? null : (AssignmentPreferenceInfo)a.getAssignmentInfo("AssignmentInfo");
    }

    public Set getSolutionIds() {
        return this.iSolutionIds;
    }

    public boolean equals(Collection solutionIds) {
        if (solutionIds.size() != this.iSolutionIds.size()) {
            return false;
        }
        for (Long solutionId : solutionIds) {
            if (this.iSolutionIds.contains(solutionId)) continue;
            return false;
        }
        return true;
    }
}

