/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.script;

import java.util.Date;
import java.util.List;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.ScriptInterface;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.script.ScriptExecution;
import org.unitime.timetable.util.queue.QueueItem;
import org.unitime.timetable.util.queue.QueueProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=ScriptInterface.GetQueueTableRpcRequest.class)
public class GetQueueTableBackend
implements GwtRpcImplementation<ScriptInterface.GetQueueTableRpcRequest, GwtRpcResponseList<ScriptInterface.QueueItemInterface>> {
    @Override
    public GwtRpcResponseList<ScriptInterface.QueueItemInterface> execute(ScriptInterface.GetQueueTableRpcRequest request, SessionContext context) {
        if (request.getDeleteId() != null) {
            QueueProcessor.getInstance().remove(request.getDeleteId());
        }
        List<QueueItem> queue = QueueProcessor.getInstance().getItems(null, null, "Script");
        GwtRpcResponseList<ScriptInterface.QueueItemInterface> table = new GwtRpcResponseList<ScriptInterface.QueueItemInterface>();
        Date now = new Date();
        long timeToShow = 3600000L;
        for (QueueItem item : queue) {
            if (item.finished() != null && now.getTime() - item.finished().getTime() > timeToShow) continue;
            table.add(GetQueueTableBackend.convert(item, context));
        }
        return table;
    }

    public static ScriptInterface.QueueItemInterface convert(QueueItem item, SessionContext context) {
        ScriptInterface.QueueItemInterface q = new ScriptInterface.QueueItemInterface();
        q.setId(item.getId());
        q.setName(item.name());
        q.setStatus(item.status());
        q.setProgress(item.progress() <= 0.0 || item.progress() >= 1.0 ? "" : String.valueOf(Math.round(100.0 * item.progress())) + "%");
        q.setOwner(item.getOwnerName());
        q.setSession(item.getSession() == null ? "None" : item.getSession().getLabel());
        q.setCreated(item.created());
        q.setStarted(item.started());
        q.setFinished(item.finished());
        if (item.finished() != null && item.hasOutput()) {
            q.setOutput(item.output().getName());
        }
        q.setLog(item.log());
        q.setCanDelete(context.getUser().getExternalUserId().equals(item.getOwnerId()) && (item.started() == null || item.finished() != null));
        if (item instanceof ScriptExecution) {
            q.setExecutionRequest(((ScriptExecution)item).getRequest());
        }
        return q;
    }
}

