/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.cpsolver.coursett.model.RoomSharingModel;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.RequiredTimeTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=RoomInterface.RoomSharingRequest.class)
public class RoomSharingBackend
implements GwtRpcImplementation<RoomInterface.RoomSharingRequest, RoomInterface.RoomSharingModel> {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public RoomInterface.RoomSharingModel execute(RoomInterface.RoomSharingRequest request, SessionContext context) {
        switch (request.getOperation()) {
            case LOAD: {
                return request.isEventAvailability() ? this.loadEventAvailability(request, context) : this.loadRoomSharing(request, context);
            }
            case SAVE: {
                return request.isEventAvailability() ? this.saveEventAvailability(request, context) : this.saveRoomSharing(request, context);
            }
        }
        return null;
    }

    public RoomInterface.RoomSharingModel loadRoomSharing(RoomInterface.RoomSharingRequest request, SessionContext context) {
        String mode;
        context.checkPermission(request.getLocationId(), "Location", Right.RoomDetailAvailability);
        Location location = (Location)LocationDAO.getInstance().get(request.getLocationId());
        RoomInterface.RoomSharingModel model = new RoomInterface.RoomSharingModel();
        model.setId(location.getUniqueId());
        model.setName(location.getLabel());
        int i = 0;
        while ((mode = ApplicationProperty.RoomSharingMode.value(String.valueOf(1 + i), i < CONSTANTS.roomSharingModes().length ? CONSTANTS.roomSharingModes()[i] : null)) != null && !mode.isEmpty()) {
            model.addMode(new RoomInterface.RoomSharingDisplayMode(mode));
            ++i;
        }
        boolean editable = context.hasPermission(location, Right.RoomEditAvailability);
        model.setDefaultEditable(editable);
        model.addOption(new RoomInterface.RoomSharingOption(-1L, "#FFFFFF", MESSAGES.codeFreeForAll(), MESSAGES.legendFreeForAll(), editable));
        model.addOption(new RoomInterface.RoomSharingOption(-2L, "#696969", MESSAGES.codeNotAvailable(), MESSAGES.legendNotAvailable(), editable));
        String defaultGridSize = RequiredTimeTable.getTimeGridSize(context.getUser());
        if (defaultGridSize != null) {
            for (int i2 = 0; i2 < model.getModes().size(); ++i2) {
                if (!model.getModes().get(i2).getName().equals(defaultGridSize)) continue;
                model.setDefaultMode(i2);
                break;
            }
        }
        model.setDefaultHorizontal(CommonValues.HorizontalGrid.eq(context.getUser().getProperty(UserProperty.GridOrientation)));
        model.setDefaultOption(model.getOptions().get(0));
        model.setNote(location.getShareNote());
        model.setNoteEditable(editable);
        TreeSet<Department> current = new TreeSet<Department>();
        for (RoomDept rd : location.getRoomDepts()) {
            current.add(rd.getDepartment());
        }
        for (Department d : current) {
            model.addOption(new RoomInterface.RoomSharingOption(d.getUniqueId(), "#" + d.getRoomSharingColor(current), d.getDeptCode(), d.getName() + (d.isExternalManager() != false ? " (EXT: " + d.getExternalMgrLabel() + ")" : ""), editable));
        }
        for (Department d : Department.findAllBeingUsed(context.getUser().getCurrentAcademicSessionId())) {
            model.addOther(new RoomInterface.RoomSharingOption(d.getUniqueId(), "#" + d.getRoomSharingColor(current), d.getDeptCode(), d.getName() + (d.isExternalManager() != false ? " (EXT: " + d.getExternalMgrLabel() + ")" : ""), editable));
        }
        HashMap<Character, Long> char2dept = new HashMap<Character, Long>();
        char pref = '0';
        if (location.getManagerIds() != null) {
            StringTokenizer stk = new StringTokenizer(location.getManagerIds(), ",");
            while (stk.hasMoreTokens()) {
                Long id = Long.valueOf(stk.nextToken());
                char c = pref;
                pref = (char)(pref + 1);
                char2dept.put(new Character(c), id);
            }
        }
        try {
            int idx = 0;
            for (int d = 0; d < Constants.NR_DAYS; ++d) {
                for (int t = 0; t < 288; ++t) {
                    Long deptId;
                    pref = location.getPattern() != null && idx < location.getPattern().length() ? location.getPattern().charAt(idx) : RoomSharingModel.sFreeForAllPrefChar;
                    ++idx;
                    if (pref == RoomSharingModel.sNotAvailablePrefChar) {
                        model.setOption(d, t, -2L);
                        continue;
                    }
                    if (pref == RoomSharingModel.sFreeForAllPrefChar) {
                        model.setOption(d, t, -1L);
                        continue;
                    }
                    Long l = deptId = char2dept == null ? null : (Long)char2dept.get(Character.valueOf(pref));
                    if (deptId == null) {
                        try {
                            deptId = ((Department)new ArrayList(current).get(pref - 48)).getUniqueId();
                        }
                        catch (IndexOutOfBoundsException e) {
                            // empty catch block
                        }
                    }
                    model.setOption(d, t, deptId);
                }
            }
        }
        catch (NullPointerException e) {
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (editable && !context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
            boolean control = false;
            boolean allDept = true;
            for (RoomDept rd : location.getRoomDepts()) {
                if (rd.isControl().booleanValue()) {
                    control = context.getUser().getCurrentAuthority().hasQualifier(rd.getDepartment());
                }
                if (!allDept || context.getUser().getCurrentAuthority().hasQualifier(rd.getDepartment())) continue;
                allDept = false;
            }
            model.setDefaultEditable(control || allDept);
            model.setNoteEditable(control || allDept);
            if (!control && !allDept) {
                for (int d = 0; d < 7; ++d) {
                    for (int s = 0; s < 288; ++s) {
                        RoomInterface.RoomSharingOption option = model.getOption(d, s);
                        model.setEditable(d, s, option != null && context.getUser().getCurrentAuthority().hasQualifier(new SimpleQualifier("Department", option.getId())));
                    }
                }
            }
        }
        return model;
    }

    public RoomInterface.RoomSharingModel saveRoomSharing(RoomInterface.RoomSharingRequest request, SessionContext context) {
        context.checkPermission(request.getLocationId(), "Location", Right.RoomEditAvailability);
        HashMap<Long, Character> dept2char = new HashMap<Long, Character>();
        dept2char.put(-1L, Character.valueOf(RoomSharingModel.sFreeForAllPrefChar));
        dept2char.put(-2L, Character.valueOf(RoomSharingModel.sNotAvailablePrefChar));
        String managerIds = "";
        char pref = '0';
        HashSet<Long> add = new HashSet<Long>();
        for (RoomInterface.RoomSharingOption option : request.getModel().getOptions()) {
            if (option.getId() < 0L) continue;
            managerIds = managerIds + (managerIds.isEmpty() ? "" : ",") + option.getId();
            char c = pref;
            pref = (char)(pref + 1);
            dept2char.put(option.getId(), new Character(c));
            add.add(option.getId());
        }
        String pattern = "";
        for (int d = 0; d < 7; ++d) {
            for (int s = 0; s < 288; ++s) {
                RoomInterface.RoomSharingOption option = request.getModel().getOption(d, s);
                pattern = pattern + dept2char.get(option.getId());
            }
        }
        Session hibSession = LocationDAO.getInstance().getSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            Location location = (Location)LocationDAO.getInstance().get(request.getLocationId(), hibSession);
            location.setManagerIds(managerIds);
            location.setPattern(pattern);
            Iterator<RoomDept> i = location.getRoomDepts().iterator();
            while (i.hasNext()) {
                RoomDept rd = i.next();
                if (add.remove(rd.getDepartment().getUniqueId())) continue;
                rd.getDepartment().getRoomDepts().remove(rd);
                i.remove();
                hibSession.delete((Object)rd);
            }
            for (Long id : add) {
                RoomDept rd = new RoomDept();
                rd.setControl(false);
                rd.setDepartment((Department)DepartmentDAO.getInstance().get(id, hibSession));
                rd.getDepartment().getRoomDepts().add(rd);
                rd.setRoom(location);
                location.getRoomDepts().add(rd);
                hibSession.saveOrUpdate((Object)rd);
            }
            hibSession.saveOrUpdate((Object)location);
            if (request.getModel().isNoteEditable()) {
                if (request.getModel().hasNote()) {
                    location.setShareNote(request.getModel().getNote().length() > 2048 ? request.getModel().getNote().substring(0, 2048) : request.getModel().getNote());
                } else {
                    location.setShareNote(null);
                }
            }
            ChangeLog.addChange(hibSession, context, location, ChangeLog.Source.ROOM_DEPT_EDIT, ChangeLog.Operation.UPDATE, null, location.getControllingDepartment());
            tx.commit();
            return null;
        }
        catch (Exception ex) {
            tx.rollback();
            if (ex instanceof GwtRpcException) {
                throw (GwtRpcException)ex;
            }
            throw new GwtRpcException(ex.getMessage(), ex);
        }
    }

    public RoomInterface.RoomSharingModel loadEventAvailability(RoomInterface.RoomSharingRequest request, SessionContext context) {
        String mode;
        context.checkPermission(request.getLocationId(), "Location", Right.RoomDetailEventAvailability);
        Location location = (Location)LocationDAO.getInstance().get(request.getLocationId());
        RoomInterface.RoomSharingModel model = new RoomInterface.RoomSharingModel();
        model.setId(location.getUniqueId());
        model.setName(location.getLabel());
        int i = 0;
        while ((mode = ApplicationProperty.RoomSharingMode.value(String.valueOf(1 + i), i < CONSTANTS.roomSharingModes().length ? CONSTANTS.roomSharingModes()[i] : null)) != null && !mode.isEmpty()) {
            model.addMode(new RoomInterface.RoomSharingDisplayMode(mode));
            ++i;
        }
        boolean editable = context.hasPermission(location, Right.RoomEditEventAvailability);
        model.setDefaultEditable(editable);
        model.addOption(new RoomInterface.RoomSharingOption(-1L, "#FFFFFF", MESSAGES.codeAvailable(), MESSAGES.legendAvailable(), editable));
        model.addOption(new RoomInterface.RoomSharingOption(-2L, "#696969", MESSAGES.codeNotAvailable(), MESSAGES.legendNotAvailable(), editable));
        String defaultGridSize = RequiredTimeTable.getTimeGridSize(context.getUser());
        if (defaultGridSize != null) {
            for (int i2 = 0; i2 < model.getModes().size(); ++i2) {
                if (!model.getModes().get(i2).getName().equals(defaultGridSize)) continue;
                model.setDefaultMode(i2);
                break;
            }
        }
        model.setDefaultHorizontal(CommonValues.HorizontalGrid.eq(context.getUser().getProperty(UserProperty.GridOrientation)));
        model.setDefaultOption(model.getOptions().get(0));
        int idx = 0;
        for (int d = 0; d < Constants.NR_DAYS; ++d) {
            for (int t = 0; t < 288; ++t) {
                int pref = location.getEventAvailability() != null && idx < location.getEventAvailability().length() ? (int)location.getEventAvailability().charAt(idx) : 48;
                ++idx;
                model.setOption(d, t, pref == 48 ? -1L : -2L);
            }
        }
        return model;
    }

    public RoomInterface.RoomSharingModel saveEventAvailability(RoomInterface.RoomSharingRequest request, SessionContext context) {
        context.checkPermission(request.getLocationId(), "Location", Right.RoomEditEventAvailability);
        String availability = "";
        for (int d = 0; d < 7; ++d) {
            for (int s = 0; s < 288; ++s) {
                RoomInterface.RoomSharingOption option = request.getModel().getOption(d, s);
                availability = availability + (option.getId() == -1L ? (char)'0' : '1');
            }
        }
        Session hibSession = LocationDAO.getInstance().getSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            Location location = (Location)LocationDAO.getInstance().get(request.getLocationId(), hibSession);
            location.setEventAvailability(availability);
            hibSession.save((Object)location);
            ChangeLog.addChange(hibSession, context, location, ChangeLog.Source.ROOM_DEPT_EDIT, ChangeLog.Operation.UPDATE, null, location.getControllingDepartment());
            tx.commit();
            return null;
        }
        catch (Exception ex) {
            tx.rollback();
            if (ex instanceof GwtRpcException) {
                throw (GwtRpcException)ex;
            }
            throw new GwtRpcException(ex.getMessage(), ex);
        }
    }
}

