/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.fileupload.FileItem;
import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.LocationPicture;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.NonUniversityLocationPicture;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomPicture;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=RoomInterface.RoomPictureRequest.class)
public class RoomPicturesBackend
implements GwtRpcImplementation<RoomInterface.RoomPictureRequest, RoomInterface.RoomPictureResponse> {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public RoomInterface.RoomPictureResponse execute(RoomInterface.RoomPictureRequest request, SessionContext context) {
        RoomInterface.RoomPictureResponse response = new RoomInterface.RoomPictureResponse();
        Session hibSession = LocationDAO.getInstance().getSession();
        Location location = (Location)LocationDAO.getInstance().get(request.getLocationId(), hibSession);
        if (location == null) {
            throw new GwtRpcException(MESSAGES.errorRoomDoesNotExist(request.getLocationId().toString()));
        }
        response.setName(location.getLabel());
        context.checkPermission(location, Right.RoomEditChangePicture);
        HashMap<Long, void> temp = (HashMap<Long, void>)context.getAttribute("ROOM_PICTURES");
        switch (request.getOperation()) {
            case LOAD: {
                boolean bl;
                for (LocationPicture locationPicture : new TreeSet<LocationPicture>(location.getPictures())) {
                    response.addPicture(new RoomInterface.RoomPictureInterface(locationPicture.getUniqueId(), locationPicture.getFileName(), locationPicture.getContentType()));
                }
                boolean samePast = true;
                boolean bl2 = true;
                for (Location other : hibSession.createQuery("from Location loc where permanentId = :permanentId and not uniqueId = :uniqueId").setLong("uniqueId", location.getUniqueId().longValue()).setLong("permanentId", location.getPermanentId().longValue()).list()) {
                    if (!this.samePictures(location, other)) {
                        if (other.getSession().getSessionBeginDateTime().before(location.getSession().getSessionBeginDateTime())) {
                            samePast = false;
                        } else {
                            bl = false;
                        }
                    }
                    if (bl) continue;
                    break;
                }
                if (samePast && bl) {
                    response.setApply(RoomInterface.RoomPictureRequest.Apply.ALL_SESSIONS);
                } else if (bl) {
                    response.setApply(RoomInterface.RoomPictureRequest.Apply.ALL_FUTURE_SESSIONS);
                } else {
                    response.setApply(RoomInterface.RoomPictureRequest.Apply.THIS_SESSION_ONLY);
                }
                context.setAttribute("ROOM_PICTURES", null);
                break;
            }
            case SAVE: {
                HashMap<Long, LocationPicture> pictures = new HashMap<Long, LocationPicture>();
                for (LocationPicture locationPicture : location.getPictures()) {
                    pictures.put(locationPicture.getUniqueId(), locationPicture);
                }
                for (RoomInterface.RoomPictureInterface roomPictureInterface : request.getPictures()) {
                    LocationPicture picture = (LocationPicture)pictures.remove(roomPictureInterface.getUniqueId());
                    if (picture != null || temp == null || (picture = (LocationPicture)temp.get(roomPictureInterface.getUniqueId())) == null) continue;
                    if (location instanceof Room) {
                        ((RoomPicture)picture).setLocation((Room)location);
                        ((Room)location).getPictures().add((RoomPicture)picture);
                    } else {
                        ((NonUniversityLocationPicture)picture).setLocation((NonUniversityLocation)location);
                        ((NonUniversityLocation)location).getPictures().add((NonUniversityLocationPicture)picture);
                    }
                    hibSession.saveOrUpdate((Object)picture);
                }
                for (LocationPicture locationPicture : pictures.values()) {
                    location.getPictures().remove(locationPicture);
                    hibSession.delete((Object)locationPicture);
                }
                hibSession.saveOrUpdate((Object)location);
                if (request.getApply() != RoomInterface.RoomPictureRequest.Apply.THIS_SESSION_ONLY) {
                    for (Location location2 : hibSession.createQuery("from Location loc where permanentId = :permanentId and not uniqueId = :uniqueId").setLong("uniqueId", location.getUniqueId().longValue()).setLong("permanentId", location.getPermanentId().longValue()).list()) {
                        if (request.getApply() == RoomInterface.RoomPictureRequest.Apply.ALL_FUTURE_SESSIONS && location2.getSession().getSessionBeginDateTime().before(location.getSession().getSessionBeginDateTime())) continue;
                        HashSet<? extends LocationPicture> otherPictures = new HashSet<LocationPicture>(location2.getPictures());
                        block11: for (LocationPicture locationPicture : location.getPictures()) {
                            LocationPicture p2;
                            Iterator i = otherPictures.iterator();
                            while (i.hasNext()) {
                                LocationPicture p22 = (LocationPicture)i.next();
                                if (!this.samePicture(locationPicture, p22)) continue;
                                i.remove();
                                continue block11;
                            }
                            if (location instanceof Room) {
                                p2 = ((RoomPicture)locationPicture).clonePicture();
                                p2.setLocation(location2);
                                ((Room)location2).getPictures().add((RoomPicture)p2);
                                hibSession.saveOrUpdate((Object)p2);
                                continue;
                            }
                            p2 = ((NonUniversityLocationPicture)locationPicture).clonePicture();
                            p2.setLocation(location2);
                            ((NonUniversityLocation)location2).getPictures().add((NonUniversityLocationPicture)p2);
                            hibSession.saveOrUpdate((Object)p2);
                        }
                        for (LocationPicture locationPicture : otherPictures) {
                            location2.getPictures().remove(locationPicture);
                            hibSession.delete((Object)locationPicture);
                        }
                        hibSession.saveOrUpdate((Object)location2);
                    }
                }
                hibSession.flush();
                context.setAttribute("ROOM_PICTURES", null);
                break;
            }
            case UPLOAD: {
                void var11_27;
                FileItem file = (FileItem)context.getAttribute("LAST_FILE");
                if (file == null) break;
                if (temp == null) {
                    temp = new HashMap<Long, void>();
                    context.setAttribute("ROOM_PICTURES", temp);
                }
                Object var11_24 = null;
                if (location instanceof Room) {
                    RoomPicture roomPicture = new RoomPicture();
                } else {
                    NonUniversityLocationPicture nonUniversityLocationPicture = new NonUniversityLocationPicture();
                }
                var11_27.setDataFile(file.get());
                String name = file.getName();
                if (name.indexOf(46) >= 0) {
                    name = name.substring(0, name.lastIndexOf(46));
                }
                var11_27.setFileName(name);
                var11_27.setContentType(file.getContentType());
                var11_27.setTimeStamp(new Date());
                temp.put(-var11_27.getTimeStamp().getTime(), var11_27);
                response.addPicture(new RoomInterface.RoomPictureInterface(-var11_27.getTimeStamp().getTime(), var11_27.getFileName(), var11_27.getContentType()));
            }
        }
        return response;
    }

    private boolean samePictures(Location l1, Location l2) {
        if (l1.getPictures().size() != l2.getPictures().size()) {
            return false;
        }
        block0: for (LocationPicture locationPicture : l1.getPictures()) {
            for (LocationPicture locationPicture2 : l2.getPictures()) {
                if (!this.samePicture(locationPicture, locationPicture2)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean samePicture(LocationPicture p1, LocationPicture p2) {
        return p1.getFileName().equals(p2.getFileName()) && Math.abs(p1.getTimeStamp().getTime() - p2.getTimeStamp().getTime()) < 1000L && p1.getContentType().equals(p2.getContentType());
    }
}

