/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.menu;

import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.MenuInterface;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.context.AnonymousUserContext;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=MenuInterface.UserInfoRpcRequest.class)
public class UserInfoBackend
implements GwtRpcImplementation<MenuInterface.UserInfoRpcRequest, MenuInterface.UserInfoInterface> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    private SessionContext sessionContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MenuInterface.UserInfoInterface execute(MenuInterface.UserInfoRpcRequest request, SessionContext context) {
        UserContext user;
        Session hibSession;
        MenuInterface.UserInfoInterface ret;
        block7: {
            ret = new MenuInterface.UserInfoInterface();
            hibSession = SessionDAO.getInstance().getSession();
            user = this.sessionContext.getUser();
            if (user != null && !(user instanceof AnonymousUserContext)) break block7;
            MenuInterface.UserInfoInterface userInfoInterface = null;
            Object var10_8 = null;
            hibSession.close();
            return userInfoInterface;
        }
        try {
            String role;
            ret.addPair(MESSAGES.fieldName(), user.getName());
            ret.setName(user.getName());
            String dept = "";
            if (user.getCurrentAuthority() != null) {
                for (Qualifiable qualifiable : user.getCurrentAuthority().getQualifiers("Department")) {
                    if (!dept.isEmpty()) {
                        dept = dept + ",";
                    }
                    dept = dept + "<span title='" + qualifiable.getQualifierLabel() + "'>" + qualifiable.getQualifierReference() + "</span>";
                }
            }
            ret.addPair(MESSAGES.fieldDepartment(), dept);
            String string = role = user.getCurrentAuthority() == null ? null : user.getCurrentAuthority().getLabel();
            if (role == null) {
                role = MESSAGES.noRole();
            }
            ret.addPair(MESSAGES.fieldRole(), role);
            ret.setRole(role);
            ret.setChameleon(this.sessionContext.hasPermission(Right.Chameleon) || user instanceof UserContext.Chameleon);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
        return ret;
    }
}

