/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.menu;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.TreeSet;
import org.cpsolver.ifs.util.DataProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.form.ListSolutionsForm;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.MenuInterface;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=MenuInterface.SolverInfoRpcRequest.class)
@GwtRpcLogging(value=GwtRpcLogging.Level.DISABLED)
public class SolverInfoBackend
implements GwtRpcImplementation<MenuInterface.SolverInfoRpcRequest, MenuInterface.SolverInfoInterface> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;
    @Autowired
    SolverService<StudentSolverProxy> studentSectioningSolverService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MenuInterface.SolverInfoInterface execute(MenuInterface.SolverInfoRpcRequest request, SessionContext context) {
        Map progress;
        StudentSolverProxy studentSolver;
        ExamSolverProxy examSolver;
        SolverProxy solver;
        org.hibernate.Session hibSession;
        MenuInterface.SolverInfoInterface ret;
        block24: {
            ret = new MenuInterface.SolverInfoInterface();
            hibSession = SessionDAO.getInstance().getSession();
            solver = this.courseTimetablingSolverService.getSolver();
            examSolver = this.examinationSolverService.getSolver();
            studentSolver = this.studentSectioningSolverService.getSolver();
            Map map = studentSolver != null ? studentSolver.getProgress() : (examSolver != null ? examSolver.getProgress() : (progress = solver != null ? solver.getProgress() : null));
            if (progress != null) break block24;
            MenuInterface.SolverInfoInterface solverInfoInterface = null;
            Object var28_11 = null;
            hibSession.close();
            return solverInfoInterface;
        }
        try {
            DataProperties properties = studentSolver != null ? studentSolver.getProperties() : (examSolver != null ? examSolver.getProperties() : solver.getProperties());
            String progressStatus = (String)progress.get("STATUS");
            String progressPhase = (String)progress.get("PHASE");
            long progressCur = (Long)progress.get("PROGRESS");
            long progressMax = (Long)progress.get("MAX_PROGRESS");
            String version = (String)progress.get("VERSION");
            if (version == null || "-1".equals(version)) {
                version = "N/A";
            }
            double progressPercent = 100.0 * (double)(progressCur < progressMax ? progressCur : progressMax) / (double)progressMax;
            String runnerName = this.getName(properties.getProperty("General.OwnerPuid", "N/A"));
            Long[] solverGroupId = properties.getPropertyLongArry("General.SolverGroupId", null);
            String ownerName = "";
            if (solverGroupId != null) {
                for (int i = 0; i < solverGroupId.length; ++i) {
                    if (i > 0) {
                        ownerName = ownerName + " & ";
                    }
                    ownerName = ownerName + this.getName((SolverGroup)new SolverGroupDAO().get(solverGroupId[i]));
                }
            }
            if (examSolver != null) {
                ownerName = ((ExamType)ExamTypeDAO.getInstance().get(examSolver.getExamTypeId())).getLabel();
            }
            if (ownerName == null || ownerName.length() == 0) {
                ownerName = "N/A";
            }
            if (ownerName.equals("N/A")) {
                ownerName = runnerName;
            }
            if (runnerName.equals("N/A")) {
                runnerName = ownerName;
            }
            if (!ownerName.equals(runnerName)) {
                ownerName = runnerName + " as " + ownerName;
            }
            if (ownerName.length() > 50) {
                ownerName = ownerName.substring(0, 47) + "...";
            }
            ret.setType(studentSolver != null ? MESSAGES.solverStudent() : (examSolver != null ? MESSAGES.solverExamination() : MESSAGES.solverCourse()));
            ret.addPair(MESSAGES.fieldType(), ret.getType());
            ret.setUrl(studentSolver != null ? "studentSolver.do" : (examSolver != null ? "examSolver.do" : "solver.do"));
            ret.addPair(MESSAGES.fieldSolver(), progressStatus);
            ret.setSolver(progressStatus);
            ret.addPair(MESSAGES.fieldPhase(), progressPhase);
            if (progressMax > 0L) {
                ret.addPair(MESSAGES.fieldProgress(), (progressCur < progressMax ? progressCur : progressMax) + " of " + progressMax + " (" + new DecimalFormat("0.0").format(progressPercent) + "%)");
            }
            ret.addPair(MESSAGES.fieldOwner(), ownerName);
            ret.addPair(MESSAGES.fieldHost(), studentSolver != null ? studentSolver.getHost() : (examSolver != null ? examSolver.getHost() : solver.getHost()));
            ret.addPair(MESSAGES.fieldSession(), ((Session)SessionDAO.getInstance().get(properties.getPropertyLong("General.SessionId", null))).getLabel());
            MenuInterface.InfoPairInterface p = ret.addPair(MESSAGES.fieldVersion(), version);
            if (request.isIncludeSolutionInfo()) {
                Map<String, String> info = null;
                try {
                    if (studentSolver != null) {
                        info = studentSolver.statusSolutionInfo();
                    } else if (examSolver != null) {
                        info = examSolver.statusSolutionInfo();
                    } else if (solver != null) {
                        info = solver.statusSolutionInfo();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (info != null && !info.isEmpty()) {
                    p.setSeparator(true);
                    TreeSet<String> keys = new TreeSet<String>(new ListSolutionsForm.InfoComparator());
                    keys.addAll(info.keySet());
                    for (String key : keys) {
                        ret.addPair(key, info.get(key));
                    }
                }
            }
            Object var28_12 = null;
        }
        catch (Throwable throwable) {
            Object var28_13 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
        return ret;
    }

    private String getName(String puid) {
        return this.getName(TimetableManager.findByExternalId(puid));
    }

    private String getName(TimetableManager mgr) {
        if (mgr == null) {
            return null;
        }
        return mgr.getShortName();
    }

    private String getName(SolverGroup gr) {
        if (gr == null) {
            return null;
        }
        return gr.getAbbv();
    }
}

