/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.hql;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.SavedHQLInterface;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=SavedHQLInterface.HQLQueriesRpcRequest.class)
public class HQLQueriesBackend
implements GwtRpcImplementation<SavedHQLInterface.HQLQueriesRpcRequest, GwtRpcResponseList<SavedHQLInterface.Query>> {
    @Autowired
    private SessionContext sessionContext;

    @Override
    @PreAuthorize(value="checkPermission('HQLReports')")
    public GwtRpcResponseList<SavedHQLInterface.Query> execute(SavedHQLInterface.HQLQueriesRpcRequest request, SessionContext context) {
        SavedHQL.Flag ap = this.getAppearanceFlag(request.getAppearance());
        switch (ap) {
            case APPEARANCE_ADMINISTRATION: {
                this.sessionContext.checkPermission(Right.HQLReportsAdministration);
                break;
            }
            case APPEARANCE_COURSES: {
                this.sessionContext.checkPermission(Right.HQLReportsCourses);
                break;
            }
            case APPEARANCE_EXAMS: {
                this.sessionContext.checkPermission(Right.HQLReportsExaminations);
                break;
            }
            case APPEARANCE_SECTIONING: {
                this.sessionContext.checkPermission(Right.HQLReportsStudents);
                break;
            }
            case APPEARANCE_EVENTS: {
                this.sessionContext.checkPermission(Right.HQLReportsEvents);
            }
        }
        GwtRpcResponseList<SavedHQLInterface.Query> ret = new GwtRpcResponseList<SavedHQLInterface.Query>();
        for (SavedHQL hql : SavedHQL.listAll(null, ap, this.sessionContext.hasPermission(Right.HQLReportsAdminOnly))) {
            SavedHQLInterface.Query query = new SavedHQLInterface.Query();
            query.setName(hql.getName());
            query.setDescription(hql.getDescription());
            query.setQuery(hql.getQuery());
            query.setFlags(hql.getType());
            query.setId(hql.getUniqueId());
            ret.add(query);
        }
        return ret;
    }

    private SavedHQL.Flag getAppearanceFlag(String appearance) {
        for (SavedHQL.Flag flag : SavedHQL.Flag.values()) {
            if (flag.getAppearance() == null || !flag.getAppearance().equalsIgnoreCase(appearance)) continue;
            return flag;
        }
        return SavedHQL.Flag.APPEARANCE_COURSES;
    }
}

