/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.hql;

import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseBoolean;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SavedHQLInterface;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.dao.SavedHQLDAO;
import org.unitime.timetable.security.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=SavedHQLInterface.HQLDeleteRpcRequest.class)
public class HQLDeleteBackend
implements GwtRpcImplementation<SavedHQLInterface.HQLDeleteRpcRequest, GwtRpcResponseBoolean> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    @PreAuthorize(value="checkPermission(#request.id, 'SavedHQL', 'HQLReportDelete')")
    public GwtRpcResponseBoolean execute(SavedHQLInterface.HQLDeleteRpcRequest request, SessionContext context) {
        if (request.getId() == null) {
            throw new GwtRpcException(MESSAGES.errorNoReportProvided());
        }
        Session hibSession = SavedHQLDAO.getInstance().getSession();
        SavedHQL hql = (SavedHQL)SavedHQLDAO.getInstance().get(request.getId(), hibSession);
        if (hql != null) {
            hibSession.delete((Object)hql);
            hibSession.flush();
        }
        return new GwtRpcResponseBoolean(hql != null);
    }
}

