/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=examType]")
public class ExaminationTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageExaminationType(), MESSAGES.pageExaminationTypes());
    }

    @PreAuthorize(value="checkPermission('ExamTypes')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> types = new ArrayList<SimpleEditInterface.ListItem>();
        types.add(new SimpleEditInterface.ListItem(String.valueOf(0), MESSAGES.finalExaminations()));
        types.add(new SimpleEditInterface.ListItem(String.valueOf(1), MESSAGES.midtermExaminations()));
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldType(), SimpleEditInterface.FieldType.list, 300, types, SimpleEditInterface.Flag.NOT_EMPTY));
        data.setSortBy(2, 1);
        for (ExamType xtype : ExamTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(xtype.getUniqueId());
            r.setField(0, xtype.getReference(), !xtype.getReference().equals("final") && !xtype.getReference().equals("midterm"));
            r.setField(1, xtype.getLabel());
            r.setField(2, xtype.getType().toString(), !xtype.isUsed(null) && !xtype.getReference().equals("final") && !xtype.getReference().equals("midterm"));
            r.setDeletable(!xtype.isUsed(null) && !xtype.getReference().equals("final") && !xtype.getReference().equals("midterm"));
        }
        data.setEditable(context.hasPermission(Right.ExamTypeEdit));
        return data;
    }

    @PreAuthorize(value="checkPermission('ExamTypeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (ExamType type : ExamTypeDAO.getInstance().findAll(hibSession)) {
            SimpleEditInterface.Record r = data.getRecord(type.getUniqueId());
            if (r == null) {
                this.delete(type, context, hibSession);
                continue;
            }
            this.update(type, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @PreAuthorize(value="checkPermission('ExamTypeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        ExamType type = new ExamType();
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        type.setType(Integer.valueOf(record.getField(2)));
        record.setUniqueId((Long)hibSession.save((Object)type));
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(ExamType type, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        if (ToolBox.equals((Object)type.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)type.getLabel(), (Object)record.getField(1)) && ToolBox.equals((Object)type.getType(), (Object)Integer.valueOf(record.getField(2)))) {
            return;
        }
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        type.setType(Integer.valueOf(record.getField(2)));
        hibSession.saveOrUpdate((Object)type);
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @PreAuthorize(value="checkPermission('ExamTypeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((ExamType)ExamTypeDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(ExamType type, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        if (type.isUsed(null)) {
            throw new GwtRpcException(MESSAGES.failedDeleteUsedExaminationType(type.getReference()));
        }
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)type);
    }

    @PreAuthorize(value="checkPermission('ExamTypeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((ExamType)ExamTypeDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

