/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExternalRoom;
import org.unitime.timetable.model.ExternalRoomDepartment;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;

public class LocationPermissions {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.DepartmentRoomGroupAdd)
    public static class DepartmentRoomGroupAdd
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.GlobalRoomGroupAdd)
    public static class GlobalRoomGroupAdd
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            return this.permissionSession.check(user, source);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.GlobalRoomGroupDelete)
    public static class GlobalRoomGroupDelete
    extends GlobalRoomGroupEdit {
    }

    @PermissionForRight(value=Right.GlobalRoomGroupEditSetDefault)
    public static class GlobalRoomGroupEditSetDefault
    extends GlobalRoomGroupEdit {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.GlobalRoomGroupEdit)
    public static class GlobalRoomGroupEdit
    implements Permission<RoomGroup> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, RoomGroup source) {
            return source.isGlobal() != false && this.permissionSession.check(user, source.getSession());
        }

        @Override
        public Class<RoomGroup> type() {
            return RoomGroup.class;
        }
    }

    @PermissionForRight(value=Right.DepartmenalRoomGroupDelete)
    public static class DepartmenalRoomGroupDelete
    extends DepartmenalRoomGroupEdit {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.DepartmenalRoomGroupEdit)
    public static class DepartmenalRoomGroupEdit
    implements Permission<RoomGroup> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, RoomGroup source) {
            return source.isGlobal() == false && this.permissionDepartment.check(user, source.getDepartment());
        }

        @Override
        public Class<RoomGroup> type() {
            return RoomGroup.class;
        }
    }

    @PermissionForRight(value=Right.RoomGroupsExportPdf)
    public static class RoomGroupsExportPdf
    extends RoomsExportPdf {
    }

    @PermissionForRight(value=Right.RoomGroups)
    public static class RoomGroups
    extends Rooms {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.DepartmentRoomFeatureAdd)
    public static class DepartmentRoomFeatureAdd
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.GlobalRoomFeatureAdd)
    public static class GlobalRoomFeatureAdd
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            return this.permissionSession.check(user, source);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.GlobalRoomFeatureDelete)
    public static class GlobalRoomFeatureDelete
    extends GlobalRoomFeatureEdit {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.GlobalRoomFeatureEdit)
    public static class GlobalRoomFeatureEdit
    implements Permission<GlobalRoomFeature> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, GlobalRoomFeature source) {
            return this.permissionSession.check(user, source.getSession());
        }

        @Override
        public Class<GlobalRoomFeature> type() {
            return GlobalRoomFeature.class;
        }
    }

    @PermissionForRight(value=Right.DepartmenalRoomFeatureDelete)
    public static class DepartmenalRoomFeatureDelete
    extends DepartmenalRoomFeatureEdit {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.DepartmenalRoomFeatureEdit)
    public static class DepartmenalRoomFeatureEdit
    implements Permission<DepartmentRoomFeature> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, DepartmentRoomFeature source) {
            return this.permissionDepartment.check(user, source.getDepartment());
        }

        @Override
        public Class<DepartmentRoomFeature> type() {
            return DepartmentRoomFeature.class;
        }
    }

    @PermissionForRight(value=Right.RoomFeaturesExportPdf)
    public static class RoomFeaturesExportPdf
    extends RoomsExportPdf {
    }

    @PermissionForRight(value=Right.RoomFeatures)
    public static class RoomFeatures
    extends Rooms {
    }

    @PermissionForRight(value=Right.RoomEditGlobalGroups)
    public static class RoomEditGlobalGroups
    extends RoomEditAvailability {
    }

    @PermissionForRight(value=Right.RoomEditGlobalFeatures)
    public static class RoomEditGlobalFeatures
    extends RoomEditAvailability {
    }

    @PermissionForRight(value=Right.RoomEditGroups)
    public static class RoomEditGroups
    extends RoomEditAvailability {
    }

    @PermissionForRight(value=Right.RoomEditFeatures)
    public static class RoomEditFeatures
    extends RoomEditAvailability {
    }

    @PermissionForRight(value=Right.RoomEditPreference)
    public static class RoomEditPreference
    extends RoomEditAvailability {
    }

    @PermissionForRight(value=Right.RoomEditEventAvailability)
    public static class RoomEditEventAvailability
    extends RoomDetailEventAvailability {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.RoomDetailEventAvailability)
    public static class RoomDetailEventAvailability
    implements Permission<Location> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Location source) {
            return source.getEventDepartment() != null && this.permissionDepartment.check(user, source.getEventDepartment());
        }

        @Override
        public Class<Location> type() {
            return Location.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.RoomEditAvailability)
    public static class RoomEditAvailability
    implements Permission<Location> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Location source) {
            if (source.getRoomDepts().isEmpty()) {
                return user.getCurrentAuthority().hasRight(Right.DepartmentIndependent);
            }
            for (RoomDept rd : source.getRoomDepts()) {
                if (!this.permissionDepartment.check(user, rd.getDepartment())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class<Location> type() {
            return Location.class;
        }
    }

    @PermissionForRight(value=Right.RoomDetailPeriodPreferences)
    public static class RoomDetailPeriodPreferences
    extends RoomDetail {
    }

    @PermissionForRight(value=Right.RoomDetailAvailability)
    public static class RoomDetailAvailability
    extends RoomDetail {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.RoomAvailability)
    public static class RoomAvailability
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            return this.permissionSession.check(user, source) && (Exam.hasFinalExams(source.getUniqueId()) || Exam.hasMidtermExams(source.getUniqueId()));
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.TravelTimesSave)
    public static class TravelTimesSave
    extends BuildingList {
    }

    @PermissionForRight(value=Right.TravelTimesLoad)
    public static class TravelTimesLoad
    extends BuildingList {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.AddRoom)
    public static class AddRoom
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source) && !Building.findAll(source.getSessionId()).isEmpty();
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.AddNonUnivLocation)
    public static class AddNonUnivLocation
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.AddSpecialUseRoom)
    public static class AddSpecialUseRoom
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source) && !ExternalRoom.findAll(source.getSessionId()).isEmpty();
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.AddSpecialUseRoomExternalRoom)
    public static class AddSpecialUseRoomExternalRoom
    implements Permission<ExternalRoom> {
        @Override
        public boolean check(UserContext user, ExternalRoom source) {
            if (user == null || user.getCurrentAuthority() == null || source == null) {
                return false;
            }
            UserAuthority authority = user.getCurrentAuthority();
            if (!authority.hasRight(Right.AddSpecialUseRoom)) {
                return false;
            }
            if (authority.hasRight(Right.DepartmentIndependent)) {
                return true;
            }
            for (ExternalRoomDepartment dept : source.getRoomDepartments()) {
                if (!authority.hasQualifier(new SimpleQualifier("Department", (Serializable)((Object)dept.getDepartmentCode())))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class<ExternalRoom> type() {
            return ExternalRoom.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.NonUniversityLocationDelete)
    public static class NonUniversityLocationDelete
    implements Permission<NonUniversityLocation> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, NonUniversityLocation source) {
            if (source.isUsed()) {
                return false;
            }
            if (!user.getCurrentAuthority().hasRight(Right.DepartmentIndependent) && !source.getExamTypes().isEmpty()) {
                return false;
            }
            boolean controls = false;
            boolean allDepts = true;
            for (RoomDept rd : source.getRoomDepts()) {
                if (rd.isControl().booleanValue() && this.permissionDepartment.check(user, rd.getDepartment())) {
                    controls = true;
                }
                if (this.permissionDepartment.check(user, rd.getDepartment())) continue;
                allDepts = false;
            }
            return controls || allDepts;
        }

        @Override
        public Class<NonUniversityLocation> type() {
            return NonUniversityLocation.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.RoomDelete)
    public static class RoomDelete
    implements Permission<Room> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Room source) {
            if (source.isUsed()) {
                return false;
            }
            if (!user.getCurrentAuthority().hasRight(Right.DepartmentIndependent) && !source.getExamTypes().isEmpty()) {
                return false;
            }
            boolean controls = source.getRoomDepts().isEmpty();
            boolean allDepts = true;
            for (RoomDept rd : source.getRoomDepts()) {
                if (rd.isControl().booleanValue() && this.permissionDepartment.check(user, rd.getDepartment())) {
                    controls = true;
                }
                if (this.permissionDepartment.check(user, rd.getDepartment())) continue;
                allDepts = false;
            }
            return controls || allDepts;
        }

        @Override
        public Class<Room> type() {
            return Room.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.BuildingDelete)
    public static class BuildingDelete
    implements Permission<Building> {
        @Autowired
        Permission.PermissionSession permissionSession;
        @Autowired
        Permission<Room> permissionRoomDelete;

        @Override
        public boolean check(UserContext user, Building source) {
            if (!this.permissionSession.check(user, source.getSession())) {
                return false;
            }
            for (Room room : RoomDAO.getInstance().findByBuilding(RoomDAO.getInstance().getSession(), source.getUniqueId())) {
                if (this.permissionRoomDelete.check(user, room)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Class<Building> type() {
            return Building.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.BuildingEdit)
    public static class BuildingEdit
    implements Permission<Building> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Building source) {
            return this.permissionSession.check(user, source.getSession());
        }

        @Override
        public Class<Building> type() {
            return Building.class;
        }
    }

    @PermissionForRight(value=Right.BuildingUpdateData)
    public static class BuildingUpdateData
    extends BuildingList {
    }

    @PermissionForRight(value=Right.BuildingExportPdf)
    public static class BuildingExportPdf
    extends BuildingList {
    }

    @PermissionForRight(value=Right.BuildingAdd)
    public static class BuildingAdd
    extends BuildingList {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.BuildingList)
    public static class BuildingList
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            return this.permissionSession.check(user, source);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.EditRoomDepartmentsExams)
    public static class EditRoomDepartmentsExams
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            return this.permissionSession.check(user, source);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.RoomDepartments)
    public static class RoomDepartments
    extends EditRoomDepartments {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.EditRoomDepartments)
    public static class EditRoomDepartments
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return user.getCurrentAuthority().hasRight(Right.DepartmentIndependent) || this.permissionDepartment.check(user, source) && user.getCurrentAuthority().getQualifiers("Department").size() > 1;
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.RoomEditChangePicture)
    public static class RoomEditChangePicture
    extends RoomEditChangeCapacity {
    }

    @PermissionForRight(value=Right.RoomEditChangeEventProperties)
    public static class RoomEditChangeEventProperties
    extends RoomEditChangeCapacity {
    }

    @PermissionForRight(value=Right.RoomEditChangeType)
    public static class RoomEditChangeType
    extends RoomEditChangeCapacity {
    }

    @PermissionForRight(value=Right.RoomEditChangeRoomProperties)
    public static class RoomEditChangeRoomProperties
    extends RoomEditChangeCapacity {
    }

    @PermissionForRight(value=Right.RoomEditChangeExternalId)
    public static class RoomEditChangeExternalId
    extends RoomEditChangeCapacity {
    }

    @PermissionForRight(value=Right.RoomEditChangeExaminationStatus)
    public static class RoomEditChangeExaminationStatus
    extends RoomEditChangeCapacity {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.RoomEditChangeCapacity)
    public static class RoomEditChangeCapacity
    implements Permission<Location> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Location source) {
            boolean controls = source.getRoomDepts().isEmpty();
            boolean allDepts = true;
            for (RoomDept rd : source.getRoomDepts()) {
                if (rd.isControl().booleanValue() && this.permissionDepartment.check(user, rd.getDepartment())) {
                    controls = true;
                }
                if (this.permissionDepartment.check(user, rd.getDepartment())) continue;
                allDepts = false;
            }
            return controls || allDepts;
        }

        @Override
        public Class<Location> type() {
            return Location.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.RoomEditChangeControll)
    public static class RoomEditChangeControll
    implements Permission<Location> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Location source) {
            boolean controls = source.getRoomDepts().isEmpty();
            boolean allDepts = true;
            for (RoomDept rd : source.getRoomDepts()) {
                if (rd.isControl().booleanValue() && this.permissionDepartment.check(user, rd.getDepartment())) {
                    controls = true;
                }
                if (this.permissionDepartment.check(user, rd.getDepartment())) continue;
                allDepts = false;
            }
            return controls || allDepts;
        }

        @Override
        public Class<Location> type() {
            return Location.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.NonUniversityLocationEdit)
    public static class NonUniversityLocationEdit
    implements Permission<NonUniversityLocation> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, NonUniversityLocation source) {
            boolean controls = source.getRoomDepts().isEmpty();
            boolean allDepts = true;
            for (RoomDept rd : source.getRoomDepts()) {
                if (rd.isControl().booleanValue() && this.permissionDepartment.check(user, rd.getDepartment())) {
                    controls = true;
                }
                if (this.permissionDepartment.check(user, rd.getDepartment())) continue;
                allDepts = false;
            }
            return controls || allDepts;
        }

        @Override
        public Class<NonUniversityLocation> type() {
            return NonUniversityLocation.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.RoomEdit)
    public static class RoomEdit
    implements Permission<Room> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Room source) {
            boolean controls = source.getRoomDepts().isEmpty();
            boolean allDepts = true;
            for (RoomDept rd : source.getRoomDepts()) {
                if (rd.isControl().booleanValue() && this.permissionDepartment.check(user, rd.getDepartment())) {
                    controls = true;
                }
                if (this.permissionDepartment.check(user, rd.getDepartment())) continue;
                allDepts = false;
            }
            return controls || allDepts;
        }

        @Override
        public Class<Room> type() {
            return Room.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.RoomDetail)
    public static class RoomDetail
    implements Permission<Location> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Location source) {
            if (source.getRoomDepts().isEmpty()) {
                return user.getCurrentAuthority().hasRight(Right.DepartmentIndependent);
            }
            for (RoomDept rd : source.getRoomDepts()) {
                if (!this.permissionDepartment.check(user, rd.getDepartment())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class<Location> type() {
            return Location.class;
        }
    }

    @PermissionForRight(value=Right.RoomsExportCsv)
    public static class RoomsExportCsv
    extends Rooms {
    }

    @PermissionForRight(value=Right.RoomsExportPdf)
    public static class RoomsExportPdf
    extends Rooms {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.Rooms)
    public static class Rooms
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source) || source.isExternalManager() != false;
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }
}

