/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.rights.Right;

public class InstructorPermissions {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.ManageInstructors)
    public static class ManageInstructors
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source, DepartmentStatusType.Status.OwnerLimitedEdit);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.InstructorsExportPdf)
    public static class InstructorsExportPdf
    extends Instructors {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.Instructors)
    public static class Instructors
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.InstructorAdd)
    public static class InstructorAdd
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source, DepartmentStatusType.Status.OwnerLimitedEdit);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.InstructorEditClearPreferences)
    public static class InstructorEditClearPreferences
    extends InstructorPreferences {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.InstructorPreferences)
    public static class InstructorPreferences
    implements Permission<DepartmentalInstructor> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, DepartmentalInstructor source) {
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<DepartmentalInstructor> type() {
            return DepartmentalInstructor.class;
        }
    }

    @PermissionForRight(value=Right.InstructorDelete)
    public static class DeleteInstructor
    extends EditInstructor {
        public boolean check(UserContext user, DepartmentalInstructor source) {
            if (!source.getClasses().isEmpty()) {
                return false;
            }
            if (!source.getExams().isEmpty()) {
                return false;
            }
            return super.check(user, source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.InstructorEdit)
    public static class EditInstructor
    implements Permission<DepartmentalInstructor> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, DepartmentalInstructor source) {
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerLimitedEdit);
        }

        @Override
        public Class<DepartmentalInstructor> type() {
            return DepartmentalInstructor.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.InstructorDetail)
    public static class InstructorDetail
    implements Permission<DepartmentalInstructor> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, DepartmentalInstructor source) {
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerView);
        }

        @Override
        public Class<DepartmentalInstructor> type() {
            return DepartmentalInstructor.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.AssignInstructorsClass)
    public static class AssignInstructorsClass
    implements Permission<Class_> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Class_ source) {
            return this.permissionDepartment.check(user, source.getControllingDept(), DepartmentStatusType.Status.OwnerLimitedEdit, source.getManagingDept(), DepartmentStatusType.Status.ManagerLimitedEdit);
        }

        @Override
        public Class<Class_> type() {
            return Class_.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.AssignInstructors)
    public static class AssignInstructors
    implements Permission<InstrOfferingConfig> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, InstrOfferingConfig source) {
            if (this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerLimitedEdit)) {
                return true;
            }
            HashSet<Department> externals = new HashSet<Department>();
            for (SchedulingSubpart subpart : source.getSchedulingSubparts()) {
                for (Class_ clazz : subpart.getClasses()) {
                    if (clazz.getManagingDept() == null || !clazz.getManagingDept().isExternalManager().booleanValue() || !externals.add(clazz.getManagingDept()) || !this.permissionDepartment.check(user, clazz.getManagingDept(), DepartmentStatusType.Status.ManagerLimitedEdit)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Class<InstrOfferingConfig> type() {
            return InstrOfferingConfig.class;
        }
    }
}

