/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleByCourseReport
extends PdfLegacyExamReport {
    protected static Logger sLog = Logger.getLogger(ScheduleByCourseReport.class);

    public ScheduleByCourseReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, "SCHEDULE BY COURSE", session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        sLog.debug((Object)"  Sorting sections...");
        Hashtable<String, TreeSet<ExamInfo.ExamSectionInfo>> subject2courseSections = new Hashtable<String, TreeSet<ExamInfo.ExamSectionInfo>>();
        for (ExamInfo examInfo : this.getExams()) {
            for (ExamInfo.ExamSectionInfo section : examInfo.getSectionsIncludeCrosslistedDummies()) {
                if (!this.hasSubjectArea(section)) continue;
                TreeSet<ExamInfo.ExamSectionInfo> sections = (TreeSet<ExamInfo.ExamSectionInfo>)subject2courseSections.get(section.getSubject());
                if (sections == null) {
                    sections = new TreeSet<ExamInfo.ExamSectionInfo>();
                    subject2courseSections.put(section.getSubject(), sections);
                }
                sections.add(section);
            }
        }
        sLog.debug((Object)"  Printing report...");
        String[] stringArray = new String[2];
        stringArray[0] = "Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section     Meeting Times                       Enrl    Date And Time                 Room         Cap ExCap";
        stringArray[1] = "------- -------- " + (this.iItype ? "------ " : "") + "--------- ------------------------------------ -----  ------------------------------ ----------- ----- -----";
        this.setHeader(stringArray);
        this.printHeader();
        Iterator i = new TreeSet(subject2courseSections.keySet()).iterator();
        while (i.hasNext()) {
            String string = (String)i.next();
            TreeSet sections = (TreeSet)subject2courseSections.get(string);
            this.setPageName(string);
            this.setCont(string);
            this.iSubjectPrinted = false;
            this.iCoursePrinted = false;
            String lastCourse = null;
            this.iITypePrinted = false;
            String lastItype = null;
            Iterator j = sections.iterator();
            while (j.hasNext()) {
                ExamInfo.ExamSectionInfo section = (ExamInfo.ExamSectionInfo)j.next();
                if (this.iCoursePrinted && !section.getCourseNbr().equals(lastCourse)) {
                    this.iCoursePrinted = false;
                    this.iITypePrinted = false;
                }
                if (this.iITypePrinted && !section.getItype().equals(lastItype)) {
                    this.iITypePrinted = false;
                }
                if (section.getExamAssignment().getRooms() == null || section.getExamAssignment().getRooms().isEmpty()) {
                    this.println(this.rpad(this.iSubjectPrinted ? "" : string, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iITypePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(section.getSection(), 9) + " " + this.rpad(this.getMeetingTime(section), 36) + " " + this.lpad(String.valueOf(section.getNrStudents()), 5) + "  " + this.rpad(section.getExamAssignment() == null ? "" : section.getExamAssignment().getPeriodNameFixedLength(), 30) + " " + (section.getExamAssignment() == null ? "" : this.iNoRoom));
                } else {
                    if (this.getLineNumber() + section.getExamAssignment().getRooms().size() > this.iNrLines) {
                        this.newPage();
                    }
                    boolean firstRoom = true;
                    for (ExamRoomInfo room : section.getExamAssignment().getRooms()) {
                        this.println(this.rpad(!firstRoom || this.iSubjectPrinted ? "" : string, 7) + " " + this.rpad(!firstRoom || this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(!firstRoom || this.iITypePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(!firstRoom ? "" : section.getSection(), 9) + " " + this.rpad(!firstRoom ? "" : this.getMeetingTime(section), 36) + " " + this.lpad(!firstRoom ? "" : String.valueOf(section.getNrStudents()), 5) + "  " + this.rpad(!firstRoom ? "" : (section.getExamAssignment() == null ? "" : section.getExamAssignment().getPeriodNameFixedLength()), 30) + " " + this.formatRoom(room.getName()) + " " + this.lpad("" + room.getCapacity(), 5) + " " + this.lpad("" + room.getExamCapacity(), 5));
                        firstRoom = false;
                    }
                }
                if (this.iNewPage) {
                    this.iCoursePrinted = false;
                    this.iITypePrinted = false;
                    this.iSubjectPrinted = false;
                    lastCourse = null;
                    lastItype = null;
                } else {
                    this.iCoursePrinted = true;
                    this.iITypePrinted = true;
                    this.iSubjectPrinted = true;
                    lastItype = section.getItype();
                    lastCourse = section.getCourseNbr();
                }
                if (!j.hasNext() || this.iNewPage) continue;
                this.println("");
            }
            this.setCont(null);
            if (!i.hasNext()) continue;
            this.newPage();
        }
        this.lastPage();
    }
}

