/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.PdfFont;

public class PdfLegacyReport {
    protected int iNrChars = 133;
    protected int iNrLines = 50;
    private OutputStream iOut = null;
    private Document iDoc = null;
    private StringBuffer iBuffer = new StringBuffer();
    private PrintWriter iPrint = null;
    private String iTitle;
    private String iTitle2;
    private String iSubject;
    private String iSession;
    private int iPageNo = 0;
    private int iLineNo = 0;
    private String iPageId = null;
    private String iCont = null;
    private String[] iHeader = null;
    private String iFooter = null;
    private boolean iEmpty = true;
    public static final int sModeNormal = 0;
    public static final int sModeLedger = 1;
    public static final int sModeText = 2;

    public PdfLegacyReport(int mode, File file, String title, String title2, String subject, String session) throws IOException, DocumentException {
        this.iTitle = title;
        this.iTitle2 = title2;
        this.iSubject = subject;
        this.iSession = session;
        if (file != null) {
            this.open(new FileOutputStream(file), mode);
        }
    }

    public PdfLegacyReport(int mode, OutputStream out, String title, String title2, String subject, String session) throws IOException, DocumentException {
        this.iTitle = title;
        this.iTitle2 = title2;
        this.iSubject = subject;
        this.iSession = session;
        if (out != null) {
            this.open(out, mode);
        }
    }

    public void open(File file, int mode) throws DocumentException, IOException {
        this.open(new FileOutputStream(file), mode);
    }

    public void open(OutputStream out, int mode) throws DocumentException, IOException {
        this.iOut = out;
        if (mode == 2) {
            this.iPrint = new PrintWriter(this.iOut);
        } else {
            this.iNrLines = mode == 1 ? 116 : 50;
            this.iDoc = new Document(mode == 1 ? PageSize.LEDGER.rotate() : PageSize.LETTER.rotate());
            PdfWriter.getInstance((Document)this.iDoc, (OutputStream)this.iOut);
            this.iDoc.addTitle(this.iTitle);
            this.iDoc.addAuthor("UniTime " + Constants.getVersion() + ", www.unitime.org");
            this.iDoc.addSubject(this.iSubject);
            this.iDoc.addCreator("UniTime " + Constants.getVersion() + ", www.unitime.org");
            this.iDoc.open();
        }
        this.iEmpty = true;
        this.iPageNo = 0;
        this.iLineNo = 0;
    }

    protected void setPageName(String pageName) {
        this.iPageId = pageName;
    }

    protected void setCont(String cont) {
        this.iCont = cont;
    }

    protected void setHeader(String[] header) {
        this.iHeader = header;
    }

    protected String[] getHeader() {
        return this.iHeader;
    }

    protected void setFooter(String footer) {
        this.iFooter = footer;
    }

    protected void out(String text) throws DocumentException {
        if (this.iBuffer.length() > 0) {
            this.iBuffer.append("\n");
        }
        this.iBuffer.append(text);
    }

    protected static String rep(char ch, int cnt) {
        String ret = "";
        for (int i = 0; i < cnt; ++i) {
            ret = ret + ch;
        }
        return ret;
    }

    protected void outln(char ch) throws DocumentException {
        this.out(PdfLegacyReport.rep(ch, this.iNrChars));
    }

    protected String lpad(String s, char ch, int len) {
        while (s.length() < len) {
            s = ch + s;
        }
        return s;
    }

    protected String lpad(String s, int len) {
        if (s == null) {
            s = "";
        }
        if (s.length() > len) {
            return s.substring(0, len);
        }
        return this.lpad(s, ' ', len);
    }

    protected String rpad(String s, char ch, int len) {
        while (s.length() < len) {
            s = s + ch;
        }
        return s;
    }

    protected String rpad(String s, int len) {
        if (s == null) {
            s = "";
        }
        if (s.length() > len) {
            return s.substring(0, len);
        }
        return this.rpad(s, ' ', len);
    }

    protected String mpad(String s, char ch, int len) {
        if (s == null) {
            s = "";
        }
        if (s.length() > len) {
            return s.substring(0, len);
        }
        while (s.length() < len) {
            if (s.length() % 2 == 0) {
                s = s + ch;
                continue;
            }
            s = ch + s;
        }
        return s;
    }

    protected String mpad(String s, int len) {
        return this.mpad(s, ' ', len);
    }

    protected String mpad(String s1, String s2, char ch, int len) {
        String m = "";
        while ((s1 + m + s2).length() < len) {
            m = m + ch;
        }
        return s1 + m + s2;
    }

    protected String render(String line, String s, int idx) {
        String a = line.length() <= idx ? this.rpad(line, ' ', idx) : line.substring(0, idx);
        String b = line.length() <= idx + s.length() ? "" : line.substring(idx + s.length());
        return a + s + b;
    }

    protected String renderMiddle(String line, String s) {
        return this.render(line, s, (this.iNrChars - s.length()) / 2);
    }

    protected String renderEnd(String line, String s) {
        return this.render(line, s, this.iNrChars - s.length());
    }

    public void printHeader() throws DocumentException {
        this.out(this.renderEnd(this.renderMiddle("UniTime " + Constants.getVersion(), this.iTitle), this.iTitle2));
        this.out(this.mpad(new SimpleDateFormat("EEE MMM dd, yyyy").format(new Date()), this.iSession, ' ', this.iNrChars));
        this.outln('=');
        this.iLineNo = 0;
        if (this.iCont != null && this.iCont.length() > 0) {
            this.println("(" + this.iCont + " Continued)");
        }
        if (this.iHeader != null) {
            for (int i = 0; i < this.iHeader.length; ++i) {
                this.println(this.iHeader[i]);
            }
        }
        this.headerPrinted();
    }

    protected void headerPrinted() {
    }

    protected void printFooter() throws DocumentException {
        this.iEmpty = false;
        this.out("");
        this.out(this.renderEnd(this.renderMiddle(this.iFooter == null ? "" : this.iFooter, "Page " + (this.iPageNo + 1)), (this.iPageId == null || this.iPageId.length() == 0 ? "" : this.iPageId) + "  "));
        if (this.iPrint != null) {
            this.iPrint.print(this.iBuffer);
        } else {
            Paragraph p = new Paragraph(this.iBuffer.toString().replace("\n ", "\n  "), PdfFont.getFixedFont());
            p.setLeading(9.5f);
            this.iDoc.add((Element)p);
        }
        this.iBuffer = new StringBuffer();
        ++this.iPageNo;
    }

    public void lastPage() throws DocumentException {
        while (this.iLineNo < this.iNrLines) {
            this.out("");
            ++this.iLineNo;
        }
        this.printFooter();
    }

    protected void newPage() throws DocumentException {
        while (this.iLineNo < this.iNrLines) {
            this.out("");
            ++this.iLineNo;
        }
        this.printFooter();
        if (this.iPrint != null) {
            this.iPrint.print("\f\n");
        } else {
            this.iDoc.newPage();
        }
        this.printHeader();
    }

    public int getLineNumber() {
        return this.iLineNo;
    }

    protected void println(String text) throws DocumentException {
        this.out(text);
        ++this.iLineNo;
        if (this.iLineNo >= this.iNrLines) {
            this.newPage();
        }
    }

    public boolean isEmpty() {
        return this.iEmpty;
    }

    public void close() throws IOException, DocumentException {
        if (this.isEmpty()) {
            this.println("Nothing to report.");
            this.lastPage();
        }
        if (this.iPrint != null) {
            this.iPrint.flush();
            this.iPrint.close();
        } else {
            this.iDoc.close();
            this.iOut.close();
        }
    }
}

