/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.updates.NotifyStudentAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class SaveStudentRequests
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Long iStudentId;
    private CourseRequestInterface iRequest;
    private boolean iKeepEnrollments;

    public SaveStudentRequests forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public SaveStudentRequests withRequest(CourseRequestInterface request, boolean keepEnrollments) {
        this.iRequest = request;
        this.iKeepEnrollments = keepEnrollments;
        return this;
    }

    public SaveStudentRequests withRequest(CourseRequestInterface request) {
        return this.withRequest(request, true);
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public CourseRequestInterface getRequest() {
        return this.iRequest;
    }

    public boolean getKeepEnrollments() {
        return this.iKeepEnrollments;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Throwable throwable2;
        Boolean bl;
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        helper.beginTransaction();
        try {
            Student student = (Student)StudentDAO.getInstance().get(this.getStudentId(), helper.getHibSession());
            if (student == null) {
                throw new SectioningException(MSG.exceptionBadStudentId());
            }
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            if (this.getRequest().getStudentId() != null) {
                action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()));
            }
            SaveStudentRequests.saveRequest(server, helper, student, this.getRequest(), this.getKeepEnrollments());
            XStudent oldStudent = server.getStudent(this.getStudentId());
            XStudent newStudent = null;
            try {
                newStudent = ReloadAllData.loadStudentNoCheck(student, server, helper);
                server.update(newStudent, true);
                action.getStudentBuilder().setUniqueId(newStudent.getStudentId()).setExternalId(newStudent.getExternalId()).setName(newStudent.getName());
                for (XRequest r : newStudent.getRequests()) {
                    action.addRequest(OnlineSectioningHelper.toProto(r));
                }
            }
            catch (Exception e) {
                if (!(e instanceof RuntimeException)) throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                throw (RuntimeException)e;
            }
            server.execute(server.createAction(NotifyStudentAction.class).forStudent(this.getStudentId()).oldStudent(oldStudent), helper.getUser());
            helper.commitTransaction();
            bl = true;
        }
        catch (Exception e) {
            try {
                helper.rollbackTransaction();
                if (!(e instanceof SectioningException)) throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                throw (SectioningException)e;
            }
            catch (Throwable throwable2) {
                Object var11_13 = null;
                lock.release();
            }
        }
        Object var11_12 = null;
        lock.release();
        return bl;
        throw throwable2;
    }

    @Override
    public String name() {
        return "save-request";
    }

    public static CourseOffering getCourse(Session hibSession, Long sessionId, String courseName) {
        Iterator iterator = hibSession.createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :course").setString("course", courseName.toLowerCase()).setLong("sessionId", sessionId.longValue()).setCacheable(true).setMaxResults(1).list().iterator();
        if (iterator.hasNext()) {
            CourseOffering co = (CourseOffering)iterator.next();
            return co;
        }
        return null;
    }

    private static CourseOffering getCourse(Session hibSession, long courseId) {
        return (CourseOffering)CourseOfferingDAO.getInstance().get(courseId, hibSession);
    }

    public static Map<Long, CourseRequest> saveRequest(OnlineSectioningServer server, OnlineSectioningHelper helper, Student student, CourseRequestInterface request, boolean keepEnrollments) throws SectioningException {
        CourseRequest cr;
        Iterator<CourseRequestOption> i;
        CourseRequest cr2;
        Iterator<CourseRequest> requests;
        Iterator<Object> i2;
        CourseDemand cd;
        CourseOffering co;
        XCourseId c;
        ArrayList<CourseOffering> courses;
        Object adept;
        CourseDemand cd2;
        TreeSet<CourseDemand> remaining = new TreeSet<CourseDemand>(student.getCourseDemands());
        int priority = 0;
        Date ts = new Date();
        HashMap<Long, CourseRequest> course2request = new HashMap<Long, CourseRequest>();
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (r.hasRequestedFreeTime() && r.hasRequestedCourse() && (server == null && SaveStudentRequests.getCourse(helper.getHibSession(), request.getAcademicSessionId(), r.getRequestedCourse()) != null || server != null && server.getCourse(r.getRequestedCourse()) != null)) {
                r.getRequestedFreeTime().clear();
            }
            if (r.hasRequestedFreeTime()) {
                for (CourseRequestInterface.FreeTime ft : r.getRequestedFreeTime()) {
                    cd2 = null;
                    Iterator i3 = remaining.iterator();
                    while (i3.hasNext()) {
                        adept = (CourseDemand)i3.next();
                        if (((BaseCourseDemand)adept).getFreeTime() == null) continue;
                        cd2 = adept;
                        i3.remove();
                        break;
                    }
                    if (cd2 == null) {
                        cd2 = new CourseDemand();
                        cd2.setTimestamp(ts);
                        cd2.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                        student.getCourseDemands().add(cd2);
                        cd2.setStudent(student);
                    }
                    cd2.setAlternative(false);
                    cd2.setPriority(priority);
                    cd2.setWaitlist(false);
                    FreeTime free = cd2.getFreeTime();
                    if (free == null) {
                        free = new FreeTime();
                        cd2.setFreeTime(free);
                    }
                    free.setCategory(0);
                    free.setDayCode(DayCode.toInt(DayCode.toDayCodes(ft.getDays())));
                    free.setStartSlot(ft.getStart());
                    free.setLength(ft.getLength());
                    free.setSession(student.getSession());
                    free.setName(ft.toString());
                    helper.getHibSession().saveOrUpdate((Object)free);
                    helper.getHibSession().saveOrUpdate((Object)cd2);
                }
            } else if (r.hasRequestedCourse() || r.hasFirstAlternative() || r.hasSecondAlternative()) {
                courses = new ArrayList();
                if (r.hasRequestedCourse()) {
                    c = server == null ? null : server.getCourse(r.getRequestedCourse());
                    CourseOffering courseOffering = co = c == null ? SaveStudentRequests.getCourse(helper.getHibSession(), request.getAcademicSessionId(), r.getRequestedCourse()) : SaveStudentRequests.getCourse(helper.getHibSession(), c.getCourseId());
                    if (co != null) {
                        courses.add(co);
                    }
                }
                if (r.hasFirstAlternative()) {
                    c = server == null ? null : server.getCourse(r.getFirstAlternative());
                    CourseOffering courseOffering = co = c == null ? SaveStudentRequests.getCourse(helper.getHibSession(), request.getAcademicSessionId(), r.getFirstAlternative()) : SaveStudentRequests.getCourse(helper.getHibSession(), c.getCourseId());
                    if (co != null) {
                        courses.add(co);
                    }
                }
                if (r.hasSecondAlternative()) {
                    c = server == null ? null : server.getCourse(r.getSecondAlternative());
                    CourseOffering courseOffering = co = c == null ? SaveStudentRequests.getCourse(helper.getHibSession(), request.getAcademicSessionId(), r.getSecondAlternative()) : SaveStudentRequests.getCourse(helper.getHibSession(), c.getCourseId());
                    if (co != null) {
                        courses.add(co);
                    }
                }
                if (courses.isEmpty()) continue;
                cd = null;
                i2 = remaining.iterator();
                block3: while (i2.hasNext()) {
                    CourseDemand adept2 = (CourseDemand)i2.next();
                    if (adept2.getFreeTime() != null) continue;
                    for (CourseRequest cr3 : adept2.getCourseRequests()) {
                        if (!cr3.getCourseOffering().getUniqueId().equals(((CourseOffering)courses.get(0)).getUniqueId())) continue;
                        cd = adept2;
                        i2.remove();
                        break block3;
                    }
                }
                if (cd == null) {
                    cd = new CourseDemand();
                    cd.setTimestamp(ts);
                    cd.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                    cd.setCourseRequests(new HashSet<CourseRequest>());
                    cd.setStudent(student);
                    student.getCourseDemands().add(cd);
                }
                cd.setAlternative(false);
                cd.setPriority(priority);
                cd.setWaitlist(r.isWaitList());
                requests = new TreeSet<CourseRequest>(cd.getCourseRequests()).iterator();
                int order = 0;
                for (CourseOffering co2 : courses) {
                    cr2 = null;
                    if (requests.hasNext()) {
                        cr2 = requests.next();
                        if (cr2.getCourseRequestOptions() != null) {
                            i = cr2.getCourseRequestOptions().iterator();
                            while (i.hasNext()) {
                                helper.getHibSession().delete((Object)i.next());
                            }
                            cr2.getCourseRequestOptions().clear();
                        }
                    } else {
                        cr2 = new CourseRequest();
                        cd.getCourseRequests().add(cr2);
                        cr2.setCourseDemand(cd);
                        cr2.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                    }
                    cr2.setAllowOverlap(false);
                    cr2.setCredit(0);
                    cr2.setOrder(order++);
                    cr2.setCourseOffering(co2);
                    course2request.put(co2.getUniqueId(), cr2);
                }
                while (requests.hasNext()) {
                    cr = requests.next();
                    cd.getCourseRequests().remove(cr);
                    helper.getHibSession().delete((Object)cr);
                }
                helper.getHibSession().saveOrUpdate((Object)cd);
            }
            ++priority;
        }
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (r.hasRequestedFreeTime() && r.hasRequestedCourse() && (server == null && SaveStudentRequests.getCourse(helper.getHibSession(), request.getAcademicSessionId(), r.getRequestedCourse()) != null || server != null && server.getCourse(r.getRequestedCourse()) != null)) {
                r.getRequestedFreeTime().clear();
            }
            if (r.hasRequestedFreeTime()) {
                for (CourseRequestInterface.FreeTime ft : r.getRequestedFreeTime()) {
                    cd2 = null;
                    Iterator i4 = remaining.iterator();
                    while (i4.hasNext()) {
                        adept = (CourseDemand)i4.next();
                        if (((BaseCourseDemand)adept).getFreeTime() == null) continue;
                        cd2 = adept;
                        i4.remove();
                        break;
                    }
                    if (cd2 == null) {
                        cd2 = new CourseDemand();
                        cd2.setTimestamp(ts);
                        cd2.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                        student.getCourseDemands().add(cd2);
                        cd2.setStudent(student);
                    }
                    cd2.setAlternative(true);
                    cd2.setPriority(priority);
                    cd2.setWaitlist(false);
                    FreeTime free = cd2.getFreeTime();
                    if (free == null) {
                        free = new FreeTime();
                        cd2.setFreeTime(free);
                    }
                    free.setCategory(0);
                    free.setDayCode(DayCode.toInt(DayCode.toDayCodes(ft.getDays())));
                    free.setStartSlot(ft.getStart());
                    free.setLength(ft.getLength());
                    free.setSession(student.getSession());
                    free.setName(ft.toString());
                    helper.getHibSession().saveOrUpdate((Object)free);
                    helper.getHibSession().saveOrUpdate((Object)cd2);
                }
            } else if (r.hasRequestedCourse() || r.hasFirstAlternative() || r.hasSecondAlternative()) {
                courses = new ArrayList<CourseOffering>();
                if (r.hasRequestedCourse()) {
                    c = server == null ? null : server.getCourse(r.getRequestedCourse());
                    CourseOffering courseOffering = co = c == null ? SaveStudentRequests.getCourse(helper.getHibSession(), request.getAcademicSessionId(), r.getRequestedCourse()) : SaveStudentRequests.getCourse(helper.getHibSession(), c.getCourseId());
                    if (co != null) {
                        courses.add(co);
                    }
                }
                if (r.hasFirstAlternative()) {
                    c = server == null ? null : server.getCourse(r.getFirstAlternative());
                    CourseOffering courseOffering = co = c == null ? SaveStudentRequests.getCourse(helper.getHibSession(), request.getAcademicSessionId(), r.getFirstAlternative()) : SaveStudentRequests.getCourse(helper.getHibSession(), c.getCourseId());
                    if (co != null) {
                        courses.add(co);
                    }
                }
                if (r.hasSecondAlternative()) {
                    c = server == null ? null : server.getCourse(r.getSecondAlternative());
                    CourseOffering courseOffering = co = c == null ? SaveStudentRequests.getCourse(helper.getHibSession(), request.getAcademicSessionId(), r.getSecondAlternative()) : SaveStudentRequests.getCourse(helper.getHibSession(), c.getCourseId());
                    if (co != null) {
                        courses.add(co);
                    }
                }
                if (courses.isEmpty()) continue;
                cd = null;
                i2 = remaining.iterator();
                block11: while (i2.hasNext()) {
                    CourseDemand adept3 = (CourseDemand)i2.next();
                    if (adept3.getFreeTime() != null) continue;
                    for (CourseRequest cr3 : adept3.getCourseRequests()) {
                        if (!cr3.getCourseOffering().getUniqueId().equals(((CourseOffering)courses.get(0)).getUniqueId())) continue;
                        cd = adept3;
                        i2.remove();
                        break block11;
                    }
                }
                if (cd == null) {
                    cd = new CourseDemand();
                    cd.setTimestamp(ts);
                    cd.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                    cd.setCourseRequests(new HashSet<CourseRequest>());
                    cd.setStudent(student);
                    student.getCourseDemands().add(cd);
                }
                cd.setAlternative(true);
                cd.setPriority(priority);
                cd.setWaitlist(r.isWaitList());
                requests = new TreeSet<CourseRequest>(cd.getCourseRequests()).iterator();
                int order = 0;
                for (CourseOffering co2 : courses) {
                    cr2 = null;
                    if (requests.hasNext()) {
                        cr2 = requests.next();
                        if (cr2.getCourseRequestOptions() != null) {
                            i = cr2.getCourseRequestOptions().iterator();
                            while (i.hasNext()) {
                                helper.getHibSession().delete((Object)i.next());
                            }
                            cr2.getCourseRequestOptions().clear();
                        }
                    } else {
                        cr2 = new CourseRequest();
                        cd.getCourseRequests().add(cr2);
                        cr2.setCourseDemand(cd);
                        cr2.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                    }
                    cr2.setAllowOverlap(false);
                    cr2.setCredit(0);
                    cr2.setOrder(order++);
                    cr2.setCourseOffering(co2);
                    course2request.put(co2.getUniqueId(), cr2);
                }
                while (requests.hasNext()) {
                    cr = requests.next();
                    cd.getCourseRequests().remove(cr);
                    helper.getHibSession().delete((Object)cr);
                }
                helper.getHibSession().saveOrUpdate((Object)cd);
            }
            ++priority;
        }
        Iterator<StudentClassEnrollment> i5 = student.getClassEnrollments().iterator();
        while (i5.hasNext()) {
            StudentClassEnrollment enrl = i5.next();
            if (keepEnrollments) {
                CourseRequest cr4 = (CourseRequest)course2request.get(enrl.getCourseOffering().getUniqueId());
                if (cr4 == null) {
                    enrl.setCourseRequest(null);
                    helper.getHibSession().saveOrUpdate((Object)enrl);
                    continue;
                }
                enrl.setCourseRequest(cr4);
                helper.getHibSession().saveOrUpdate((Object)enrl);
                continue;
            }
            enrl.getClazz().getStudentEnrollments().remove(enrl);
            helper.getHibSession().delete((Object)enrl);
            i5.remove();
        }
        if (!keepEnrollments) {
            for (CourseDemand cd3 : student.getCourseDemands()) {
                if (cd3.getCourseRequests() == null) continue;
                for (CourseRequest cr5 : cd3.getCourseRequests()) {
                    if (cr5.getClassWaitLists() == null) continue;
                    i2 = cr5.getClassWaitLists().iterator();
                    while (i2.hasNext()) {
                        helper.getHibSession().delete(i2.next());
                        i2.remove();
                    }
                }
            }
        }
        for (CourseDemand cd3 : remaining) {
            if (cd3.getFreeTime() != null) {
                helper.getHibSession().delete((Object)cd3.getFreeTime());
            }
            for (CourseRequest cr5 : cd3.getCourseRequests()) {
                helper.getHibSession().delete((Object)cr5);
            }
            student.getCourseDemands().remove(cd3);
            helper.getHibSession().delete((Object)cd3);
        }
        helper.getHibSession().saveOrUpdate((Object)student);
        helper.getHibSession().flush();
        return course2request;
    }
}

