/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.SectioningInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class PersistExpectedSpacesAction
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Collection<Long> iOfferingIds;
    private static DecimalFormat sDF = new DecimalFormat("+0.000;-0.000");

    public PersistExpectedSpacesAction forOfferings(Long ... offeringIds) {
        this.iOfferingIds = new ArrayList<Long>();
        for (Long offeringId : offeringIds) {
            this.iOfferingIds.add(offeringId);
        }
        return this;
    }

    public PersistExpectedSpacesAction forOfferings(Collection<Long> offeringIds) {
        this.iOfferingIds = offeringIds;
        return this;
    }

    public Collection<Long> getOfferingIds() {
        return this.iOfferingIds;
    }

    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        for (Long offeringId : this.getOfferingIds()) {
            try {
                helper.beginTransaction();
                PersistExpectedSpacesAction.persistExpectedSpaces(offeringId, true, server, helper);
                helper.commitTransaction();
            }
            catch (Exception e) {
                helper.rollbackTransaction();
                helper.error(MSG.exceptionUnknown(e.getMessage()), e);
            }
        }
        return true;
    }

    private static int getLimit(Class_ clazz) {
        int limit = -1;
        if (!clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
            limit = clazz.getMaxExpectedCapacity();
            if (clazz.getExpectedCapacity() < clazz.getMaxExpectedCapacity() && clazz.getCommittedAssignment() != null && clazz.getCommittedAssignment().getRooms().isEmpty()) {
                int roomSize = Integer.MAX_VALUE;
                for (Location room : clazz.getCommittedAssignment().getRooms()) {
                    roomSize = Math.min(roomSize, room.getCapacity() == null ? 0 : room.getCapacity());
                }
                int roomLimit = (int)Math.floor((float)roomSize / (clazz.getRoomRatio() == null ? 1.0f : clazz.getRoomRatio().floatValue()));
                limit = Math.min(Math.max(clazz.getExpectedCapacity(), roomLimit), clazz.getMaxExpectedCapacity());
            }
            if (limit >= 9999) {
                limit = -1;
            }
        }
        return limit;
    }

    public static void persistExpectedSpaces(Long offeringId, boolean needLock, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Double expectation;
        Map<Long, Double> expectations = server.getExpectations(offeringId).toMap();
        if (expectations == null || expectations.isEmpty()) {
            return;
        }
        for (SectioningInfo info : helper.getHibSession().createQuery("select i from SectioningInfo i left join fetch i.clazz as c where i.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering = :offeringId").setLong("offeringId", offeringId.longValue()).setCacheable(true).list()) {
            expectation = expectations.remove(info.getClazz().getUniqueId());
            if (expectation == null) {
                helper.getHibSession().delete((Object)info);
                continue;
            }
            if (expectation.equals(info.getNbrExpectedStudents())) continue;
            helper.debug(info.getClazz().getClassLabel(helper.getHibSession()) + ": expected " + sDF.format(expectation - info.getNbrExpectedStudents()));
            int limit = PersistExpectedSpacesAction.getLimit(info.getClazz());
            if (limit >= 0 && (double)limit >= info.getNbrExpectedStudents() && (double)limit < expectation) {
                helper.debug(info.getClazz().getClassLabel(helper.getHibSession()) + ": become over-expected");
            }
            if (limit >= 0 && (double)limit < info.getNbrExpectedStudents() && (double)limit >= expectation) {
                helper.debug(info.getClazz().getClassLabel(helper.getHibSession()) + ": no longer over-expected");
            }
            info.setNbrExpectedStudents(expectation);
            helper.getHibSession().saveOrUpdate((Object)info);
        }
        if (!expectations.isEmpty()) {
            for (Class_ clazz : helper.getHibSession().createQuery("select c from Class_ c where c.schedulingSubpart.instrOfferingConfig.instructionalOffering = :offeringId").setLong("offeringId", offeringId.longValue()).setCacheable(true).list()) {
                expectation = expectations.remove(clazz.getUniqueId());
                if (expectation == null) continue;
                SectioningInfo info = new SectioningInfo();
                helper.debug(clazz.getClassLabel(helper.getHibSession()) + ": expected " + sDF.format(expectation) + " (new)");
                int limit = PersistExpectedSpacesAction.getLimit(clazz);
                if (limit >= 0 && (double)limit < expectation) {
                    helper.debug(clazz.getClassLabel(helper.getHibSession()) + ": become over-expected");
                }
                info.setClazz(clazz);
                info.setNbrExpectedStudents(expectation);
                info.setNbrHoldingStudents(0.0);
                helper.getHibSession().saveOrUpdate((Object)info);
            }
        }
    }

    @Override
    public String name() {
        return "persist-expectations";
    }
}

