/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.hibernate.CacheMode;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.base.BaseStudentClassEnrollment;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.onlinesectioning.HasCacheMode;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.solver.CheckAssignmentAction;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.CheckOfferingAction;
import org.unitime.timetable.onlinesectioning.updates.NotifyStudentAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class EnrollStudent
implements OnlineSectioningAction<ClassAssignmentInterface>,
HasCacheMode {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Long iStudentId;
    private CourseRequestInterface iRequest;
    private List<ClassAssignmentInterface.ClassAssignment> iAssignment;

    public EnrollStudent forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public EnrollStudent withRequest(CourseRequestInterface request) {
        this.iRequest = request;
        return this;
    }

    public EnrollStudent withAssignment(List<ClassAssignmentInterface.ClassAssignment> assignment) {
        this.iAssignment = assignment;
        return this;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public CourseRequestInterface getRequest() {
        return this.iRequest;
    }

    public List<ClassAssignmentInterface.ClassAssignment> getAssignment() {
        return this.iAssignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public ClassAssignmentInterface execute(OnlineSectioningServer server, final OnlineSectioningHelper helper) {
        if (!server.getAcademicSession().isSectioningEnabled()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        HashSet<Long> offeringIds = new HashSet<Long>();
        HashSet<Long> lockedCourses = new HashSet<Long>();
        List<StudentEnrollmentProvider.EnrollmentFailure> failures = null;
        boolean includeRequestInTheReturnMessage = false;
        for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
            if (ca == null || ca.isFreeTime() || ca.isDummy()) continue;
            XCourse course = server.getCourse(ca.getCourseId());
            if (course == null) {
                throw new SectioningException(MSG.exceptionEnrollNotAvailable(MSG.clazz(ca.getSubject(), ca.getCourseNbr(), ca.getSubpart(), ca.getSection())));
            }
            if (server.isOfferingLocked(course.getOfferingId())) {
                lockedCourses.add(course.getCourseId());
                for (CourseRequestInterface.Request r : this.getRequest().getCourses()) {
                    if (r.isWaitList() || r.hasRequestedFreeTime() || !(r.hasRequestedCourse() && course.matchCourseName(r.getRequestedCourse()) || r.hasFirstAlternative() && course.matchCourseName(r.getFirstAlternative())) && (!r.hasSecondAlternative() || !course.matchCourseName(r.getSecondAlternative()))) continue;
                    r.setWaitList(true);
                }
                continue;
            }
            offeringIds.add(course.getOfferingId());
        }
        OnlineSectioningServer.ServerCallback<Boolean> offeringChecked = new OnlineSectioningServer.ServerCallback<Boolean>(){

            @Override
            public void onFailure(Throwable exception) {
                helper.error("Offering check failed: " + exception.getMessage(), exception);
            }

            @Override
            public void onSuccess(Boolean result) {
            }
        };
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), offeringIds, this.name());
        try {
            helper.beginTransaction();
            try {
                Object newEnrollment;
                XOffering offering;
                org.unitime.timetable.model.CourseRequest cr;
                Iterator<Serializable> i;
                CourseRequestOption o;
                OnlineSectioningLog.CourseRequestOption.Builder option;
                org.unitime.timetable.model.CourseRequest cr2;
                Iterator<Serializable> requests;
                Iterator<Object> i2;
                BaseCourseDemand cd;
                XCourseId c;
                Object courses;
                Object adept;
                OnlineSectioningLog.Action.Builder action = helper.getAction();
                if (this.getRequest().getStudentId() != null) {
                    action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()));
                }
                OnlineSectioningLog.Enrollment.Builder requested = OnlineSectioningLog.Enrollment.newBuilder();
                requested.setType(OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED);
                Hashtable<Long, OnlineSectioningLog.CourseRequestOption.Builder> options = new Hashtable<Long, OnlineSectioningLog.CourseRequestOption.Builder>();
                for (ClassAssignmentInterface.ClassAssignment assignment : this.getAssignment()) {
                    if (assignment == null) continue;
                    OnlineSectioningLog.Section s = OnlineSectioningHelper.toProto(assignment);
                    requested.addSection(s);
                    if (assignment.isFreeTime() || assignment.isDummy()) continue;
                    OnlineSectioningLog.CourseRequestOption.Builder option2 = (OnlineSectioningLog.CourseRequestOption.Builder)options.get(assignment.getCourseId());
                    if (option2 == null) {
                        option2 = OnlineSectioningLog.CourseRequestOption.newBuilder().setType(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT);
                        options.put(assignment.getCourseId(), option2);
                    }
                    option2.addSection(s);
                }
                action.addEnrollment(requested);
                for (OnlineSectioningLog.Request r : OnlineSectioningHelper.toProto(this.getRequest())) {
                    action.addRequest(r);
                }
                List<StudentEnrollmentProvider.EnrollmentRequest> enrlCheck = server.createAction(CheckAssignmentAction.class).forStudent(this.getStudentId()).withAssignment(this.getAssignment()).check(server, helper);
                Student student = (Student)helper.getHibSession().createQuery("select s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch cd.freeTime as ft left join fetch cr.courseOffering as co left join fetch cr.courseRequestOptions as cro left join fetch cr.classWaitLists as cwl left join fetch s.classEnrollments as e left join fetch e.clazz as c left join fetch c.managingDept as cmd left join fetch c.schedulingSubpart as ss where s.uniqueId = :studentId").setLong("studentId", this.getStudentId().longValue()).uniqueResult();
                if (student == null) {
                    throw new SectioningException(MSG.exceptionBadStudentId());
                }
                XStudent oldStudent = server.getStudent(this.getStudentId());
                action.getStudentBuilder().setUniqueId(student.getUniqueId()).setExternalId(oldStudent.getExternalId()).setName(oldStudent.getName());
                if (CustomStudentEnrollmentHolder.hasProvider()) {
                    failures = CustomStudentEnrollmentHolder.getProvider().enroll(server, helper, oldStudent, enrlCheck, lockedCourses);
                    Iterator<Serializable> i3 = this.getAssignment().iterator();
                    block8: while (i3.hasNext()) {
                        ClassAssignmentInterface.ClassAssignment ca = i3.next();
                        if (ca == null || ca.isFreeTime() || ca.getClassId() == null || ca.isDummy()) continue;
                        for (StudentEnrollmentProvider.EnrollmentFailure f : failures) {
                            if (f.isEnrolled() || !f.getSection().getSectionId().equals(ca.getClassId())) continue;
                            i3.remove();
                            continue block8;
                        }
                    }
                    block10: for (StudentEnrollmentProvider.EnrollmentFailure f : failures) {
                        if (!f.isEnrolled()) continue;
                        for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
                            if (ca == null || !f.getSection().getSectionId().equals(ca.getClassId())) continue;
                            continue block10;
                        }
                        ClassAssignmentInterface.ClassAssignment ca = new ClassAssignmentInterface.ClassAssignment();
                        ca.setClassId(f.getSection().getSectionId());
                        ca.setCourseId(f.getCourse().getCourseId());
                        this.getAssignment().add(ca);
                    }
                }
                TreeSet<CourseDemand> remaining = new TreeSet<CourseDemand>(student.getCourseDemands());
                int priority = 0;
                Date ts = new Date();
                HashMap<Long, org.unitime.timetable.model.CourseRequest> course2request = new HashMap<Long, org.unitime.timetable.model.CourseRequest>();
                for (CourseRequestInterface.Request r : this.getRequest().getCourses()) {
                    if (r.hasRequestedFreeTime() && r.hasRequestedCourse() && server.getCourse(r.getRequestedCourse()) != null) {
                        r.getRequestedFreeTime().clear();
                    }
                    if (r.hasRequestedFreeTime()) {
                        for (CourseRequestInterface.FreeTime ft : r.getRequestedFreeTime()) {
                            CourseDemand cd2 = null;
                            Iterator i4 = remaining.iterator();
                            while (i4.hasNext()) {
                                adept = (CourseDemand)i4.next();
                                if (((BaseCourseDemand)adept).getFreeTime() == null) continue;
                                cd2 = adept;
                                i4.remove();
                                break;
                            }
                            if (cd2 == null) {
                                cd2 = new CourseDemand();
                                cd2.setTimestamp(ts);
                                cd2.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                                student.getCourseDemands().add(cd2);
                                cd2.setStudent(student);
                            }
                            cd2.setAlternative(false);
                            cd2.setPriority(priority);
                            cd2.setWaitlist(false);
                            FreeTime free = cd2.getFreeTime();
                            if (free == null) {
                                free = new FreeTime();
                                cd2.setFreeTime(free);
                            }
                            free.setCategory(0);
                            free.setDayCode(DayCode.toInt(DayCode.toDayCodes(ft.getDays())));
                            free.setStartSlot(ft.getStart());
                            free.setLength(ft.getLength());
                            free.setSession(student.getSession());
                            free.setName(ft.toString());
                            helper.getHibSession().saveOrUpdate((Object)free);
                            helper.getHibSession().saveOrUpdate((Object)cd2);
                        }
                    } else {
                        courses = new ArrayList();
                        if (r.hasRequestedCourse() && (c = server.getCourse(r.getRequestedCourse())) != null) {
                            courses.add(c);
                        }
                        if (r.hasFirstAlternative() && (c = server.getCourse(r.getFirstAlternative())) != null) {
                            courses.add(c);
                        }
                        if (r.hasSecondAlternative() && (c = server.getCourse(r.getSecondAlternative())) != null) {
                            courses.add(c);
                        }
                        if (courses.isEmpty()) continue;
                        cd = null;
                        Iterator i22 = remaining.iterator();
                        block15: while (i22.hasNext()) {
                            CourseDemand adept2 = (CourseDemand)i22.next();
                            if (adept2.getFreeTime() != null) continue;
                            for (org.unitime.timetable.model.CourseRequest courseRequest : adept2.getCourseRequests()) {
                                if (!courseRequest.getCourseOffering().getUniqueId().equals(((XCourseId)courses.get(0)).getCourseId())) continue;
                                cd = adept2;
                                i22.remove();
                                break block15;
                            }
                        }
                        if (cd == null) {
                            cd = new CourseDemand();
                            cd.setTimestamp(ts);
                            cd.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                            cd.setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                            cd.setStudent(student);
                            cd.setEnrollmentMessages(new HashSet<StudentEnrollmentMessage>());
                            student.getCourseDemands().add((CourseDemand)cd);
                        } else {
                            i2 = cd.getEnrollmentMessages().iterator();
                            while (i2.hasNext()) {
                                StudentEnrollmentMessage message = (StudentEnrollmentMessage)i2.next();
                                helper.getHibSession().delete((Object)message);
                                i2.remove();
                            }
                        }
                        cd.setAlternative(false);
                        cd.setPriority(priority);
                        cd.setWaitlist(r.isWaitList());
                        requests = new TreeSet<org.unitime.timetable.model.CourseRequest>(cd.getCourseRequests()).iterator();
                        int order = 0;
                        adept = courses.iterator();
                        while (adept.hasNext()) {
                            XCourseId xCourseId = (XCourseId)((Object)adept.next());
                            cr2 = null;
                            option = (OnlineSectioningLog.CourseRequestOption.Builder)options.get(xCourseId.getCourseId());
                            if (requests.hasNext()) {
                                cr2 = (org.unitime.timetable.model.CourseRequest)requests.next();
                                if (cr2.getCourseRequestOptions() != null && cr2.getCourseRequestOptions().size() == 1 && option != null) {
                                    o = cr2.getCourseRequestOptions().iterator().next();
                                    o.setOption(option.build());
                                } else {
                                    if (cr2.getCourseRequestOptions() != null) {
                                        i = cr2.getCourseRequestOptions().iterator();
                                        while (i.hasNext()) {
                                            helper.getHibSession().delete((Object)i.next());
                                            i.remove();
                                        }
                                    } else {
                                        cr2.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                                    }
                                    if (option != null) {
                                        o = new CourseRequestOption();
                                        o.setCourseRequest(cr2);
                                        o.setOption(option.build());
                                        cr2.getCourseRequestOptions().add(o);
                                    }
                                }
                                if (cr2.getClassWaitLists() != null) {
                                    i = cr2.getClassWaitLists().iterator();
                                    while (i.hasNext()) {
                                        helper.getHibSession().delete((Object)i.next());
                                        i.remove();
                                    }
                                }
                            } else {
                                cr2 = new org.unitime.timetable.model.CourseRequest();
                                cd.getCourseRequests().add(cr2);
                                cr2.setCourseDemand((CourseDemand)cd);
                                cr2.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                                if (option != null) {
                                    o = new CourseRequestOption();
                                    o.setCourseRequest(cr2);
                                    o.setOption(option.build());
                                    cr2.getCourseRequestOptions().add(o);
                                }
                            }
                            cr2.setAllowOverlap(false);
                            cr2.setCredit(0);
                            cr2.setOrder(order++);
                            if (cr2.getCourseOffering() == null || !cr2.getCourseOffering().getUniqueId().equals(xCourseId.getCourseId())) {
                                cr2.setCourseOffering((CourseOffering)CourseOfferingDAO.getInstance().get(xCourseId.getCourseId(), helper.getHibSession()));
                            }
                            course2request.put(xCourseId.getCourseId(), cr2);
                            if (failures == null) continue;
                            String message = null;
                            for (StudentEnrollmentProvider.EnrollmentFailure f : failures) {
                                if (!xCourseId.getCourseId().equals(f.getCourse().getCourseId())) continue;
                                if (message == null) {
                                    message = f.getMessage();
                                    continue;
                                }
                                if (message.contains(f.getMessage())) continue;
                                message = message + "\n" + f.getMessage();
                            }
                            if (message == null || message.isEmpty()) continue;
                            StudentEnrollmentMessage m = new StudentEnrollmentMessage();
                            m.setCourseDemand((CourseDemand)cd);
                            m.setLevel(0);
                            m.setType(0);
                            m.setTimestamp(ts);
                            m.setMessage(message.length() > 255 ? message.substring(0, 252) + "..." : message);
                            m.setOrder(0);
                            cd.getEnrollmentMessages().add(m);
                        }
                        while (requests.hasNext()) {
                            cr = (org.unitime.timetable.model.CourseRequest)requests.next();
                            cd.getCourseRequests().remove(cr);
                            helper.getHibSession().delete((Object)cr);
                        }
                        helper.getHibSession().saveOrUpdate((Object)cd);
                    }
                    ++priority;
                }
                for (CourseRequestInterface.Request r : this.getRequest().getAlternatives()) {
                    if (r.hasRequestedFreeTime() && r.hasRequestedCourse() && server.getCourse(r.getRequestedCourse()) != null) {
                        r.getRequestedFreeTime().clear();
                    }
                    if (r.hasRequestedFreeTime()) {
                        for (CourseRequestInterface.FreeTime ft : r.getRequestedFreeTime()) {
                            Object cd2 = null;
                            Iterator i5 = remaining.iterator();
                            while (i5.hasNext()) {
                                adept = (CourseDemand)i5.next();
                                if (((BaseCourseDemand)adept).getFreeTime() == null) continue;
                                cd2 = adept;
                                i5.remove();
                                break;
                            }
                            if (cd2 == null) {
                                cd2 = new CourseDemand();
                                ((BaseCourseDemand)cd2).setTimestamp(ts);
                                ((BaseCourseDemand)cd2).setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                                student.getCourseDemands().add((CourseDemand)cd2);
                                ((BaseCourseDemand)cd2).setStudent(student);
                            }
                            ((BaseCourseDemand)cd2).setAlternative(true);
                            ((BaseCourseDemand)cd2).setPriority(priority);
                            ((BaseCourseDemand)cd2).setWaitlist(false);
                            FreeTime free = ((BaseCourseDemand)cd2).getFreeTime();
                            if (free == null) {
                                free = new FreeTime();
                                ((BaseCourseDemand)cd2).setFreeTime(free);
                            }
                            free.setCategory(0);
                            free.setDayCode(DayCode.toInt(DayCode.toDayCodes(ft.getDays())));
                            free.setStartSlot(ft.getStart());
                            free.setLength(ft.getLength());
                            free.setSession(student.getSession());
                            free.setName(ft.toString());
                            helper.getHibSession().saveOrUpdate((Object)free);
                            helper.getHibSession().saveOrUpdate(cd2);
                        }
                    } else {
                        courses = new ArrayList();
                        if (r.hasRequestedCourse() && (c = server.getCourse(r.getRequestedCourse())) != null) {
                            courses.add(c);
                        }
                        if (r.hasFirstAlternative() && (c = server.getCourse(r.getFirstAlternative())) != null) {
                            courses.add(c);
                        }
                        if (r.hasSecondAlternative() && (c = server.getCourse(r.getSecondAlternative())) != null) {
                            courses.add(c);
                        }
                        if (courses.isEmpty()) continue;
                        cd = null;
                        i2 = remaining.iterator();
                        block26: while (i2.hasNext()) {
                            CourseDemand adept3 = (CourseDemand)i2.next();
                            if (adept3.getFreeTime() != null) continue;
                            for (org.unitime.timetable.model.CourseRequest courseRequest : adept3.getCourseRequests()) {
                                if (!courseRequest.getCourseOffering().getUniqueId().equals(((XCourseId)courses.get(0)).getCourseId())) continue;
                                cd = adept3;
                                i2.remove();
                                break block26;
                            }
                        }
                        if (cd == null) {
                            cd = new CourseDemand();
                            cd.setTimestamp(ts);
                            cd.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                            cd.setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                            cd.setStudent(student);
                            student.getCourseDemands().add((CourseDemand)cd);
                        }
                        cd.setAlternative(true);
                        cd.setPriority(priority);
                        cd.setWaitlist(r.isWaitList());
                        requests = new TreeSet<org.unitime.timetable.model.CourseRequest>(cd.getCourseRequests()).iterator();
                        int order = 0;
                        adept = courses.iterator();
                        while (adept.hasNext()) {
                            XCourseId xCourseId = (XCourseId)((Object)adept.next());
                            cr2 = null;
                            option = (OnlineSectioningLog.CourseRequestOption.Builder)options.get(xCourseId.getCourseId());
                            if (requests.hasNext()) {
                                cr2 = (org.unitime.timetable.model.CourseRequest)requests.next();
                                if (cr2.getCourseRequestOptions() != null && cr2.getCourseRequestOptions().size() == 1 && option != null) {
                                    o = cr2.getCourseRequestOptions().iterator().next();
                                    o.setOption(option.build());
                                } else {
                                    if (cr2.getCourseRequestOptions() != null) {
                                        i = cr2.getCourseRequestOptions().iterator();
                                        while (i.hasNext()) {
                                            helper.getHibSession().delete((Object)i.next());
                                            i.remove();
                                        }
                                    } else {
                                        cr2.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                                    }
                                    if (option != null) {
                                        o = new CourseRequestOption();
                                        o.setCourseRequest(cr2);
                                        o.setOption(option.build());
                                        cr2.getCourseRequestOptions().add(o);
                                    }
                                }
                                if (cr2.getClassWaitLists() != null) {
                                    i = cr2.getClassWaitLists().iterator();
                                    while (i.hasNext()) {
                                        helper.getHibSession().delete((Object)i.next());
                                        i.remove();
                                    }
                                }
                            } else {
                                cr2 = new org.unitime.timetable.model.CourseRequest();
                                cd.getCourseRequests().add(cr2);
                                cr2.setCourseDemand((CourseDemand)cd);
                                cr2.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                                if (option != null) {
                                    o = new CourseRequestOption();
                                    o.setCourseRequest(cr2);
                                    o.setOption(option.build());
                                    cr2.getCourseRequestOptions().add(o);
                                }
                            }
                            cr2.setAllowOverlap(false);
                            cr2.setCredit(0);
                            cr2.setOrder(order++);
                            if (cr2.getCourseOffering() == null || !cr2.getCourseOffering().getUniqueId().equals(xCourseId.getCourseId())) {
                                cr2.setCourseOffering((CourseOffering)CourseOfferingDAO.getInstance().get(xCourseId.getCourseId(), helper.getHibSession()));
                            }
                            course2request.put(xCourseId.getCourseId(), cr2);
                        }
                        while (requests.hasNext()) {
                            cr = (org.unitime.timetable.model.CourseRequest)requests.next();
                            cd.getCourseRequests().remove(cr);
                            helper.getHibSession().delete((Object)cr);
                        }
                        helper.getHibSession().saveOrUpdate((Object)cd);
                    }
                    ++priority;
                }
                HashMap<FindAssignmentAction.IdPair, StudentClassEnrollment> oldEnrollments = new HashMap<FindAssignmentAction.IdPair, StudentClassEnrollment>();
                HashMap<Long, Object[]> oldApprovals = new HashMap<Long, Object[]>();
                for (StudentClassEnrollment e : student.getClassEnrollments()) {
                    oldEnrollments.put(new FindAssignmentAction.IdPair(e.getCourseOffering().getUniqueId(), e.getClazz().getUniqueId()), e);
                    if (e.getApprovedBy() == null || oldApprovals.containsKey(e.getCourseOffering().getUniqueId())) continue;
                    oldApprovals.put(e.getCourseOffering().getUniqueId(), new Object[]{e.getApprovedBy(), e.getApprovedDate()});
                }
                HashMap<Long, Class_> classes = new HashMap<Long, Class_>();
                String classIds = null;
                for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
                    if (ca == null || ca.isFreeTime() || ca.getClassId() == null || ca.isDummy() || oldEnrollments.containsKey(new FindAssignmentAction.IdPair(ca.getCourseId(), ca.getClassId()))) continue;
                    if (classIds == null) {
                        classIds = ca.getClassId().toString();
                        continue;
                    }
                    classIds = classIds + "," + ca.getClassId();
                }
                if (classIds != null) {
                    for (Class_ clazz : helper.getHibSession().createQuery("select c from Class_ c left join fetch c.studentEnrollments as e left join fetch c.schedulingSubpart as s where c.uniqueId in (" + classIds + ")").list()) {
                        classes.put(clazz.getUniqueId(), clazz);
                    }
                }
                HashMap<Long, Long> courseDemandId2courseId = new HashMap<Long, Long>();
                for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
                    void var26_46;
                    if (ca == null || ca.isFreeTime() || ca.getClassId() == null || ca.isDummy()) continue;
                    org.unitime.timetable.model.CourseRequest courseRequest = (org.unitime.timetable.model.CourseRequest)course2request.get(ca.getCourseId());
                    if (courseRequest == null) {
                        CourseDemand cd3 = null;
                        Iterator i6 = remaining.iterator();
                        block36: while (i6.hasNext()) {
                            CourseDemand adept4 = (CourseDemand)i6.next();
                            if (adept4.getFreeTime() != null) continue;
                            for (org.unitime.timetable.model.CourseRequest r : adept4.getCourseRequests()) {
                                if (!r.getCourseOffering().getUniqueId().equals(ca.getCourseId())) continue;
                                cd3 = adept4;
                                i6.remove();
                                break block36;
                            }
                        }
                        if (cd3 == null) {
                            cd3 = new CourseDemand();
                            cd3.setTimestamp(ts);
                            cd3.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                            cd3.setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                            cd3.setStudent(student);
                            student.getCourseDemands().add(cd3);
                        }
                        cd3.setAlternative(false);
                        cd3.setPriority(priority++);
                        cd3.setWaitlist(false);
                        org.unitime.timetable.model.CourseRequest courseRequest2 = new org.unitime.timetable.model.CourseRequest();
                        cd3.getCourseRequests().add(courseRequest2);
                        courseRequest2.setCourseDemand(cd3);
                        courseRequest2.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                        option = (OnlineSectioningLog.CourseRequestOption.Builder)options.get(ca.getCourseId());
                        if (option != null) {
                            o = new CourseRequestOption();
                            o.setCourseRequest(courseRequest2);
                            o.setOption(option.build());
                            courseRequest2.getCourseRequestOptions().add(o);
                        }
                        courseRequest2.setAllowOverlap(false);
                        courseRequest2.setCredit(0);
                        courseRequest2.setOrder(0);
                        courseRequest2.setCourseOffering((CourseOffering)CourseOfferingDAO.getInstance().get(ca.getCourseId(), helper.getHibSession()));
                        course2request.put(ca.getCourseId(), courseRequest2);
                        helper.getHibSession().saveOrUpdate((Object)cd3);
                        courseDemandId2courseId.put(cd3.getUniqueId(), ca.getCourseId());
                        includeRequestInTheReturnMessage = true;
                    } else {
                        Long courseId = (Long)courseDemandId2courseId.get(courseRequest.getCourseDemand().getUniqueId());
                        if (courseId == null) {
                            courseDemandId2courseId.put(courseRequest.getCourseDemand().getUniqueId(), ca.getCourseId());
                        } else if (!courseId.equals(ca.getCourseId())) {
                            courseRequest.getCourseDemand().getCourseRequests().remove(courseRequest);
                            CourseDemand cd4 = new CourseDemand();
                            cd4.setTimestamp(ts);
                            cd4.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                            cd4.setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                            cd4.setStudent(student);
                            student.getCourseDemands().add(cd4);
                            cd4.setAlternative(false);
                            cd4.setPriority(priority++);
                            cd4.setWaitlist(false);
                            courseRequest.setCourseDemand(cd4);
                            cd4.getCourseRequests().add(courseRequest);
                            helper.getHibSession().saveOrUpdate((Object)cd4);
                            courseDemandId2courseId.put(cd4.getUniqueId(), ca.getCourseId());
                            includeRequestInTheReturnMessage = true;
                        }
                    }
                    StudentClassEnrollment enrl = (StudentClassEnrollment)oldEnrollments.remove(new FindAssignmentAction.IdPair(ca.getCourseId(), ca.getClassId()));
                    if (enrl != null) {
                        if (var26_46.equals(enrl.getCourseRequest())) continue;
                        enrl.setCourseRequest((org.unitime.timetable.model.CourseRequest)var26_46);
                        helper.getHibSession().update((Object)enrl);
                        continue;
                    }
                    Class_ clazz = (Class_)classes.get(ca.getClassId());
                    if (clazz == null) continue;
                    if (lockedCourses.contains(ca.getCourseId())) {
                        ClassWaitList cwl = new ClassWaitList();
                        cwl.setClazz(clazz);
                        cwl.setCourseRequest((org.unitime.timetable.model.CourseRequest)var26_46);
                        cwl.setStudent(student);
                        cwl.setType(ClassWaitList.Type.LOCKED.ordinal());
                        cwl.setTimestamp(ts);
                        if (var26_46.getClassWaitLists() == null) {
                            var26_46.setClassWaitLists(new HashSet<ClassWaitList>());
                        }
                        var26_46.getClassWaitLists().add(cwl);
                        helper.getHibSession().saveOrUpdate((Object)cwl);
                        continue;
                    }
                    enrl = new StudentClassEnrollment();
                    enrl.setClazz(clazz);
                    enrl.setStudent(student);
                    enrl.setCourseOffering(var26_46.getCourseOffering());
                    clazz.getStudentEnrollments().add(enrl);
                    student.getClassEnrollments().add(enrl);
                    enrl.setTimestamp(ts);
                    enrl.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                    Object[] approval = (Object[])oldApprovals.get(ca.getCourseId());
                    if (approval != null) {
                        enrl.setApprovedBy((String)approval[0]);
                        enrl.setApprovedDate((Date)approval[1]);
                    }
                    enrl.setCourseRequest((org.unitime.timetable.model.CourseRequest)var26_46);
                }
                for (CourseDemand cd5 : remaining) {
                    if (cd5.getFreeTime() != null) {
                        helper.getHibSession().delete((Object)cd5.getFreeTime());
                    }
                    for (org.unitime.timetable.model.CourseRequest cr22 : cd5.getCourseRequests()) {
                        helper.getHibSession().delete((Object)cr22);
                    }
                    student.getCourseDemands().remove(cd5);
                    helper.getHibSession().delete((Object)cd5);
                }
                for (Iterator<XRequest> enrl : oldEnrollments.values()) {
                    ((BaseStudentClassEnrollment)((Object)enrl)).getClazz().getStudentEnrollments().remove(enrl);
                    student.getClassEnrollments().remove(enrl);
                    helper.getHibSession().delete((Object)enrl);
                }
                helper.getHibSession().saveOrUpdate((Object)student);
                XStudent newStudent = new XStudent(oldStudent, student.getCourseDemands(), helper, server.getAcademicSession().getFreeTimePattern());
                for (XRequest xRequest : newStudent.getRequests()) {
                    XCourseRequest courseRequest;
                    XEnrollment enrollment;
                    if (!(xRequest instanceof XCourseRequest) || (enrollment = (courseRequest = (XCourseRequest)xRequest).getEnrollment()) == null || enrollment.getReservation() != null || (offering = server.getOffering(enrollment.getOfferingId())) == null || offering.getReservations().isEmpty()) continue;
                    enrollment.setReservation(offering.guessReservation(server.getRequests(enrollment.getOfferingId()), newStudent, enrollment));
                }
                server.update(newStudent, true);
                for (XRequest xRequest : oldStudent.getRequests()) {
                    Set<Long> oldSections;
                    XEnrollment oldEnrollment;
                    XEnrollment xEnrollment = oldEnrollment = xRequest instanceof XCourseRequest ? ((XCourseRequest)xRequest).getEnrollment() : null;
                    if (oldEnrollment == null) continue;
                    XRequest newRequest = null;
                    newEnrollment = null;
                    if (newStudent != null) {
                        for (XRequest r : newStudent.getRequests()) {
                            XEnrollment e = r instanceof XCourseRequest ? ((XCourseRequest)r).getEnrollment() : null;
                            if (e == null || !e.getOfferingId().equals(oldEnrollment.getOfferingId())) continue;
                            newRequest = (XCourseRequest)r;
                            newEnrollment = e;
                            break;
                        }
                    }
                    if (newEnrollment == null) {
                        oldSections = oldEnrollment.getSectionIds();
                    } else {
                        oldSections = new HashSet<Long>();
                        for (Long sectionId : oldEnrollment.getSectionIds()) {
                            if (((XEnrollment)newEnrollment).getSectionIds().contains(sectionId)) continue;
                            oldSections.add(sectionId);
                        }
                    }
                    if (oldSections.isEmpty()) continue;
                    boolean checkOffering = false;
                    XOffering offering2 = server.getOffering(oldEnrollment.getOfferingId());
                    if (!offering2.getReservations().isEmpty()) {
                        checkOffering = true;
                        helper.debug("Check offering for " + oldEnrollment.getCourseName() + ": there are reservations.");
                    } else {
                        XCourse course;
                        XConfig config;
                        XEnrollments enrollments = server.getEnrollments(oldEnrollment.getOfferingId());
                        for (Long sectionId : oldSections) {
                            XSection section = offering2.getSection(sectionId);
                            if (section == null || section.getLimit() < 0 || section.getLimit() - enrollments.countEnrollmentsForSection(sectionId) != 1) continue;
                            checkOffering = true;
                            helper.debug("Check offering for " + oldEnrollment.getCourseName() + ": section " + section + " became available.");
                            break;
                        }
                        if (!(checkOffering || newEnrollment != null && ((XEnrollment)newEnrollment).getConfigId().equals(oldEnrollment.getConfigId()) || (config = offering2.getConfig(oldEnrollment.getConfigId())) == null || config.getLimit() < 0 || config.getLimit() - enrollments.countEnrollmentsForConfig(config.getConfigId()) != 1)) {
                            checkOffering = true;
                            helper.debug("Check offering for " + oldEnrollment.getCourseName() + ": config " + config + " became available.");
                        }
                        if (!(checkOffering || newEnrollment != null && ((XCourseId)newEnrollment).getCourseId().equals(oldEnrollment.getCourseId()) || (course = offering2.getCourse(oldEnrollment.getCourseId())) == null || course.getLimit() < 0 || course.getLimit() - enrollments.countEnrollmentsForCourse(course.getCourseId()) != 1)) {
                            checkOffering = true;
                            helper.debug("Check offering for " + oldEnrollment.getCourseName() + ": course " + course + " became available.");
                        }
                    }
                    if (checkOffering) {
                        server.execute(server.createAction(CheckOfferingAction.class).forOfferings(oldEnrollment.getOfferingId()), helper.getUser(), offeringChecked);
                    }
                    EnrollStudent.updateSpace(server, newEnrollment == null ? null : SectioningRequest.convert(newStudent, (XCourseRequest)newRequest, server, offering2, (XEnrollment)newEnrollment), oldEnrollment == null ? null : SectioningRequest.convert(oldStudent, (XCourseRequest)xRequest, server, offering2, oldEnrollment), offering2);
                    server.persistExpectedSpaces(oldEnrollment.getOfferingId());
                }
                OnlineSectioningLog.Enrollment.Builder previous = OnlineSectioningLog.Enrollment.newBuilder();
                previous.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                for (XRequest oldRequest : oldStudent.getRequests()) {
                    XEnrollment oldEnrollment = oldRequest instanceof XCourseRequest ? ((XCourseRequest)oldRequest).getEnrollment() : null;
                    if (oldEnrollment == null) continue;
                    for (XSection section : server.getOffering(oldEnrollment.getOfferingId()).getSections(oldEnrollment)) {
                        previous.addSection(OnlineSectioningHelper.toProto(section, oldEnrollment));
                    }
                }
                action.addEnrollment(previous);
                block48: for (XRequest newRequest : newStudent.getRequests()) {
                    XEnrollment newEnrollment2 = newRequest instanceof XCourseRequest ? ((XCourseRequest)newRequest).getEnrollment() : null;
                    if (newEnrollment2 == null) continue;
                    if (oldStudent != null) {
                        for (XRequest oldRequest : oldStudent.getRequests()) {
                            XEnrollment oldEnrollment = oldRequest instanceof XCourseRequest ? ((XCourseRequest)oldRequest).getEnrollment() : null;
                            if (oldEnrollment == null || !oldEnrollment.getOfferingId().equals(newEnrollment2.getOfferingId())) continue;
                            continue block48;
                        }
                    }
                    offering = server.getOffering(newEnrollment2.getOfferingId());
                    EnrollStudent.updateSpace(server, SectioningRequest.convert(newStudent, (XCourseRequest)newRequest, server, offering, newEnrollment2), null, offering);
                    server.persistExpectedSpaces(newEnrollment2.getOfferingId());
                }
                OnlineSectioningLog.Enrollment.Builder builder = OnlineSectioningLog.Enrollment.newBuilder();
                builder.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                for (XRequest newRequest : newStudent.getRequests()) {
                    newEnrollment = newRequest instanceof XCourseRequest ? ((XCourseRequest)newRequest).getEnrollment() : null;
                    if (newEnrollment == null) continue;
                    for (XSection section : server.getOffering(((XCourseId)newEnrollment).getOfferingId()).getSections((XEnrollment)newEnrollment)) {
                        builder.addSection(OnlineSectioningHelper.toProto(section, (XEnrollment)newEnrollment));
                    }
                }
                action.addEnrollment(builder);
                server.execute(server.createAction(NotifyStudentAction.class).forStudent(this.getStudentId()).oldStudent(oldStudent), helper.getUser());
                helper.commitTransaction();
            }
            catch (Exception e) {
                helper.rollbackTransaction();
                if (e instanceof SectioningException) {
                    throw (SectioningException)e;
                }
                helper.error("Failed to enroll student " + this.getStudentId() + ": " + e.getMessage(), e);
                throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
            }
            Object var38_71 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var38_72 = null;
            lock.release();
            throw throwable;
        }
        return server.execute(server.createAction(GetAssignment.class).forStudent(this.getStudentId()).withMessages(failures).withRequest(includeRequestInTheReturnMessage), helper.getUser());
    }

    public static int getLimit(Enrollment enrollment, Map<Long, XSection> sections) {
        Integer limit = null;
        for (Section s : enrollment.getSections()) {
            XSection section = sections.get(s.getId());
            if (section == null || section.getLimit() < 0) continue;
            if (limit == null) {
                limit = section.getLimit();
                continue;
            }
            limit = Math.min(limit, section.getLimit());
        }
        return limit == null ? -1 : limit;
    }

    public static void updateSpace(OnlineSectioningServer server, Enrollment newEnrollment, Enrollment oldEnrollment, XOffering offering) {
        EnrollStudent.updateSpace(server, newEnrollment, oldEnrollment, offering, offering);
    }

    public static void updateSpace(OnlineSectioningServer server, Enrollment newEnrollment, Enrollment oldEnrollment, XOffering newOffering, XOffering oldOffering) {
        Enrollment otherErollment;
        Object feasibleEnrollments;
        HashMap<Long, XSection> sections;
        if (newEnrollment == null && oldEnrollment == null) {
            return;
        }
        XExpectations expectations = server.getExpectations((newEnrollment == null ? oldEnrollment : newEnrollment).getOffering().getId());
        DefaultSingleAssignment assignment = new DefaultSingleAssignment();
        if (oldEnrollment != null) {
            sections = new HashMap<Long, XSection>();
            if (oldOffering != null) {
                for (XConfig config : oldOffering.getConfigs()) {
                    for (XSubpart subpart : config.getSubparts()) {
                        for (XSection section : subpart.getSections()) {
                            sections.put(section.getSectionId(), section);
                        }
                    }
                }
            }
            feasibleEnrollments = new ArrayList();
            int totalLimit = 0;
            for (Enrollment enrl : oldEnrollment.getRequest().values((Assignment)assignment)) {
                if (!enrl.getCourse().equals((Object)oldEnrollment.getCourse())) continue;
                boolean overlaps = false;
                for (Request otherRequest : oldEnrollment.getRequest().getStudent().getRequests()) {
                    if (otherRequest.equals((Object)oldEnrollment.getRequest()) || !(otherRequest instanceof CourseRequest) || (otherErollment = (Enrollment)otherRequest.getInitialAssignment()) == null || !enrl.isOverlapping(otherErollment)) continue;
                    overlaps = true;
                    break;
                }
                if (overlaps) continue;
                feasibleEnrollments.add(enrl);
                if (totalLimit < 0) continue;
                int limit = EnrollStudent.getLimit(enrl, sections);
                if (limit < 0) {
                    totalLimit = -1;
                    continue;
                }
                totalLimit += limit;
            }
            double increment = 1.0 / (double)(totalLimit > 0 ? totalLimit : feasibleEnrollments.size());
            Iterator<Object> overlaps = feasibleEnrollments.iterator();
            while (overlaps.hasNext()) {
                Enrollment feasibleEnrollment = (Enrollment)overlaps.next();
                for (Section section : feasibleEnrollment.getSections()) {
                    if (totalLimit > 0) {
                        expectations.incExpectedSpace(section.getId(), increment * (double)EnrollStudent.getLimit(feasibleEnrollment, sections));
                        continue;
                    }
                    expectations.incExpectedSpace(section.getId(), increment);
                }
            }
        }
        if (newEnrollment != null) {
            sections = new HashMap();
            if (newOffering != null) {
                for (XConfig config : newOffering.getConfigs()) {
                    for (XSubpart subpart : config.getSubparts()) {
                        for (XSection section : subpart.getSections()) {
                            sections.put(section.getSectionId(), section);
                        }
                    }
                }
            }
            for (Section section : newEnrollment.getSections()) {
                section.setSpaceHeld(section.getSpaceHeld() - 1.0);
            }
            feasibleEnrollments = new ArrayList();
            int totalLimit = 0;
            for (Enrollment enrl : newEnrollment.getRequest().values((Assignment)assignment)) {
                if (!enrl.getCourse().equals((Object)newEnrollment.getCourse())) continue;
                boolean overlaps = false;
                for (Request otherRequest : newEnrollment.getRequest().getStudent().getRequests()) {
                    if (otherRequest.equals((Object)newEnrollment.getRequest()) || !(otherRequest instanceof CourseRequest) || (otherErollment = (Enrollment)assignment.getValue((Variable)otherRequest)) == null || !enrl.isOverlapping(otherErollment)) continue;
                    overlaps = true;
                    break;
                }
                if (overlaps) continue;
                feasibleEnrollments.add(enrl);
                if (totalLimit < 0) continue;
                int limit = EnrollStudent.getLimit(enrl, sections);
                if (limit < 0) {
                    totalLimit = -1;
                    continue;
                }
                totalLimit += limit;
            }
            double decrement = 1.0 / (double)(totalLimit > 0 ? totalLimit : feasibleEnrollments.size());
            Iterator iterator = feasibleEnrollments.iterator();
            while (iterator.hasNext()) {
                Enrollment feasibleEnrollment = (Enrollment)iterator.next();
                for (Section section : feasibleEnrollment.getSections()) {
                    if (totalLimit > 0) {
                        expectations.incExpectedSpace(section.getId(), -decrement * (double)EnrollStudent.getLimit(feasibleEnrollment, sections));
                        continue;
                    }
                    expectations.incExpectedSpace(section.getId(), -decrement);
                }
            }
        }
        server.update(expectations);
    }

    @Override
    public String name() {
        return "enroll";
    }

    @Override
    public CacheMode getCacheMode() {
        return CacheMode.IGNORE;
    }
}

