/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.AbstractStudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XAcademicAreaCode;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.status.FindEnrollmentInfoAction;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindStudentInfoAction
implements OnlineSectioningAction<List<ClassAssignmentInterface.StudentInfo>> {
    private static final long serialVersionUID = 1L;
    private Query iQuery;
    private Integer iLimit = null;
    private Set<Long> iCoursesIcoordinate;
    private Set<Long> iCoursesIcanApprove;
    private boolean iCanShowExtIds = false;
    private SectioningStatusFilterBox.SectioningStatusFilterRpcRequest iFilter = null;
    protected static Pattern sCreditPattern = Pattern.compile("\\d+\\.?\\d*");

    public FindStudentInfoAction withParams(String query, Set<Long> coursesIcoordinage, Set<Long> coursesIcanApprove, boolean canShowExtIds) {
        this.iQuery = new Query(query);
        this.iCoursesIcanApprove = coursesIcanApprove;
        this.iCoursesIcoordinate = coursesIcoordinage;
        this.iCanShowExtIds = canShowExtIds;
        Matcher m = Pattern.compile("limit:[ ]?([0-9]*)", 2).matcher(query);
        if (m.find()) {
            this.iLimit = Integer.parseInt(m.group(1));
        }
        return this;
    }

    public FindStudentInfoAction withFilter(SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter) {
        this.iFilter = filter;
        return this;
    }

    public Query query() {
        return this.iQuery;
    }

    public Integer limit() {
        return this.iLimit;
    }

    public boolean isConsentToDoCourse(XCourse course) {
        return this.iCoursesIcanApprove != null && course.getConsentLabel() != null && this.iCoursesIcanApprove.contains(course.getCourseId());
    }

    public boolean isCourseVisible(Long courseId) {
        return this.iCoursesIcoordinate == null || this.iCoursesIcoordinate.contains(courseId);
    }

    @Override
    public List<ClassAssignmentInterface.StudentInfo> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        HashMap<Long, ClassAssignmentInterface.StudentInfo> students = new HashMap<Long, ClassAssignmentInterface.StudentInfo>();
        int gEnrl = 0;
        int gWait = 0;
        int gRes = 0;
        int gUnasg = 0;
        int gtEnrl = 0;
        int gtWait = 0;
        int gtRes = 0;
        int gtUnasg = 0;
        int gConNeed = 0;
        int gtConNeed = 0;
        HashSet<Long> unassigned = new HashSet<Long>();
        AcademicSessionInfo session = server.getAcademicSession();
        Set<Long> studentIds = this.iFilter == null ? null : server.createAction(SectioningStatusFilterAction.class).forRequest(this.iFilter).getStudentIds(server, helper);
        for (XCourseId xCourseId : server.findCourses(new FindEnrollmentInfoAction.FindEnrollmentInfoCourseMatcher(this.iCoursesIcoordinate, this.iCoursesIcanApprove, this.iQuery))) {
            XOffering xOffering = server.getOffering(xCourseId.getOfferingId());
            if (xOffering == null) continue;
            XCourse xCourse = xOffering.getCourse(xCourseId.getCourseId());
            XEnrollments enrollments = server.getEnrollments(xCourseId.getOfferingId());
            if (enrollments == null) continue;
            boolean isConsentToDoCourse = this.isConsentToDoCourse(xCourse);
            for (XCourseRequest xCourseRequest : enrollments.getRequests()) {
                XStudent student;
                if (!xCourseRequest.hasCourse(xCourseId.getCourseId()) || xCourseRequest.getEnrollment() != null && !xCourseRequest.getEnrollment().getCourseId().equals(xCourseId.getCourseId()) || studentIds != null && !studentIds.contains(xCourseRequest.getStudentId()) || (student = server.getStudent(xCourseRequest.getStudentId())) == null) continue;
                StatusPageSuggestionsAction.CourseRequestMatcher m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, xCourse, student, xOffering, xCourseRequest, isConsentToDoCourse);
                if (!this.query().match(m)) continue;
                ClassAssignmentInterface.StudentInfo s = (ClassAssignmentInterface.StudentInfo)students.get(xCourseRequest.getStudentId());
                if (s == null) {
                    s = new ClassAssignmentInterface.StudentInfo();
                    students.put(xCourseRequest.getStudentId(), s);
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    s.setStudent(st);
                    st.setId(xCourseRequest.getStudentId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(student.getExternalId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    st.setName(student.getName());
                    for (XAcademicAreaCode ac : student.getAcademicAreaClasiffications()) {
                        st.addArea(ac.getArea());
                        st.addClassification(ac.getCode());
                    }
                    for (XAcademicAreaCode ac : student.getMajors()) {
                        st.addMajor(ac.getCode());
                    }
                    for (String acc : student.getAccomodations()) {
                        st.addAccommodation(acc);
                    }
                    for (String gr : student.getGroups()) {
                        st.addGroup(gr);
                    }
                    int tEnrl = 0;
                    int tWait = 0;
                    int tRes = 0;
                    int tConNeed = 0;
                    int tReq = 0;
                    int tUnasg = 0;
                    float tCred = 0.0f;
                    for (XRequest r : student.getRequests()) {
                        XOffering o;
                        XConfig g;
                        XCourse i;
                        if (!(r instanceof XCourseRequest)) continue;
                        XCourseRequest cr = (XCourseRequest)r;
                        if (!r.isAlternative()) {
                            ++tReq;
                        }
                        if (cr.getEnrollment() == null) {
                            if (!student.canAssign(cr)) continue;
                            ++tUnasg;
                            ++gtUnasg;
                            if (!cr.isWaitlist()) continue;
                            ++tWait;
                            ++gtWait;
                            continue;
                        }
                        ++tEnrl;
                        ++gtEnrl;
                        if (cr.getEnrollment().getReservation() != null) {
                            ++tRes;
                            ++gtRes;
                        }
                        if (cr.getEnrollment().getApproval() == null && (i = server.getCourse(cr.getEnrollment().getCourseId())) != null && i.getConsentLabel() != null) {
                            ++tConNeed;
                            ++gtConNeed;
                        }
                        if ((g = (o = server.getOffering(cr.getEnrollment().getOfferingId())) == null ? null : o.getConfig(cr.getEnrollment().getConfigId())) == null) continue;
                        for (XSubpart xs : g.getSubparts()) {
                            tCred += this.guessCredit(xs.getCreditAbbv(cr.getEnrollment().getCourseId()));
                        }
                    }
                    s.setTotalEnrollment(tEnrl);
                    s.setTotalReservation(tRes);
                    s.setTotalWaitlist(tWait);
                    s.setTotalUnassigned(tUnasg);
                    s.setTotalConsentNeeded(tConNeed);
                    s.setEnrollment(0);
                    s.setReservation(0);
                    s.setWaitlist(0);
                    s.setUnassigned(0);
                    s.setConsentNeeded(0);
                    s.setRequested(tReq);
                    s.setStatus(student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus());
                    s.setEmailDate(student.getEmailTimeStamp() == null ? null : student.getEmailTimeStamp());
                    s.setCredit(Float.valueOf(0.0f));
                    s.setTotalCredit(Float.valueOf(tCred));
                }
                if (m.enrollment() != null) {
                    XOffering o;
                    XConfig g;
                    s.setEnrollment(s.getEnrollment() + 1);
                    ++gEnrl;
                    if (m.enrollment().getReservation() != null) {
                        s.setReservation(s.getReservation() + 1);
                        ++gRes;
                    }
                    if (xCourse.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                        s.setConsentNeeded(s.getConsentNeeded() + 1);
                        ++gConNeed;
                    }
                    if (m.enrollment().getTimeStamp() != null) {
                        if (s.getEnrolledDate() == null) {
                            s.setEnrolledDate(m.enrollment().getTimeStamp());
                        } else if (m.enrollment().getTimeStamp().after(s.getEnrolledDate())) {
                            s.setEnrolledDate(m.enrollment().getTimeStamp());
                        }
                    }
                    if (m.enrollment().getApproval() != null) {
                        if (s.getApprovedDate() == null) {
                            s.setApprovedDate(m.enrollment().getApproval().getTimeStamp());
                        } else if (m.enrollment().getApproval().getTimeStamp().after(s.getApprovedDate())) {
                            s.setApprovedDate(m.enrollment().getApproval().getTimeStamp());
                        }
                    }
                    XConfig xConfig = g = (o = server.getOffering(m.enrollment().getOfferingId())) == null ? null : o.getConfig(m.enrollment().getConfigId());
                    if (g != null) {
                        for (XSubpart xs : g.getSubparts()) {
                            s.setCredit(Float.valueOf(s.getCredit().floatValue() + this.guessCredit(xs.getCreditAbbv(m.enrollment().getCourseId()))));
                        }
                    }
                } else if (m.student().canAssign(m.request()) && unassigned.add(m.request().getRequestId())) {
                    if (m.request().isWaitlist()) {
                        s.setWaitlist(s.getWaitlist() + 1);
                        ++gWait;
                        if (s.getTopWaitingPriority() == null) {
                            s.setTopWaitingPriority(1 + m.request().getPriority());
                        } else {
                            s.setTopWaitingPriority(Math.min(1 + m.request().getPriority(), s.getTopWaitingPriority()));
                        }
                    }
                    s.setUnassigned(s.getUnassigned() + 1);
                    ++gUnasg;
                }
                if (m.request().getTimeStamp() == null) continue;
                if (s.getRequestedDate() == null) {
                    s.setRequestedDate(m.request().getTimeStamp());
                    continue;
                }
                if (!m.request().getTimeStamp().after(s.getRequestedDate())) continue;
                s.setRequestedDate(m.request().getTimeStamp());
            }
        }
        ArrayList<Object> ret = new ArrayList(students.values());
        if (studentIds != null && studentIds.size() < 1000) {
            FindStudentInfoMatcher findStudentInfoMatcher = new FindStudentInfoMatcher(session, this.query());
            for (Long l : studentIds) {
                XStudent student;
                if (students.containsKey(l) || (student = server.getStudent(l)) == null || !findStudentInfoMatcher.match(student)) continue;
                ClassAssignmentInterface.StudentInfo s = new ClassAssignmentInterface.StudentInfo();
                ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                s.setStudent(st);
                st.setId(student.getStudentId());
                st.setSessionId(session.getUniqueId());
                st.setExternalId(student.getExternalId());
                st.setCanShowExternalId(this.iCanShowExtIds);
                st.setName(student.getName());
                for (XAcademicAreaCode ac : student.getAcademicAreaClasiffications()) {
                    st.addArea(ac.getArea());
                    st.addClassification(ac.getCode());
                }
                for (XAcademicAreaCode ac : student.getMajors()) {
                    st.addMajor(ac.getCode());
                }
                for (String acc : student.getAccomodations()) {
                    st.addAccommodation(acc);
                }
                for (String gr : student.getGroups()) {
                    st.addGroup(gr);
                }
                s.setStatus(student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus());
                s.setEmailDate(student.getEmailTimeStamp() == null ? null : student.getEmailTimeStamp());
                ret.add(s);
            }
        } else {
            for (XStudentId xStudentId : server.findStudents(new FindStudentInfoMatcher(session, this.query()))) {
                XStudent xStudent = xStudentId instanceof XStudent ? (XStudent)xStudentId : server.getStudent(xStudentId.getStudentId());
                ClassAssignmentInterface.StudentInfo s = new ClassAssignmentInterface.StudentInfo();
                ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                s.setStudent(st);
                st.setId(xStudent.getStudentId());
                st.setSessionId(session.getUniqueId());
                st.setExternalId(xStudent.getExternalId());
                st.setCanShowExternalId(this.iCanShowExtIds);
                st.setName(xStudent.getName());
                for (XAcademicAreaCode xAcademicAreaCode : xStudent.getAcademicAreaClasiffications()) {
                    st.addArea(xAcademicAreaCode.getArea());
                    st.addClassification(xAcademicAreaCode.getCode());
                }
                for (XAcademicAreaCode xAcademicAreaCode : xStudent.getMajors()) {
                    st.addMajor(xAcademicAreaCode.getCode());
                }
                for (String string : xStudent.getAccomodations()) {
                    st.addAccommodation(string);
                }
                for (String string : xStudent.getGroups()) {
                    st.addGroup(string);
                }
                s.setStatus(xStudent.getStatus() == null ? session.getDefaultSectioningStatus() : xStudent.getStatus());
                s.setEmailDate(xStudent.getEmailTimeStamp() == null ? null : xStudent.getEmailTimeStamp());
                ret.add(s);
            }
        }
        Collections.sort(ret, new Comparator<ClassAssignmentInterface.StudentInfo>(){

            @Override
            public int compare(ClassAssignmentInterface.StudentInfo s1, ClassAssignmentInterface.StudentInfo s2) {
                int cmp = s1.getStudent().getName().compareTo(s2.getStudent().getName());
                if (cmp != 0) {
                    return cmp;
                }
                return new Long(s1.getStudent().getId()).compareTo(s2.getStudent().getId());
            }
        });
        if (this.limit() != null && ret.size() >= this.limit()) {
            ArrayList<ClassAssignmentInterface.StudentInfo> arrayList = new ArrayList<ClassAssignmentInterface.StudentInfo>(this.limit());
            for (ClassAssignmentInterface.StudentInfo studentInfo : ret) {
                arrayList.add(studentInfo);
                if (arrayList.size() != this.limit().intValue()) continue;
                break;
            }
            ret = arrayList;
        }
        ClassAssignmentInterface.StudentInfo studentInfo = new ClassAssignmentInterface.StudentInfo();
        studentInfo.setEnrollment(gEnrl);
        studentInfo.setReservation(gRes);
        studentInfo.setWaitlist(gWait);
        studentInfo.setUnassigned(gUnasg);
        studentInfo.setTotalEnrollment(gtEnrl);
        studentInfo.setTotalReservation(gtRes);
        studentInfo.setTotalWaitlist(gtWait);
        studentInfo.setTotalUnassigned(gtUnasg);
        studentInfo.setConsentNeeded(gConNeed);
        studentInfo.setTotalConsentNeeded(gtConNeed);
        ret.add(studentInfo);
        return ret;
    }

    protected float guessCredit(String creditAbbv) {
        if (creditAbbv == null) {
            return 0.0f;
        }
        Matcher m = Pattern.compile("[0-9]+\\.?[0-9]*").matcher(creditAbbv);
        if (m.find()) {
            return Float.parseFloat(m.group(0));
        }
        return 0.0f;
    }

    @Override
    public String name() {
        return "find-student-infos";
    }

    public static class FindStudentInfoMatcher
    extends AbstractStudentMatcher {
        private static final long serialVersionUID = 1L;
        private Query iQuery;
        private String iDefaultSectioningStatus;

        public FindStudentInfoMatcher(AcademicSessionInfo session, Query query) {
            this.iQuery = query;
            this.iDefaultSectioningStatus = session.getDefaultSectioningStatus();
        }

        public boolean match(XStudentId id) {
            XStudent student = id instanceof XStudent ? (XStudent)id : this.getServer().getStudent(id.getStudentId());
            return student != null && student.getRequests().isEmpty() && this.iQuery.match(new StatusPageSuggestionsAction.StudentMatcher(student, this.iDefaultSectioningStatus));
        }
    }
}

