/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.AbstractCourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindEnrollmentInfoAction
implements OnlineSectioningAction<List<ClassAssignmentInterface.EnrollmentInfo>> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Query iQuery;
    private Integer iLimit = null;
    private Long iCourseId;
    private Set<Long> iCoursesIcoordinate;
    private Set<Long> iCoursesIcanApprove;
    private SectioningStatusFilterBox.SectioningStatusFilterRpcRequest iFilter = null;

    public FindEnrollmentInfoAction withParams(String query, Long courseId, Set<Long> coursesIcoordinage, Set<Long> coursesIcanApprove) {
        this.iQuery = new Query(query);
        this.iCourseId = courseId;
        this.iCoursesIcanApprove = coursesIcanApprove;
        this.iCoursesIcoordinate = coursesIcoordinage;
        Matcher m = Pattern.compile("limit:[ ]?([0-9]*)", 2).matcher(query);
        if (m.find()) {
            this.iLimit = Integer.parseInt(m.group(1));
        }
        return this;
    }

    public FindEnrollmentInfoAction withFilter(SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter) {
        this.iFilter = filter;
        return this;
    }

    public Query query() {
        return this.iQuery;
    }

    public Integer limit() {
        return this.iLimit;
    }

    public Long courseId() {
        return this.iCourseId;
    }

    public boolean isCourseVisible(Long courseId) {
        return this.iCoursesIcoordinate == null || this.iCoursesIcoordinate.contains(courseId);
    }

    public boolean isConsentToDoCourse(XCourse course) {
        return this.iCoursesIcanApprove != null && course.getConsentLabel() != null && this.iCoursesIcanApprove.contains(course.getCourseId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ClassAssignmentInterface.EnrollmentInfo> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Set<Long> studentIds;
        ArrayList<ClassAssignmentInterface.EnrollmentInfo> ret = new ArrayList<ClassAssignmentInterface.EnrollmentInfo>();
        AcademicSessionInfo session = server.getAcademicSession();
        Set<Long> set = studentIds = this.iFilter == null ? null : server.createAction(SectioningStatusFilterAction.class).forRequest(this.iFilter).getStudentIds(server, helper);
        if (this.courseId() == null) {
            HashSet<Long> students = new HashSet<Long>();
            HashSet<Long> matchingStudents = new HashSet<Long>();
            int gEnrl = 0;
            int gWait = 0;
            int gRes = 0;
            int gUnasg = 0;
            int gtEnrl = 0;
            int gtWait = 0;
            int gtRes = 0;
            int gtUnasg = 0;
            int gConNeed = 0;
            int gtConNeed = 0;
            for (XCourseId xCourseId : server.findCourses(new FindEnrollmentInfoCourseMatcher(this.iCoursesIcoordinate, this.iCoursesIcanApprove, this.iQuery))) {
                int n;
                int n2;
                XCourse course;
                XOffering offering = server.getOffering(xCourseId.getOfferingId());
                if (offering == null || (course = offering.getCourse(xCourseId.getCourseId())) == null) continue;
                XEnrollments enrollments = server.getEnrollments(xCourseId.getOfferingId());
                boolean isConsentToDoCourse = this.isConsentToDoCourse(course);
                ClassAssignmentInterface.EnrollmentInfo e = new ClassAssignmentInterface.EnrollmentInfo();
                e.setCourseId(xCourseId.getCourseId());
                e.setOfferingId(offering.getOfferingId());
                e.setSubject(course.getSubjectArea());
                e.setCourseNbr(course.getCourseNumber());
                e.setTitle(course.getTitle());
                e.setConsent(course.getConsentAbbv());
                int match = 0;
                int enrl = 0;
                int wait = 0;
                int res = 0;
                int unasg = 0;
                int tEnrl = 0;
                int tWait = 0;
                int tRes = 0;
                int n3 = 0;
                int conNeed = 0;
                int tConNeed = 0;
                HashSet<Long> addedStudents = new HashSet<Long>();
                for (XCourseRequest xCourseRequest : enrollments.getRequests()) {
                    XStudent student;
                    if (!xCourseRequest.hasCourse(xCourseId.getCourseId())) continue;
                    if (students.add(xCourseRequest.getStudentId())) {
                        addedStudents.add(xCourseRequest.getStudentId());
                    }
                    if (xCourseRequest.getEnrollment() != null && !xCourseRequest.getEnrollment().getCourseId().equals(xCourseId.getCourseId())) continue;
                    if (studentIds != null && !studentIds.contains(xCourseRequest.getStudentId())) {
                        if (xCourseRequest.getEnrollment() != null) {
                            ++tEnrl;
                            if (xCourseRequest.getEnrollment().getReservation() != null) {
                                ++tRes;
                            }
                            if (course.getConsentLabel() == null || xCourseRequest.getEnrollment().getApproval() != null) continue;
                            ++tConNeed;
                            continue;
                        }
                        student = server.getStudent(xCourseRequest.getStudentId());
                        if (student == null || !student.canAssign(xCourseRequest)) continue;
                        ++n3;
                        if (!xCourseRequest.isWaitlist()) continue;
                        ++tWait;
                        continue;
                    }
                    student = server.getStudent(xCourseRequest.getStudentId());
                    if (student == null) continue;
                    StatusPageSuggestionsAction.CourseRequestMatcher m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, course, student, offering, xCourseRequest, isConsentToDoCourse);
                    if (this.query().match(m)) {
                        matchingStudents.add(xCourseRequest.getStudentId());
                        ++match;
                        if (m.enrollment() != null) {
                            ++enrl;
                            if (m.enrollment().getReservation() != null) {
                                ++res;
                            }
                            if (course.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                                ++conNeed;
                            }
                        } else if (m.student().canAssign(m.request())) {
                            ++unasg;
                            if (m.request().isWaitlist()) {
                                ++wait;
                            }
                        }
                    }
                    if (m.enrollment() != null) {
                        ++tEnrl;
                        if (m.enrollment().getReservation() != null) {
                            ++tRes;
                        }
                        if (course.getConsentLabel() == null || m.enrollment().getApproval() != null) continue;
                        ++tConNeed;
                        continue;
                    }
                    if (!m.student().canAssign(m.request())) continue;
                    ++n3;
                    if (!m.request().isWaitlist()) continue;
                    ++tWait;
                }
                if (match == 0) {
                    students.removeAll(addedStudents);
                    continue;
                }
                gEnrl += enrl;
                gWait += wait;
                gUnasg += unasg;
                gRes += res;
                gConNeed += conNeed;
                gtEnrl += tEnrl;
                gtWait += tWait;
                gtUnasg += n3;
                gtRes += tRes;
                gtConNeed += tConNeed;
                int limit = 0;
                for (XConfig config : offering.getConfigs()) {
                    if (config.getLimit() < 0) {
                        limit = -1;
                        break;
                    }
                    limit += config.getLimit();
                }
                e.setLimit(course.getLimit());
                e.setProjection(course.getProjected());
                int n4 = Math.max(0, offering.getUnreservedSpace(enrollments));
                if (course.getLimit() >= 0 && n4 > course.getLimit() - enrollments.countEnrollmentsForCourse(xCourseId.getCourseId())) {
                    n2 = course.getLimit() - enrollments.countEnrollmentsForCourse(xCourseId.getCourseId());
                }
                if (n2 == Integer.MAX_VALUE) {
                    n = -1;
                }
                e.setAvailable(n);
                if (n >= 0) {
                    int other = 0;
                    for (XCourse xCourse : offering.getCourses()) {
                        if (xCourse.equals(course)) continue;
                        other += enrollments.countEnrollmentsForCourse(xCourse.getCourseId());
                    }
                    e.setOther(Math.min(course.getLimit() - enrollments.countEnrollmentsForCourse(xCourseId.getCourseId()) - n, other));
                    int lim = 0;
                    for (XConfig f : offering.getConfigs()) {
                        if (lim < 0 || f.getLimit() < 0) {
                            lim = -1;
                            continue;
                        }
                        lim += f.getLimit();
                    }
                    if (lim >= 0 && lim < course.getLimit()) {
                        e.setOther(e.getOther() + course.getLimit() - limit);
                    }
                }
                e.setEnrollment(enrl);
                e.setReservation(res);
                e.setWaitlist(wait);
                e.setUnassigned(unasg);
                e.setTotalEnrollment(tEnrl);
                e.setTotalReservation(tRes);
                e.setTotalWaitlist(tWait);
                e.setTotalUnassigned(n3);
                e.setConsentNeeded(conNeed);
                e.setTotalConsentNeeded(tConNeed);
                ret.add(e);
                if (this.limit() == null || ret.size() < this.limit()) continue;
                break;
            }
            final NaturalOrderComparator noc = new NaturalOrderComparator();
            Collections.sort(ret, new Comparator<ClassAssignmentInterface.EnrollmentInfo>(){

                @Override
                public int compare(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
                    int cmp = noc.compare(e1.getSubject(), e2.getSubject());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = e1.getCourseNbr().compareTo(e2.getCourseNbr());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return 0;
                }
            });
            ClassAssignmentInterface.EnrollmentInfo enrollmentInfo = new ClassAssignmentInterface.EnrollmentInfo();
            enrollmentInfo.setSubject(MSG.total());
            enrollmentInfo.setCourseNbr("");
            enrollmentInfo.setLimit(students.size());
            enrollmentInfo.setAvailable(matchingStudents.size());
            enrollmentInfo.setEnrollment(gEnrl);
            enrollmentInfo.setReservation(gRes);
            enrollmentInfo.setWaitlist(gWait);
            enrollmentInfo.setUnassigned(gUnasg);
            enrollmentInfo.setTotalEnrollment(gtEnrl);
            enrollmentInfo.setTotalReservation(gtRes);
            enrollmentInfo.setTotalWaitlist(gtWait);
            enrollmentInfo.setTotalUnassigned(gtUnasg);
            enrollmentInfo.setConsentNeeded(gConNeed);
            enrollmentInfo.setTotalConsentNeeded(gtConNeed);
            ret.add(enrollmentInfo);
        } else {
            XCourse info = server.getCourse(this.courseId());
            if (info == null) {
                return ret;
            }
            final XOffering offering = server.getOffering(info.getOfferingId());
            if (offering == null) {
                return ret;
            }
            XCourse course = offering.getCourse(info.getCourseId());
            if (course == null) {
                return ret;
            }
            XEnrollments enrollments = server.getEnrollments(info.getOfferingId());
            OverExpectedCriterion overExp = server.getOverExpectedCriterion();
            XExpectations expectations = server.getExpectations(info.getOfferingId());
            boolean isConsentToDoCourse = this.isConsentToDoCourse(info);
            ArrayList<XSection> sections = new ArrayList<XSection>();
            for (XConfig config : offering.getConfigs()) {
                for (XSubpart subpart : config.getSubparts()) {
                    sections.addAll(subpart.getSections());
                }
            }
            Collections.sort(sections, new Comparator<XSection>(){

                @Override
                public int compare(XConfig c1, XConfig c2) {
                    int cmp = c1.getName().compareToIgnoreCase(c2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return c1.getConfigId().compareTo(c2.getConfigId());
                }

                public boolean isParent(XSubpart s1, XSubpart s2) {
                    XSubpart p1;
                    XSubpart xSubpart = p1 = s1.getParentId() == null ? null : offering.getSubpart(s1.getParentId());
                    if (p1 == null) {
                        return false;
                    }
                    if (p1.equals(s2)) {
                        return true;
                    }
                    return this.isParent(p1, s2);
                }

                @Override
                public int compare(XSubpart s1, XSubpart s2) {
                    int cmp = this.compare(offering.getConfig(s1.getConfigId()), offering.getConfig(s2.getConfigId()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    if (this.isParent(s1, s2)) {
                        return 1;
                    }
                    if (this.isParent(s2, s1)) {
                        return -1;
                    }
                    cmp = s1.getInstructionalType().compareTo(s2.getInstructionalType());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getSubpartId().compareTo(s2.getSubpartId());
                }

                @Override
                public int compare(XSection s1, XSection s2) {
                    if (s1.getSubpartId().equals(s2.getSubpartId())) {
                        int cmp;
                        if (s1.getParentId() != null && (cmp = this.compare(offering.getSection(s1.getParentId()), offering.getSection(s2.getParentId()))) != 0) {
                            return cmp;
                        }
                        try {
                            cmp = Integer.valueOf(s1.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "0" : s1.getName(FindEnrollmentInfoAction.this.courseId())).compareTo(Integer.valueOf(s2.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "0" : s2.getName(FindEnrollmentInfoAction.this.courseId())));
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        cmp = (s1.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "" : s1.getName(FindEnrollmentInfoAction.this.courseId())).compareTo(s2.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "" : s2.getName(FindEnrollmentInfoAction.this.courseId()));
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getSectionId().compareTo(s2.getSectionId());
                    }
                    XSection x = s1;
                    while (x != null) {
                        if (this.isParent(offering.getSubpart(s2.getSubpartId()), offering.getSubpart(x.getSubpartId()))) {
                            XSection s = offering.getSection(s2.getParentId());
                            while (!s.getSubpartId().equals(x.getSubpartId())) {
                                s = offering.getSection(s.getParentId());
                            }
                            int cmp = this.compare(x, s);
                            return cmp == 0 ? (x.equals(s1) ? -1 : this.compare(offering.getSubpart(x.getSubpartId()), offering.getSubpart(s.getSubpartId()))) : cmp;
                        }
                        x = offering.getSection(x.getParentId());
                    }
                    x = s2;
                    while (x != null) {
                        if (this.isParent(offering.getSubpart(s1.getSubpartId()), offering.getSubpart(x.getSubpartId()))) {
                            XSection s = offering.getSection(s1.getParentId());
                            while (!s.getSubpartId().equals(x.getSubpartId())) {
                                s = offering.getSection(s.getParentId());
                            }
                            int cmp = this.compare(s, x);
                            return cmp == 0 ? (x.equals(s2) ? 1 : this.compare(offering.getSubpart(s.getSubpartId()), offering.getSubpart(x.getSubpartId()))) : cmp;
                        }
                        x = offering.getSection(x.getParentId());
                    }
                    int cmp = this.compare(offering.getSubpart(s1.getSubpartId()), offering.getSubpart(s2.getSubpartId()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    try {
                        cmp = Integer.valueOf(s1.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "0" : s1.getName(FindEnrollmentInfoAction.this.courseId())).compareTo(Integer.valueOf(s2.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "0" : s2.getName(FindEnrollmentInfoAction.this.courseId())));
                        if (cmp != 0) {
                            return cmp;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    cmp = (s1.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "" : s1.getName(FindEnrollmentInfoAction.this.courseId())).compareTo(s2.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "" : s2.getName(FindEnrollmentInfoAction.this.courseId()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getSectionId().compareTo(s2.getSectionId());
                }
            });
            for (XSection section : sections) {
                String string;
                void var19_34;
                XSection xSection;
                XSubpart subpart;
                ClassAssignmentInterface.EnrollmentInfo e = new ClassAssignmentInterface.EnrollmentInfo();
                e.setCourseId(info.getCourseId());
                e.setOfferingId(offering.getOfferingId());
                e.setSubject(info.getSubjectArea());
                e.setCourseNbr(info.getCourseNumber());
                e.setTitle(info.getTitle());
                e.setConsent(info.getConsentAbbv());
                subpart = offering.getSubpart(section.getSubpartId());
                XConfig config = offering.getConfig(subpart.getConfigId());
                e.setConfig(config.getName());
                e.setConfigId(config.getConfigId());
                e.setSubpart(subpart.getName());
                e.setSubpartId(subpart.getSubpartId());
                e.setClazz(section.getName(this.courseId()));
                e.setClazzId(section.getSectionId());
                XSection xSection2 = xSection = section.getParentId() == null ? null : offering.getSection(section.getParentId());
                while (var19_34 != null) {
                    e.incLevel();
                    XSection xSection3 = var19_34.getParentId() == null ? null : offering.getSection(var19_34.getParentId());
                }
                int match = 0;
                int enrl = 0;
                int wait = 0;
                int res = 0;
                int unasg = 0;
                int tEnrl = 0;
                int tWait = 0;
                int tRes = 0;
                int tUnasg = 0;
                int conNeed = 0;
                int tConNeed = 0;
                int other = 0;
                for (XCourseRequest xCourseRequest : enrollments.getRequests()) {
                    XEnrollment enrollment = xCourseRequest.getEnrollment();
                    if (enrollment == null || !enrollment.getSectionIds().contains(section.getSectionId())) continue;
                    if (!xCourseRequest.getEnrollment().getCourseId().equals(this.courseId())) {
                        ++other;
                        continue;
                    }
                    XStudent student = server.getStudent(xCourseRequest.getStudentId());
                    if (student == null) continue;
                    StatusPageSuggestionsAction.CourseRequestMatcher m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, info, student, offering, xCourseRequest, isConsentToDoCourse);
                    if (this.query().match(m)) {
                        ++match;
                        ++enrl;
                        if (m.enrollment().getReservation() != null) {
                            ++res;
                        }
                        if (info.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                            ++conNeed;
                        }
                    }
                    ++tEnrl;
                    if (m.enrollment().getReservation() != null) {
                        ++tRes;
                    }
                    if (info.getConsentLabel() == null || m.enrollment().getApproval() != null) continue;
                    ++tConNeed;
                }
                for (XCourseRequest xCourseRequest : enrollments.getRequests()) {
                    XStudent student;
                    if (xCourseRequest.getEnrollment() != null || !xCourseRequest.hasCourse(this.courseId()) || (student = server.getStudent(xCourseRequest.getStudentId())) == null || !student.canAssign(xCourseRequest)) continue;
                    StatusPageSuggestionsAction.CourseRequestMatcher m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, info, student, offering, xCourseRequest, isConsentToDoCourse);
                    boolean hasEnrollment = false;
                    AssignmentMap assignment = new AssignmentMap();
                    CourseRequest courseRequest = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, xCourseRequest, server);
                    Section s = courseRequest.getSection(section.getSectionId().longValue());
                    block11: for (Enrollment enrollment : courseRequest.values((Assignment)assignment)) {
                        if (!enrollment.getSections().contains(s)) continue;
                        for (Request x : courseRequest.getStudent().getRequests()) {
                            Enrollment xe = (Enrollment)assignment.getValue((Variable)x);
                            if (x.equals((Object)courseRequest) || xe == null || !xe.isOverlapping(enrollment)) continue;
                            continue block11;
                        }
                        hasEnrollment = true;
                        break;
                    }
                    if (!hasEnrollment) continue;
                    if (this.query().match(m)) {
                        ++match;
                        ++unasg;
                        if (xCourseRequest.isWaitlist()) {
                            ++wait;
                        }
                    }
                    ++tUnasg;
                    if (!xCourseRequest.isWaitlist()) continue;
                    ++tWait;
                }
                if (match == 0) continue;
                e.setLimit(section.getLimit() < 0 ? section.getLimit() : section.getLimit());
                e.setOther(other);
                e.setAvailable(Math.max(0, offering.getUnreservedSectionSpace(section.getSectionId(), enrollments)));
                if (e.getAvailable() == Integer.MAX_VALUE) {
                    e.setAvailable(-1);
                }
                e.setProjection(tEnrl + (int)Math.round(expectations.getExpectedSpace(section.getSectionId())));
                e.setEnrollment(enrl);
                e.setReservation(res);
                e.setWaitlist(wait);
                e.setUnassigned(unasg);
                e.setTotalEnrollment(tEnrl);
                e.setTotalReservation(tRes);
                e.setTotalWaitlist(tWait);
                e.setTotalUnassigned(tUnasg);
                e.setConsentNeeded(conNeed);
                e.setTotalConsentNeeded(tConNeed);
                ClassAssignmentInterface.ClassAssignment a = new ClassAssignmentInterface.ClassAssignment();
                a.setClassId(section.getSectionId());
                a.setSubpart(section.getSubpartName());
                a.setClassNumber(section.getName(-1L));
                a.setSection(section.getName(this.courseId()));
                a.setLimit(new int[]{enrollments.countEnrollmentsForSection(section.getSectionId()), section.getLimit()});
                if (section.getTime() != null) {
                    for (DayCode d : DayCode.toDayCodes(section.getTime().getDays())) {
                        a.addDay(d.getIndex());
                    }
                    a.setStart(section.getTime().getSlot());
                    a.setLength(section.getTime().getLength());
                    a.setBreakTime(section.getTime().getBreakTime());
                    a.setDatePattern(section.getTime().getDatePatternName());
                }
                if (section.getNrRooms() > 0) {
                    for (XRoom rm : section.getRooms()) {
                        a.addRoom(rm.getName());
                    }
                }
                if (section.getInstructors() != null) {
                    for (XInstructor instructor : section.getInstructors()) {
                        a.addInstructor(instructor.getName());
                        a.addInstructoEmail(instructor.getEmail());
                    }
                }
                if (section.getParentId() != null) {
                    a.setParentSection(offering.getSection(section.getParentId()).getName(course.getCourseId()));
                }
                a.setSubpartId(section.getSubpartId());
                a.addNote(course.getNote());
                a.addNote(section.getNote());
                a.setCredit(subpart.getCredit(course.getCourseId()));
                if (a.getParentSection() == null && (string = server.getCourse(this.courseId()).getConsentLabel()) != null) {
                    a.setParentSection(string);
                }
                a.setExpected(overExp.getExpected(section.getLimit(), expectations.getExpectedSpace(section.getSectionId()).doubleValue()));
                e.setAssignment(a);
                ret.add(e);
            }
        }
        return ret;
    }

    @Override
    public String name() {
        return "find-enrollment-info";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FindEnrollmentInfoCourseMatcher
    extends AbstractCourseMatcher {
        private static final long serialVersionUID = 1L;
        private Set<Long> iCoursesIcoordinate;
        private Set<Long> iCoursesIcanApprove;
        private Query iQuery;

        public FindEnrollmentInfoCourseMatcher(Set<Long> coursesIcoordinate, Set<Long> coursesIcanApprove, Query query) {
            this.iCoursesIcoordinate = coursesIcoordinate;
            this.iCoursesIcanApprove = coursesIcanApprove;
            this.iQuery = query;
        }

        public boolean isCourseVisible(Long courseId) {
            return this.iCoursesIcoordinate == null || this.iCoursesIcoordinate.contains(courseId);
        }

        public boolean isConsentToDoCourse(XCourse course) {
            return this.iCoursesIcanApprove != null && course.getConsentLabel() != null && this.iCoursesIcanApprove.contains(course.getCourseId());
        }

        @Override
        public boolean match(XCourseId id) {
            XCourse course = id instanceof XCourse ? (XCourse)id : this.getServer().getCourse(id.getCourseId());
            return course != null && this.isCourseVisible(course.getCourseId()) && this.iQuery.match(new StatusPageSuggestionsAction.CourseInfoMatcher(course, this.isConsentToDoCourse(course)));
        }
    }
}

