/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServerContext;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.match.StudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.AbstractLockingServer;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseServer
extends AbstractLockingServer {
    public DatabaseServer(OnlineSectioningServerContext context) throws SectioningException {
        super(context);
    }

    public Collection<XCourseId> findCourses(String query, Integer limit, CourseMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        ArrayList<XCourseId> ret = new ArrayList<XCourseId>();
        for (CourseOffering c : this.getCurrentHelper().getHibSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and c.instructionalOffering.notOffered = false and (lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like :q || '%' " + (query.length() > 2 ? "or lower(c.title) like '%' || :q || '%'" : "") + ") " + "order by case " + "when lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like :q || '%' then 0 else 1 end," + "c.subjectArea.subjectAreaAbbreviation, c.courseNbr").setString("q", query.toLowerCase()).setLong("sessionId", this.getAcademicSession().getUniqueId().longValue()).setCacheable(true).list()) {
            XCourse course = new XCourse(c);
            if (matcher == null || matcher.match(course)) {
                ret.add(course);
            }
            if (limit == null || ret.size() < limit) continue;
            break;
        }
        return ret;
    }

    public Collection<XCourseId> findCourses(CourseMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        ArrayList<XCourseId> ret = new ArrayList<XCourseId>();
        for (CourseOffering c : this.getCurrentHelper().getHibSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and c.instructionalOffering.notOffered = false order by c.subjectArea.subjectAreaAbbreviation, c.courseNbr").setLong("sessionId", this.getAcademicSession().getUniqueId().longValue()).setCacheable(true).list()) {
            XCourse course = new XCourse(c);
            if (matcher != null && !matcher.match(course)) continue;
            ret.add(course);
        }
        return ret;
    }

    public Collection<XStudent> findStudents(StudentMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        ArrayList<XStudent> ret = new ArrayList<XStudent>();
        for (Student s : this.getCurrentHelper().getHibSession().createQuery("select distinct s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch cr.classWaitLists as cwl left join fetch s.classEnrollments as e left join fetch s.academicAreaClassifications as a left join fetch s.posMajors as mj left join fetch s.waitlists as w left join fetch s.groups as g where s.session.uniqueId = :sessionId").setLong("sessionId", this.getAcademicSession().getUniqueId().longValue()).setCacheable(true).list()) {
            XStudent student = new XStudent(s, this.getCurrentHelper(), this.getAcademicSession().getFreeTimePattern());
            if (matcher != null && !matcher.match(student)) continue;
            ret.add(student);
        }
        return ret;
    }

    @Override
    public XCourse getCourse(Long courseId) {
        CourseOffering c = (CourseOffering)CourseOfferingDAO.getInstance().get(courseId, this.getCurrentHelper().getHibSession());
        return c == null || c.getInstructionalOffering().isNotOffered() != false ? null : new XCourse(c);
    }

    @Override
    public XCourseId getCourse(String course) {
        CourseOffering c = (CourseOffering)this.getCurrentHelper().getHibSession().createQuery("from CourseOffering where subjectAreaAbbv || ' ' || courseNbr = :name and subjectArea.session.uniqueId = :sessionId and instructionalOffering.notOffered = false").setLong("sessionId", this.getAcademicSession().getUniqueId().longValue()).setString("name", course).setCacheable(true).setMaxResults(1).uniqueResult();
        return c == null ? null : new XCourseId(c);
    }

    @Override
    public XStudent getStudent(Long studentId) {
        Student s = (Student)StudentDAO.getInstance().get(studentId, this.getCurrentHelper().getHibSession());
        return s == null ? null : new XStudent(s, this.getCurrentHelper(), this.getAcademicSession().getFreeTimePattern());
    }

    @Override
    public XOffering getOffering(Long offeringId) {
        InstructionalOffering o;
        ArrayList<XDistribution> distributions = new ArrayList<XDistribution>();
        List distPrefs = this.getCurrentHelper().getHibSession().createQuery("select distinct p from DistributionPref p inner join p.distributionObjects o, Department d, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering io where p.distributionType.reference in (:ref1, :ref2) and d.session.uniqueId = :sessionId and io.uniqueId = :offeringId and (o.prefGroup = c or o.prefGroup = c.schedulingSubpart) and p.owner = d and p.prefLevel.prefProlog = :pref").setString("ref1", GroupConstraint.ConstraintType.LINKED_SECTIONS.reference()).setString("ref2", "NO_CONFLICT").setString("pref", PreferenceLevel.sRequired).setLong("sessionId", this.getAcademicSession().getUniqueId().longValue()).setLong("offeringId", offeringId.longValue()).setCacheable(true).list();
        if (!distPrefs.isEmpty()) {
            for (DistributionPref pref : distPrefs) {
                int variant = 0;
                for (Collection<Class_> sections : ReloadAllData.getSections(pref)) {
                    XDistributionType type = XDistributionType.IngoreConflicts;
                    if (GroupConstraint.ConstraintType.LINKED_SECTIONS.reference().equals(pref.getDistributionType().getReference())) {
                        type = XDistributionType.LinkedSections;
                    }
                    distributions.add(new XDistribution(type, pref.getUniqueId(), variant++, sections));
                }
            }
        }
        return (o = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(offeringId, this.getCurrentHelper().getHibSession())) == null ? null : new XOffering(o, distributions, this.getCurrentHelper());
    }

    @Override
    public Collection<XCourseRequest> getRequests(Long offeringId) {
        ArrayList<XCourseRequest> ret = new ArrayList<XCourseRequest>();
        for (CourseDemand d : this.getCurrentHelper().getHibSession().createQuery("select distinct d from CourseRequest r inner join r.courseDemand d where r.courseOffering.instructionalOffering = :offeringId").setLong("offeringId", offeringId.longValue()).setCacheable(true).list()) {
            ret.add(new XCourseRequest(d, this.getCurrentHelper()));
        }
        return ret;
    }

    @Override
    public XExpectations getExpectations(Long offeringId) {
        HashMap<Long, Double> expectations = new HashMap<Long, Double>();
        for (Object[] info : this.getCurrentHelper().getHibSession().createQuery("select i.clazz.uniqueId, i.nbrExpectedStudents from SectioningInfo i where i.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering = :offeringId").setLong("offeringId", offeringId.longValue()).setCacheable(true).list()) {
            expectations.put((Long)info[0], (Double)info[1]);
        }
        return new XExpectations(offeringId, expectations);
    }

    @Override
    public void update(XExpectations expectations) {
    }

    @Override
    public void remove(XStudent student) {
    }

    @Override
    public void update(XStudent student, boolean updateRequests) {
    }

    @Override
    public void remove(XOffering offering) {
    }

    @Override
    public void update(XOffering offering) {
    }

    @Override
    public void clearAll() {
    }

    @Override
    public void clearAllStudents() {
    }

    @Override
    public XCourseRequest assign(XCourseRequest request, XEnrollment enrollment) {
        request.setEnrollment(enrollment);
        return request;
    }

    @Override
    public XCourseRequest waitlist(XCourseRequest request, boolean waitlist) {
        request.setWaitlist(waitlist);
        return request;
    }
}

