/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.base.BaseStudentEnrollmentMessage;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XWaitListedSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SerializeWith(value=XCourseRequestSerializer.class)
public class XCourseRequest
extends XRequest {
    private static final long serialVersionUID = 1L;
    private List<XCourseId> iCourseIds = new ArrayList<XCourseId>();
    private boolean iWaitlist = false;
    private Date iTimeStamp = null;
    private XEnrollment iEnrollment = null;
    private Map<XCourseId, List<XWaitListedSection>> iSectionWaitlist = null;
    private Map<XCourseId, byte[]> iOptions = null;
    private String iMessage = null;

    public XCourseRequest() {
    }

    public XCourseRequest(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XCourseRequest(CourseDemand demand, OnlineSectioningHelper helper) {
        super(demand);
        TreeSet<org.unitime.timetable.model.CourseRequest> crs = new TreeSet<org.unitime.timetable.model.CourseRequest>(new Comparator<org.unitime.timetable.model.CourseRequest>(){

            @Override
            public int compare(org.unitime.timetable.model.CourseRequest r1, org.unitime.timetable.model.CourseRequest r2) {
                return r1.getOrder().compareTo(r2.getOrder());
            }
        });
        crs.addAll(demand.getCourseRequests());
        for (org.unitime.timetable.model.CourseRequest cr : crs) {
            XCourseId courseId = new XCourseId(cr.getCourseOffering());
            this.iCourseIds.add(courseId);
            if (cr.getClassWaitLists() != null) {
                for (ClassWaitList cwl : cr.getClassWaitLists()) {
                    List<XWaitListedSection> sections;
                    if (this.iSectionWaitlist == null) {
                        this.iSectionWaitlist = new HashMap<XCourseId, List<XWaitListedSection>>();
                    }
                    if ((sections = this.iSectionWaitlist.get(courseId)) == null) {
                        sections = new ArrayList<XWaitListedSection>();
                        this.iSectionWaitlist.put(courseId, sections);
                    }
                    sections.add(new XWaitListedSection(cwl, helper));
                }
            }
            for (CourseRequestOption option : cr.getCourseRequestOptions()) {
                if (OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT.getNumber() != option.getOptionType().intValue()) continue;
                if (this.iOptions == null) {
                    this.iOptions = new HashMap<XCourseId, byte[]>();
                }
                this.iOptions.put(courseId, option.getValue());
            }
        }
        this.iWaitlist = demand.isWaitlist() != null && demand.isWaitlist() != false;
        this.iTimeStamp = demand.getTimestamp() == null ? new Date() : demand.getTimestamp();
        for (org.unitime.timetable.model.CourseRequest cr : crs) {
            List<StudentClassEnrollment> enrl = cr.getClassEnrollments();
            if (enrl.isEmpty()) continue;
            this.iEnrollment = new XEnrollment(demand.getStudent(), cr.getCourseOffering(), helper, enrl);
            break;
        }
        if (demand.getEnrollmentMessages() != null) {
            BaseStudentEnrollmentMessage message = null;
            for (StudentEnrollmentMessage m : demand.getEnrollmentMessages()) {
                if (message != null && message.getOrder() >= m.getOrder() && (message.getOrder() != m.getOrder() || !message.getTimestamp().before(m.getTimestamp()))) continue;
                message = m;
            }
            if (message != null) {
                this.iMessage = message.getMessage();
            }
        }
    }

    public XCourseRequest(Student student, CourseOffering course, int priority, OnlineSectioningHelper helper, Collection<StudentClassEnrollment> classes) {
        this.iStudentId = student.getUniqueId();
        this.iRequestId = -course.getUniqueId().longValue();
        this.iAlternative = false;
        this.iPriority = priority;
        this.iCourseIds.add(new XCourseId(course));
        this.iWaitlist = false;
        if (classes != null && !classes.isEmpty()) {
            this.iEnrollment = new XEnrollment(student, course, helper, classes);
        }
        this.iTimeStamp = this.iEnrollment != null ? this.iEnrollment.getTimeStamp() : new Date();
    }

    public XCourseRequest(CourseRequest request, Enrollment enrollment) {
        super((Request)request);
        for (Course course : request.getCourses()) {
            this.iCourseIds.add(new XCourseId(course));
        }
        this.iWaitlist = request.isWaitlist();
        this.iTimeStamp = request.getTimeStamp() == null ? null : new Date(request.getTimeStamp());
        this.iEnrollment = enrollment == null ? null : new XEnrollment(enrollment);
    }

    public List<XCourseId> getCourseIds() {
        return this.iCourseIds;
    }

    public boolean hasCourse(Long courseId) {
        for (XCourseId id : this.iCourseIds) {
            if (!id.getCourseId().equals(courseId)) continue;
            return true;
        }
        return false;
    }

    public XCourseId getCourseIdByOfferingId(Long offeringId) {
        for (XCourseId id : this.iCourseIds) {
            if (!id.getOfferingId().equals(offeringId)) continue;
            return id;
        }
        return null;
    }

    public boolean isWaitlist() {
        return this.iWaitlist;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public XEnrollment getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(XEnrollment enrollment) {
        this.iEnrollment = enrollment;
    }

    public void setWaitlist(boolean waitlist) {
        this.iWaitlist = waitlist;
    }

    public boolean hasSectionWaitlist(XCourseId courseId) {
        List<XWaitListedSection> sections = this.getSectionWaitlist(courseId);
        return sections != null && !sections.isEmpty();
    }

    public List<XWaitListedSection> getSectionWaitlist(XCourseId courseId) {
        return this.iSectionWaitlist == null ? null : this.iSectionWaitlist.get(courseId);
    }

    public OnlineSectioningLog.CourseRequestOption getOptions(Long offeringId) {
        if (this.iOptions == null) {
            return null;
        }
        XCourseId courseId = this.getCourseIdByOfferingId(offeringId);
        if (courseId == null) {
            return null;
        }
        byte[] option = this.iOptions.get(courseId);
        if (option != null) {
            try {
                return OnlineSectioningLog.CourseRequestOption.parseFrom(option);
            }
            catch (InvalidProtocolBufferException e) {
                // empty catch block
            }
        }
        return null;
    }

    public void fillChoicesIn(CourseRequest request) {
        if (this.iSectionWaitlist != null) {
            for (Map.Entry<XCourseId, List<XWaitListedSection>> entry : this.iSectionWaitlist.entrySet()) {
                Course course = request.getCourse(entry.getKey().getCourseId().longValue());
                if (course == null) continue;
                for (XSection xSection : entry.getValue()) {
                    request.getSelectedChoices().add(new Choice(course.getOffering(), xSection.getInstructionalType(), xSection.getTime() == null ? null : xSection.getTime().toTimeLocation(), xSection.getInstructorIds(), xSection.getInstructorNames()));
                }
            }
        }
    }

    public String getEnrollmentMessage() {
        return this.iMessage;
    }

    public void setEnrollmentMessage(String message) {
        this.iMessage = message;
    }

    @Override
    public String toString() {
        String ret = super.toString();
        Iterator<XCourseId> i = this.iCourseIds.iterator();
        while (i.hasNext()) {
            XCourseId c = i.next();
            ret = ret + " " + c.getCourseName();
            if (!i.hasNext()) continue;
            ret = ret + ",";
        }
        if (this.isWaitlist()) {
            ret = ret + " (w)";
        }
        ret = ret + " (" + this.getRequestId() + ")";
        return ret;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int nrCourses = in.readInt();
        this.iCourseIds.clear();
        for (int i = 0; i < nrCourses; ++i) {
            this.iCourseIds.add(new XCourseId(in));
        }
        this.iWaitlist = in.readBoolean();
        this.iTimeStamp = in.readBoolean() ? new Date(in.readLong()) : null;
        this.iEnrollment = in.readBoolean() ? new XEnrollment(in) : null;
        int nrWaitlists = in.readInt();
        if (nrWaitlists == 0) {
            this.iSectionWaitlist = null;
        } else {
            this.iSectionWaitlist = new HashMap<XCourseId, List<XWaitListedSection>>();
            block1: for (int i = 0; i < nrWaitlists; ++i) {
                Long courseId = in.readLong();
                int nrSections = in.readInt();
                ArrayList<XWaitListedSection> sections = new ArrayList<XWaitListedSection>(nrSections);
                for (int j = 0; j < nrSections; ++j) {
                    sections.add(new XWaitListedSection(in));
                }
                for (XCourseId course : this.iCourseIds) {
                    if (!course.getCourseId().equals(courseId)) continue;
                    this.iSectionWaitlist.put(course, sections);
                    continue block1;
                }
            }
        }
        int nrOptions = in.readInt();
        if (nrOptions == 0) {
            this.iOptions = null;
        } else {
            this.iOptions = new HashMap<XCourseId, byte[]>();
            block4: for (int i = 0; i < nrOptions; ++i) {
                Long courseId = in.readLong();
                byte[] data = new byte[in.readInt()];
                in.read(data);
                for (XCourseId course : this.iCourseIds) {
                    if (!course.getCourseId().equals(courseId)) continue;
                    this.iOptions.put(course, data);
                    continue block4;
                }
            }
        }
        this.iMessage = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.iCourseIds.size());
        for (XCourseId xCourseId : this.iCourseIds) {
            xCourseId.writeExternal(out);
        }
        out.writeBoolean(this.iWaitlist);
        out.writeBoolean(this.iTimeStamp != null);
        if (this.iTimeStamp != null) {
            out.writeLong(this.iTimeStamp.getTime());
        }
        out.writeBoolean(this.iEnrollment != null);
        if (this.iEnrollment != null) {
            this.iEnrollment.writeExternal(out);
        }
        out.writeInt(this.iSectionWaitlist == null ? 0 : this.iSectionWaitlist.size());
        if (this.iSectionWaitlist != null) {
            for (Map.Entry entry : this.iSectionWaitlist.entrySet()) {
                out.writeLong(((XCourseId)entry.getKey()).getCourseId());
                out.writeInt(((List)entry.getValue()).size());
                for (XWaitListedSection section : (List)entry.getValue()) {
                    section.writeExternal(out);
                }
            }
        }
        out.writeInt(this.iOptions == null ? 0 : this.iOptions.size());
        if (this.iOptions != null) {
            for (Map.Entry entry : this.iOptions.entrySet()) {
                out.writeLong(((XCourseId)entry.getKey()).getCourseId());
                byte[] value = (byte[])entry.getValue();
                out.writeInt(value.length);
                out.write(value);
            }
        }
        out.writeObject(this.iMessage);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XCourseRequestSerializer
    implements Externalizer<XCourseRequest> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XCourseRequest object) throws IOException {
            object.writeExternal(output);
        }

        public XCourseRequest readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XCourseRequest(input);
        }
    }
}

