/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.XEInterface;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XEStudentEnrollment
implements StudentEnrollmentProvider {
    private static Logger sLog = Logger.getLogger(XEStudentEnrollment.class);
    private static StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public XEStudentEnrollment() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getBannerSite() {
        return ApplicationProperties.getProperty("banner.xe.site");
    }

    protected String getBannerUser() {
        return ApplicationProperties.getProperty("banner.xe.user");
    }

    protected String getBannerPassword() {
        return ApplicationProperties.getProperty("banner.xe.password");
    }

    protected String getBannerRecheck() {
        return ApplicationProperties.getProperty("banner.xe.recheck");
    }

    protected boolean isBannerAdmin() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.admin", "false"));
    }

    protected String getBannerId(XStudent student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T readResponse(Gson gson, Response response, Type typeOfT) throws JsonIOException, JsonSyntaxException, IOException {
        Object object;
        if (response == null) {
            return null;
        }
        JsonReader reader = new JsonReader(response.getEntity().getReader());
        try {
            object = gson.fromJson(reader, typeOfT);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            reader.close();
            response.release();
            throw throwable;
        }
        reader.close();
        response.release();
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, XStudent student) throws SectioningException {
        ClientResource resource;
        block49: {
            if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL) && student.getStudentId() != null) {
                return;
            }
            resource = null;
            try {
                block48: {
                    try {
                        String pin = helper.getPin();
                        AcademicSessionInfo session = server.getAcademicSession();
                        String term = this.getBannerTerm(session);
                        if (helper.isDebugEnabled()) {
                            helper.debug("Checking eligility for " + student.getName() + " (term: " + term + ", id:" + this.getBannerId(student) + ", pin:" + pin + ")");
                        }
                        resource = new ClientResource(this.getBannerSite());
                        resource.setNext((Uniform)this.iClient);
                        resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(), this.getBannerPassword());
                        Gson gson = this.getGson(helper);
                        XEInterface.RegisterResponse original = null;
                        if (this.isBannerAdmin() && helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER) {
                            XEInterface.RegisterRequest req = new XEInterface.RegisterRequest(term, this.getBannerId(student), pin, true);
                            helper.getAction().addOptionBuilder().setKey("term").setValue(req.term);
                            helper.getAction().addOptionBuilder().setKey("bannerId").setValue(req.bannerId);
                            helper.getAction().addOptionBuilder().setKey("systemIn").setValue(req.systemIn);
                            try {
                                resource.post((Representation)new JsonRepresentation(gson.toJson((Object)req.empty())));
                            }
                            catch (ResourceException exception) {
                                try {
                                    XEInterface.ErrorResponse response = (XEInterface.ErrorResponse)this.readResponse(gson, resource.getResponse(), (Type)((Object)XEInterface.ErrorResponse.class));
                                    helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                                    XEInterface.Error error = response.getError();
                                    if (error != null && error.message != null) {
                                        throw new SectioningException(error.message);
                                    }
                                    if (error != null && error.description != null) {
                                        throw new SectioningException(error.description);
                                    }
                                    if (error == null) throw exception;
                                    if (error.errorMessage == null) throw exception;
                                    throw new SectioningException(error.errorMessage);
                                }
                                catch (SectioningException e) {
                                    throw e;
                                }
                                catch (Throwable t) {
                                    throw exception;
                                }
                            }
                            original = (XEInterface.RegisterResponse)this.readResponse(gson, resource.getResponse(), (Type)((Object)XEInterface.RegisterResponse.class));
                            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)original));
                        } else {
                            resource.addQueryParameter("term", term);
                            resource.addQueryParameter("bannerId", this.getBannerId(student));
                            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                            helper.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
                            if (pin != null && !pin.isEmpty()) {
                                resource.addQueryParameter("altPin", pin);
                                helper.getAction().addOptionBuilder().setKey("pin").setValue(pin);
                            }
                            try {
                                resource.get(MediaType.APPLICATION_JSON);
                            }
                            catch (ResourceException exception) {
                                try {
                                    XEInterface.ErrorResponse response = (XEInterface.ErrorResponse)this.readResponse(gson, resource.getResponse(), (Type)((Object)XEInterface.ErrorResponse.class));
                                    helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                                    XEInterface.Error error = response.getError();
                                    if (error != null && error.message != null) {
                                        throw new SectioningException(error.message);
                                    }
                                    if (error != null && error.description != null) {
                                        throw new SectioningException(error.description);
                                    }
                                    if (error == null) throw exception;
                                    if (error.errorMessage == null) throw exception;
                                    throw new SectioningException(error.errorMessage);
                                }
                                catch (SectioningException e) {
                                    throw e;
                                }
                                catch (Throwable t) {
                                    throw exception;
                                }
                            }
                            List current = (List)this.readResponse(gson, resource.getResponse(), XEInterface.RegisterResponse.TYPE_LIST);
                            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)current));
                            if (current != null && !current.isEmpty()) {
                                original = (XEInterface.RegisterResponse)current.get(0);
                            }
                        }
                        if (original != null && helper.isDebugEnabled()) {
                            helper.debug("Current registration: " + gson.toJson((Object)original));
                        }
                        if (original == null || !original.validStudent.booleanValue()) {
                            String bannerRecheck = this.getBannerRecheck();
                            String reason = null;
                            boolean noreason = true;
                            boolean recheck = true;
                            if (original != null && original.failureReasons != null) {
                                for (String string : original.failureReasons) {
                                    if (bannerRecheck == null || !string.matches(bannerRecheck)) {
                                        recheck = false;
                                    }
                                    noreason = false;
                                    if ("Your PIN is invalid.".equals(string)) {
                                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED, true);
                                        if (pin == null || pin.isEmpty()) continue;
                                    }
                                    if (reason == null) {
                                        reason = string;
                                        continue;
                                    }
                                    reason = reason + "<br>" + string;
                                }
                            }
                            if (noreason) {
                                reason = "Failed to check student registration eligility.";
                                if (bannerRecheck == null || !reason.matches(bannerRecheck)) {
                                    recheck = false;
                                }
                            }
                            if (recheck) {
                                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.RECHECK_BEFORE_ENROLLMENT, true);
                            } else {
                                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                            }
                            check.setMessage(reason);
                            break block48;
                        }
                        if (student.getStudentId() == null) {
                            check.setMessage("UniTime enrollment data are not synchronized with Banner enrollment data, please try again later.");
                            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                            if (this.isCanRequestUpdates()) {
                                ArrayList<XStudent> students = new ArrayList<XStudent>(1);
                                students.add(student);
                                this.requestUpdate(server, helper, students);
                            }
                            break block48;
                        }
                        OnlineSectioningLog.Enrollment.Builder stored = OnlineSectioningLog.Enrollment.newBuilder();
                        stored.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                        HashSet<String> sectionExternalIds = new HashSet<String>();
                        for (XRequest request : student.getRequests()) {
                            Object r;
                            XEnrollment xEnrollment;
                            helper.getAction().addRequest(OnlineSectioningHelper.toProto(request));
                            if (!(request instanceof XCourseRequest) || (xEnrollment = ((XCourseRequest)(r = (XCourseRequest)request)).getEnrollment()) == null) continue;
                            XOffering offering = server.getOffering(xEnrollment.getOfferingId());
                            for (XSection section : offering.getSections(xEnrollment)) {
                                stored.addSection(OnlineSectioningHelper.toProto(section, xEnrollment));
                                String extId = section.getExternalId(xEnrollment.getCourseId());
                                if (extId == null) continue;
                                sectionExternalIds.add(extId);
                            }
                        }
                        helper.getAction().addEnrollment(stored);
                        OnlineSectioningLog.Enrollment.Builder external = OnlineSectioningLog.Enrollment.newBuilder();
                        external.setType(OnlineSectioningLog.Enrollment.EnrollmentType.EXTERNAL);
                        String added = "";
                        if (original.registrations != null) {
                            for (XEInterface.Registration registration : original.registrations) {
                                if (!registration.isRegistered()) continue;
                                if (!sectionExternalIds.remove(registration.courseReferenceNumber) && !this.eligibilityIgnoreBannerRegistration(server, helper, student, registration)) {
                                    added = added + (added.isEmpty() ? "" : ", ") + registration.courseReferenceNumber;
                                }
                                OnlineSectioningLog.Section.Builder section = external.addSectionBuilder().setClazz(OnlineSectioningLog.Entity.newBuilder().setName(registration.courseReferenceNumber)).setCourse(OnlineSectioningLog.Entity.newBuilder().setName(registration.subject + " " + registration.courseNumber)).setSubpart(OnlineSectioningLog.Entity.newBuilder().setName(registration.scheduleType));
                                if (registration.registrationStatusDate == null) continue;
                                section.setTimeStamp(registration.registrationStatusDate.getMillis());
                            }
                        }
                        helper.getAction().addEnrollment(external);
                        String removed = "";
                        for (String s : sectionExternalIds) {
                            removed = removed + (removed.isEmpty() ? "" : ", ") + s;
                        }
                        if (added.isEmpty() && removed.isEmpty()) break block48;
                        if (this.updateStudentRegistration(server, helper, student, original.registrations)) {
                            Object var22_42 = null;
                            if (resource == null) return;
                            break block49;
                        }
                        check.setMessage("UniTime enrollment data are not synchronized with Banner enrollment data, please try again later (" + (removed.isEmpty() ? "added " + added : (added.isEmpty() ? "dropped " + removed : "added " + added + ", dropped " + removed)) + ")");
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                        if (!this.isCanRequestUpdates()) break block48;
                        ArrayList<XStudent> arrayList = new ArrayList<XStudent>(1);
                        arrayList.add(student);
                        this.requestUpdate(server, helper, arrayList);
                    }
                    catch (SectioningException e) {
                        helper.info("Banner eligibility failed: " + e.getMessage());
                        throw e;
                    }
                    catch (Exception e) {
                        helper.warn("Banner eligibility failed: " + e.getMessage(), e);
                        throw new SectioningException(e.getMessage());
                    }
                }
                Object var22_43 = null;
                if (resource == null) return;
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
                return;
            }
            catch (Throwable throwable) {
                Object var22_44 = null;
                if (resource == null) throw throwable;
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
                throw throwable;
            }
        }
        if (resource.getResponse() != null) {
            resource.getResponse().release();
        }
        resource.release();
    }

    protected boolean eligibilityIgnoreBannerRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, XEInterface.Registration reg) {
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<StudentEnrollmentProvider.EnrollmentFailure> enroll(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, List<StudentEnrollmentProvider.EnrollmentRequest> enrollments, Set<Long> lockedCourses) throws SectioningException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isAllowWaitListing() {
        return false;
    }

    @Override
    public boolean requestUpdate(OnlineSectioningServer server, OnlineSectioningHelper helper, Collection<XStudent> students) throws SectioningException {
        return false;
    }

    protected boolean updateStudentRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, List<XEInterface.Registration> registration) throws SectioningException {
        return false;
    }

    @Override
    public boolean isCanRequestUpdates() {
        return false;
    }
}

