/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class XEInterface {

    public static class Error {
        public String code;
        public String message;
        public String description;
        public String type;
        public String errorMessage;
    }

    public static class ErrorResponse {
        public List<Error> errors;

        public Error getError() {
            return this.errors == null || this.errors.isEmpty() ? null : this.errors.get(0);
        }
    }

    public static class RegisterRequest {
        public String bannerId;
        public String term;
        public String altPin;
        public String systemIn;
        public List<CourseReferenceNumber> courseReferenceNumbers;
        public List<RegisterAction> actionsAndOptions;

        public RegisterRequest(String term, String bannerId, String pin, boolean admin) {
            this.term = term;
            this.bannerId = bannerId;
            this.altPin = pin;
            this.systemIn = admin ? "SB" : "WA";
        }

        public RegisterRequest drop(String crn) {
            if (this.actionsAndOptions == null) {
                this.actionsAndOptions = new ArrayList<RegisterAction>();
            }
            this.actionsAndOptions.add(new RegisterAction("DW", crn));
            return this;
        }

        public RegisterRequest keep(String crn) {
            if (this.courseReferenceNumbers == null) {
                this.courseReferenceNumbers = new ArrayList<CourseReferenceNumber>();
            }
            this.courseReferenceNumbers.add(new CourseReferenceNumber(crn));
            return this;
        }

        public RegisterRequest add(String crn, boolean changeStatus) {
            if (changeStatus) {
                if (this.actionsAndOptions == null) {
                    this.actionsAndOptions = new ArrayList<RegisterAction>();
                }
                this.actionsAndOptions.add(new RegisterAction("SB".equals(this.systemIn) ? "RE" : "RW", crn));
            } else {
                if (this.courseReferenceNumbers == null) {
                    this.courseReferenceNumbers = new ArrayList<CourseReferenceNumber>();
                }
                this.courseReferenceNumbers.add(new CourseReferenceNumber(crn));
            }
            return this;
        }

        public RegisterRequest empty() {
            if (this.courseReferenceNumbers == null) {
                this.courseReferenceNumbers = new ArrayList<CourseReferenceNumber>();
            }
            this.courseReferenceNumbers.add(new CourseReferenceNumber());
            return this;
        }

        public boolean isEmpty() {
            return !(this.actionsAndOptions != null && !this.actionsAndOptions.isEmpty() || this.courseReferenceNumbers != null && !this.courseReferenceNumbers.isEmpty());
        }
    }

    public static class RegisterAction {
        public String courseReferenceNumber;
        public String selectedAction;
        public String selectedLevel;
        public String selectedGradingMode;
        public String selectedStudyPath;
        public String selectedCreditHour;

        public RegisterAction(String action, String crn) {
            this.selectedAction = action;
            this.courseReferenceNumber = crn;
        }
    }

    public static class CourseReferenceNumber {
        public String courseReferenceNumber;
        public String courseRegistrationStatus;

        public CourseReferenceNumber() {
        }

        public CourseReferenceNumber(String crn) {
            this.courseReferenceNumber = crn;
        }

        public CourseReferenceNumber(String crn, String status) {
            this.courseReferenceNumber = crn;
            this.courseRegistrationStatus = status;
        }
    }

    public static class RegisterResponse {
        public static final Type TYPE_LIST = new TypeToken<ArrayList<RegisterResponse>>(){}.getType();
        public List<FailedRegistration> failedRegistrations;
        public List<String> failureReasons;
        public List<Registration> registrations;
        public List<TimeTicket> timeTickets;
        public Boolean validStudent;
        public String registrationException;
    }

    public static class FailedRegistration {
        public String failedCRN;
        public String failure;
        public Registration registration;
    }

    public static class TimeTicket {
        public DateTime beginDate;
        public DateTime endDate;
        public String startTime;
        public String endTime;
    }

    public static class RegistrationAction {
        public String courseRegistrationStatus;
        public String description;
        public Boolean remove;
        public String voiceType;
    }

    public static class CrnError {
        public String errorFlag;
        public String message;
        public String messageType;
    }

    public static class Registration {
        public String subject;
        public String subjectDescription;
        public String courseNumber;
        public String courseReferenceNumber;
        public String courseTitle;
        public String courseRegistrationStatus;
        public String courseRegistrationStatusDescription;
        public Double creditHour;
        public String gradingMode;
        public String gradingModeDescription;
        public String level;
        public String levelDescription;
        public DateTime registrationStatusDate;
        public String scheduleDescription;
        public String scheduleType;
        public String sequenceNumber;
        public String statusDescription;
        public String statusIndicator;
        public List<CrnError> crnErrors;
        public String term;
        public String campus;
        public List<RegistrationAction> registrationActions;

        public boolean can(String status) {
            if (this.registrationActions != null) {
                for (RegistrationAction action : this.registrationActions) {
                    if (!status.equals(action.courseRegistrationStatus)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean canDrop() {
            return this.can("DW");
        }

        public boolean canAdd(boolean admin) {
            return this.can(admin ? "RE" : "RW");
        }

        public boolean isRegistered() {
            return "R".equals(this.statusIndicator);
        }
    }
}

