/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface StudentEnrollmentProvider {
    public void checkEligibility(OnlineSectioningServer var1, OnlineSectioningHelper var2, OnlineSectioningInterface.EligibilityCheck var3, XStudent var4) throws SectioningException;

    public List<EnrollmentFailure> enroll(OnlineSectioningServer var1, OnlineSectioningHelper var2, XStudent var3, List<EnrollmentRequest> var4, Set<Long> var5) throws SectioningException;

    public boolean requestUpdate(OnlineSectioningServer var1, OnlineSectioningHelper var2, Collection<XStudent> var3) throws SectioningException;

    public void dispose();

    public boolean isAllowWaitListing();

    public boolean isCanRequestUpdates();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnrollmentRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private XCourse iCourse;
        private List<XSection> iSections;

        public EnrollmentRequest(XCourse course, List<XSection> sections) {
            this.iCourse = course;
            this.iSections = sections;
        }

        public XCourse getCourse() {
            return this.iCourse;
        }

        public List<XSection> getSections() {
            return this.iSections;
        }

        public String toString() {
            return this.getCourse().getCourseName() + ": " + ToolBox.col2string(this.getSections(), (int)2);
        }
    }

    public static class EnrollmentFailure
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private XCourse iCourse;
        private XSection iSection;
        private String iMessage;
        private boolean iEnrolled;

        public EnrollmentFailure(XCourse course, XSection section, String message, boolean enrolled) {
            this.iCourse = course;
            this.iSection = section;
            this.iMessage = message;
            this.iEnrolled = enrolled;
        }

        public XCourse getCourse() {
            return this.iCourse;
        }

        public XSection getSection() {
            return this.iSection;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public boolean isEnrolled() {
            return this.iEnrolled;
        }

        public String toString() {
            return this.getCourse().getCourseName() + " " + this.getSection().getSubpartName() + " " + this.getSection().getName(this.getCourse().getCourseId()) + ": " + this.getMessage() + (this.isEnrolled() ? " (e)" : "");
        }
    }
}

