/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Order;
import org.unitime.commons.hibernate.util.DatabaseUpdate;
import org.unitime.commons.hibernate.util.HibernateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class _BaseRootDAO<T, K extends Serializable> {
    protected static Map<String, SessionFactory> sSessionFactoryMap;
    protected static SessionFactory sSessionFactory;
    protected static ThreadLocal<HashMap<String, Session>> sMappedSessions;
    protected static ThreadLocal<Session> sSessions;
    protected static Configuration sConfiguration;

    public static void initialize() {
        _BaseRootDAO.initialize(null);
    }

    public static void initialize(String configFileName) {
        _BaseRootDAO.initialize(configFileName, _BaseRootDAO.getNewConfiguration(null));
    }

    public static void initialize(String configFileName, Configuration configuration) {
        if (configFileName == null && sSessionFactory != null) {
            return;
        }
        if (sSessionFactoryMap != null && sSessionFactoryMap.get(configFileName) != null) {
            return;
        }
        HibernateUtil.configureHibernateFromRootDAO(configFileName, configuration);
        sConfiguration = configuration;
        _BaseRootDAO.setSessionFactory(configuration.buildSessionFactory());
        HibernateUtil.addBitwiseOperationsToDialect();
        DatabaseUpdate.update();
    }

    protected static void setSessionFactory(SessionFactory sessionFactory) {
        _BaseRootDAO.setSessionFactory(null, sessionFactory);
    }

    protected static void setSessionFactory(String configFileName, SessionFactory sessionFactory) {
        if (configFileName == null) {
            sSessionFactory = sessionFactory;
        } else {
            if (sSessionFactoryMap == null) {
                sSessionFactoryMap = new HashMap<String, SessionFactory>();
            }
            sSessionFactoryMap.put(configFileName, sessionFactory);
        }
    }

    protected SessionFactory getSessionFactory() {
        return this.getSessionFactory(this.getConfigurationFileName());
    }

    protected SessionFactory getSessionFactory(String configFile) {
        if (configFile == null) {
            if (sSessionFactory == null) {
                throw new RuntimeException("The session factory has not been initialized (or an error occured during initialization)");
            }
            return sSessionFactory;
        }
        if (sSessionFactoryMap == null) {
            throw new RuntimeException("The session factory for '" + configFile + "' has not been initialized (or an error occured during initialization)");
        }
        SessionFactory sessionFactory = sSessionFactoryMap.get(configFile);
        if (sessionFactory == null) {
            throw new RuntimeException("The session factory for '" + configFile + "' has not been initialized (or an error occured during initialization)");
        }
        return sessionFactory;
    }

    public Session getSession() {
        return this.getSession(this.getConfigurationFileName(), false);
    }

    public Session createNewSession() {
        return this.getSession(this.getConfigurationFileName(), true);
    }

    private Session getSession(String configFile, boolean createNew) {
        Session session;
        HashMap<String, Object> map;
        if (createNew) {
            return this.getSessionFactory(configFile).openSession();
        }
        if (configFile == null) {
            Session session2;
            if (sSessions == null) {
                sSessions = new ThreadLocal();
            }
            if ((session2 = sSessions.get()) == null || !session2.isOpen()) {
                session2 = this.getSessionFactory(null).openSession();
                sSessions.set(session2);
            }
            return session2;
        }
        if (sMappedSessions == null) {
            sMappedSessions = new ThreadLocal();
        }
        if ((map = sMappedSessions.get()) == null) {
            map = new HashMap();
            sMappedSessions.set(map);
        }
        if ((session = map.get(configFile)) == null || !session.isOpen()) {
            session = this.getSessionFactory(configFile).openSession();
            map.put(configFile, session);
        }
        return session;
    }

    public Session getCurrentThreadSession() {
        return this.getCurrentThreadSession(this.getConfigurationFileName());
    }

    private Session getCurrentThreadSession(String configFile) {
        HashMap<String, Session> map;
        if (configFile == null) {
            Session session;
            if (sSessions != null && (session = sSessions.get()) != null) {
                return session;
            }
        } else if (sMappedSessions != null && (map = sMappedSessions.get()) != null) {
            return map.get(configFile);
        }
        return null;
    }

    public static boolean closeCurrentThreadSessions() {
        return _BaseRootDAO.closeCurrentThreadSessions(true);
    }

    public static boolean rollbackCurrentThreadSessions() {
        return _BaseRootDAO.closeCurrentThreadSessions(false);
    }

    private static boolean closeCurrentThreadSessions(boolean commit) {
        boolean ret = false;
        if (sSessions != null) {
            Session session = sSessions.get();
            if (session != null && session.isOpen()) {
                if (session.getTransaction() != null && session.getTransaction().isActive()) {
                    if (commit) {
                        session.getTransaction().commit();
                    } else {
                        session.getTransaction().rollback();
                    }
                }
                session.close();
                ret = true;
            }
            sSessions.remove();
        }
        if (sMappedSessions != null) {
            HashMap<String, Session> map = sMappedSessions.get();
            if (map != null) {
                HibernateException thrownException = null;
                for (Session session : map.values()) {
                    try {
                        if (null == session || !session.isOpen()) continue;
                        if (session.getTransaction() != null && session.getTransaction().isActive()) {
                            if (commit) {
                                session.getTransaction().commit();
                            } else {
                                session.getTransaction().rollback();
                            }
                        }
                        session.close();
                        ret = true;
                    }
                    catch (HibernateException e) {
                        thrownException = e;
                    }
                }
                map.clear();
                if (null != thrownException) {
                    throw thrownException;
                }
            }
            sMappedSessions.remove();
        }
        return ret;
    }

    public Transaction beginTransaction(Session s) {
        if (s.getTransaction() != null && s.getTransaction().isActive()) {
            return null;
        }
        return s.beginTransaction();
    }

    public void commitTransaction(Transaction t) {
        if (t != null) {
            t.commit();
        }
    }

    public static Configuration getNewConfiguration(String configFileName) {
        return new Configuration();
    }

    public static boolean isConfigured() {
        return sConfiguration != null && sSessionFactory != null;
    }

    public static Configuration getConfiguration() {
        return sConfiguration;
    }

    public String getConfigurationFileName() {
        return null;
    }

    protected abstract Class<T> getReferenceClass();

    protected T get(Class<T> refClass, K key) {
        return this.get(refClass, key, this.getSession());
    }

    public T get(K key) {
        return this.get(this.getReferenceClass(), key);
    }

    protected T get(Class<T> refClass, K key, Session s) {
        return (T)s.get(refClass, key);
    }

    public T get(K key, Session s) {
        return this.get(this.getReferenceClass(), key, s);
    }

    protected T load(Class<T> refClass, K key) {
        return this.load(refClass, key, this.getSession());
    }

    public T load(K key) {
        return this.load(this.getReferenceClass(), key);
    }

    protected T load(Class<T> refClass, K key, Session s) {
        return (T)s.load(refClass, key);
    }

    public T load(K key, Session s) {
        return this.load(this.getReferenceClass(), key, s);
    }

    public T loadInitialize(K key, Session s) {
        T obj = this.load(key, s);
        if (!Hibernate.isInitialized(obj)) {
            Hibernate.initialize(obj);
        }
        return obj;
    }

    public List<T> findAll() {
        Transaction t = null;
        Session s = null;
        try {
            s = this.getSession();
            t = this.beginTransaction(s);
            List<T> rtn = this.findAll(s);
            this.commitTransaction(t);
            return rtn;
        }
        catch (HibernateException e) {
            if (null != t) {
                t.rollback();
            }
            throw e;
        }
    }

    public List<T> findAll(Session s) {
        return this.findAll(s, this.getDefaultOrder());
    }

    public List<T> findAll(Order ... orders) {
        return this.findAll(this.getSession(), orders);
    }

    public List<T> findAll(Session s, Order ... orders) {
        Criteria crit = s.createCriteria(this.getReferenceClass());
        if (orders != null) {
            for (Order order : orders) {
                if (order == null) continue;
                crit.addOrder(order);
            }
        }
        crit.setCacheable(true);
        return crit.list();
    }

    public Query getQuery(String queryStr) {
        return this.getQuery(queryStr, this.getSession());
    }

    public Query getQuery(String queryStr, Session s) {
        return s.createQuery(queryStr);
    }

    protected Order getDefaultOrder() {
        return null;
    }

    public K save(T obj) {
        Transaction t = null;
        Session s = null;
        try {
            s = this.getSession();
            t = this.beginTransaction(s);
            K rtn = this.save(obj, s);
            this.commitTransaction(t);
            return rtn;
        }
        catch (HibernateException e) {
            if (null != t) {
                t.rollback();
            }
            throw e;
        }
    }

    public K save(T obj, Session s) {
        return (K)s.save(obj);
    }

    public void saveOrUpdate(T obj) {
        Transaction t = null;
        Session s = null;
        try {
            s = this.getSession();
            t = this.beginTransaction(s);
            this.saveOrUpdate(obj, s);
            this.commitTransaction(t);
        }
        catch (HibernateException e) {
            if (null != t) {
                t.rollback();
            }
            throw e;
        }
    }

    public void saveOrUpdate(T obj, Session s) {
        s.saveOrUpdate(obj);
    }

    public void update(T obj) {
        Transaction t = null;
        Session s = null;
        try {
            s = this.getSession();
            t = this.beginTransaction(s);
            this.update(obj, s);
            this.commitTransaction(t);
        }
        catch (HibernateException e) {
            if (null != t) {
                t.rollback();
            }
            throw e;
        }
    }

    public void update(T obj, Session s) {
        s.update(obj);
    }

    public void delete(T obj) {
        Transaction t = null;
        Session s = null;
        try {
            s = this.getSession();
            t = this.beginTransaction(s);
            this.delete((K)obj, s);
            this.commitTransaction(t);
        }
        catch (HibernateException e) {
            if (null != t) {
                t.rollback();
            }
            throw e;
        }
    }

    public void delete(T obj, Session s) {
        s.delete(obj);
    }

    public void delete(K key) {
        this.delete((K)this.load(key));
    }

    public void delete(K key, Session s) {
        s.delete(this.load(key, s));
    }

    public void refresh(T obj, Session s) {
        s.refresh(obj);
    }
}

