/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamConflict;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseExam
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iName;
    private String iNote;
    private Integer iLength;
    private Integer iExamSize;
    private Integer iPrintOffset;
    private Integer iMaxNbrRooms;
    private Integer iSeatingType;
    private String iAssignedPreference;
    private Integer iAvgPeriod;
    private Long iUniqueIdRolledForwardFrom;
    private Session iSession;
    private ExamPeriod iAssignedPeriod;
    private ExamType iExamType;
    private Set<ExamOwner> iOwners;
    private Set<Location> iAssignedRooms;
    private Set<DepartmentalInstructor> iInstructors;
    private Set<ExamConflict> iConflicts;
    public static String PROP_NAME = "name";
    public static String PROP_NOTE = "note";
    public static String PROP_LENGTH = "length";
    public static String PROP_EXAM_SIZE = "examSize";
    public static String PROP_PRINT_OFFSET = "printOffset";
    public static String PROP_MAX_NBR_ROOMS = "maxNbrRooms";
    public static String PROP_SEATING_TYPE = "seatingType";
    public static String PROP_ASSIGNED_PREF = "assignedPreference";
    public static String PROP_AVG_PERIOD = "avgPeriod";
    public static String PROP_UID_ROLLED_FWD_FROM = "uniqueIdRolledForwardFrom";

    public BaseExam() {
        this.initialize();
    }

    public BaseExam(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    @Override
    protected void initialize() {
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    public Integer getLength() {
        return this.iLength;
    }

    public void setLength(Integer length) {
        this.iLength = length;
    }

    public Integer getExamSize() {
        return this.iExamSize;
    }

    public void setExamSize(Integer examSize) {
        this.iExamSize = examSize;
    }

    public Integer getPrintOffset() {
        return this.iPrintOffset;
    }

    public void setPrintOffset(Integer printOffset) {
        this.iPrintOffset = printOffset;
    }

    public Integer getMaxNbrRooms() {
        return this.iMaxNbrRooms;
    }

    public void setMaxNbrRooms(Integer maxNbrRooms) {
        this.iMaxNbrRooms = maxNbrRooms;
    }

    public Integer getSeatingType() {
        return this.iSeatingType;
    }

    public void setSeatingType(Integer seatingType) {
        this.iSeatingType = seatingType;
    }

    public String getAssignedPreference() {
        return this.iAssignedPreference;
    }

    public void setAssignedPreference(String assignedPreference) {
        this.iAssignedPreference = assignedPreference;
    }

    public Integer getAvgPeriod() {
        return this.iAvgPeriod;
    }

    public void setAvgPeriod(Integer avgPeriod) {
        this.iAvgPeriod = avgPeriod;
    }

    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @Override
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public ExamPeriod getAssignedPeriod() {
        return this.iAssignedPeriod;
    }

    public void setAssignedPeriod(ExamPeriod assignedPeriod) {
        this.iAssignedPeriod = assignedPeriod;
    }

    public ExamType getExamType() {
        return this.iExamType;
    }

    public void setExamType(ExamType examType) {
        this.iExamType = examType;
    }

    public Set<ExamOwner> getOwners() {
        return this.iOwners;
    }

    public void setOwners(Set<ExamOwner> owners) {
        this.iOwners = owners;
    }

    public void addToowners(ExamOwner examOwner) {
        if (this.iOwners == null) {
            this.iOwners = new HashSet<ExamOwner>();
        }
        this.iOwners.add(examOwner);
    }

    public Set<Location> getAssignedRooms() {
        return this.iAssignedRooms;
    }

    public void setAssignedRooms(Set<Location> assignedRooms) {
        this.iAssignedRooms = assignedRooms;
    }

    public void addToassignedRooms(Location location) {
        if (this.iAssignedRooms == null) {
            this.iAssignedRooms = new HashSet<Location>();
        }
        this.iAssignedRooms.add(location);
    }

    public Set<DepartmentalInstructor> getInstructors() {
        return this.iInstructors;
    }

    public void setInstructors(Set<DepartmentalInstructor> instructors) {
        this.iInstructors = instructors;
    }

    public void addToinstructors(DepartmentalInstructor departmentalInstructor) {
        if (this.iInstructors == null) {
            this.iInstructors = new HashSet<DepartmentalInstructor>();
        }
        this.iInstructors.add(departmentalInstructor);
    }

    public Set<ExamConflict> getConflicts() {
        return this.iConflicts;
    }

    public void setConflicts(Set<ExamConflict> conflicts) {
        this.iConflicts = conflicts;
    }

    public void addToconflicts(ExamConflict examConflict) {
        if (this.iConflicts == null) {
            this.iConflicts = new HashSet<ExamConflict>();
        }
        this.iConflicts.add(examConflict);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Exam)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Exam)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Exam)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "Exam[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    @Override
    public String toDebugString() {
        return "Exam[\n\tAssignedPeriod: " + this.getAssignedPeriod() + "\n\tAssignedPreference: " + this.getAssignedPreference() + "\n\tAvgPeriod: " + this.getAvgPeriod() + "\n\tExamSize: " + this.getExamSize() + "\n\tExamType: " + this.getExamType() + "\n\tLength: " + this.getLength() + "\n\tMaxNbrRooms: " + this.getMaxNbrRooms() + "\n\tName: " + this.getName() + "\n\tNote: " + this.getNote() + "\n\tPrintOffset: " + this.getPrintOffset() + "\n\tSeatingType: " + this.getSeatingType() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "]";
    }
}

