/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.commons.Debug;
import org.unitime.commons.Email;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ListSolutionsForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolutionInfo;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseAssignment;
import org.unitime.timetable.model.base.BaseClass_;
import org.unitime.timetable.model.base.BaseSchedulingSubpart;
import org.unitime.timetable.model.base.BaseSolution;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.DivSecAssignmentComparator;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao.SolutionInfoDAO;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.solver.ui.PropertiesInfo;
import org.unitime.timetable.solver.ui.TimetableInfo;
import org.unitime.timetable.solver.ui.TimetableInfoFileProxy;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solution
extends BaseSolution
implements ClassAssignmentProxy {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private static final long serialVersionUID = 1L;
    private static Log sLog = LogFactory.getLog(Solution.class);
    public static DecimalFormat sSufixFormat = new DecimalFormat("000");
    public static boolean DEBUG = false;
    private transient Hashtable iAssignmentTable = null;
    private transient DataProperties iPropertiesCache = null;

    public Solution() {
    }

    public Solution(Long uniqueId) {
        super(uniqueId);
    }

    public SolutionInfo getSolutionInfo(String name) throws Exception {
        if ("GlobalInfo".equals(name)) {
            return this.getGlobalInfo();
        }
        return (SolutionInfo)new SolutionInfoDAO().getSession().createQuery("select si from SolutionInfo si where si.definition.name=:name and si.solution.uniqueId=:solutionId").setString("name", name).setLong("solutionId", this.getUniqueId().longValue()).uniqueResult();
    }

    public TimetableInfo getInfo(String name) throws Exception {
        SolutionInfo sinfo = this.getSolutionInfo(name);
        if (sinfo == null) {
            return null;
        }
        return sinfo.getInfo();
    }

    public void uncommitSolution(org.hibernate.Session hibSession) throws Exception {
        this.uncommitSolution(hibSession, null);
    }

    public void uncommitSolution(org.hibernate.Session hibSession, String sendNotificationPuid) throws Exception {
        if (DEBUG) {
            sLog.debug((Object)("uncommit[" + this.getUniqueId() + "," + this.getOwner().getName() + "] -------------------------------------------------------"));
        }
        this.setCommitDate(null);
        this.setCommited(Boolean.FALSE);
        hibSession.update((Object)this);
        if (ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue()) {
            this.deleteObjects(hibSession, "ClassEvent", "select e.uniqueId from Solution s inner join s.assignments a, ClassEvent e where e.clazz=a.clazz and s.uniqueId=:solutionId");
        } else {
            TimetableManager manager;
            EventContact contact;
            EventContact eventContact = contact = sendNotificationPuid == null ? null : EventContact.findByExternalUniqueId(sendNotificationPuid);
            if (contact == null && sendNotificationPuid != null && (manager = TimetableManager.findByExternalId(sendNotificationPuid)) != null) {
                contact = new EventContact();
                contact.setFirstName(manager.getFirstName());
                contact.setMiddleName(manager.getMiddleName());
                contact.setLastName(manager.getLastName());
                contact.setExternalUniqueId(manager.getExternalUniqueId());
                contact.setEmailAddress(manager.getEmailAddress());
                hibSession.save((Object)contact);
            }
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date today = cal.getTime();
            List events = hibSession.createQuery("select e from Solution s inner join s.assignments a, ClassEvent e where e.clazz=a.clazz and s.uniqueId=:solutionId").setLong("solutionId", this.getUniqueId().longValue()).list();
            for (ClassEvent event : events) {
                Iterator<Meeting> i = event.getMeetings().iterator();
                while (i.hasNext()) {
                    if (i.next().getMeetingDate().before(today)) continue;
                    i.remove();
                }
                if (event.getMeetings().isEmpty()) {
                    hibSession.delete((Object)event);
                    continue;
                }
                if (event.getNotes() == null) {
                    event.setNotes(new HashSet<EventNote>());
                }
                EventNote note = new EventNote();
                note.setEvent(event);
                note.setNoteType(4);
                note.setTimeStamp(new Date());
                note.setUser(contact == null ? "System" : contact.getName());
                note.setUserId(sendNotificationPuid);
                note.setTextNote(this.getOwner().getName() + " uncommitted");
                note.setMeetings("N/A");
                event.getNotes().add(note);
                hibSession.saveOrUpdate((Object)event);
            }
        }
        if (sendNotificationPuid != null) {
            Solution.sendNotification(this, null, sendNotificationPuid, true, null);
        }
        for (Assignment a : this.getAssignments()) {
            a.getClazz().setCommittedAssignment(null);
        }
    }

    public boolean commitSolution(Vector messages, org.hibernate.Session hibSession) throws Exception {
        return this.commitSolution(messages, hibSession, null);
    }

    public static boolean shareRooms(Assignment a1, Assignment a2) {
        String ref;
        DistributionPref dp;
        if (!a1.getPlacement().sameRooms(a2.getPlacement())) {
            return false;
        }
        for (DistributionObject distObj : a1.getClazz().getDistributionObjects()) {
            dp = distObj.getDistributionPref();
            ref = dp.getDistributionType().getReference();
            if (!"MEET_WITH".equals(ref) && !"CAN_SHARE_ROOM".equals(ref) || !PreferenceLevel.sRequired.equals(dp.getPrefLevel().getPrefProlog())) continue;
            for (DistributionObject distObj2 : dp.getDistributionObjects()) {
                if (!distObj2.getPrefGroup().equals(a2.getClazz()) && !distObj2.getPrefGroup().equals(a2.getClazz().getSchedulingSubpart())) continue;
                return true;
            }
        }
        for (DistributionObject distObj : a1.getClazz().getSchedulingSubpart().getDistributionObjects()) {
            dp = distObj.getDistributionPref();
            ref = dp.getDistributionType().getReference();
            if (!"MEET_WITH".equals(ref) && !"CAN_SHARE_ROOM".equals(ref) || !PreferenceLevel.sRequired.equals(dp.getPrefLevel().getPrefProlog())) continue;
            for (DistributionObject distObj2 : dp.getDistributionObjects()) {
                if (!distObj2.getPrefGroup().equals(a2.getClazz()) && !distObj2.getPrefGroup().equals(a2.getClazz().getSchedulingSubpart())) continue;
                return true;
            }
        }
        for (DepartmentalInstructor instr : a1.getInstructors()) {
            for (DistributionPref dp2 : instr.getDistributionPreferences()) {
                String ref2 = dp2.getDistributionType().getReference();
                if (!"MEET_WITH".equals(ref2) && !"CAN_SHARE_ROOM".equals(ref2) || !PreferenceLevel.sRequired.equals(dp2.getPrefLevel().getPrefProlog())) continue;
                for (DepartmentalInstructor inst2 : DepartmentalInstructor.getAllForInstructor(instr, instr.getDepartment().getSession().getUniqueId())) {
                    for (ClassInstructor ci : inst2.getClasses()) {
                        if (!ci.getClassInstructing().equals(a2.getClazz())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean commitSolution(List<String> messages, org.hibernate.Session hibSession, String sendNotificationPuid) throws Exception {
        TimetableManager manager;
        Assignment b;
        Assignment a2;
        List solutions = hibSession.createCriteria(Solution.class).add((Criterion)Restrictions.eq((String)"owner", (Object)this.getOwner())).list();
        Solution uncommittedSolution = null;
        for (Object s : solutions) {
            if (((BaseSolution)s).equals(this) || !((BaseSolution)s).isCommited().booleanValue()) continue;
            uncommittedSolution = s;
            ((Solution)s).uncommitSolution(hibSession, null);
        }
        if (DEBUG) {
            sLog.debug((Object)("commit[" + this.getUniqueId() + "," + this.getOwner().getName() + "] -------------------------------------------------------"));
        }
        boolean isOK = true;
        for (Object[] o : hibSession.createQuery("select r, a1, a2 from Location r inner join r.assignments a1 inner join r.assignments a2 where a1.solution.uniqueId = :solutionId and a2.solution.commited = true and a2.solution.owner.uniqueId != :ownerId and bit_and(a1.days, a2.days) > 0 and (a1.timePattern.type = :exactType or a2.timePattern.type = :exactType or (a1.startSlot < a2.startSlot + a2.timePattern.slotsPerMtg and a2.startSlot < a1.startSlot + a1.timePattern.slotsPerMtg))").setLong("ownerId", this.getOwner().getUniqueId().longValue()).setLong("solutionId", this.getUniqueId().longValue()).setInteger("exactType", 5).list()) {
            Location room = (Location)o[0];
            a2 = (Assignment)o[1];
            b = (Assignment)o[2];
            if (room.isIgnoreRoomCheck().booleanValue() || !a2.getTimeLocation().hasIntersection(b.getTimeLocation()) || Solution.shareRooms(a2, b)) continue;
            messages.add("Class " + a2.getClassName() + " " + a2.getTimeLocation().getName(CONSTANTS.useAmPm()) + " overlaps with " + b.getClassName() + " " + b.getTimeLocation().getName(CONSTANTS.useAmPm()) + " (room " + room.getLabel() + ")");
            isOK = false;
        }
        for (Object[] o : hibSession.createQuery("select i1, a1, a2 from ClassInstructor c1 inner join c1.instructor i1 inner join c1.classInstructing.assignments a1, ClassInstructor c2 inner join c2.instructor i2 inner join c2.classInstructing.assignments a2 where c1.lead = true and c2.lead = true and i1.department.solverGroup.uniqueId = :ownerId and i2.department.solverGroup.uniqueId != :ownerId and i2.department.session = :sessionId and i1.externalUniqueId is not null and i1.externalUniqueId = i2.externalUniqueId and a1.solution.uniqueId = :solutionId and a2.solution.commited = true and a2.solution.owner.uniqueId != :ownerId and bit_and(a1.days, a2.days) > 0 and (a1.timePattern.type = :exactType or a2.timePattern.type = :exactType or (a1.startSlot < a2.startSlot + a2.timePattern.slotsPerMtg and a2.startSlot < a1.startSlot + a1.timePattern.slotsPerMtg))").setLong("ownerId", this.getOwner().getUniqueId().longValue()).setLong("solutionId", this.getUniqueId().longValue()).setLong("sessionId", this.getOwner().getSession().getUniqueId().longValue()).setInteger("exactType", 5).list()) {
            DepartmentalInstructor instructor = (DepartmentalInstructor)o[0];
            a2 = (Assignment)o[1];
            b = (Assignment)o[2];
            if (!a2.getTimeLocation().hasIntersection(b.getTimeLocation()) || Solution.shareRooms(a2, b)) continue;
            messages.add("Class " + a2.getClassName() + " " + a2.getTimeLocation().getName(CONSTANTS.useAmPm()) + " overlaps with " + b.getClassName() + " " + b.getTimeLocation().getName(CONSTANTS.useAmPm()) + " (instructor " + instructor.nameLastNameFirst() + ")");
            isOK = false;
        }
        if (!isOK) {
            if (sendNotificationPuid != null) {
                Solution.sendNotification(uncommittedSolution, this, sendNotificationPuid, false, messages);
            }
            return false;
        }
        this.setCommitDate(new Date());
        this.setCommited(Boolean.TRUE);
        EventContact contact = null;
        if (sendNotificationPuid != null && (contact = EventContact.findByExternalUniqueId(sendNotificationPuid)) == null && (manager = TimetableManager.findByExternalId(sendNotificationPuid)) != null) {
            contact = new EventContact();
            contact.setFirstName(manager.getFirstName());
            contact.setMiddleName(manager.getMiddleName());
            contact.setLastName(manager.getLastName());
            contact.setExternalUniqueId(manager.getExternalUniqueId());
            contact.setEmailAddress(manager.getEmailAddress());
            hibSession.save((Object)contact);
        }
        Hashtable<Long, ClassEvent> classEvents = new Hashtable<Long, ClassEvent>();
        Iterator<Assignment> i = hibSession.createQuery("select e from Solution s inner join s.assignments a, ClassEvent e where e.clazz=a.clazz and s.uniqueId=:solutionId").setLong("solutionId", this.getUniqueId().longValue()).iterate();
        while (i.hasNext()) {
            ClassEvent e = (ClassEvent)i.next();
            classEvents.put(e.getClazz().getUniqueId(), e);
        }
        for (Assignment a2 : this.getAssignments()) {
            ClassEvent event = a2.generateCommittedEvent((ClassEvent)classEvents.get(a2.getClassId()), true);
            classEvents.remove(a2.getClassId());
            if (event != null && !event.getMeetings().isEmpty()) {
                event.setMainContact(contact);
                if (event.getNotes() == null) {
                    event.setNotes(new HashSet<EventNote>());
                }
                EventNote note = new EventNote();
                note.setEvent(event);
                note.setNoteType(event.getUniqueId() == null ? 0 : 5);
                note.setTimeStamp(new Date());
                note.setUser(contact == null ? "System" : contact.getName());
                note.setUserId(sendNotificationPuid);
                note.setTextNote(this.getOwner().getName() + " committed");
                note.setMeetings(a2.getPlacement().getLongName(CONSTANTS.useAmPm()));
                event.getNotes().add(note);
                hibSession.saveOrUpdate((Object)event);
            }
            if (event == null || !event.getMeetings().isEmpty() || event.getUniqueId() == null) continue;
            hibSession.delete((Object)event);
        }
        if (ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue()) {
            Enumeration e = classEvents.elements();
            while (e.hasMoreElements()) {
                ClassEvent event = (ClassEvent)e.nextElement();
                hibSession.delete((Object)event);
            }
        } else {
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date today = cal.getTime();
            Enumeration e = classEvents.elements();
            while (e.hasMoreElements()) {
                ClassEvent event = (ClassEvent)e.nextElement();
                Iterator<Meeting> i2 = event.getMeetings().iterator();
                while (i2.hasNext()) {
                    if (i2.next().getMeetingDate().before(today)) continue;
                    i2.remove();
                }
                if (event.getMeetings().isEmpty()) {
                    hibSession.delete((Object)event);
                    continue;
                }
                if (event.getNotes() == null) {
                    event.setNotes(new HashSet<EventNote>());
                }
                EventNote note = new EventNote();
                note.setEvent(event);
                note.setNoteType(4);
                note.setTimeStamp(new Date());
                note.setUser(contact == null ? "System" : contact.getName());
                note.setUserId(sendNotificationPuid);
                note.setTextNote(this.getOwner().getName() + " committed, class was removed or unassigned");
                note.setMeetings("N/A");
                event.getNotes().add(note);
                hibSession.saveOrUpdate((Object)event);
            }
        }
        if (sendNotificationPuid != null) {
            Solution.sendNotification(uncommittedSolution, this, sendNotificationPuid, true, messages);
        }
        for (Assignment a2 : this.getAssignments()) {
            a2.getClazz().setCommittedAssignment(a2);
        }
        return true;
    }

    public static void sendNotification(Solution uncommittedSolution, Solution committedSolution, String puid, boolean success, List<String> messages) {
        try {
            String value;
            String key;
            Enumeration<Object> e;
            Vector<Object> infos;
            PropertiesInfo globalInfo;
            if (ApplicationProperty.EmailNotificationSolutionCommits.isFalse()) {
                return;
            }
            Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
            SolverGroup owner = (uncommittedSolution == null ? committedSolution : uncommittedSolution).getOwner();
            String subject = "Solution " + (committedSolution != null ? (uncommittedSolution != null ? "recommitted" : "committed") : "uncommitted") + " for " + owner.getName();
            if (!success) {
                subject = "Failed to " + (committedSolution != null ? (uncommittedSolution != null ? "recommit" : "commit") : "uncommit") + " a solution for " + owner.getName();
            }
            String mail = subject;
            mail = mail + "\r\n";
            mail = mail + "\r\n";
            if (messages != null && !messages.isEmpty()) {
                mail = mail + "Message(s): ----------------- \r\n";
                for (String m : messages) {
                    mail = mail + m + "\r\n";
                }
                mail = mail + "\r\n";
                mail = mail + "\r\n";
            }
            if (committedSolution != null) {
                mail = mail + "Committed solution info: -------------- \r\n";
                mail = mail + "Created: " + sdf.format(committedSolution.getCreated()) + "\r\n";
                mail = mail + "Owner: " + committedSolution.getOwner().getName() + "\r\n";
                if (committedSolution.getCommitDate() != null) {
                    mail = mail + "Commited: " + sdf.format(committedSolution.getCommitDate()) + "\r\n";
                }
                if (committedSolution.getNote() != null && committedSolution.getNote().trim().length() > 0) {
                    mail = mail + "Note: " + committedSolution.getNote() + "\r\n";
                }
                globalInfo = (PropertiesInfo)committedSolution.getInfo("GlobalInfo");
                infos = new Vector<Object>(globalInfo.keySet());
                Collections.sort(infos, new ListSolutionsForm.InfoComparator());
                e = infos.elements();
                while (e.hasMoreElements()) {
                    key = (String)e.nextElement();
                    value = globalInfo.getProperty(key);
                    mail = mail + key + ": " + value + "\r\n";
                }
                mail = mail + "\r\n";
                mail = mail + "\r\n";
            }
            if (uncommittedSolution != null) {
                mail = mail + "Uncommitted solution info: -------------- \r\n";
                mail = mail + "Created: " + sdf.format(uncommittedSolution.getCreated()) + "\r\n";
                mail = mail + "Owner: " + uncommittedSolution.getOwner().getName() + "\r\n";
                if (uncommittedSolution.getNote() != null && uncommittedSolution.getNote().trim().length() > 0) {
                    mail = mail + "Note: " + uncommittedSolution.getNote() + "\r\n";
                }
                globalInfo = (PropertiesInfo)uncommittedSolution.getInfo("GlobalInfo");
                infos = new Vector<Object>(globalInfo.keySet());
                Collections.sort(infos, new ListSolutionsForm.InfoComparator());
                e = infos.elements();
                while (e.hasMoreElements()) {
                    key = (String)e.nextElement();
                    value = globalInfo.getProperty(key);
                    mail = mail + key + ": " + value + "\r\n";
                }
                mail = mail + "\r\n";
                mail = mail + "\r\n";
            }
            TimetableManager mgr = TimetableManager.findByExternalId(puid);
            mail = mail + "Manager info -------------- \r\n";
            mail = mail + "Name: " + mgr.getName() + "\r\n";
            mail = mail + "Email: " + mgr.getEmailAddress() + "\r\n";
            mail = mail + "\r\n";
            mail = mail + "Session info -------------- \r\n";
            mail = mail + "Session Term: " + owner.getSession().getAcademicYearTerm() + "\r\n";
            mail = mail + "Session Initiative: " + owner.getSession().getAcademicInitiative() + "\r\n";
            mail = mail + "Departments (from solver group): \r\n";
            for (Department d : owner.getDepartments()) {
                mail = mail + "  " + d.getLabel() + "\r\n";
            }
            mail = mail + "\r\n";
            mail = mail + "Application info -------------- \r\n";
            mail = mail + "Version: " + Constants.getVersion() + " (" + Constants.getReleaseDate() + ")\r\n";
            mail = mail + "TimeStamp: " + new Date();
            Email email = Email.createEmail();
            email.addRecipient(mgr.getEmailAddress(), mgr.getName());
            email.addNotifyCC();
            email.setSubject("UniTime (Solution Commit): " + subject);
            email.setText(mail);
            email.send();
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to send solution commit/uncommit notification, reason: " + e.getMessage()), (Throwable)e);
        }
    }

    public void export(CSVFile file, String instructorFormat) {
        file.setSeparator(",");
        file.setQuotationMark("\"");
        if (this.isCommited().booleanValue()) {
            file.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"COURSE"), new CSVFile.CSVField((Object)"ITYPE"), new CSVFile.CSVField((Object)"SECTION"), new CSVFile.CSVField((Object)"SUFFIX"), new CSVFile.CSVField((Object)"EXTERNAL_ID"), new CSVFile.CSVField((Object)"DATE_PATTERN"), new CSVFile.CSVField((Object)"DAY"), new CSVFile.CSVField((Object)"START_TIME"), new CSVFile.CSVField((Object)"END_TIME"), new CSVFile.CSVField((Object)"ROOM"), new CSVFile.CSVField((Object)"INSTRUCTOR"), new CSVFile.CSVField((Object)"SCHEDULE_NOTE")});
        } else {
            file.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"COURSE"), new CSVFile.CSVField((Object)"ITYPE"), new CSVFile.CSVField((Object)"SECTION"), new CSVFile.CSVField((Object)"SUFFIX"), new CSVFile.CSVField((Object)"DATE_PATTERN"), new CSVFile.CSVField((Object)"DAY"), new CSVFile.CSVField((Object)"START_TIME"), new CSVFile.CSVField((Object)"END_TIME"), new CSVFile.CSVField((Object)"ROOM"), new CSVFile.CSVField((Object)"INSTRUCTOR"), new CSVFile.CSVField((Object)"SCHEDULE_NOTE")});
        }
        Vector<Assignment> assignments = new Vector<Assignment>(this.getAssignments());
        assignments.addAll(this.getOwner().getNotAssignedClasses(this));
        Collections.sort(assignments, new ClassOrAssignmentComparator());
        for (Assignment o : assignments) {
            if (o instanceof Assignment) {
                Assignment assignment = o;
                Class_ clazz = assignment.getClazz();
                List<DepartmentalInstructor> leads = clazz.getLeadInstructors();
                StringBuffer leadsSb = new StringBuffer();
                Iterator<DepartmentalInstructor> e = leads.iterator();
                while (e.hasNext()) {
                    DepartmentalInstructor instructor = e.next();
                    leadsSb.append(instructor.getName(instructorFormat));
                    if (!e.hasNext()) continue;
                    leadsSb.append(";");
                }
                Placement placement = assignment.getPlacement();
                if (this.isCommited().booleanValue()) {
                    file.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)clazz.getCourseName()), new CSVFile.CSVField((Object)clazz.getItypeDesc()), new CSVFile.CSVField((Object)clazz.getSectionNumber()), new CSVFile.CSVField((Object)clazz.getSchedulingSubpart().getSchedulingSubpartSuffix()), new CSVFile.CSVField((Object)clazz.getDivSecNumber()), new CSVFile.CSVField((Object)clazz.effectiveDatePattern().getName()), new CSVFile.CSVField((Object)placement.getTimeLocation().getDayHeader()), new CSVFile.CSVField((Object)placement.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm())), new CSVFile.CSVField((Object)placement.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm())), new CSVFile.CSVField((Object)placement.getRoomName(",")), new CSVFile.CSVField((Object)leadsSb), new CSVFile.CSVField((Object)(clazz.getSchedulePrintNote() == null ? "" : clazz.getSchedulePrintNote()))});
                    continue;
                }
                file.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)clazz.getCourseName()), new CSVFile.CSVField((Object)clazz.getItypeDesc()), new CSVFile.CSVField((Object)clazz.getSectionNumber()), new CSVFile.CSVField((Object)clazz.getSchedulingSubpart().getSchedulingSubpartSuffix()), new CSVFile.CSVField((Object)clazz.effectiveDatePattern().getName()), new CSVFile.CSVField((Object)placement.getTimeLocation().getDayHeader()), new CSVFile.CSVField((Object)placement.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm())), new CSVFile.CSVField((Object)placement.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm())), new CSVFile.CSVField((Object)placement.getRoomName(",")), new CSVFile.CSVField((Object)leadsSb), new CSVFile.CSVField((Object)(clazz.getSchedulePrintNote() == null ? "" : clazz.getSchedulePrintNote()))});
                continue;
            }
            Class_ clazz = (Class_)((Object)o);
            List<DepartmentalInstructor> leads = clazz.getLeadInstructors();
            StringBuffer leadsSb = new StringBuffer();
            Iterator<DepartmentalInstructor> e = leads.iterator();
            while (e.hasNext()) {
                DepartmentalInstructor instructor = e.next();
                leadsSb.append(instructor.getName(instructorFormat));
                if (!e.hasNext()) continue;
                leadsSb.append(";");
            }
            if (this.isCommited().booleanValue()) {
                file.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)clazz.getCourseName()), new CSVFile.CSVField((Object)clazz.getItypeDesc()), new CSVFile.CSVField((Object)clazz.getSectionNumber()), new CSVFile.CSVField((Object)clazz.getSchedulingSubpart().getSchedulingSubpartSuffix()), new CSVFile.CSVField((Object)clazz.getDivSecNumber()), new CSVFile.CSVField((Object)clazz.effectiveDatePattern().getName()), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)leadsSb), new CSVFile.CSVField((Object)(clazz.getSchedulePrintNote() == null ? "" : clazz.getSchedulePrintNote()))});
                continue;
            }
            file.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)clazz.getCourseName()), new CSVFile.CSVField((Object)clazz.getItypeDesc()), new CSVFile.CSVField((Object)clazz.getSectionNumber()), new CSVFile.CSVField((Object)clazz.getSchedulingSubpart().getSchedulingSubpartSuffix()), new CSVFile.CSVField((Object)clazz.effectiveDatePattern().getName()), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)leadsSb), new CSVFile.CSVField((Object)(clazz.getSchedulePrintNote() == null ? "" : clazz.getSchedulePrintNote()))});
        }
    }

    private void deleteObjects(org.hibernate.Session hibSession, String objectName, String idQuery) {
        Iterator idIterator = hibSession.createQuery(idQuery).setLong("solutionId", this.getUniqueId().longValue()).iterate();
        StringBuffer ids = new StringBuffer();
        int idx = 0;
        while (idIterator.hasNext()) {
            ids.append(idIterator.next());
            if (++idx == 100) {
                hibSession.createQuery("delete " + objectName + " as x where x.uniqueId in (" + ids + ")").executeUpdate();
                ids = new StringBuffer();
                idx = 0;
                continue;
            }
            if (!idIterator.hasNext()) continue;
            ids.append(",");
        }
        if (idx > 0) {
            hibSession.createQuery("delete " + objectName + " as x where x.uniqueId in (" + ids + ")").executeUpdate();
        }
    }

    public void delete(org.hibernate.Session hibSession) {
        try {
            SolutionInfo solutionInfo = this.getSolutionInfo("CBSInfo");
            if (solutionInfo != null) {
                solutionInfo.delete(hibSession);
            }
        }
        catch (Exception e) {
            Debug.error(e);
        }
        hibSession.createQuery("delete StudentEnrollment x where x.solution.uniqueId=:solutionId ").setLong("solutionId", this.getUniqueId().longValue()).executeUpdate();
        hibSession.createQuery("delete JointEnrollment x where x.solution.uniqueId=:solutionId ").setLong("solutionId", this.getUniqueId().longValue()).executeUpdate();
        this.deleteObjects(hibSession, "SolverInfo", "select a.uniqueId from AssignmentInfo a where a.assignment.solution.uniqueId=:solutionId");
        this.deleteObjects(hibSession, "SolverInfo", "select s.uniqueId from SolutionInfo s where s.solution.uniqueId=:solutionId");
        this.deleteObjects(hibSession, "SolverInfo", "select c.uniqueId from ConstraintInfo c inner join c.assignments a where a.solution.uniqueId=:solutionId");
        hibSession.createQuery("delete Assignment x where x.solution.uniqueId=:solutionId ").setLong("solutionId", this.getUniqueId().longValue()).executeUpdate();
        this.deleteObjects(hibSession, "SolverParameter", "select p.uniqueId from Solution s inner join s.parameters p where s.uniqueId=:solutionId");
        this.getOwner().getSolutions().remove(this);
        hibSession.delete((Object)this);
    }

    public void empty(org.hibernate.Session hibSession, TimetableInfoFileProxy proxy) {
        try {
            SolutionInfo solutionInfo = this.getSolutionInfo("CBSInfo");
            if (solutionInfo != null) {
                solutionInfo.delete(hibSession, proxy);
            }
        }
        catch (Exception e) {
            Debug.error(e);
        }
        hibSession.flush();
        hibSession.createQuery("delete StudentEnrollment x where x.solution.uniqueId=:solutionId ").setLong("solutionId", this.getUniqueId().longValue()).executeUpdate();
        hibSession.createQuery("delete JointEnrollment x where x.solution.uniqueId=:solutionId ) ").setLong("solutionId", this.getUniqueId().longValue()).executeUpdate();
        this.deleteObjects(hibSession, "SolverInfo", "select a.uniqueId from AssignmentInfo a where a.assignment.solution.uniqueId=:solutionId");
        this.deleteObjects(hibSession, "SolverInfo", "select s.uniqueId from SolutionInfo s where s.solution.uniqueId=:solutionId");
        this.deleteObjects(hibSession, "SolverInfo", "select c.uniqueId from ConstraintInfo c inner join c.assignments a where a.solution.uniqueId=:solutionId");
        hibSession.createQuery("delete Assignment x where x.solution.uniqueId=:solutionId ) ").setLong("solutionId", this.getUniqueId().longValue()).executeUpdate();
        this.deleteObjects(hibSession, "SolverParameter", "select p.uniqueId from Solution s inner join s.parameters p where s.uniqueId=:solutionId");
        this.setAssignments(null);
        this.setSolutionInfo(null);
        this.setJointEnrollments(null);
        this.setStudentEnrollments(null);
        this.setParameters(null);
        hibSession.saveOrUpdate((Object)this);
        hibSession.flush();
    }

    public void updateCommittedStudentEnrollmentInfos(org.hibernate.Session hibSession) throws Exception {
        SolutionInfo sInfo = this.getSolutionInfo("GlobalInfo");
        if (sInfo != null) {
            PropertiesInfo propInfo = (PropertiesInfo)sInfo.getInfo();
            String conf = propInfo.getProperty("Student conflicts");
            int studentConf = Integer.parseInt(conf.substring(0, conf.indexOf(32)));
            if (conf.indexOf("committed:") >= 0) {
                int commitedStart = conf.indexOf("committed:") + "committed:".length();
                int commitedEnd = conf.indexOf(44, commitedStart);
                int commitedConf = Integer.parseInt(conf.substring(commitedStart, commitedEnd));
                String newConf = studentConf - commitedConf + " [" + conf.substring(commitedEnd + 2);
                propInfo.setProperty("Student conflicts", newConf);
            }
            sInfo.setInfo(propInfo);
            hibSession.saveOrUpdate((Object)sInfo);
        }
    }

    public Session getSession() {
        return this.getOwner().getSession();
    }

    public static Collection findBySessionId(Long sessionId) {
        return new SolutionDAO().getSession().createQuery("select s from Solution s where s.owner.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).list();
    }

    private HashSet takenDivisionNumbers(SchedulingSubpart subpart) {
        HashSet<Integer> divNums = new HashSet<Integer>();
        InstructionalOffering offering = subpart.getInstrOfferingConfig().getInstructionalOffering();
        ItypeDesc itype = subpart.getItype();
        for (InstrOfferingConfig cfg : offering.getInstrOfferingConfigs()) {
            for (SchedulingSubpart s : cfg.getSchedulingSubparts()) {
                if (!s.getItype().equals(itype)) continue;
                for (Class_ clazz : s.getClasses()) {
                    if (clazz.getClassSuffix() == null) continue;
                    Integer divNum = Integer.valueOf(clazz.getClassSuffix().substring(0, 3));
                    divNums.add(divNum);
                }
            }
        }
        return divNums;
    }

    public void createDivSecNumbers(org.hibernate.Session hibSession, Vector messages) {
        Vector<Assignment> assignments = new Vector<Assignment>(this.getAssignments());
        assignments.addAll(new SolutionDAO().getSession().createQuery("select distinct c from Class_ c, Solution s inner join s.owner.departments d where s.uniqueId = :solutionId and c.managingDept=d and c.uniqueId not in (select a.clazz.uniqueId from s.assignments a)").setLong("solutionId", this.getUniqueId().longValue()).list());
        HashSet<InstructionalOffering> relatedOfferings = new HashSet<InstructionalOffering>();
        Enumeration<Assignment> e = assignments.elements();
        while (e.hasMoreElements()) {
            Assignment o = e.nextElement();
            Assignment assignment = o instanceof Assignment ? o : null;
            Class_ clazz = assignment == null ? (Class_)((Object)o) : assignment.getClazz();
            relatedOfferings.add(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering());
        }
        for (InstructionalOffering io : relatedOfferings) {
            for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : ioc.getSchedulingSubparts()) {
                    for (Class_ clazz : subpart.getClasses()) {
                        if (clazz.getClassSuffix() == null || this.getOwner().getDepartments().contains(clazz.getManagingDept())) continue;
                        Assignment assignment = clazz.getCommittedAssignment();
                        assignments.add((Assignment)(assignment == null ? clazz : assignment));
                        clazz.setClassSuffix(null);
                    }
                }
            }
        }
        DivSecAssignmentComparator cmp = new DivSecAssignmentComparator(this, true, false);
        Collections.sort(assignments, cmp);
        BaseAssignment lastAssignment = null;
        BaseSchedulingSubpart lastSubpart = null;
        BaseClass_ lastClazz = null;
        int divNum = 1;
        int secNum = 0;
        HashSet takenDivNums = null;
        HashSet<SchedulingSubpart> recompute = new HashSet<SchedulingSubpart>();
        Enumeration<Assignment> e2 = assignments.elements();
        while (e2.hasMoreElements()) {
            Class_ clazz;
            Assignment o = e2.nextElement();
            Assignment assignment = o instanceof Assignment ? o : null;
            Class_ class_ = clazz = assignment == null ? (Class_)((Object)o) : assignment.getClazz();
            if (clazz.getParentClass() != null && clazz.getSchedulingSubpart().getItype().equals(clazz.getParentClass().getSchedulingSubpart().getItype())) continue;
            if (lastSubpart == null || !lastSubpart.equals(clazz.getSchedulingSubpart())) {
                takenDivNums = this.takenDivisionNumbers(clazz.getSchedulingSubpart());
                lastAssignment = null;
                lastSubpart = null;
                lastClazz = null;
            }
            int nrClasses = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getNrClasses(clazz.getSchedulingSubpart().getItype());
            if (lastAssignment != null && assignment != null) {
                if (nrClasses >= 100 && cmp.compareTimeLocations(lastAssignment.getClazz(), assignment.getClazz(), ((Assignment)lastAssignment).getTimeLocation(), assignment.getTimeLocation()) == 0) {
                    if (lastClazz != null && clazz.getParentClass() != null && !clazz.getParentClass().equals(lastClazz.getParentClass()) && clazz.getParentClass().getDivSecNumber() != null && lastClazz.getParentClass().getDivSecNumber() != null) {
                        if (cmp.compareTimeLocations(lastAssignment.getClazz(), assignment.getClazz(), ((Assignment)lastAssignment).getTimeLocation(), assignment.getTimeLocation()) == 0 && clazz.getParentClass().getDivSecNumber().substring(0, 3).equals(lastClazz.getParentClass().getDivSecNumber().substring(0, 3))) {
                            ++secNum;
                        } else {
                            ++divNum;
                            secNum = 1;
                            while (takenDivNums.contains(new Integer(divNum))) {
                                ++divNum;
                            }
                        }
                    } else {
                        ++secNum;
                    }
                } else {
                    ++divNum;
                    secNum = 1;
                    while (takenDivNums.contains(new Integer(divNum))) {
                        ++divNum;
                    }
                }
            } else if (lastClazz != null) {
                ++divNum;
                secNum = 1;
                while (takenDivNums.contains(new Integer(divNum))) {
                    ++divNum;
                }
            } else {
                divNum = 1;
                secNum = 1;
                while (takenDivNums.contains(new Integer(divNum))) {
                    ++divNum;
                }
            }
            if (divNum == 100 && secNum == 1) {
                sLog.warn((Object)("Division number exceeded 99 for scheduling subpart " + clazz.getSchedulingSubpart().getSchedulingSubpartLabel() + "."));
                for (InstrOfferingConfig cfg : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs()) {
                    for (SchedulingSubpart subpart : cfg.getSchedulingSubparts()) {
                        if (!subpart.getItype().equals(clazz.getSchedulingSubpart().getItype())) continue;
                        recompute.add(subpart);
                    }
                }
            }
            clazz.setClassSuffix(sSufixFormat.format(divNum) + sSufixFormat.format(secNum));
            hibSession.update((Object)clazz);
            lastAssignment = assignment;
            lastSubpart = clazz.getSchedulingSubpart();
            lastClazz = clazz;
        }
        if (!recompute.isEmpty()) {
            Assignment assignment;
            Assignment o;
            HashSet<SchedulingSubpart> recompute2 = new HashSet<SchedulingSubpart>();
            Iterator<Assignment> i = assignments.iterator();
            while (i.hasNext()) {
                Class_ clazz;
                o = i.next();
                assignment = o instanceof Assignment ? o : null;
                Class_ class_ = clazz = assignment == null ? (Class_)((Object)o) : assignment.getClazz();
                if (recompute.contains(clazz.getSchedulingSubpart())) {
                    clazz.setClassSuffix(null);
                    hibSession.update((Object)clazz);
                    continue;
                }
                i.remove();
            }
            cmp = new DivSecAssignmentComparator(this, false, false);
            Collections.sort(assignments, cmp);
            lastAssignment = null;
            lastSubpart = null;
            lastClazz = null;
            Enumeration<Assignment> e3 = assignments.elements();
            while (e3.hasMoreElements()) {
                Class_ clazz;
                o = e3.nextElement();
                assignment = o instanceof Assignment ? o : null;
                Class_ class_ = clazz = assignment == null ? (Class_)((Object)o) : assignment.getClazz();
                if (lastSubpart == null || !lastSubpart.equals(clazz.getSchedulingSubpart())) {
                    takenDivNums = this.takenDivisionNumbers(clazz.getSchedulingSubpart());
                    lastAssignment = null;
                    lastSubpart = null;
                    lastClazz = null;
                }
                if (lastAssignment != null && assignment != null) {
                    if (cmp.compareTimeLocations(lastAssignment.getClazz(), assignment.getClazz(), ((Assignment)lastAssignment).getTimeLocation(), assignment.getTimeLocation()) == 0) {
                        ++secNum;
                    } else {
                        ++divNum;
                        secNum = 1;
                        while (takenDivNums.contains(new Integer(divNum))) {
                            ++divNum;
                        }
                    }
                } else if (lastClazz != null) {
                    ++divNum;
                    secNum = 1;
                    while (takenDivNums.contains(new Integer(divNum))) {
                        ++divNum;
                    }
                } else {
                    divNum = 1;
                    secNum = 1;
                    while (takenDivNums.contains(new Integer(divNum))) {
                        ++divNum;
                    }
                }
                if (divNum == 100 && secNum == 1) {
                    sLog.warn((Object)("Division number still (fallback) exceeded 99 for scheduling subpart " + clazz.getSchedulingSubpart().getSchedulingSubpartLabel() + "."));
                    for (InstrOfferingConfig cfg : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs()) {
                        for (SchedulingSubpart subpart : cfg.getSchedulingSubparts()) {
                            if (!subpart.getItype().equals(clazz.getSchedulingSubpart().getItype())) continue;
                            recompute2.add(subpart);
                        }
                    }
                }
                clazz.setClassSuffix(sSufixFormat.format(divNum) + sSufixFormat.format(secNum));
                hibSession.update((Object)clazz);
                lastAssignment = assignment;
                lastSubpart = clazz.getSchedulingSubpart();
                lastClazz = clazz;
            }
            if (!recompute2.isEmpty()) {
                i = assignments.iterator();
                while (i.hasNext()) {
                    Class_ clazz;
                    o = i.next();
                    assignment = o instanceof Assignment ? o : null;
                    Class_ class_ = clazz = assignment == null ? (Class_)((Object)o) : assignment.getClazz();
                    if (recompute2.contains(clazz.getSchedulingSubpart())) {
                        clazz.setClassSuffix(null);
                        hibSession.update((Object)clazz);
                        continue;
                    }
                    i.remove();
                }
                cmp = new DivSecAssignmentComparator(this, false, true);
                Collections.sort(assignments, cmp);
                lastAssignment = null;
                lastSubpart = null;
                lastClazz = null;
                e3 = assignments.elements();
                while (e3.hasMoreElements()) {
                    Class_ clazz;
                    o = e3.nextElement();
                    assignment = o instanceof Assignment ? o : null;
                    Class_ class_ = clazz = assignment == null ? (Class_)((Object)o) : assignment.getClazz();
                    if (lastSubpart == null || cmp.compareSchedulingSubparts((SchedulingSubpart)lastSubpart, clazz.getSchedulingSubpart()) != 0) {
                        takenDivNums = this.takenDivisionNumbers(clazz.getSchedulingSubpart());
                        lastAssignment = null;
                        lastSubpart = null;
                        lastClazz = null;
                    }
                    if (lastAssignment != null && assignment != null) {
                        if (cmp.compareTimeLocations(lastAssignment.getClazz(), assignment.getClazz(), ((Assignment)lastAssignment).getTimeLocation(), assignment.getTimeLocation()) == 0) {
                            ++secNum;
                        } else {
                            ++divNum;
                            secNum = 1;
                            while (takenDivNums.contains(new Integer(divNum))) {
                                ++divNum;
                            }
                        }
                    } else if (lastClazz != null) {
                        ++divNum;
                        secNum = 1;
                        while (takenDivNums.contains(new Integer(divNum))) {
                            ++divNum;
                        }
                    } else {
                        divNum = 1;
                        secNum = 1;
                        while (takenDivNums.contains(new Integer(divNum))) {
                            ++divNum;
                        }
                    }
                    if (divNum == 100 && secNum == 1) {
                        messages.add("Division number exceeded 99 for scheduling subpart " + clazz.getSchedulingSubpart().getSchedulingSubpartLabel() + ".");
                        sLog.warn((Object)("Division number still (fallback2) exceeded 99 for scheduling subpart " + clazz.getSchedulingSubpart().getSchedulingSubpartLabel() + "."));
                    }
                    clazz.setClassSuffix(sSufixFormat.format(divNum) + sSufixFormat.format(secNum));
                    hibSession.update((Object)clazz);
                    lastAssignment = assignment;
                    lastSubpart = clazz.getSchedulingSubpart();
                    lastClazz = clazz;
                }
            }
        }
    }

    public void removeDivSecNumbers(org.hibernate.Session hibSession) {
        HashSet<Class_> classes = new HashSet<Class_>();
        for (Assignment assignment : this.getAssignments()) {
            Class_ clazz = assignment.getClazz();
            if (clazz == null || clazz.getClassSuffix() == null) continue;
            classes.add(clazz);
        }
        HashSet<SchedulingSubpart> subparts2fix = new HashSet<SchedulingSubpart>();
        for (Class_ clazz : classes) {
            clazz.setClassSuffix(null);
            subparts2fix.add(clazz.getSchedulingSubpart());
            hibSession.update((Object)clazz);
        }
        List otherClasses = new SolutionDAO().getSession().createQuery("select distinct c from Class_ c, Solution s inner join s.owner.departments d where s.uniqueId = :solutionId and c.managingDept=d and c.uniqueId not in (select a.clazz.uniqueId from s.assignments a)").setLong("solutionId", this.getUniqueId().longValue()).list();
        for (Class_ clazz : otherClasses) {
            if (clazz.getClassSuffix() == null) continue;
            clazz.setClassSuffix(null);
            subparts2fix.add(clazz.getSchedulingSubpart());
            hibSession.update((Object)clazz);
        }
        for (SchedulingSubpart subpart : subparts2fix) {
            TreeSet takenDivNums = new TreeSet(this.takenDivisionNumbers(subpart));
            int dec = 0;
            int lastDiv = 0;
            Iterator j = takenDivNums.iterator();
            while (j.hasNext()) {
                int div = (Integer)j.next();
                if ((dec += div - (lastDiv = div) - 1) <= 0) continue;
                sLog.debug((Object)(subpart.getSchedulingSubpartLabel() + ": " + div + "->" + (div - dec)));
                InstructionalOffering offering = subpart.getInstrOfferingConfig().getInstructionalOffering();
                ItypeDesc itype = subpart.getItype();
                for (InstrOfferingConfig cfg : offering.getInstrOfferingConfigs()) {
                    for (SchedulingSubpart s : cfg.getSchedulingSubparts()) {
                        if (!s.getItype().equals(itype)) continue;
                        for (Class_ clazz : s.getClasses()) {
                            if (clazz.getClassSuffix() == null || clazz.getClassSuffix().length() != 6) continue;
                            int clazzDivNum = Integer.parseInt(clazz.getClassSuffix().substring(0, 3));
                            int clazzSecNum = Integer.parseInt(clazz.getClassSuffix().substring(3, 6));
                            if (clazzDivNum != div) continue;
                            clazz.setClassSuffix(sSufixFormat.format(clazzDivNum - dec) + sSufixFormat.format(clazzSecNum));
                            hibSession.update((Object)clazz);
                        }
                    }
                }
            }
        }
    }

    @Override
    public Assignment getAssignment(Long classId) throws Exception {
        if (this.iAssignmentTable == null) {
            this.iAssignmentTable = new Hashtable();
            for (Assignment a : this.getAssignments()) {
                this.iAssignmentTable.put(a.getClassId(), a);
            }
        }
        return (Assignment)this.iAssignmentTable.get(classId);
    }

    @Override
    public Assignment getAssignment(Class_ clazz) throws Exception {
        if (!this.getOwner().getDepartments().contains(clazz.getManagingDept())) {
            return clazz.getCommittedAssignment();
        }
        return this.getAssignment(clazz.getUniqueId());
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Class_ clazz) throws Exception {
        return this.getAssignmentInfo(clazz.getUniqueId());
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Long classId) throws Exception {
        Assignment a = this.getAssignment(classId);
        return a == null ? null : (AssignmentPreferenceInfo)a.getAssignmentInfo("AssignmentInfo");
    }

    @Override
    public Hashtable getAssignmentTable(Collection classesOrClassIds) throws Exception {
        Hashtable<Long, Assignment> assignments = new Hashtable<Long, Assignment>();
        for (Object classOrClassId : classesOrClassIds) {
            Assignment assignment;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((assignment = classOrClassId instanceof Class_ ? this.getAssignment((Class_)classOrClassId) : this.getAssignment((Long)classOrClassId)) == null) continue;
            assignments.put(classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId, assignment);
        }
        return assignments;
    }

    @Override
    public Hashtable getAssignmentInfoTable(Collection classesOrClassIds) throws Exception {
        Hashtable<Long, AssignmentPreferenceInfo> infos = new Hashtable<Long, AssignmentPreferenceInfo>();
        for (Object classOrClassId : classesOrClassIds) {
            AssignmentPreferenceInfo info;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((info = classOrClassId instanceof Class_ ? this.getAssignmentInfo((Class_)classOrClassId) : this.getAssignmentInfo((Long)classOrClassId)) == null) continue;
            infos.put(classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId, info);
        }
        return infos;
    }

    public synchronized DataProperties getProperties() {
        if (this.iPropertiesCache == null) {
            this.iPropertiesCache = new DataProperties();
            for (SolverParameter p : this.getParameters()) {
                this.iPropertiesCache.setProperty(p.getDefinition().getName(), p.getValue());
            }
        }
        return this.iPropertiesCache;
    }

    public static void refreshSolution(Long solutionId) {
        SolutionDAO dao = new SolutionDAO();
        org.hibernate.Session hibSession = dao.getSession();
        SessionFactory hibSessionFactory = hibSession.getSessionFactory();
        hibSessionFactory.getCache().evictEntity(Solution.class, (Serializable)solutionId);
        hibSessionFactory.getCache().evictCollection(Solution.class.getName() + ".parameters", (Serializable)solutionId);
        hibSessionFactory.getCache().evictCollection(Solution.class.getName() + ".assignments", (Serializable)solutionId);
        Iterator i = hibSession.createQuery("select c.uniqueId from Class_ c, Solution s where s.uniqueId=:solutionId and c.managingDept.uniqueId in elements (s.owner.departments)").setLong("solutionId", solutionId.longValue()).iterate();
        while (i.hasNext()) {
            Number classId = (Number)i.next();
            hibSessionFactory.getCache().evictEntity(Class_.class, (Serializable)classId);
            hibSessionFactory.getCache().evictCollection(Class_.class.getName() + ".assignments", (Serializable)classId);
        }
        hibSessionFactory.getCache().evictCollection(SolverGroup.class.getName() + ".solutions", (Serializable)((Long)hibSession.createQuery("select owner.uniqueId from Solution s where s.uniqueId=:solutionId").setLong("solutionId", solutionId.longValue()).uniqueResult()));
    }

    public static boolean hasTimetable(Long sessionId) {
        return ((Number)new SolutionDAO().getSession().createQuery("select count(s) from Solution s where s.owner.session.uniqueId=:sessionId and s.commited = true").setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult()).longValue() > 0L;
    }

    private static class ClassOrAssignmentComparator
    implements Comparator {
        ClassComparator cc = new ClassComparator(5);

        private ClassOrAssignmentComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            Class_ c1 = o1 instanceof Class_ ? (Class_)o1 : ((Assignment)o1).getClazz();
            Class_ c2 = o2 instanceof Class_ ? (Class_)o2 : ((Assignment)o2).getClazz();
            return this.cc.compare(c1, c2);
        }
    }
}

