/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.List;
import java.util.TreeSet;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.base.BaseRoomType;
import org.unitime.timetable.model.dao.RoomTypeDAO;
import org.unitime.timetable.model.dao.RoomTypeOptionDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomType
extends BaseRoomType
implements Comparable<RoomType> {
    private static final long serialVersionUID = 1L;

    public RoomType() {
    }

    public RoomType(Long uniqueId) {
        super(uniqueId);
    }

    public static TreeSet<RoomType> findAll() {
        return new TreeSet<RoomType>(RoomTypeDAO.getInstance().findAll());
    }

    public static TreeSet<RoomType> findAll(Long sessionId) {
        return new TreeSet<RoomType>(RoomTypeDAO.getInstance().getSession().createQuery("select distinct t from Location l inner join l.roomType t where l.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
    }

    public static TreeSet<RoomType> findAll(boolean isRoom) {
        return new TreeSet<RoomType>(RoomTypeDAO.getInstance().getSession().createCriteria(RoomType.class).add((Criterion)Restrictions.eq((String)"room", (Object)isRoom)).setCacheable(true).list());
    }

    public static RoomType findByReference(String ref) {
        return (RoomType)RoomTypeDAO.getInstance().getSession().createCriteria(RoomType.class).add((Criterion)Restrictions.eq((String)"reference", (Object)ref)).setCacheable(true).uniqueResult();
    }

    @Override
    public int compareTo(RoomType t) {
        int cmp = this.getOrd().compareTo(t.getOrd());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getLabel().compareTo(t.getLabel());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(t.getUniqueId() == null ? -1L : t.getUniqueId());
    }

    public RoomTypeOption getOption(Department department) {
        if (department == null) {
            RoomTypeOption opt = new RoomTypeOption(this, department);
            opt.setStatus(RoomTypeOption.getDefaultStatus());
            opt.setBreakTime(ApplicationProperty.RoomDefaultBreakTime.intValue(this.getReference()));
            return opt;
        }
        RoomTypeOption opt = (RoomTypeOption)RoomTypeOptionDAO.getInstance().getSession().createQuery("from RoomTypeOption where department.uniqueId = :departmentId and roomType.uniqueId = :roomTypeId").setLong("departmentId", department.getUniqueId().longValue()).setLong("roomTypeId", this.getUniqueId().longValue()).setCacheable(true).uniqueResult();
        if (opt == null) {
            opt = new RoomTypeOption(this, department);
        }
        if (opt.getStatus() == null) {
            opt.setStatus(RoomTypeOption.getDefaultStatus());
        }
        if (opt.getBreakTime() == null) {
            opt.setBreakTime(ApplicationProperty.RoomDefaultBreakTime.intValue(this.getReference()));
        }
        return opt;
    }

    @Deprecated
    public boolean canScheduleEvents(Long sessionId) {
        for (RoomTypeOption option : (List)RoomTypeDAO.getInstance().getSession().createQuery("select distinct o from " + (this.isRoom() != false ? "Room" : "NonUniversityLocation") + " r, RoomTypeOption o " + "where r.roomType.uniqueId = :roomTypeId and r.session.uniqueId = :sessionId and " + "r.eventDepartment.allowEvents = true and r.eventDepartment = o.department and r.roomType = o.roomType").setLong("roomTypeId", this.getUniqueId().longValue()).setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult()) {
            if (!option.canScheduleEvents()) continue;
            return true;
        }
        return false;
    }

    public int countRooms() {
        return ((Number)RoomTypeDAO.getInstance().getSession().createQuery("select count(distinct r.permanentId) from " + (this.isRoom() != false ? "Room" : "NonUniversityLocation") + " r where r.roomType.uniqueId=:roomTypeId").setLong("roomTypeId", this.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue();
    }

    public int countRooms(Long sessionId) {
        return ((Number)RoomTypeDAO.getInstance().getSession().createQuery("select count(r) from " + (this.isRoom() != false ? "Room" : "NonUniversityLocation") + " r where r.roomType.uniqueId=:roomTypeId and r.session.uniqueId=:sessionId").setLong("roomTypeId", this.getUniqueId().longValue()).setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult()).intValue();
    }

    public int countManagableRooms() {
        return ((Number)RoomTypeDAO.getInstance().getSession().createQuery("select count(distinct r.permanentId) from " + (this.isRoom() != false ? "Room" : "NonUniversityLocation") + " r " + "where r.roomType.uniqueId=:roomTypeId and " + "r.eventDepartment.allowEvents = true").setLong("roomTypeId", this.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue();
    }

    public List<Location> getManagableRooms(Long sessionId) {
        return (List)RoomTypeDAO.getInstance().getSession().createQuery("select r from " + (this.isRoom() != false ? "Room" : "NonUniversityLocation") + " r " + "where r.roomType.uniqueId=:roomTypeId and r.session.uniqueId=:sessionId and " + "r.eventDepartment.allowEvents = true").setLong("roomTypeId", this.getUniqueId().longValue()).setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult();
    }

    public int countManagableRooms(Long sessionId) {
        return ((Number)RoomTypeDAO.getInstance().getSession().createQuery("select count(r) from " + (this.isRoom() != false ? "Room" : "NonUniversityLocation") + " r " + "where r.roomType.uniqueId=:roomTypeId and r.session.uniqueId=:sessionId and " + "r.eventDepartment.allowEvents = true").setLong("roomTypeId", this.getUniqueId().longValue()).setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult()).intValue();
    }

    public int countManagableRoomsOfBuilding(Long buildingId) {
        return ((Number)RoomTypeDAO.getInstance().getSession().createQuery("select count(r) from Room r where r.roomType.uniqueId=:roomTypeId and r.building.uniqueId=:buildingId and r.eventDepartment.allowEvents = true").setLong("roomTypeId", this.getUniqueId().longValue()).setLong("buildingId", buildingId.longValue()).setCacheable(true).uniqueResult()).intValue();
    }
}

