/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseRoomPref;

public class RoomPref
extends BaseRoomPref {
    private static final long serialVersionUID = 1L;

    public RoomPref() {
    }

    public RoomPref(Long uniqueId) {
        super(uniqueId);
    }

    public String preferenceText() {
        return this.getRoom().getLabel();
    }

    public int compareTo(Object o) {
        try {
            RoomPref p = (RoomPref)o;
            int cmp = this.getRoom().getLabel().compareTo(p.getRoom().getLabel());
            if (cmp != 0) {
                return cmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.compareTo(o);
    }

    public Object clone() {
        RoomPref pref = new RoomPref();
        pref.setPrefLevel(this.getPrefLevel());
        pref.setRoom(this.getRoom());
        return pref;
    }

    public boolean isSame(Preference other) {
        if (other == null || !(other instanceof RoomPref)) {
            return false;
        }
        return ToolBox.equals((Object)this.getRoom(), (Object)((RoomPref)other).getRoom());
    }

    public String preferenceHtml() {
        StringBuffer sb = new StringBuffer("<span ");
        String style = "font-weight:bold;";
        if (this.getPrefLevel().getPrefId() != 4) {
            style = style + "color:" + this.getPrefLevel().prefcolor() + ";";
        }
        if (this.getOwner() != null && this.getOwner() instanceof Class_ && ApplicationProperty.PreferencesHighlighClassPreferences.isTrue()) {
            style = style + "background: #ffa;";
        }
        sb.append("style='" + style + "' ");
        String owner = "";
        if (this.getOwner() != null && this.getOwner() instanceof Class_) {
            owner = ", class";
        } else if (this.getOwner() != null && this.getOwner() instanceof SchedulingSubpart) {
            owner = ", scheduling subpart";
        } else if (this.getOwner() != null && this.getOwner() instanceof DepartmentalInstructor) {
            owner = ", instructor";
        } else if (this.getOwner() != null && this.getOwner() instanceof Exam) {
            owner = ", examination";
        } else if (this.getOwner() != null && this.getOwner() instanceof Department) {
            owner = ", department";
        } else if (this.getOwner() != null && this.getOwner() instanceof Session) {
            owner = ", session";
        }
        sb.append("onmouseover=\"showGwtRoomHint(this, '" + this.getRoom().getUniqueId() + "', '" + this.getPrefLevel().getPrefName() + " Room {0} ({1}" + owner + ")');\" onmouseout=\"hideGwtRoomHint();\">");
        sb.append(this.preferenceAbbv());
        sb.append("</span>");
        return sb.toString();
    }

    public String preferenceTitle() {
        return this.getPrefLevel().getPrefName() + " Room " + this.getRoom().getLabel();
    }
}

