/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.hibernate.ObjectNotFoundException;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.webutil.RequiredTimeTable;

public abstract class PreferenceGroup
extends BasePreferenceGroup {
    private static final long serialVersionUID = 1L;

    public PreferenceGroup() {
    }

    public PreferenceGroup(Long uniqueId) {
        super(uniqueId);
    }

    public Set getTimePreferences() {
        return this.getPreferences(TimePref.class);
    }

    public Set getTimePatterns() {
        Set timePrefs = this.getTimePreferences();
        if (timePrefs == null) {
            return null;
        }
        TreeSet<TimePattern> ret = new TreeSet<TimePattern>();
        for (TimePref tp : timePrefs) {
            if (tp.getTimePattern() == null) continue;
            ret.add(tp.getTimePattern());
        }
        return ret;
    }

    public Set getEffectiveTimePreferences() {
        return this.effectivePreferences(TimePref.class);
    }

    public Set effectiveTimePatterns() {
        Set timePrefs = this.getEffectiveTimePreferences();
        if (timePrefs == null) {
            return null;
        }
        TreeSet<TimePattern> ret = new TreeSet<TimePattern>();
        for (TimePref tp : timePrefs) {
            if (tp.getTimePattern() == null) continue;
            ret.add(tp.getTimePattern());
        }
        return ret;
    }

    public Set getRoomPreferences() {
        return this.getPreferences(RoomPref.class);
    }

    public Set getEffectiveRoomPreferences() {
        return this.effectivePreferences(RoomPref.class);
    }

    public Set getBuildingPreferences() {
        return this.getPreferences(BuildingPref.class);
    }

    public Set getEffectiveBuildingPreferences() {
        return this.effectivePreferences(BuildingPref.class);
    }

    public Set getRoomFeaturePreferences() {
        return this.getPreferences(RoomFeaturePref.class);
    }

    public Set getRoomGroupPreferences() {
        return this.getPreferences(RoomGroupPref.class);
    }

    public Set getEffectiveRoomFeaturePreferences() {
        return this.effectivePreferences(RoomFeaturePref.class);
    }

    public Set getDistributionPreferences() {
        return this.getPreferences(DistributionPref.class);
    }

    public Set getEffectiveDistributionPreferences() {
        return this.effectivePreferences(DistributionPref.class);
    }

    private String htmlForPrefs(Assignment assignment, Set prefList, boolean timeVertical, boolean gridAsText, String timeGridSize) {
        StringBuffer sb = new StringBuffer();
        if (prefList != null && !prefList.isEmpty()) {
            if (prefList.toArray()[0] instanceof TimePref) {
                sb.append(this.htmlForTimePrefs(assignment, prefList, timeVertical, gridAsText, timeGridSize));
            } else {
                Iterator it = prefList.iterator();
                Preference aPref = null;
                boolean notFirst = false;
                while (it.hasNext()) {
                    if (notFirst) {
                        sb.append("<BR>");
                    } else {
                        notFirst = true;
                    }
                    aPref = (Preference)it.next();
                    sb.append(aPref.preferenceHtml());
                }
            }
        }
        return sb.toString();
    }

    private String htmlForPrefs(Assignment assignment, Set prefList) {
        return this.htmlForTimePrefs(assignment, prefList, false, false, null);
    }

    private String htmlForTimePrefs(Assignment assignment, Set timePrefList, boolean timeVertical, boolean gridAsText, String timeGridSize) {
        StringBuffer sb = new StringBuffer();
        Iterator i = timePrefList.iterator();
        while (i.hasNext()) {
            TimePref tp = (TimePref)i.next();
            RequiredTimeTable rtt = tp.getRequiredTimeTable(assignment == null ? null : assignment.getTimeLocation());
            String owner = "";
            owner = tp.getOwner() != null && tp.getOwner() instanceof Class_ ? " (class)" : (tp.getOwner() != null && tp.getOwner() instanceof SchedulingSubpart ? " (scheduling subpart)" : (tp.getOwner() != null && tp.getOwner() instanceof DepartmentalInstructor ? " (instructor)" : (tp.getOwner() != null && tp.getOwner() instanceof Exam ? " (examination)" : (tp.getOwner() != null && tp.getOwner() instanceof Department ? " (department)" : (tp.getOwner() != null && tp.getOwner() instanceof Session ? " (session)" : " (combined)")))));
            String hint = rtt.print(false, timeVertical, true, false, rtt.getModel().getName() + owner).replace(");\n</script>", "").replace("<script language=\"javascript\">\ndocument.write(", "").replace("\n", " ");
            if (gridAsText || rtt.getModel().isExactTime()) {
                sb.append("<span onmouseover=\"showGwtHint(this, " + hint + ");\" onmouseout=\"hideGwtHint();\" " + (tp.getOwner() != null && tp.getOwner() instanceof Class_ && ApplicationProperty.PreferencesHighlighClassPreferences.isTrue() ? " style='background: #ffa;'" : "") + ">" + rtt.getModel().toString().replaceAll(", ", "<br>") + "</span>");
            } else {
                rtt.getModel().setDefaultSelection(timeGridSize);
                sb.append("<img border='0' src='pattern?v=" + (timeVertical ? 1 : 0) + "&s=" + rtt.getModel().getDefaultSelection() + "&tp=" + tp.getTimePattern().getUniqueId() + "&p=" + rtt.getModel().getPreferences() + (assignment == null || assignment.getTimeLocation() == null ? "" : "&as=" + assignment.getTimeLocation().getStartSlot() + "&ad=" + assignment.getTimeLocation().getDayCode()) + (tp.getOwner() != null && tp.getOwner() instanceof Class_ && ApplicationProperty.PreferencesHighlighClassPreferences.isTrue() ? "&hc=1" : "") + "' onmouseover=\"showGwtHint(this, " + hint + ");\" onmouseout=\"hideGwtHint();\">&nbsp;");
            }
            if (!i.hasNext()) continue;
            sb.append("<br>");
        }
        return sb.toString();
    }

    public abstract String htmlLabel();

    public String effectiveTimePatternHtml() {
        return new String();
    }

    public String getPrefHtmlForPrefType(Class type) {
        return this.htmlForPrefs(null, this.getPreferences(type));
    }

    public String getEffectivePrefHtmlForPrefType(Class type) {
        return this.htmlForPrefs(null, this.effectivePreferences(type), false, false, null);
    }

    public String getEffectivePrefHtmlForPrefType(Class type, boolean timeVertical, boolean gridAsText, String timeGridSize) {
        return this.htmlForPrefs(null, this.effectivePreferences(type), timeVertical, gridAsText, timeGridSize);
    }

    public String getEffectivePrefHtmlForPrefType(Assignment assignment, Class type, boolean timeVertical, boolean gridAsText, String timeGridSize) {
        return this.htmlForPrefs(assignment, this.effectivePreferences(type), timeVertical, gridAsText, timeGridSize);
    }

    public Class getInstanceOf() {
        return PreferenceGroup.class;
    }

    public Set getPreferences(Class type) {
        return this.getPreferences(type, null);
    }

    public Set getPreferences(Class type, PreferenceGroup appliesTo) {
        TreeSet<Preference> ret = new TreeSet<Preference>();
        Iterator<Preference> i = null;
        try {
            i = this.getPreferences().iterator();
        }
        catch (ObjectNotFoundException e) {
            Debug.error("Exception " + e.getMessage() + " seen for " + this);
            new _RootDAO().getSession().refresh((Object)this);
            i = this.getPreferences() != null ? this.getPreferences().iterator() : null;
        }
        catch (Exception e) {
            i = null;
        }
        if (i == null) {
            return ret;
        }
        while (i.hasNext()) {
            Preference preference = i.next();
            if (appliesTo != null && !preference.appliesTo(appliesTo) || !type.isInstance(preference)) continue;
            ret.add(preference);
        }
        return ret;
    }

    public Set effectivePreferences(Class type, Vector leadInstructors) {
        return this.effectivePreferences(type);
    }

    public Set effectivePreferences(Class type) {
        return this.getPreferences(type, null);
    }

    public DatePattern effectiveDatePattern() {
        return null;
    }

    public Set getAvailableRooms() {
        return new TreeSet();
    }

    public Set getAvailableBuildings() {
        TreeSet<Building> bldgs = new TreeSet<Building>();
        for (Location location : this.getAvailableRooms()) {
            if (!(location instanceof Room)) continue;
            bldgs.add(((Room)location).getBuilding());
        }
        return bldgs;
    }

    public abstract Session getSession();

    public Set getAvailableRoomFeatures() {
        return new TreeSet<GlobalRoomFeature>(RoomFeature.getAllGlobalRoomFeatures(this.getSession()));
    }

    public Set getAvailableRoomGroups() {
        return new TreeSet<RoomGroup>(RoomGroup.getAllGlobalRoomGroups(this.getSession()));
    }

    public Set getExamPeriodPreferences() {
        return this.getPreferences(ExamPeriodPref.class);
    }

    public Set getEffectiveExamPeriodPreferences() {
        return this.effectivePreferences(ExamPeriodPref.class);
    }

    public abstract Department getDepartment();
}

