/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.HashSet;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseNonUniversityLocation;
import org.unitime.timetable.model.dao.NonUniversityLocationDAO;

public class NonUniversityLocation
extends BaseNonUniversityLocation {
    private static final long serialVersionUID = 1L;

    public NonUniversityLocation() {
    }

    public NonUniversityLocation(Long uniqueId) {
        super(uniqueId);
    }

    public String getLabel() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public Object clone() {
        NonUniversityLocation l = new NonUniversityLocation();
        l.setCapacity(this.getCapacity());
        l.setCoordinateX(this.getCoordinateX());
        l.setCoordinateY(this.getCoordinateY());
        l.setArea(this.getArea());
        l.setDisplayName(this.getDisplayName());
        l.setName(this.getName());
        l.setIgnoreRoomCheck(this.isIgnoreRoomCheck());
        l.setIgnoreTooFar(this.isIgnoreTooFar());
        l.setPattern(this.getPattern());
        l.setSession(this.getSession());
        l.setPermanentId(this.getPermanentId());
        l.setExamCapacity(this.getExamCapacity());
        l.setExamTypes(new HashSet<ExamType>(this.getExamTypes()));
        l.setRoomType(this.getRoomType());
        l.setEventStatus(null);
        l.setBreakTime(this.getBreakTime());
        l.setNote(this.getNote());
        l.setEventAvailability(this.getEventAvailability());
        l.setExternalUniqueId(this.getExternalUniqueId());
        l.setShareNote(this.getShareNote());
        return l;
    }

    public NonUniversityLocation findSameNonUniversityLocationInSession(Session newSession) throws Exception {
        if (newSession == null) {
            return null;
        }
        NonUniversityLocation newNonUniversityLocation = null;
        NonUniversityLocationDAO nulDao = new NonUniversityLocationDAO();
        String query = "from NonUniversityLocation nul inner join RoomDept rd where nul.permanentId = '" + this.getPermanentId() + "'";
        query = query + " and nul.session.uniqueId = " + newSession.getUniqueId().toString();
        query = query + " and rd.control = 1";
        query = query + " and rd.department.uniqueId =" + this.getControllingDepartment().getUniqueId();
        newNonUniversityLocation = (NonUniversityLocation)nulDao.getQuery(query).uniqueResult();
        return newNonUniversityLocation;
    }

    public String getRoomTypeLabel() {
        return this.getRoomType().getLabel();
    }
}

