/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.List;
import org.unitime.timetable.model.base.BaseCurriculum;
import org.unitime.timetable.model.dao.CurriculumDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Curriculum
extends BaseCurriculum
implements Comparable<Curriculum> {
    private static final long serialVersionUID = 1L;

    public Curriculum() {
    }

    public Curriculum(Long uniqueId) {
        super(uniqueId);
    }

    public static List<Curriculum> findAll(Long sessionId) {
        return CurriculumDAO.getInstance().getSession().createQuery("select c from Curriculum c where c.department.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public static List<Curriculum> findByDepartment(Long deptId) {
        return CurriculumDAO.getInstance().getSession().createQuery("select c from Curriculum c where c.department.uniqueId=:deptId").setLong("deptId", deptId.longValue()).setCacheable(true).list();
    }

    @Override
    public int compareTo(Curriculum c) {
        int cmp = this.getAbbv().compareToIgnoreCase(c.getAbbv());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(c.getUniqueId() == null ? -1L : c.getUniqueId());
    }
}

