/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseBuildingPref;

public class BuildingPref
extends BaseBuildingPref {
    private static final long serialVersionUID = 1L;

    public BuildingPref() {
    }

    public BuildingPref(Long uniqueId) {
        super(uniqueId);
    }

    public String preferenceText() {
        return this.getBuilding().getAbbreviation();
    }

    public int compareTo(Object o) {
        try {
            BuildingPref p = (BuildingPref)o;
            int cmp = this.getBuilding().getAbbreviation().compareTo(p.getBuilding().getAbbreviation());
            if (cmp != 0) {
                return cmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.compareTo(o);
    }

    public Object clone() {
        BuildingPref pref = new BuildingPref();
        pref.setPrefLevel(this.getPrefLevel());
        pref.setBuilding(this.getBuilding());
        return pref;
    }

    public boolean isSame(Preference other) {
        if (other == null || !(other instanceof BuildingPref)) {
            return false;
        }
        return ToolBox.equals((Object)this.getBuilding(), (Object)((BuildingPref)other).getBuilding());
    }

    public String preferenceHtml() {
        StringBuffer sb = new StringBuffer("<span ");
        String style = "font-weight:bold;";
        if (this.getPrefLevel().getPrefId() != 4) {
            style = style + "color:" + this.getPrefLevel().prefcolor() + ";";
        }
        if (this.getOwner() != null && this.getOwner() instanceof Class_ && ApplicationProperty.PreferencesHighlighClassPreferences.isTrue()) {
            style = style + "background: #ffa;";
        }
        sb.append("style='" + style + "' ");
        String owner = "";
        if (this.getOwner() != null && this.getOwner() instanceof Class_) {
            owner = " (class)";
        } else if (this.getOwner() != null && this.getOwner() instanceof SchedulingSubpart) {
            owner = " (scheduling subpart)";
        } else if (this.getOwner() != null && this.getOwner() instanceof DepartmentalInstructor) {
            owner = " (instructor)";
        } else if (this.getOwner() != null && this.getOwner() instanceof Exam) {
            owner = " (examination)";
        } else if (this.getOwner() != null && this.getOwner() instanceof Department) {
            owner = " (department)";
        } else if (this.getOwner() != null && this.getOwner() instanceof Session) {
            owner = " (session)";
        }
        sb.append("onmouseover=\"showGwtRoomHint(this, '-" + this.getBuilding().getUniqueId() + "', '" + this.getPrefLevel().getPrefName() + " Building {0}" + owner + "');\" onmouseout=\"hideGwtRoomHint();\">");
        sb.append(this.preferenceAbbv());
        sb.append("</span>");
        return sb.toString();
    }

    public String preferenceTitle() {
        return this.getPrefLevel().getPrefName() + " Building " + this.getBuilding().getName();
    }
}

