/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonInterface
implements Comparable<PersonInterface>,
IsSerializable {
    private String iId;
    private String iFName;
    private String iMName;
    private String iLName;
    private String iEmail;
    private String iPhone;
    private String iDept;
    private String iPos;
    private String iSource;
    private String iTitle;
    private String iFormattedName = null;

    public PersonInterface() {
    }

    public PersonInterface(String id, String fname, String mname, String lname, String title, String email, String phone, String dept, String pos, String source) {
        this.iId = id;
        this.iSource = source;
        this.iFName = fname;
        this.iMName = mname;
        this.iLName = lname;
        this.iTitle = title;
        if (this.iMName != null && this.iFName != null && this.iMName.indexOf(this.iFName) >= 0) {
            this.iMName = this.iMName.replaceAll(this.iFName + " ?", "");
        }
        if (this.iMName != null && this.iLName != null && this.iMName.indexOf(this.iLName) >= 0) {
            this.iMName = this.iMName.replaceAll(" ?" + this.iLName, "");
        }
        this.iEmail = email;
        this.iPhone = phone;
        this.iDept = dept;
        this.iPos = pos;
    }

    public String getId() {
        return this.iId;
    }

    public void setId(String id) {
        this.iId = id;
    }

    public String getSource() {
        return this.iSource;
    }

    public void setSource(String source) {
        this.iSource = source;
    }

    public String getFirstName() {
        return this.iFName;
    }

    public void setFirstName(String fname) {
        this.iFName = fname;
    }

    public String getMiddleName() {
        return this.iMName;
    }

    public void setMiddleName(String mname) {
        this.iMName = mname;
    }

    public String getLastName() {
        return this.iLName;
    }

    public void setLastName(String lname) {
        this.iLName = lname;
    }

    public String getName() {
        return this.iFormattedName != null ? this.iFormattedName : ((this.iLName == null || this.iLName.isEmpty() ? "" : this.iLName) + (this.iFName == null || this.iFName.isEmpty() ? "" : ", " + this.iFName) + (this.iMName == null || this.iMName.isEmpty() ? "" : " " + this.iMName)).trim();
    }

    public String getShortName() {
        String name = "";
        if (this.iFName != null && !this.iFName.isEmpty()) {
            name = name + this.iFName.substring(0, 1) + " ";
        }
        if (this.iMName != null && !this.iMName.isEmpty()) {
            name = name + this.iMName.substring(0, 1) + " ";
        }
        if (this.iLName != null && !this.iLName.isEmpty()) {
            name = name + this.iLName;
        }
        return name.trim();
    }

    public String getPhone() {
        return this.iPhone;
    }

    public void setPhone(String phone) {
        this.iPhone = phone;
    }

    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    public String getDepartment() {
        return this.iDept;
    }

    public void setDepartment(String dept) {
        this.iDept = dept;
    }

    public String getPosition() {
        return this.iPos;
    }

    public void setPosition(String pos) {
        this.iPos = pos;
    }

    public String getAcademicTitle() {
        return this.iTitle;
    }

    public void setAcademicTitle(String title) {
        this.iTitle = title;
    }

    @Override
    public int compareTo(PersonInterface p) {
        int cmp = (this.getLastName() == null ? "" : this.getLastName()).compareToIgnoreCase(p.getLastName() == null ? "" : p.getLastName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = (this.getFirstName() == null ? "" : this.getFirstName()).compareToIgnoreCase(p.getFirstName() == null ? "" : p.getFirstName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = (this.getMiddleName() == null ? "" : this.getMiddleName()).compareToIgnoreCase(p.getMiddleName() == null ? "" : p.getMiddleName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getSource().compareToIgnoreCase(p.getSource());
        if (cmp != 0) {
            return cmp;
        }
        if (this.getId() != null) {
            return this.getId().compareTo(p.getId());
        }
        if (this.getId() == null && p.getId() == null) {
            return 0;
        }
        return 1;
    }

    public void merge(PersonInterface person) {
        if (this.iId == null || this.iId.isEmpty()) {
            this.iId = person.getId();
        }
        if (this.iFName == null || this.iFName.isEmpty()) {
            this.iFName = person.getFirstName();
        }
        if (this.iMName == null || this.iMName.isEmpty()) {
            this.iMName = person.getMiddleName();
        }
        if (this.iLName == null || this.iLName.isEmpty()) {
            this.iLName = person.getLastName();
        }
        if (this.iTitle == null || this.iTitle.isEmpty()) {
            this.iTitle = person.getAcademicTitle();
        }
        if (this.iEmail == null || this.iEmail.isEmpty()) {
            this.iEmail = person.getEmail();
        }
        if (this.iPhone == null || this.iPhone.isEmpty()) {
            this.iPhone = person.getPhone();
        }
        if (this.iDept == null || this.iDept.isEmpty()) {
            this.iDept = person.getDepartment();
        }
        if (!this.iSource.contains(person.getSource())) {
            this.iSource = this.iSource + ", " + person.getSource();
        }
    }

    public void setFormattedName(String name) {
        this.iFormattedName = name;
    }

    public boolean hasFormattedName() {
        return this.iFormattedName != null && !this.iFormattedName.isEmpty();
    }

    public String getFormattedName() {
        return this.iFormattedName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LookupRequest
    implements GwtRpcRequest<GwtRpcResponseList<PersonInterface>> {
        private String iQuery;
        private String iOptions;

        public LookupRequest() {
        }

        public LookupRequest(String query, String options) {
            this.iQuery = query;
            this.iOptions = options;
        }

        public String getQuery() {
            return this.iQuery;
        }

        public void setQuery(String query) {
            this.iQuery = query;
        }

        public String getOptions() {
            return this.iOptions;
        }

        public void setOptions(String options) {
            this.iOptions = options;
        }

        public boolean hasOptions() {
            return this.iOptions != null && !this.iOptions.isEmpty();
        }

        @Override
        public String toString() {
            return this.getQuery() + (this.hasOptions() ? " (" + this.getOptions() + ")" : "");
        }
    }
}

