/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.shared.EventInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculumInterface
implements IsSerializable,
Comparable<CurriculumInterface> {
    private Long iId;
    private String iAbbv;
    private String iName;
    private boolean iEditable = false;
    private String iLastChange = null;
    private AcademicAreaInterface iAcademicArea;
    private TreeSet<MajorInterface> iMajors;
    private DepartmentInterface iDept;
    private TreeSet<CurriculumClassificationInterface> iClasf;
    private TreeSet<CourseInterface> iCourses;

    public Long getId() {
        return this.iId;
    }

    public void setId(Long id) {
        this.iId = id;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    public String getLastChange() {
        return this.iLastChange;
    }

    public void setLastChange(String lastChange) {
        this.iLastChange = lastChange;
    }

    public boolean hasLastChange() {
        return this.iLastChange != null && !this.iLastChange.isEmpty();
    }

    public AcademicAreaInterface getAcademicArea() {
        return this.iAcademicArea;
    }

    public void setAcademicArea(AcademicAreaInterface area) {
        this.iAcademicArea = area;
    }

    public TreeSet<MajorInterface> getMajors() {
        return this.iMajors;
    }

    public boolean hasMajors() {
        return this.iMajors != null && !this.iMajors.isEmpty();
    }

    public void addMajor(MajorInterface major) {
        if (this.iMajors == null) {
            this.iMajors = new TreeSet();
        }
        this.iMajors.add(major);
    }

    public String getMajorNames(String delim) {
        String ret = "";
        if (this.iMajors == null) {
            return ret;
        }
        for (MajorInterface major : this.iMajors) {
            if (!ret.isEmpty()) {
                ret = ret + delim;
            }
            ret = ret + major.getName();
        }
        return ret;
    }

    public String getMajorCodes(String delim) {
        String ret = "";
        if (this.iMajors == null) {
            return ret;
        }
        for (MajorInterface major : this.iMajors) {
            if (!ret.isEmpty()) {
                ret = ret + delim;
            }
            ret = ret + major.getCode();
        }
        return ret;
    }

    public String getCodeMajorNames(String delim) {
        String ret = "";
        if (this.iMajors == null) {
            return ret;
        }
        for (MajorInterface major : this.iMajors) {
            if (!ret.isEmpty()) {
                ret = ret + delim;
            }
            ret = ret + major.getCode() + " - " + major.getName();
        }
        return ret;
    }

    public DepartmentInterface getDepartment() {
        return this.iDept;
    }

    public void setDepartment(DepartmentInterface dept) {
        this.iDept = dept;
    }

    public TreeSet<CurriculumClassificationInterface> getClassifications() {
        return this.iClasf;
    }

    public boolean hasClassifications() {
        return this.iClasf != null;
    }

    public void addClassification(CurriculumClassificationInterface clasf) {
        if (this.iClasf == null) {
            this.iClasf = new TreeSet();
        }
        this.iClasf.add(clasf);
    }

    public TreeSet<CourseInterface> getCourses() {
        return this.iCourses;
    }

    public boolean hasCourses() {
        return this.iCourses != null && !this.iCourses.isEmpty();
    }

    public void addCourse(CourseInterface course) {
        if (this.iCourses == null) {
            this.iCourses = new TreeSet();
        }
        this.iCourses.add(course);
    }

    public Integer getExpected() {
        if (!this.hasClassifications()) {
            return null;
        }
        int ret = 0;
        for (CurriculumClassificationInterface c : this.getClassifications()) {
            ret += c.getExpected() == null ? 0 : c.getExpected();
        }
        return ret;
    }

    public Integer getEnrollment() {
        if (!this.hasClassifications()) {
            return null;
        }
        int ret = 0;
        for (CurriculumClassificationInterface c : this.getClassifications()) {
            ret += c.getEnrollment() == null ? 0 : c.getEnrollment();
        }
        return ret;
    }

    public Integer getLastLike() {
        if (!this.hasClassifications()) {
            return null;
        }
        int ret = 0;
        for (CurriculumClassificationInterface c : this.getClassifications()) {
            ret += c.getLastLike() == null ? 0 : c.getLastLike();
        }
        return ret;
    }

    public Integer getProjection() {
        if (!this.hasClassifications()) {
            return null;
        }
        int ret = 0;
        for (CurriculumClassificationInterface c : this.getClassifications()) {
            ret += c.getProjection() == null ? 0 : c.getProjection();
        }
        return ret;
    }

    public Integer getRequested() {
        if (!this.hasClassifications()) {
            return null;
        }
        int ret = 0;
        for (CurriculumClassificationInterface c : this.getClassifications()) {
            ret += c.getRequested() == null ? 0 : c.getRequested();
        }
        return ret;
    }

    public String getExpectedString() {
        if (!this.hasClassifications()) {
            return "?";
        }
        Integer count = this.getExpected();
        return count == null ? "N/A" : count.toString();
    }

    public String getLastLikeString() {
        if (!this.hasClassifications()) {
            return "?";
        }
        Integer count = this.getLastLike();
        return count == null ? "N/A" : count.toString();
    }

    public String getProjectionString() {
        if (!this.hasClassifications()) {
            return "?";
        }
        Integer count = this.getProjection();
        return count == null ? "N/A" : count.toString();
    }

    public String getEnrollmentString() {
        if (!this.hasClassifications()) {
            return "?";
        }
        Integer count = this.getEnrollment();
        return count == null ? "N/A" : count.toString();
    }

    public String getRequestedString() {
        if (!this.hasClassifications()) {
            return "?";
        }
        Integer count = this.getRequested();
        return count == null ? "N/A" : count.toString();
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    public boolean isEditable() {
        return this.iEditable;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CurriculumInterface)) {
            return false;
        }
        return this.getId().equals(((CurriculumInterface)o).getId());
    }

    public int hashCode() {
        return this.getId() == null ? 0 : this.getId().hashCode();
    }

    @Override
    public int compareTo(CurriculumInterface curriculum) {
        int cmp = this.getAbbv().compareTo(curriculum.getAbbv());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getId() == null ? new Long(-1L) : this.getId()).compareTo(curriculum.getId() == null ? -1L : curriculum.getId());
    }

    public static class CurriculumFilterRpcRequest
    extends EventInterface.FilterRpcRequest {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CurriculumStudentsInterface
    implements IsSerializable {
        private Set<Long> iEnrollment = null;
        private Set<Long> iRequested = null;
        private HashMap<String, Set<Long>> iLastLike = null;
        private HashMap<String, Float> iProjection = null;

        public int getEnrollment() {
            return this.iEnrollment == null || this.iEnrollment.isEmpty() ? 0 : this.iEnrollment.size();
        }

        public int getLastLike() {
            if (this.iLastLike == null || this.iLastLike.isEmpty()) {
                return 0;
            }
            int lastLike = 0;
            for (Map.Entry<String, Set<Long>> entry : this.iLastLike.entrySet()) {
                lastLike += entry.getValue().size();
            }
            return lastLike;
        }

        public int getProjection() {
            if (this.iLastLike == null || this.iLastLike.isEmpty()) {
                return 0;
            }
            float proj = 0.0f;
            for (Map.Entry<String, Set<Long>> entry : this.iLastLike.entrySet()) {
                Float f;
                Float f2 = f = this.iProjection == null ? null : this.iProjection.get(entry.getKey());
                if (f == null && this.iProjection != null) {
                    f = this.iProjection.get("");
                }
                proj += (f == null ? 1.0f : f.floatValue()) * (float)entry.getValue().size();
            }
            return Math.round(proj);
        }

        public int getRequested() {
            return this.iRequested == null || this.iRequested.isEmpty() ? 0 : this.iRequested.size();
        }

        public Set<Long> getEnrolledStudents() {
            return this.iEnrollment;
        }

        public Set<Long> getLastLikeStudents() {
            if (this.iLastLike == null || this.iLastLike.isEmpty()) {
                return null;
            }
            if (this.iLastLike.size() == 1) {
                return this.iLastLike.values().iterator().next();
            }
            HashSet<Long> lastLike = new HashSet<Long>();
            for (Map.Entry<String, Set<Long>> entry : this.iLastLike.entrySet()) {
                lastLike.addAll((Collection<Long>)entry.getValue());
            }
            return lastLike;
        }

        public Set<Long> getProjectedStudents() {
            return this.getLastLikeStudents();
        }

        public int countProjectedStudents(Set<Long> students) {
            if (this.iLastLike == null || this.iLastLike.isEmpty()) {
                return 0;
            }
            float proj = 0.0f;
            for (Map.Entry<String, Set<Long>> entry : this.iLastLike.entrySet()) {
                Float f;
                int share = 0;
                for (Long student : entry.getValue()) {
                    if (!students.contains(student)) continue;
                    ++share;
                }
                if (share <= 0) continue;
                Float f2 = f = this.iProjection == null ? null : this.iProjection.get(entry.getKey());
                if (f == null && this.iProjection != null) {
                    f = this.iProjection.get("");
                }
                proj += (f == null ? 1.0f : f.floatValue()) * (float)share;
            }
            return Math.round(proj);
        }

        public Set<Long> getRequestedStudents() {
            return this.iRequested;
        }

        public void setEnrolledStudents(Set<Long> students) {
            this.iEnrollment = students;
        }

        public void setLastLikeStudents(HashMap<String, Set<Long>> students) {
            this.iLastLike = students;
        }

        public void setProjection(HashMap<String, Float> projection) {
            this.iProjection = projection;
        }

        public void setRequestedStudents(Set<Long> students) {
            this.iRequested = students;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CurriculumCourseGroupInterface
    implements IsSerializable,
    Comparable<CurriculumCourseGroupInterface> {
        private Long iId;
        private String iName;
        private String iColor;
        private int iType;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getColor() {
            return this.iColor;
        }

        public void setColor(String color) {
            this.iColor = color;
        }

        public int getType() {
            return this.iType;
        }

        public void setType(int type) {
            this.iType = type;
        }

        public int hashCode() {
            return this.iName.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CurriculumCourseGroupInterface)) {
                return false;
            }
            return this.getName().equals(((CurriculumCourseGroupInterface)o).getName());
        }

        @Override
        public int compareTo(CurriculumCourseGroupInterface g) {
            return this.getName().compareTo(g.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CurriculumCourseInterface
    implements IsSerializable,
    Comparable<CurriculumCourseInterface> {
        private Long iId;
        private Long iCourseId;
        private Long iClasfId;
        private String iCourseName;
        private float iShare = 0.0f;
        private Integer iLastLike = null;
        private Integer iEnrollment = null;
        private Integer iProjection = null;
        private Integer iRequested = null;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public Long getCourseOfferingId() {
            return this.iCourseId;
        }

        public void setCourseOfferingId(Long courseId) {
            this.iCourseId = courseId;
        }

        public Long getCurriculumClassificationId() {
            return this.iClasfId;
        }

        public void setCurriculumClassificationId(Long clasfId) {
            this.iClasfId = clasfId;
        }

        public String getCourseName() {
            return this.iCourseName;
        }

        public void setCourseName(String courseName) {
            this.iCourseName = courseName;
        }

        public float getShare() {
            return this.iShare;
        }

        public void setShare(float share) {
            this.iShare = share;
        }

        public Integer getLastLike() {
            return this.iLastLike;
        }

        public void setLastLike(Integer lastLike) {
            this.iLastLike = lastLike;
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }

        public Integer getRequested() {
            return this.iRequested;
        }

        public void setRequested(Integer requested) {
            this.iRequested = requested;
        }

        public Integer getProjection() {
            return this.iProjection;
        }

        public void setProjection(Integer projection) {
            this.iProjection = projection;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CurriculumCourseInterface)) {
                return false;
            }
            return this.getId().equals(((CurriculumCourseInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(CurriculumCourseInterface course) {
            return this.getCourseName().compareTo(course.getCourseName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CourseInterface
    implements IsSerializable,
    Comparable<CourseInterface> {
        private Long iCourseId;
        private String iCourseName;
        private List<CurriculumCourseInterface> iCurriculumCourses;
        private TreeSet<CurriculumCourseGroupInterface> iGroups;

        public Long getId() {
            return this.iCourseId;
        }

        public void setId(Long id) {
            this.iCourseId = id;
        }

        public String getCourseName() {
            return this.iCourseName;
        }

        public void setCourseName(String courseName) {
            this.iCourseName = courseName;
        }

        public boolean hasCurriculumCourses() {
            return this.iCurriculumCourses != null && !this.iCurriculumCourses.isEmpty();
        }

        public void setCurriculumCourse(int idx, CurriculumCourseInterface course) {
            if (this.iCurriculumCourses == null) {
                this.iCurriculumCourses = new ArrayList<CurriculumCourseInterface>();
            }
            if (idx < this.iCurriculumCourses.size()) {
                this.iCurriculumCourses.set(idx, course);
            } else {
                while (this.iCurriculumCourses.size() < idx) {
                    this.iCurriculumCourses.add(null);
                }
                this.iCurriculumCourses.add(course);
            }
        }

        public CurriculumCourseInterface getCurriculumCourse(int idx) {
            if (this.iCurriculumCourses == null || idx >= this.iCurriculumCourses.size()) {
                return null;
            }
            return this.iCurriculumCourses.get(idx);
        }

        public List<CurriculumCourseInterface> getCurriculumCourses() {
            return this.iCurriculumCourses;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CourseInterface)) {
                return false;
            }
            return this.getId().equals(((CourseInterface)o).getId());
        }

        public boolean hasGroups() {
            return this.iGroups != null && !this.iGroups.isEmpty();
        }

        public void addGroup(CurriculumCourseGroupInterface group) {
            if (this.iGroups == null) {
                this.iGroups = new TreeSet();
            }
            this.iGroups.add(group);
        }

        public TreeSet<CurriculumCourseGroupInterface> getGroups() {
            return this.iGroups;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        private int firstClassification() {
            if (!this.hasCurriculumCourses()) {
                return -1;
            }
            for (int i = 0; i < this.iCurriculumCourses.size(); ++i) {
                CurriculumCourseInterface c = this.iCurriculumCourses.get(i);
                if (c == null || !(c.getShare() > 0.0f)) continue;
                return i;
            }
            return this.iCurriculumCourses.size();
        }

        private int highestClassification() {
            if (!this.hasCurriculumCourses()) {
                return -1;
            }
            int best = this.iCurriculumCourses.size();
            double bestShare = -1.0;
            for (int i = 0; i < this.iCurriculumCourses.size(); ++i) {
                CurriculumCourseInterface c = this.iCurriculumCourses.get(i);
                if (c == null || !((double)c.getShare() > bestShare)) continue;
                bestShare = c.getShare();
                best = i;
            }
            return best;
        }

        @Override
        public int compareTo(CourseInterface course) {
            if (this.hasCurriculumCourses()) {
                int cmp;
                CurriculumCourseInterface d;
                CurriculumCourseInterface c;
                int b;
                int a = this.highestClassification();
                if (a < (b = course.highestClassification())) {
                    return -1;
                }
                if (a > b) {
                    return 1;
                }
                if (a <= this.iCurriculumCourses.size()) {
                    c = this.getCurriculumCourse(a);
                    d = course.getCurriculumCourse(a);
                    cmp = Double.compare(d == null ? 0.0 : (double)d.getShare(), c == null ? 0.0 : (double)c.getShare());
                    if (cmp != 0) {
                        return cmp;
                    }
                }
                if ((a = this.firstClassification()) < (b = course.firstClassification())) {
                    return -1;
                }
                if (a > b) {
                    return 1;
                }
                while (a <= this.iCurriculumCourses.size()) {
                    c = this.getCurriculumCourse(a);
                    d = course.getCurriculumCourse(a);
                    cmp = Double.compare(d == null ? 0.0 : (double)d.getShare(), c == null ? 0.0 : (double)c.getShare());
                    if (cmp != 0) {
                        return cmp;
                    }
                    ++a;
                }
            }
            return this.getCourseName().compareTo(course.getCourseName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CurriculumClassificationInterface
    implements IsSerializable,
    Comparable<CurriculumClassificationInterface> {
        private Long iCurriculumId;
        private Long iClasfId;
        private String iName;
        private Integer iNrStudents = null;
        private Integer iEnrollment = null;
        private Integer iLastLike = null;
        private Integer iProjection = null;
        private Integer iRequested = null;
        private AcademicClassificationInterface iClasf;
        private TreeSet<CurriculumCourseInterface> iCourses = null;

        public Long getId() {
            return this.iClasfId;
        }

        public void setId(Long id) {
            this.iClasfId = id;
        }

        public Long getCurriculumId() {
            return this.iCurriculumId;
        }

        public void setCurriculumId(Long curriculumId) {
            this.iCurriculumId = curriculumId;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public Integer getExpected() {
            return this.iNrStudents;
        }

        public void setExpected(Integer nrStudents) {
            this.iNrStudents = nrStudents;
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }

        public Integer getRequested() {
            return this.iRequested;
        }

        public void setRequested(Integer requested) {
            this.iRequested = requested;
        }

        public Integer getLastLike() {
            return this.iLastLike;
        }

        public void setLastLike(Integer lastLike) {
            this.iLastLike = lastLike;
        }

        public Integer getProjection() {
            return this.iProjection;
        }

        public void setProjection(Integer projection) {
            this.iProjection = projection;
        }

        public AcademicClassificationInterface getAcademicClassification() {
            return this.iClasf;
        }

        public void setAcademicClassification(AcademicClassificationInterface clasf) {
            this.iClasf = clasf;
        }

        public TreeSet<CurriculumCourseInterface> getCourses() {
            return this.iCourses;
        }

        public boolean hasCourses() {
            return this.iCourses != null && !this.iCourses.isEmpty();
        }

        public void addCourse(CurriculumCourseInterface course) {
            if (this.iCourses == null) {
                this.iCourses = new TreeSet();
            }
            this.iCourses.add(course);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CurriculumClassificationInterface)) {
                return false;
            }
            return this.getId().equals(((CurriculumClassificationInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(CurriculumClassificationInterface clasf) {
            return this.getAcademicClassification().compareTo(clasf.getAcademicClassification());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcademicClassificationInterface
    implements IsSerializable,
    Comparable<AcademicClassificationInterface> {
        private Long iClasfId;
        private String iClasfCode;
        private String iClasfName;

        public Long getId() {
            return this.iClasfId;
        }

        public void setId(Long id) {
            this.iClasfId = id;
        }

        public String getCode() {
            return this.iClasfCode;
        }

        public void setCode(String code) {
            this.iClasfCode = code;
        }

        public String getName() {
            return this.iClasfName;
        }

        public void setName(String name) {
            this.iClasfName = name;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof AcademicClassificationInterface)) {
                return false;
            }
            return this.getId().equals(((AcademicClassificationInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(AcademicClassificationInterface clasf) {
            int cmp = this.getCode().compareTo(clasf.getCode());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getName().compareTo(clasf.getName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId().compareTo(clasf.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DepartmentInterface
    implements IsSerializable,
    Comparable<DepartmentInterface> {
        private Long iDeptId;
        private String iDeptCode;
        private String iDeptAbbv;
        private String iDeptName;

        public Long getId() {
            return this.iDeptId;
        }

        public void setId(Long id) {
            this.iDeptId = id;
        }

        public String getCode() {
            return this.iDeptCode;
        }

        public void setCode(String code) {
            this.iDeptCode = code;
        }

        public String getAbbv() {
            return this.iDeptAbbv;
        }

        public void setAbbv(String abbv) {
            this.iDeptAbbv = abbv;
        }

        public String getName() {
            return this.iDeptName;
        }

        public void setName(String name) {
            this.iDeptName = name;
        }

        public String getLabel() {
            return this.iDeptCode + " - " + this.iDeptName;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof DepartmentInterface)) {
                return false;
            }
            return this.getId().equals(((DepartmentInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(DepartmentInterface dept) {
            int cmp = this.getLabel().compareTo(dept.getLabel());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId().compareTo(dept.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MajorInterface
    implements IsSerializable,
    Comparable<MajorInterface> {
        private Long iMajorId;
        private String iMajorCode;
        private String iMajorName;

        public Long getId() {
            return this.iMajorId;
        }

        public void setId(Long id) {
            this.iMajorId = id;
        }

        public String getCode() {
            return this.iMajorCode;
        }

        public void setCode(String code) {
            this.iMajorCode = code;
        }

        public String getName() {
            return this.iMajorName;
        }

        public void setName(String name) {
            this.iMajorName = name;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof MajorInterface)) {
                return false;
            }
            return this.getId().equals(((MajorInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(MajorInterface major) {
            int cmp;
            if (this.getCode() != null && (cmp = this.getCode().compareTo(major.getCode())) != 0) {
                return cmp;
            }
            return this.getId().compareTo(major.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcademicAreaInterface
    implements IsSerializable,
    Comparable<AcademicAreaInterface> {
        private Long iAreaId;
        private String iAreaAbbv;
        private String iAreaName;

        public Long getId() {
            return this.iAreaId;
        }

        public void setId(Long id) {
            this.iAreaId = id;
        }

        public String getAbbv() {
            return this.iAreaAbbv;
        }

        public void setAbbv(String abbv) {
            this.iAreaAbbv = abbv;
        }

        public String getName() {
            return this.iAreaName;
        }

        public void setName(String name) {
            this.iAreaName = name;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof AcademicAreaInterface)) {
                return false;
            }
            return this.getId().equals(((AcademicAreaInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(AcademicAreaInterface area) {
            int cmp = this.getAbbv().compareTo(area.getAbbv());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId().compareTo(area.getId());
        }
    }
}

