/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseRequestInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long iSessionId;
    private Long iStudentId;
    private ArrayList<Request> iCourses = new ArrayList();
    private ArrayList<Request> iAlternatives = new ArrayList();
    private boolean iSaved = false;
    private boolean iNoChange = false;

    public Long getAcademicSessionId() {
        return this.iSessionId;
    }

    public void setAcademicSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public void setStudentId(Long studentId) {
        this.iStudentId = studentId;
    }

    public ArrayList<Request> getCourses() {
        return this.iCourses;
    }

    public ArrayList<Request> getAlternatives() {
        return this.iAlternatives;
    }

    public boolean isSaved() {
        return this.iSaved;
    }

    public void setSaved(boolean saved) {
        this.iSaved = saved;
    }

    public boolean isNoChange() {
        return this.iNoChange;
    }

    public void setNoChange(boolean noChange) {
        this.iNoChange = noChange;
    }

    public String toString() {
        String ret = "CourseRequests(student = " + this.iStudentId + ", session = " + this.iSessionId + ", requests = {";
        int idx = 1;
        for (Request r : this.iCourses) {
            ret = ret + "\n   " + idx++ + ". " + r;
        }
        idx = 1;
        for (Request r : this.iAlternatives) {
            ret = ret + "\n  A" + idx++ + ". " + r;
        }
        return ret + "\n})";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Request
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ArrayList<FreeTime> iRequestedFreeTime = null;
        private String iRequestedCourse = null;
        private String iFirstAlternative = null;
        private String iSecondAlternative = null;
        private Boolean iWaitList = false;

        public String getRequestedCourse() {
            return this.iRequestedCourse;
        }

        public void setRequestedCourse(String requestedCourse) {
            this.iRequestedCourse = requestedCourse;
        }

        public boolean hasRequestedCourse() {
            return this.iRequestedCourse != null && !this.iRequestedCourse.isEmpty();
        }

        public ArrayList<FreeTime> getRequestedFreeTime() {
            return this.iRequestedFreeTime;
        }

        public void addRequestedFreeTime(FreeTime ft) {
            if (this.iRequestedFreeTime == null) {
                this.iRequestedFreeTime = new ArrayList();
            }
            this.iRequestedFreeTime.add(ft);
        }

        public boolean hasRequestedFreeTime() {
            return this.iRequestedFreeTime != null && !this.iRequestedFreeTime.isEmpty();
        }

        public String getFirstAlternative() {
            return this.iFirstAlternative;
        }

        public void setFirstAlternative(String firstAlternative) {
            this.iFirstAlternative = firstAlternative;
        }

        public boolean hasFirstAlternative() {
            return this.iFirstAlternative != null && !this.iFirstAlternative.isEmpty();
        }

        public String getSecondAlternative() {
            return this.iSecondAlternative;
        }

        public void setSecondAlternative(String secondAlternative) {
            this.iSecondAlternative = secondAlternative;
        }

        public boolean hasSecondAlternative() {
            return this.iSecondAlternative != null && !this.iSecondAlternative.isEmpty();
        }

        public boolean hasWaitList() {
            return this.iWaitList != null;
        }

        public boolean isWaitList() {
            return this.iWaitList != null && this.iWaitList != false;
        }

        public void setWaitList(Boolean waitList) {
            this.iWaitList = waitList;
        }

        public String toString() {
            return (this.hasRequestedFreeTime() ? this.iRequestedFreeTime.toString() : (this.hasRequestedCourse() ? this.iRequestedCourse : "-")) + (this.hasFirstAlternative() ? ", " + this.iFirstAlternative : "") + (this.hasSecondAlternative() ? ", " + this.iSecondAlternative : "") + (this.isWaitList() ? " (w)" : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FreeTime
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ArrayList<Integer> iDays = new ArrayList();
        private int iStart;
        private int iLength;

        public void addDay(int day) {
            this.iDays.add(day);
        }

        public ArrayList<Integer> getDays() {
            return this.iDays;
        }

        public String getDaysString(String[] shortDays, String separator) {
            if (this.iDays == null) {
                return "";
            }
            String ret = "";
            for (int day : this.iDays) {
                ret = ret + (ret.isEmpty() ? "" : separator) + shortDays[day];
            }
            return ret;
        }

        public int getStart() {
            return this.iStart;
        }

        public void setStart(int startSlot) {
            this.iStart = startSlot;
        }

        public String getStartString(boolean useAmPm) {
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public int getLength() {
            return this.iLength;
        }

        public void setLength(int length) {
            this.iLength = length;
        }

        public String getEndString(boolean useAmPm) {
            int h = (this.iStart + this.iLength) / 12;
            int m = 5 * ((this.iStart + this.iLength) % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String toString(String[] shortDays, boolean useAmPm) {
            return this.getDaysString(shortDays, "") + " " + this.getStartString(useAmPm) + " - " + this.getEndString(useAmPm);
        }

        public String toString() {
            return "Free " + this.toString(new String[]{"M", "T", "W", "R", "F", "S", "U"}, true);
        }

        public String toAriaString(String[] longDays, boolean useAmPm) {
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            String ret = this.getDaysString(longDays, " ") + " from ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            h = (this.iStart + this.iLength) / 12;
            m = 5 * ((this.iStart + this.iLength) % 12);
            ret = ret + " to ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            return ret;
        }
    }
}

