/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import biweekly.Biweekly;
import biweekly.ICalendar;
import biweekly.component.VEvent;
import biweekly.component.VFreeBusy;
import biweekly.parameter.Role;
import biweekly.property.Attendee;
import biweekly.property.CalendarScale;
import biweekly.property.DateEnd;
import biweekly.property.DateStart;
import biweekly.property.ExceptionDates;
import biweekly.property.Method;
import biweekly.property.Organizer;
import biweekly.property.Status;
import biweekly.property.Version;
import biweekly.util.Recurrence;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cpsolver.coursett.model.TimeLocation;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.action.PersonalizedExamReportAction;
import org.unitime.timetable.events.EventDetailBackend;
import org.unitime.timetable.events.QueryEncoderBackend;
import org.unitime.timetable.export.events.EventsExportEventsToICal;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.server.CourseDetailsBackend;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;

public class CalendarServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverServerService solverServerService;

    public void init() {
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)((Object)this));
    }

    private SessionContext getSessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Params params = null;
        String q = request.getParameter("q");
        params = q != null ? new QParams(q) : new HttpParams(request);
        Long sessionId = null;
        if (params.getParameter("sid") != null) {
            sessionId = Long.valueOf(params.getParameter("sid"));
        } else {
            UserContext user = this.getSessionContext() == null ? null : this.getSessionContext().getUser();
            sessionId = user != null ? user.getCurrentAcademicSessionId() : (Long)request.getSession().getAttribute("sessionId");
        }
        if (params.getParameter("term") != null) {
            org.hibernate.Session hibSession = CurriculumDAO.getInstance().getSession();
            try {
                List sessions = hibSession.createQuery("select s.uniqueId from Session s where s.academicTerm || s.academicYear = :term or s.academicTerm || s.academicYear || s.academicInitiative = :term").setString("term", params.getParameter("term")).list();
                if (!sessions.isEmpty()) {
                    sessionId = (Long)sessions.get(0);
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            {
            }
        }
        if (sessionId == null) {
            response.sendError(400, "No academic session provided.");
            return;
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        if (session == null) {
            response.sendError(400, "Academic session does not exist.");
            return;
        }
        String classIds = params.getParameter("cid");
        String fts = params.getParameter("ft");
        String examIds = params.getParameter("xid");
        String eventIds = params.getParameter("eid");
        String userId = params.getParameter("uid");
        if (q == null) {
            userId = QueryEncoderBackend.decode(userId);
        }
        response.setContentType("text/calendar; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"schedule.ics\"");
        ICalendar ical = new ICalendar();
        ical.setVersion(Version.v2_0());
        ical.setCalendarScale(CalendarScale.gregorian());
        ical.setMethod(new Method("PUBLISH"));
        ical.setExperimentalProperty("X-WR-CALNAME", "UniTime Schedule");
        ical.setExperimentalProperty("X-WR-TIMEZONE", TimeZone.getDefault().getID());
        ical.setProductId("-//UniTime LLC/UniTime " + Constants.getVersion() + " Schedule//EN");
        org.hibernate.Session hibSession = CurriculumDAO.getInstance().getSession();
        try {
            EventsExportEventsToICal exporter = new EventsExportEventsToICal();
            if (classIds != null && !classIds.isEmpty()) {
                for (String classId : classIds.split(",")) {
                    String[] courseAndClassId;
                    if (classId.isEmpty() || (courseAndClassId = classId.split("-")).length != 2) continue;
                    CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(Long.valueOf(courseAndClassId[0]), hibSession);
                    Class_ clazz = (Class_)Class_DAO.getInstance().get(Long.valueOf(courseAndClassId[1]), hibSession);
                    if (course == null || clazz == null) continue;
                    this.printClass(course, clazz, ical);
                }
            }
            if (fts != null && !fts.isEmpty()) {
                Date dpFirstDate = DateUtils.getDate(1, session.getPatternStartMonth(), session.getSessionStartYear());
                BitSet weekCode = session.getDefaultDatePattern().getPatternBitSet();
                for (String ft : fts.split(",")) {
                    String[] daysStartLen;
                    if (ft.isEmpty() || (daysStartLen = ft.split("-")).length != 3) continue;
                    CalendarServlet.printFreeTime(dpFirstDate, weekCode, daysStartLen[0], Integer.parseInt(daysStartLen[1]), Integer.parseInt(daysStartLen[2]), ical);
                }
            }
            if (examIds != null && !examIds.isEmpty()) {
                for (String examId : examIds.split(",")) {
                    if (examId.isEmpty()) continue;
                    try {
                        Exam exam = (Exam)ExamDAO.getInstance().get(Long.valueOf(examId), hibSession);
                        if (exam == null) continue;
                        this.printExam(exam, ical);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            if (eventIds != null && !eventIds.isEmpty()) {
                for (String eventId : eventIds.split(",")) {
                    if (eventId.isEmpty()) continue;
                    try {
                        Event event = (Event)EventDAO.getInstance().get(Long.valueOf(eventId), hibSession);
                        if (event == null) continue;
                        exporter.print(ical, EventDetailBackend.getEventDetail(session, event, null));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            if (userId != null && !userId.isEmpty()) {
                for (DepartmentalInstructor instructor : hibSession.createQuery("select i from DepartmentalInstructor i where i.externalUniqueId = :externalId and i.department.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setString("externalId", userId).list()) {
                    if (!PersonalizedExamReportAction.canDisplay(instructor.getDepartment().getSession())) continue;
                    if (instructor.getDepartment().getSession().getStatusType().canNoRoleReportExamMidterm()) {
                        for (Exam exam : instructor.getExams(1)) {
                            this.printExam(exam, ical);
                        }
                    }
                    if (instructor.getDepartment().getSession().getStatusType().canNoRoleReportExamFinal()) {
                        for (Exam exam : instructor.getExams(0)) {
                            this.printExam(exam, ical);
                        }
                    }
                    if (!instructor.getDepartment().getSession().getStatusType().canNoRoleReportClass()) continue;
                    for (ClassInstructor ci : instructor.getClasses()) {
                        this.printClass(ci.getClassInstructing().getSchedulingSubpart().getInstrOfferingConfig().getControllingCourseOffering(), ci.getClassInstructing(), ical);
                    }
                }
                for (Student student : hibSession.createQuery("select s from Student s where s.externalUniqueId=:externalId and s.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setString("externalId", userId).list()) {
                    if (!PersonalizedExamReportAction.canDisplay(student.getSession())) continue;
                    if (student.getSession().getStatusType().canNoRoleReportExamFinal()) {
                        for (Exam exam : student.getExams(0)) {
                            this.printExam(exam, ical);
                        }
                    }
                    if (student.getSession().getStatusType().canNoRoleReportExamMidterm()) {
                        for (Exam exam : student.getExams(1)) {
                            this.printExam(exam, ical);
                        }
                    }
                    if (!student.getSession().getStatusType().canNoRoleReportClass()) continue;
                    for (StudentClassEnrollment sce : student.getClassEnrollments()) {
                        this.printClass(sce.getCourseOffering(), sce.getClazz(), ical);
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.error(e.getMessage(), e);
            response.sendError(500, e.getMessage());
        }
        PrintWriter out = response.getWriter();
        try {
            Biweekly.write((ICalendar[])new ICalendar[]{ical}).go((Writer)out);
            out.flush();
            Object var23_49 = null;
            out.close();
        }
        catch (Throwable throwable) {
            Object var23_50 = null;
            out.close();
            throw throwable;
        }
    }

    private void printExam(Exam exam, ICalendar ical) throws IOException {
        if (exam.getAssignedPeriod() == null) {
            return;
        }
        VEvent vevent = new VEvent();
        vevent.setSequence(Integer.valueOf(0));
        vevent.setUid(exam.getUniqueId().toString());
        DateStart dstart = new DateStart(exam.getAssignedPeriod().getStartTime(), true);
        dstart.setLocalTime(false);
        dstart.setTimezoneId(TimeZone.getDefault().getID());
        vevent.setDateStart(dstart);
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(exam.getAssignedPeriod().getStartTime());
        endTime.add(12, exam.getLength());
        DateEnd dend = new DateEnd(endTime.getTime(), true);
        dend.setLocalTime(false);
        dend.setTimezoneId(TimeZone.getDefault().getID());
        vevent.setDateEnd(dend);
        vevent.setSummary(exam.getLabel() + " (" + exam.getExamType().getLabel() + " Exam)");
        if (!exam.getAssignedRooms().isEmpty()) {
            String rooms = "";
            for (Location location : new TreeSet<Location>(exam.getAssignedRooms())) {
                if (rooms.length() > 0) {
                    rooms = rooms + ", ";
                }
                rooms = rooms + location.getLabel();
            }
            vevent.setLocation(rooms);
        }
        vevent.setStatus(Status.confirmed());
        ical.addEvent(vevent);
    }

    private void printClass(CourseOffering course, Class_ clazz, ICalendar ical) throws IOException {
        String desc;
        Assignment assignment = clazz.getCommittedAssignment();
        if (assignment == null) {
            return;
        }
        TimeLocation time = assignment.getTimeLocation();
        if (time == null || time.getWeekCode().isEmpty()) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat tf = new SimpleDateFormat("HHmmss");
        tf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date dpFirstDate = DateUtils.getDate(1, clazz.getSession().getPatternStartMonth(), clazz.getSession().getSessionStartYear());
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        cal.setTime(dpFirstDate);
        int idx = time.getWeekCode().nextSetBit(0);
        cal.add(6, idx);
        cal.set(11, Constants.toHour(time.getStartSlot()));
        cal.set(12, Constants.toMinute(time.getStartSlot()));
        cal.set(13, 0);
        Date first = null;
        while (idx < time.getWeekCode().size() && first == null) {
            if (time.getWeekCode().get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((time.getDayCode() & DayCode.MON.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((time.getDayCode() & DayCode.TUE.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((time.getDayCode() & DayCode.WED.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((time.getDayCode() & DayCode.THU.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((time.getDayCode() & DayCode.FRI.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((time.getDayCode() & DayCode.SAT.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((time.getDayCode() & DayCode.SUN.getCode()) == 0) break;
                        first = cal.getTime();
                    }
                }
            }
            if (first != null) continue;
            cal.add(6, 1);
            ++idx;
        }
        if (first == null) {
            return;
        }
        cal.add(12, Constants.SLOT_LENGTH_MIN * time.getLength() - time.getBreakTime());
        Date firstEnd = cal.getTime();
        int fidx = idx;
        cal.setTime(dpFirstDate);
        idx = time.getWeekCode().length() - 1;
        cal.add(6, idx);
        cal.set(11, Constants.toHour(time.getStartSlot()));
        cal.set(12, Constants.toMinute(time.getStartSlot()));
        cal.set(13, 0);
        cal.add(12, Constants.SLOT_LENGTH_MIN * time.getLength() - time.getBreakTime());
        Date last = null;
        while (idx >= 0 && last == null) {
            if (time.getWeekCode().get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((time.getDayCode() & DayCode.MON.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((time.getDayCode() & DayCode.TUE.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((time.getDayCode() & DayCode.WED.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((time.getDayCode() & DayCode.THU.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((time.getDayCode() & DayCode.FRI.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((time.getDayCode() & DayCode.SAT.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((time.getDayCode() & DayCode.SUN.getCode()) == 0) break;
                        last = cal.getTime();
                    }
                }
            }
            if (last != null) continue;
            cal.add(6, -1);
            --idx;
        }
        if (last == null) {
            return;
        }
        cal.setTime(dpFirstDate);
        idx = fidx;
        cal.add(6, idx);
        cal.set(11, Constants.toHour(time.getStartSlot()));
        cal.set(12, Constants.toMinute(time.getStartSlot()));
        cal.set(13, 0);
        VEvent vevent = new VEvent();
        DateStart dstart = new DateStart(first, true);
        dstart.setLocalTime(false);
        dstart.setTimezoneId(TimeZone.getDefault().getID());
        vevent.setDateStart(dstart);
        DateEnd dend = new DateEnd(firstEnd, true);
        dend.setLocalTime(false);
        dend.setTimezoneId(TimeZone.getDefault().getID());
        vevent.setDateEnd(dend);
        Recurrence.Builder recur = new Recurrence.Builder(Recurrence.Frequency.WEEKLY);
        Iterator<DayCode> i = DayCode.toDayCodes(time.getDayCode()).iterator();
        while (i.hasNext()) {
            switch (i.next()) {
                case MON: {
                    recur.byDay(Recurrence.DayOfWeek.MONDAY);
                    break;
                }
                case TUE: {
                    recur.byDay(Recurrence.DayOfWeek.TUESDAY);
                    break;
                }
                case WED: {
                    recur.byDay(Recurrence.DayOfWeek.WEDNESDAY);
                    break;
                }
                case THU: {
                    recur.byDay(Recurrence.DayOfWeek.THURSDAY);
                    break;
                }
                case FRI: {
                    recur.byDay(Recurrence.DayOfWeek.FRIDAY);
                    break;
                }
                case SAT: {
                    recur.byDay(Recurrence.DayOfWeek.SATURDAY);
                    break;
                }
                case SUN: {
                    recur.byDay(Recurrence.DayOfWeek.SUNDAY);
                }
            }
        }
        recur.workweekStarts(Recurrence.DayOfWeek.MONDAY).until(last);
        vevent.setRecurrenceRule(recur.build());
        ExceptionDates exdates = new ExceptionDates(true);
        while (idx < time.getWeekCode().length()) {
            int dow = cal.get(7);
            boolean offered = false;
            switch (dow) {
                case 2: {
                    if ((time.getDayCode() & DayCode.MON.getCode()) == 0) break;
                    offered = true;
                    break;
                }
                case 3: {
                    if ((time.getDayCode() & DayCode.TUE.getCode()) == 0) break;
                    offered = true;
                    break;
                }
                case 4: {
                    if ((time.getDayCode() & DayCode.WED.getCode()) == 0) break;
                    offered = true;
                    break;
                }
                case 5: {
                    if ((time.getDayCode() & DayCode.THU.getCode()) == 0) break;
                    offered = true;
                    break;
                }
                case 6: {
                    if ((time.getDayCode() & DayCode.FRI.getCode()) == 0) break;
                    offered = true;
                    break;
                }
                case 7: {
                    if ((time.getDayCode() & DayCode.SAT.getCode()) == 0) break;
                    offered = true;
                    break;
                }
                case 1: {
                    if ((time.getDayCode() & DayCode.SUN.getCode()) == 0) break;
                    offered = true;
                }
            }
            if (!offered) {
                cal.add(6, 1);
                ++idx;
                continue;
            }
            cal.set(11, Constants.toHour(time.getStartSlot()));
            cal.set(12, Constants.toMinute(time.getStartSlot()));
            cal.set(13, 0);
            if (!time.getWeekCode().get(idx)) {
                exdates.addValue((Object)cal.getTime());
            }
            cal.add(6, 1);
            ++idx;
        }
        if (!exdates.getValues().isEmpty()) {
            vevent.addExceptionDates(exdates);
        }
        vevent.setUid(clazz.getUniqueId().toString());
        vevent.setSequence(Integer.valueOf(0));
        vevent.setSummary(clazz.getClassLabel(course));
        String string = desc = course.getTitle() == null ? "" : course.getTitle();
        if (course.getConsentType() != null) {
            desc = desc + " (" + course.getConsentType().getLabel() + ")";
        }
        vevent.setDescription(desc);
        if (!assignment.getRooms().isEmpty()) {
            String loc = "";
            for (Location r : assignment.getRooms()) {
                if (!loc.isEmpty()) {
                    loc = loc + ", ";
                }
                loc = loc + r.getLabel();
            }
            vevent.setLocation(loc);
        }
        try {
            URL url = CourseDetailsBackend.getCourseUrl(new AcademicSessionInfo(course.getInstructionalOffering().getSession()), course.getSubjectAreaAbbv(), course.getCourseNbr());
            if (url != null) {
                vevent.setUrl(url.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (clazz.isDisplayInstructor().booleanValue()) {
            for (ClassInstructor instructor : clazz.getClassInstructors()) {
                if (vevent.getOrganizer() == null) {
                    Organizer organizer = new Organizer("mailto:" + (instructor.getInstructor().getEmail() != null ? instructor.getInstructor().getEmail() : ""));
                    organizer.setCommonName(instructor.getInstructor().getNameLastFirst());
                    vevent.setOrganizer(organizer);
                    continue;
                }
                Attendee attendee = new Attendee("mailto:" + (instructor.getInstructor().getEmail() != null ? instructor.getInstructor().getEmail() : ""));
                attendee.setCommonName(instructor.getInstructor().getNameLastFirst());
                attendee.setRole(Role.CHAIR);
                vevent.addAttendee(attendee);
            }
        }
        vevent.setStatus(Status.confirmed());
        ical.addEvent(vevent);
    }

    private static void printFreeTime(Date dpFirstDate, BitSet weekCode, String days, int start, int len, ICalendar ical) throws IOException {
        int idx;
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        cal.setTime(dpFirstDate);
        cal.add(6, idx);
        cal.set(11, Constants.toHour(start));
        cal.set(12, Constants.toMinute(start));
        cal.set(13, 0);
        Date first = null;
        for (idx = weekCode.nextSetBit(0); idx < weekCode.size() && first == null; ++idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if (!days.contains(DayCode.MON.getAbbv())) break;
                        first = cal.getTime();
                        break;
                    }
                    case 3: {
                        if (!days.contains(DayCode.TUE.getAbbv())) break;
                        first = cal.getTime();
                        break;
                    }
                    case 4: {
                        if (!days.contains(DayCode.WED.getAbbv())) break;
                        first = cal.getTime();
                        break;
                    }
                    case 5: {
                        if (!days.contains(DayCode.THU.getAbbv())) break;
                        first = cal.getTime();
                        break;
                    }
                    case 6: {
                        if (!days.contains(DayCode.FRI.getAbbv())) break;
                        first = cal.getTime();
                        break;
                    }
                    case 7: {
                        if (!days.contains(DayCode.SAT.getAbbv())) break;
                        first = cal.getTime();
                        break;
                    }
                    case 1: {
                        if (!days.contains(DayCode.SUN.getAbbv())) break;
                        first = cal.getTime();
                    }
                }
            }
            cal.add(6, 1);
        }
        if (first == null) {
            return;
        }
        cal.setTime(dpFirstDate);
        cal.add(6, idx);
        cal.set(11, Constants.toHour(start));
        cal.set(12, Constants.toMinute(start));
        cal.set(13, 0);
        cal.add(12, Constants.SLOT_LENGTH_MIN * len);
        Date last = null;
        for (idx = weekCode.length() - 1; idx >= 0 && last == null; --idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if (!days.contains(DayCode.MON.getAbbv())) break;
                        last = cal.getTime();
                        break;
                    }
                    case 3: {
                        if (!days.contains(DayCode.TUE.getAbbv())) break;
                        last = cal.getTime();
                        break;
                    }
                    case 4: {
                        if (!days.contains(DayCode.WED.getAbbv())) break;
                        last = cal.getTime();
                        break;
                    }
                    case 5: {
                        if (!days.contains(DayCode.THU.getAbbv())) break;
                        last = cal.getTime();
                        break;
                    }
                    case 6: {
                        if (!days.contains(DayCode.FRI.getAbbv())) break;
                        last = cal.getTime();
                        break;
                    }
                    case 7: {
                        if (!days.contains(DayCode.SAT.getAbbv())) break;
                        last = cal.getTime();
                        break;
                    }
                    case 1: {
                        if (!days.contains(DayCode.SUN.getAbbv())) break;
                        last = cal.getTime();
                    }
                }
            }
            cal.add(6, -1);
        }
        if (last == null) {
            return;
        }
        VFreeBusy vfree = new VFreeBusy();
        DateStart dstart = new DateStart(first, true);
        dstart.setLocalTime(false);
        dstart.setTimezoneId(TimeZone.getDefault().getID());
        vfree.setDateStart(dstart);
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(first);
        c.add(12, Constants.SLOT_LENGTH_MIN * len);
        DateEnd dend = new DateEnd(c.getTime(), true);
        dend.setLocalTime(false);
        dend.setTimezoneId(TimeZone.getDefault().getID());
        vfree.setDateEnd(dend);
        vfree.addComment("Free Time");
        ical.addFreeBusy(vfree);
        cal.setTime(dpFirstDate);
        cal.add(6, idx);
        for (idx = weekCode.nextSetBit(0); idx < weekCode.length(); ++idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                boolean offered = false;
                switch (dow) {
                    case 2: {
                        if (!days.contains(DayCode.MON.getAbbv())) break;
                        offered = true;
                        break;
                    }
                    case 3: {
                        if (!days.contains(DayCode.TUE.getAbbv())) break;
                        offered = true;
                        break;
                    }
                    case 4: {
                        if (!days.contains(DayCode.WED.getAbbv())) break;
                        offered = true;
                        break;
                    }
                    case 5: {
                        if (!days.contains(DayCode.THU.getAbbv())) break;
                        offered = true;
                        break;
                    }
                    case 6: {
                        if (!days.contains(DayCode.FRI.getAbbv())) break;
                        offered = true;
                        break;
                    }
                    case 7: {
                        if (!days.contains(DayCode.SAT.getAbbv())) break;
                        offered = true;
                        break;
                    }
                    case 1: {
                        if (!days.contains(DayCode.SUN.getAbbv())) break;
                        offered = true;
                    }
                }
                if (offered) {
                    cal.set(11, Constants.toHour(start));
                    cal.set(12, Constants.toMinute(start));
                    cal.set(13, 0);
                    vfree = new VFreeBusy();
                    dstart = new DateStart(cal.getTime(), true);
                    dstart.setLocalTime(false);
                    dstart.setTimezoneId(TimeZone.getDefault().getID());
                    vfree.setDateStart(dstart);
                    cal.add(12, Constants.SLOT_LENGTH_MIN * len);
                    dend = new DateEnd(cal.getTime(), true);
                    dend.setLocalTime(false);
                    dend.setTimezoneId(TimeZone.getDefault().getID());
                    vfree.setDateEnd(dend);
                    vfree.addComment("Free Time");
                    ical.addFreeBusy(vfree);
                }
            }
            cal.add(6, 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ICalendarMeeting
    implements Comparable<ICalendarMeeting> {
        private DateTime iStart;
        private DateTime iEnd;
        private String iLocation;
        private Status iStatus;

        public ICalendarMeeting(Meeting meeting) {
            this.iStart = new DateTime((Object)meeting.getStartTime());
            this.iEnd = new DateTime((Object)meeting.getStopTime());
            this.iLocation = meeting.getLocation() == null ? "" : meeting.getLocation().getLabel();
            this.iStatus = meeting.isApproved() ? Status.confirmed() : Status.tentative();
        }

        public DateTime getStart() {
            return this.iStart;
        }

        public DateStart getDateStart() {
            DateStart ds = new DateStart(this.iStart.toDate(), true);
            ds.setLocalTime(false);
            ds.setTimezoneId(TimeZone.getDefault().getID());
            return ds;
        }

        public DateTime getEnd() {
            return this.iEnd;
        }

        public DateEnd getDateEnd() {
            DateEnd de = new DateEnd(this.iEnd.toDate(), true);
            de.setLocalTime(false);
            de.setTimezoneId(TimeZone.getDefault().getID());
            return de;
        }

        public String getLocation() {
            return this.iLocation;
        }

        public Status getStatus() {
            return this.iStatus;
        }

        public boolean merge(ICalendarMeeting m) {
            if (m.getStart().equals((Object)this.getStart()) && m.getEnd().equals((Object)this.getEnd())) {
                if (m.getStatus() == Status.tentative()) {
                    this.iStatus = Status.tentative();
                }
                this.iLocation = this.iLocation + ", " + m.getLocation();
                return true;
            }
            return false;
        }

        public boolean same(ICalendarMeeting m) {
            return m.getStart().getSecondOfDay() == this.getStart().getSecondOfDay() && m.getEnd().getSecondOfDay() == this.getEnd().getSecondOfDay() && this.getLocation().equals(m.getLocation()) && this.getStatus().equals(m.getStatus());
        }

        @Override
        public int compareTo(ICalendarMeeting m) {
            int cmp = this.getStart().compareTo((ReadableInstant)m.getStart());
            if (cmp != 0) {
                return cmp;
            }
            return this.getEnd().compareTo((ReadableInstant)m.getEnd());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QParams
    implements Params {
        private Map<String, List<String>> iParams = new HashMap<String, List<String>>();

        QParams(String q) throws UnsupportedEncodingException {
            for (String p : QueryEncoderBackend.decode(q).split("&")) {
                String name = p.substring(0, p.indexOf(61));
                String value = URLDecoder.decode(p.substring(p.indexOf(61) + 1), "UTF-8");
                List<String> values = this.iParams.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    this.iParams.put(name, values);
                }
                values.add(value);
            }
        }

        @Override
        public String getParameter(String name) {
            List<String> values = this.iParams.get(name);
            return values == null || values.isEmpty() ? null : values.get(0);
        }

        @Override
        public String[] getParameterValues(String name) {
            List<String> values = this.iParams.get(name);
            if (values == null) {
                return null;
            }
            String[] ret = new String[values.size()];
            values.toArray(ret);
            return ret;
        }

        @Override
        public Enumeration<String> getParameterNames() {
            final Iterator<String> iterator = this.iParams.keySet().iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)iterator.next();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HttpParams
    implements Params {
        private Map<String, String[]> iParams = new HashMap<String, String[]>();

        HttpParams(HttpServletRequest request) {
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.iParams.put(name, request.getParameterValues(name));
            }
        }

        @Override
        public String getParameter(String name) {
            String[] values = this.iParams.get(name);
            return values == null || values.length <= 0 ? null : values[0];
        }

        @Override
        public String[] getParameterValues(String name) {
            return this.iParams.get(name);
        }

        @Override
        public Enumeration<String> getParameterNames() {
            final Iterator<String> iterator = this.iParams.keySet().iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)iterator.next();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Params {
        public String getParameter(String var1);

        public String[] getParameterValues(String var1);

        public Enumeration<String> getParameterNames();
    }
}

