/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.unitime.timetable.gwt.client.aria.AriaCheckBox;
import org.unitime.timetable.gwt.client.aria.AriaHiddenLabel;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebTable
extends Composite {
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    private Row[] iHeader;
    private String iEmptyMessage = MESSAGES.tableEmpty();
    private Row[] iRows;
    private ArrayList<RowClickHandler> iRowClickHandlers = new ArrayList();
    private ArrayList<RowDoubleClickHandler> iRowDoubleClickHandlers = new ArrayList();
    private ArrayList<RowOverHandler> iRowOverHandlers = new ArrayList();
    private ArrayList<RowOutHandler> iRowOutHandlers = new ArrayList();
    private ArrayList<RowMoveHandler> iRowMoveHandlers = new ArrayList();
    private RowSelectingFlexTable iTable = new RowSelectingFlexTable();
    private int iSelectedRow = -1;
    private boolean iSelectSameIdRows = false;

    public WebTable() {
        this.iTable.setCellPadding(2);
        this.iTable.setCellSpacing(0);
        this.iTable.setStyleName("unitime-WebTable");
        this.initWidget((Widget)this.iTable);
        Roles.getGridRole().set((Element)this.iTable.getElement());
    }

    public Widget getPrintWidget(int ... skipColumns) {
        ArrayList<Integer> skip = new ArrayList<Integer>();
        for (int c : skipColumns) {
            skip.add(c);
        }
        return this.getPrintWidget(skip);
    }

    public Widget getPrintWidget(ArrayList<Integer> skipColumns) {
        int newColSpan;
        Cell cell;
        int j;
        ArrayList<Cell> cells;
        int col;
        int i;
        WebTable x = new WebTable();
        if (this.iHeader != null) {
            Row[] header = new Row[this.iHeader.length];
            for (i = 0; i < this.iHeader.length; ++i) {
                col = 0;
                cells = new ArrayList<Cell>();
                for (j = 0; j < this.iHeader[i].getNrCells(); ++j) {
                    cell = this.iHeader[i].getCell(j);
                    newColSpan = 0;
                    for (int c = 0; c < cell.getColSpan(); ++c) {
                        if (skipColumns.contains(col + c)) continue;
                        ++newColSpan;
                    }
                    col += cell.getColSpan();
                    if (newColSpan == 0) continue;
                    Cell c = new Cell(cell.getValue(), newColSpan, cell.getWidth());
                    c.setStyleName(cell.getStyleName());
                    cells.add(c);
                }
                header[i] = new Row(cells);
            }
            x.setHeader(header);
        }
        if (this.iRows != null && this.iRows.length > 0) {
            Row[] data = new Row[this.iRows.length];
            for (i = 0; i < this.iRows.length; ++i) {
                col = 0;
                cells = new ArrayList();
                for (j = 0; j < this.iRows[i].getNrCells(); ++j) {
                    cell = this.iRows[i].getCell(j);
                    newColSpan = 0;
                    for (int c = 0; c < cell.getColSpan(); ++c) {
                        if (skipColumns.contains(col + c)) continue;
                        ++newColSpan;
                    }
                    col += cell.getColSpan();
                    if (newColSpan == 0) continue;
                    Cell c = new Cell(cell.getValue(), newColSpan, cell.getWidth());
                    c.setStyleName(cell.getStyleName());
                    cells.add(c);
                }
                data[i] = new Row(cells);
            }
            x.setData(data);
        } else {
            x.setEmptyMessage(this.iEmptyMessage);
        }
        return x;
    }

    public void setHeader(Row ... header) {
        this.iHeader = header;
        for (int i = 0; i < header.length; ++i) {
            for (int j = 0; j < header[i].getNrCells(); ++j) {
                Cell cell = header[i].getCell(j);
                if (cell.getWidget() == null) {
                    this.iTable.setHTML(i, j, cell.getValue() == null || cell.getValue().isEmpty() ? "&nbsp;" : cell.getValue());
                    if (cell.getAriaLabel() != null && !cell.getAriaLabel().isEmpty()) {
                        Roles.getGridcellRole().setAriaLabelProperty((Element)this.iTable.getCellFormatter().getElement(i, j), cell.getAriaLabel());
                    }
                } else {
                    this.iTable.setWidget(i, j, cell.getWidget());
                }
                this.iTable.getFlexCellFormatter().setWordWrap(i, j, cell.getWordWrap());
                this.iTable.getFlexCellFormatter().setStyleName(i, j, cell.getStyleName() == null ? "unitime-TableHeader" : cell.getStyleName());
                this.iTable.getFlexCellFormatter().setWidth(i, j, cell.getWidth() == null ? 100 / header.length + "%" : cell.getWidth());
                this.iTable.getFlexCellFormatter().setColSpan(i, j, cell.getColSpan());
                this.iTable.getFlexCellFormatter().setVerticalAlignment(i, j, cell.getVerticalAlignment());
                this.iTable.getFlexCellFormatter().setHorizontalAlignment(i, j, cell.getHorizontalAlignment());
                this.iTable.getFlexCellFormatter().getElement(i, j).setTitle(cell.getTitle());
                Roles.getColumnheaderRole().set((Element)this.iTable.getCellFormatter().getElement(i, j));
            }
            Roles.getRowRole().set((Element)this.iTable.getRowFormatter().getElement(i));
            if (header[i].getAriaLabel() != null && !header[i].getAriaLabel().isEmpty()) {
                this.iTable.setWidget(i, header[i].getNrCells(), new AriaHiddenLabel(header[i].getAriaLabel()));
            } else {
                this.iTable.setHTML(i, header[i].getNrCells(), "");
            }
            Roles.getRowheaderRole().set((Element)this.iTable.getCellFormatter().getElement(i, header[i].getNrCells()));
            this.iTable.getFlexCellFormatter().setStyleName(i, header[i].getNrCells(), "unitime-TableHeader");
            this.iTable.getFlexCellFormatter().addStyleName(i, header[i].getNrCells(), "rowheader");
        }
    }

    public void setColumnVisible(int col, boolean visible) {
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            this.iTable.getFlexCellFormatter().setVisible(row, col, visible);
        }
    }

    public int getColumnsCount() {
        if (this.iHeader == null || this.iHeader.length == 0) {
            return 1;
        }
        int ret = 0;
        for (int i = 0; i < this.iHeader[0].getNrCells(); ++i) {
            ret += this.iHeader[0].getCell(i).getColSpan();
        }
        return ret;
    }

    public int getHeaderRowsCount() {
        if (this.iHeader == null) {
            return 0;
        }
        return this.iHeader.length;
    }

    public int getRowsCount() {
        if (this.iRows == null) {
            return 0;
        }
        return this.iRows.length;
    }

    public void setEmptyMessage(String emptyMessage) {
        this.iEmptyMessage = emptyMessage;
        if (this.iRows == null || this.iRows.length == 0) {
            this.iTable.setHTML(this.getHeaderRowsCount(), 0, this.iEmptyMessage);
            if (this.iEmptyMessage != null) {
                this.iTable.getFlexCellFormatter().setColSpan(this.getHeaderRowsCount(), 0, this.getColumnsCount());
                this.iTable.getFlexCellFormatter().setStyleName(this.getHeaderRowsCount(), 0, "unitime-TableEmpty");
            } else {
                this.iTable.getFlexCellFormatter().setColSpan(this.getHeaderRowsCount(), 0, 1);
                this.iTable.getFlexCellFormatter().setStyleName(this.getHeaderRowsCount(), 0, null);
            }
        }
    }

    public void clearData(boolean showEmptyMessage) {
        for (int row = this.iTable.getRowCount() - 1; row >= this.getHeaderRowsCount(); --row) {
            this.iTable.removeRow(row);
        }
        this.iRows = null;
        if (showEmptyMessage) {
            this.setEmptyMessage(this.iEmptyMessage);
        }
    }

    public void clearData(int keepRows) {
        for (int row = this.iTable.getRowCount() - 1; row >= this.getHeaderRowsCount() + keepRows; --row) {
            this.iTable.removeRow(row);
        }
    }

    public boolean isEmpty() {
        return this.iRows == null || this.iRows.length == 0;
    }

    public void setData(Row ... rows) {
        this.setSelectedRow(-1);
        if (rows == null || rows.length == 0) {
            this.clearData(true);
            return;
        }
        this.clearData(rows.length);
        this.iRows = rows;
        for (int i = 0; i < this.iRows.length; ++i) {
            int j;
            if (this.iRows[i] == null) continue;
            this.iRows[i].setRowIdx(i);
            this.iRows[i].setTable(this);
            this.iTable.getRowFormatter().setStyleName(i + this.getHeaderRowsCount(), null);
            for (j = 0; j < this.iRows[i].getNrCells(); ++j) {
                Cell cell = this.iRows[i].getCell(j);
                cell.setColIdx(j);
                cell.setRow(this.iRows[i]);
                if (cell.getWidget() == null) {
                    this.iTable.setHTML(i + this.getHeaderRowsCount(), j, cell.getValue() == null || cell.getValue().isEmpty() ? "&nbsp;" : cell.getValue());
                    if (cell.getAriaLabel() != null && !cell.getAriaLabel().isEmpty()) {
                        Roles.getGridcellRole().setAriaLabelProperty((Element)this.iTable.getCellFormatter().getElement(i + this.getHeaderRowsCount(), j), cell.getAriaLabel());
                    }
                } else {
                    this.iTable.setWidget(i + this.getHeaderRowsCount(), j, cell.getWidget());
                }
                this.iTable.getFlexCellFormatter().setWordWrap(i + this.getHeaderRowsCount(), j, cell.getWordWrap());
                this.iTable.getFlexCellFormatter().setColSpan(i + this.getHeaderRowsCount(), j, cell.getColSpan());
                this.iTable.getFlexCellFormatter().setStyleName(i + this.getHeaderRowsCount(), j, cell.getStyleName());
                this.iTable.getFlexCellFormatter().setWidth(i + this.getHeaderRowsCount(), j, cell.getWidth());
                this.iTable.getFlexCellFormatter().setVerticalAlignment(i + this.getHeaderRowsCount(), j, cell.getVerticalAlignment());
                this.iTable.getFlexCellFormatter().setHorizontalAlignment(i + this.getHeaderRowsCount(), j, cell.getHorizontalAlignment());
                this.iTable.getFlexCellFormatter().getElement(i + this.getHeaderRowsCount(), j).setTitle(cell.getTitle());
                Roles.getGridcellRole().set((Element)this.iTable.getCellFormatter().getElement(i + this.getHeaderRowsCount(), j));
            }
            Roles.getRowRole().set((Element)this.iTable.getRowFormatter().getElement(i + this.getHeaderRowsCount()));
            for (j = this.iTable.getCellCount(i + this.getHeaderRowsCount()) - 1; j >= this.iRows[i].getNrCells(); --j) {
                this.iTable.removeCell(i + this.getHeaderRowsCount(), j);
            }
            if (this.iRows[i].getAriaLabel() != null && !this.iRows[i].getAriaLabel().isEmpty()) {
                this.iTable.setWidget(i + this.getHeaderRowsCount(), this.iRows[i].getNrCells(), new AriaHiddenLabel(this.iRows[i].getAriaLabel()));
            } else {
                this.iTable.setHTML(i + this.getHeaderRowsCount(), this.iRows[i].getNrCells(), "");
            }
            Roles.getRowheaderRole().set((Element)this.iTable.getCellFormatter().getElement(i + this.getHeaderRowsCount(), this.iRows[i].getNrCells()));
            this.iTable.getFlexCellFormatter().setStyleName(i + this.getHeaderRowsCount(), this.iRows[i].getNrCells(), this.iRows[i].getCell(this.iRows[i].getNrCells() - 1).getStyleName());
            this.iTable.getFlexCellFormatter().addStyleName(i + this.getHeaderRowsCount(), this.iRows[i].getNrCells(), "rowheader");
        }
    }

    public void setData(String[] ... lines) {
        Row[] rows = new Row[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            rows[i] = new Row(lines[i]);
        }
        this.setData(rows);
    }

    public void addRowClickHandler(RowClickHandler rowClickHandler) {
        this.iRowClickHandlers.add(rowClickHandler);
    }

    public void addRowDoubleClickHandler(RowDoubleClickHandler rowDoubleClickHandler) {
        this.iRowDoubleClickHandlers.add(rowDoubleClickHandler);
    }

    public void addRowOverHandler(RowOverHandler rowOverHandler) {
        this.iRowOverHandlers.add(rowOverHandler);
    }

    public void addRowOutHandler(RowOutHandler rowOutHandler) {
        this.iRowOutHandlers.add(rowOutHandler);
    }

    public void addRowMoveHandler(RowMoveHandler rowMoveHandler) {
        this.iRowMoveHandlers.add(rowMoveHandler);
    }

    public void fireRowClickEvent(Event event, int row) {
        RowClickEvent e = new RowClickEvent(event, this.iRows[row], row);
        for (RowClickHandler h : this.iRowClickHandlers) {
            h.onRowClick(e);
        }
    }

    public void fireDoubleRowClickEvent(Event event, int row) {
        RowDoubleClickEvent e = new RowDoubleClickEvent(event, this.iRows[row], row);
        for (RowDoubleClickHandler h : this.iRowDoubleClickHandlers) {
            h.onRowDoubleClick(e);
        }
    }

    public void setSelectedRow(int row) {
        String id;
        if (this.iSelectedRow >= 0) {
            if (this.isSelectSameIdRows() && this.iRows != null && this.iSelectedRow < this.iRows.length) {
                id = this.iRows[this.iSelectedRow].getId();
                for (Row r : this.iRows) {
                    if (!id.equals(r.getId())) continue;
                    this.iTable.getRowFormatter().setStyleName(this.getHeaderRowsCount() + r.getRowIdx(), null);
                }
            } else {
                this.iTable.getRowFormatter().setStyleName(this.iSelectedRow + this.getHeaderRowsCount(), null);
            }
        }
        if (row < 0 || this.iRows == null || this.iRows.length == 0) {
            this.iSelectedRow = -1;
        } else {
            this.iSelectedRow = row % this.iRows.length;
            if (this.isSelectSameIdRows()) {
                id = this.iRows[this.iSelectedRow].getId();
                for (Row r : this.iRows) {
                    if (!id.equals(r.getId())) continue;
                    this.iTable.getRowFormatter().setStyleName(this.getHeaderRowsCount() + r.getRowIdx(), "unitime-TableRowSelected");
                }
            } else {
                this.iTable.getRowFormatter().setStyleName(this.iSelectedRow + this.getHeaderRowsCount(), "unitime-TableRowSelected");
            }
        }
    }

    public int getSelectedRow() {
        return this.iSelectedRow;
    }

    public Row[] getRows() {
        return this.iRows;
    }

    public void setSelectSameIdRows(boolean selectSameIdRows) {
        this.iSelectSameIdRows = selectSameIdRows;
    }

    public boolean isSelectSameIdRows() {
        return this.iSelectSameIdRows;
    }

    public String getSelectedRowId() {
        if (this.iSelectedRow < 0 || this.iSelectedRow >= this.iRows.length) {
            return null;
        }
        return this.iRows[this.iSelectedRow].getId();
    }

    public FlexTable getTable() {
        return this.iTable;
    }

    public static interface RowMoveHandler {
        public void onRowMove(RowMoveEvent var1);
    }

    public static class RowMoveEvent
    extends RowClickEvent {
        private RowMoveEvent(Event event, Row row, int rowIdx) {
            super(event, row, rowIdx);
        }
    }

    public static interface RowOutHandler {
        public void onRowOut(RowOutEvent var1);
    }

    public static class RowOutEvent
    extends RowClickEvent {
        private RowOutEvent(Event event, Row row, int rowIdx) {
            super(event, row, rowIdx);
        }
    }

    public static interface RowOverHandler {
        public void onRowOver(RowOverEvent var1);
    }

    public static class RowOverEvent
    extends RowClickEvent {
        private RowOverEvent(Event event, Row row, int rowIdx) {
            super(event, row, rowIdx);
        }
    }

    public static interface RowDoubleClickHandler {
        public void onRowDoubleClick(RowDoubleClickEvent var1);
    }

    public static class RowDoubleClickEvent {
        private Event iEvent;
        private Row iRow;
        private int iRowIdx;

        private RowDoubleClickEvent(Event event, Row row, int rowIdx) {
            this.iEvent = event;
            this.iRow = row;
            this.iRowIdx = rowIdx;
        }

        public Event getEvent() {
            return this.iEvent;
        }

        public Row getRow() {
            return this.iRow;
        }

        public int getRowIdx() {
            return this.iRowIdx;
        }
    }

    public static interface RowClickHandler {
        public void onRowClick(RowClickEvent var1);
    }

    public static class RowClickEvent {
        private Event iEvent;
        private Row iRow;
        private int iRowIdx;

        private RowClickEvent(Event event, Row row, int rowIdx) {
            this.iEvent = event;
            this.iRow = row;
            this.iRowIdx = rowIdx;
        }

        public Event getEvent() {
            return this.iEvent;
        }

        public Row getRow() {
            return this.iRow;
        }

        public int getRowIdx() {
            return this.iRowIdx;
        }
    }

    public class RowSelectingFlexTable
    extends FlexTable {
        public RowSelectingFlexTable() {
            this.sinkEvents(16);
            this.sinkEvents(32);
            this.sinkEvents(64);
            this.sinkEvents(1);
            this.sinkEvents(2);
        }

        public void onBrowserEvent(Event event) {
            if (WebTable.this.iRows == null || WebTable.this.iRows.length == 0) {
                return;
            }
            com.google.gwt.user.client.Element td = this.getEventTargetCell(event);
            if (td == null) {
                return;
            }
            com.google.gwt.user.client.Element tr = DOM.getParent((Element)td);
            com.google.gwt.user.client.Element body = DOM.getParent((Element)tr);
            int row = DOM.getChildIndex((Element)body, (Element)tr);
            if (row >= WebTable.this.getHeaderRowsCount() && row < WebTable.this.getHeaderRowsCount() + WebTable.this.iRows.length && !WebTable.this.iRows[row - WebTable.this.getHeaderRowsCount()].isSelectable()) {
                return;
            }
            switch (DOM.eventGetType((Event)event)) {
                case 16: {
                    if (row < WebTable.this.getHeaderRowsCount() || row >= WebTable.this.getHeaderRowsCount() + WebTable.this.iRows.length) break;
                    if (WebTable.this.isSelectSameIdRows()) {
                        String id = WebTable.this.iRows[row - WebTable.this.getHeaderRowsCount()].getId();
                        String sid = WebTable.this.getSelectedRowId();
                        for (Row r : WebTable.this.iRows) {
                            if (!id.equals(r.getId())) continue;
                            this.getRowFormatter().setStyleName(WebTable.this.getHeaderRowsCount() + r.getRowIdx(), id.equals(sid) ? "unitime-TableRowSelectedHover" : "unitime-TableRowHover");
                        }
                    } else {
                        this.getRowFormatter().setStyleName(row, row - WebTable.this.getHeaderRowsCount() == WebTable.this.iSelectedRow ? "unitime-TableRowSelectedHover" : "unitime-TableRowHover");
                    }
                    RowOverEvent e = new RowOverEvent(event, WebTable.this.iRows[row - WebTable.this.getHeaderRowsCount()], row - WebTable.this.getHeaderRowsCount());
                    for (RowOverHandler h : WebTable.this.iRowOverHandlers) {
                        h.onRowOver(e);
                    }
                    if (WebTable.this.iRowClickHandlers.isEmpty()) break;
                    this.getRowFormatter().getElement(row).getStyle().setCursor(Style.Cursor.POINTER);
                    break;
                }
                case 32: {
                    if (row >= WebTable.this.getHeaderRowsCount() && row < WebTable.this.getHeaderRowsCount() + WebTable.this.iRows.length && row - WebTable.this.getHeaderRowsCount() != WebTable.this.iSelectedRow) {
                        if (WebTable.this.isSelectSameIdRows()) {
                            String id = WebTable.this.iRows[row - WebTable.this.getHeaderRowsCount()].getId();
                            String sid = WebTable.this.getSelectedRowId();
                            for (Row r : WebTable.this.iRows) {
                                if (!id.equals(r.getId())) continue;
                                this.getRowFormatter().setStyleName(WebTable.this.getHeaderRowsCount() + r.getRowIdx(), id.equals(sid) ? "unitime-TableRowSelectedHover" : null);
                            }
                        } else {
                            this.getRowFormatter().setStyleName(row, row - WebTable.this.getHeaderRowsCount() == WebTable.this.iSelectedRow ? "unitime-TableRowSelectedHover" : null);
                        }
                    }
                    if (row < WebTable.this.getHeaderRowsCount() || row >= WebTable.this.getHeaderRowsCount() + WebTable.this.iRows.length) break;
                    RowOutEvent e = new RowOutEvent(event, WebTable.this.iRows[row - WebTable.this.getHeaderRowsCount()], row - WebTable.this.getHeaderRowsCount());
                    for (Object h : WebTable.this.iRowOutHandlers) {
                        h.onRowOut(e);
                    }
                    if (WebTable.this.iRowClickHandlers.isEmpty()) break;
                    this.getRowFormatter().getElement(row).getStyle().clearCursor();
                    break;
                }
                case 1: {
                    if (row < WebTable.this.getHeaderRowsCount() || row >= WebTable.this.getHeaderRowsCount() + WebTable.this.iRows.length) break;
                    RowClickEvent e = new RowClickEvent(event, WebTable.this.iRows[row - WebTable.this.getHeaderRowsCount()], row - WebTable.this.getHeaderRowsCount());
                    for (RowClickHandler h : WebTable.this.iRowClickHandlers) {
                        h.onRowClick(e);
                    }
                    break;
                }
                case 2: {
                    if (row < WebTable.this.getHeaderRowsCount() || row >= WebTable.this.getHeaderRowsCount() + WebTable.this.iRows.length) break;
                    RowDoubleClickEvent e = new RowDoubleClickEvent(event, WebTable.this.iRows[row - WebTable.this.getHeaderRowsCount()], row - WebTable.this.getHeaderRowsCount());
                    for (RowDoubleClickHandler h : WebTable.this.iRowDoubleClickHandlers) {
                        h.onRowDoubleClick(e);
                    }
                    break;
                }
                case 64: {
                    RowMoveEvent e = new RowMoveEvent(event, WebTable.this.iRows[row - WebTable.this.getHeaderRowsCount()], row - WebTable.this.getHeaderRowsCount());
                    for (RowMoveHandler h : WebTable.this.iRowMoveHandlers) {
                        h.onRowMove(e);
                    }
                    break;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstructorCell
    extends MultiCell {
        public InstructorCell(ArrayList<String> names, ArrayList<String> emails, String separator) {
            super(null, separator);
            if (names != null && !names.isEmpty()) {
                separator = separator.replace(" ", "&nbsp;");
                for (int i = 0; i < names.size(); ++i) {
                    String email;
                    String text = names.get(i) + (i + 1 < names.size() ? separator : "");
                    String string = email = emails != null && i < emails.size() ? emails.get(i) : null;
                    if (email != null && !email.isEmpty()) {
                        this.iText = this.iText + text;
                        HorizontalPanel p = new HorizontalPanel();
                        p.setStyleName("instructor");
                        Anchor a = new Anchor();
                        a.setHref("mailto:" + email);
                        a.setHTML(new Image(RESOURCES.email()).getElement().getString());
                        a.setTitle(MESSAGES.sendEmail(names.get(i)));
                        a.setStyleName("unitime-SimpleLink");
                        a.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                event.stopPropagation();
                            }
                        });
                        p.add((Widget)a);
                        p.setCellVerticalAlignment((Widget)a, HasVerticalAlignment.ALIGN_MIDDLE);
                        HTML h = new HTML(text, false);
                        h.getElement().getStyle().setMarginLeft(2.0, Style.Unit.PX);
                        p.add((Widget)h);
                        this.iPanel.add((Widget)p);
                        this.iContent.add(h);
                        continue;
                    }
                    this.add(text);
                }
            } else {
                this.add("&nbsp;");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiCell
    extends Cell {
        protected Panel iPanel = new FlowPanel();
        protected String iText = "";
        protected ArrayList<UIObject> iContent = new ArrayList();

        public MultiCell(ArrayList<String> names, String separator) {
            super(null);
            if (names != null) {
                separator = separator.replace(" ", "&nbsp;");
                for (int i = 0; i < names.size(); ++i) {
                    this.add(names.get(i) + (i + 1 < names.size() ? separator : ""));
                }
            }
        }

        protected void add(String text) {
            this.iText = this.iText + text;
            HTML h = new HTML(text, false);
            this.iPanel.add((Widget)h);
            this.iContent.add((UIObject)h);
        }

        @Override
        public String getValue() {
            return this.iText;
        }

        @Override
        public Widget getWidget() {
            return this.iPanel;
        }

        @Override
        public void setStyleName(String styleName) {
            super.setStyleName(styleName);
            for (UIObject c : this.iContent) {
                c.setStyleName(styleName);
                c.getElement().getStyle().setBorderWidth(0.0, Style.Unit.PX);
            }
        }
    }

    public static class WidgetCell
    extends Cell {
        private Widget iWidget = null;

        public WidgetCell(Widget widget, String text, int colspan, String width) {
            super(text, colspan, width);
            this.iWidget = widget;
        }

        public WidgetCell(Widget widget, String text) {
            super(text);
            this.iWidget = widget;
        }

        public Widget getWidget() {
            return this.iWidget;
        }
    }

    public static class AbbvTextCell
    extends Cell {
        private P iNote = new P("unitime-Note");

        public AbbvTextCell(String text) {
            super(null);
            if (text != null && text.indexOf(124) >= 0) {
                this.iNote.setHTML(text.substring(0, text.indexOf(124)));
                this.iNote.setTitle(text.substring(text.indexOf(124) + 1).replace("\n", "<br>"));
            } else {
                this.iNote.setHTML(text == null ? "" : text.replace("\n", "<br>"));
                if (text != null) {
                    this.iNote.setTitle(text);
                }
            }
        }

        public String getValue() {
            return this.iNote.getHTML();
        }

        public Widget getWidget() {
            return this.iNote;
        }

        public void setStyleName(String styleName) {
            super.setStyleName(styleName);
        }
    }

    public static class NoteCell
    extends Cell {
        private P iNote = new P("unitime-Note");

        public NoteCell(String text, String title) {
            super(null);
            this.iNote.setHTML(text);
            if (title != null) {
                this.iNote.setTitle(title);
            }
        }

        public String getValue() {
            return this.iNote.getHTML();
        }

        public Widget getWidget() {
            return this.iNote;
        }

        public void setStyleName(String styleName) {
            super.setStyleName(styleName);
        }
    }

    public static class IconsCell
    extends Cell {
        private HorizontalPanel iPanel = new HorizontalPanel();

        public IconsCell() {
            super(null);
            this.iPanel.setStyleName("icons");
        }

        public IconsCell add(ImageResource resource, String title) {
            if (resource == null) {
                return this;
            }
            Image icon = new Image(resource);
            icon.setTitle(title);
            icon.setAltText(title);
            if (this.iPanel.getWidgetCount() > 0) {
                icon.getElement().getStyle().setPaddingLeft(3.0, Style.Unit.PX);
            }
            this.iPanel.add((Widget)icon);
            this.iPanel.setCellVerticalAlignment((Widget)icon, HasVerticalAlignment.ALIGN_MIDDLE);
            return this;
        }

        public String getValue() {
            String value = "";
            for (int i = 0; i < this.iPanel.getWidgetCount(); ++i) {
                if (i > 0) {
                    value = value + ", ";
                }
                value = value + ((Image)this.iPanel.getWidget(i)).getTitle();
            }
            return value;
        }

        public Widget getWidget() {
            return this.iPanel;
        }

        public void setStyleName(String styleName) {
            super.setStyleName(styleName);
        }
    }

    public static class IconCell
    extends Cell {
        private Image iIcon = null;
        private HTML iLabel = null;
        private HorizontalPanel iPanel = null;

        public IconCell(ImageResource resource, String title, String text) {
            super(null);
            this.iIcon = new Image(resource);
            this.iIcon.setTitle(title);
            this.iIcon.setAltText(title);
            if (text != null && !text.isEmpty()) {
                this.iLabel = new HTML(text, false);
                this.iPanel = new HorizontalPanel();
                this.iPanel.setStyleName("icon");
                this.iPanel.add((Widget)this.iIcon);
                this.iPanel.add((Widget)this.iLabel);
                this.iIcon.getElement().getStyle().setPaddingRight(3.0, Style.Unit.PX);
                this.iPanel.setCellVerticalAlignment((Widget)this.iIcon, HasVerticalAlignment.ALIGN_MIDDLE);
            }
        }

        public String getValue() {
            return this.iPanel == null ? this.iIcon.getTitle() : this.iLabel.getText();
        }

        public Widget getWidget() {
            return this.iPanel == null ? this.iIcon : this.iPanel;
        }

        public void setStyleName(String styleName) {
            super.setStyleName(styleName);
            if (this.iLabel != null) {
                this.iLabel.setStyleName(styleName);
                this.iLabel.getElement().getStyle().setBorderWidth(0.0, Style.Unit.PX);
            }
        }
    }

    public static class CheckboxCell
    extends Cell
    implements HasAriaLabel {
        private AriaCheckBox iCheck = new AriaCheckBox();

        public CheckboxCell(boolean check, String text, String ariaLabel) {
            super(null);
            if (text != null) {
                this.iCheck.setText(text);
            }
            this.iCheck.setValue(check);
            this.iCheck.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            if (ariaLabel != null) {
                this.setAriaLabel(ariaLabel);
            }
        }

        public CheckboxCell(boolean check, String ariaLabel) {
            this(check, null, ariaLabel);
        }

        public CheckboxCell(boolean check, String ariaLabel, final String onTitle, final String offTitle) {
            this(check, null, ariaLabel);
            this.iCheck.setTitle(this.iCheck.getValue() != false ? onTitle : offTitle);
            this.iCheck.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    CheckboxCell.this.iCheck.setTitle((Boolean)event.getValue() != false ? onTitle : offTitle);
                }
            });
        }

        public boolean isChecked() {
            return this.iCheck.getValue();
        }

        public String getValue() {
            return this.iCheck.getValue().toString();
        }

        public Widget getWidget() {
            return this.iCheck;
        }

        public String getAriaLabel() {
            return this.iCheck.getAriaLabel();
        }

        public void setAriaLabel(String text) {
            this.iCheck.setAriaLabel(text);
        }
    }

    public static class Cell
    implements HasAriaLabel {
        String iValue;
        int iColSpan = 1;
        String iStyleName = null;
        String iWidth = null;
        Row iRow = null;
        int iColIdx = -1;
        boolean iWrap = false;
        HasVerticalAlignment.VerticalAlignmentConstant iVerticalAlignment = HasVerticalAlignment.ALIGN_TOP;
        HasHorizontalAlignment.HorizontalAlignmentConstant iHorizontalAlignment = HasHorizontalAlignment.ALIGN_LEFT;
        String iAriaLabel = null;
        String iTitle = null;

        public Cell(String value) {
            this.iValue = value;
        }

        public Cell(String value, int colSpan, String width) {
            this.iValue = value;
            this.iColSpan = colSpan;
            this.iWidth = width;
        }

        public Cell(String value, boolean wrap) {
            this.iValue = value;
            this.iWrap = wrap;
        }

        public String getValue() {
            return this.iValue;
        }

        public int getColSpan() {
            return this.iColSpan;
        }

        public void setColSpan(int colSpan) {
            this.iColSpan = colSpan;
        }

        public String getStyleName() {
            return this.iStyleName;
        }

        public void setStyleName(String styleName) {
            this.iStyleName = styleName;
            if (this.iRow != null) {
                this.iRow.iTable.iTable.getCellFormatter().setStyleName(this.iRow.iTable.getHeaderRowsCount() + this.iRow.iRowIdx, this.iColIdx, this.iStyleName);
            }
        }

        public String getWidth() {
            return this.iWidth;
        }

        public void setWitdh(String width) {
            this.iWidth = width;
        }

        public void setColIdx(int colIdx) {
            this.iColIdx = colIdx;
        }

        public int getColIdx() {
            return this.iColIdx;
        }

        public void setRow(Row row) {
            this.iRow = row;
        }

        public Row getRow() {
            return this.iRow;
        }

        public Widget getWidget() {
            return null;
        }

        public HasVerticalAlignment.VerticalAlignmentConstant getVerticalAlignment() {
            return this.iVerticalAlignment;
        }

        public void setVerticalAlignment(HasVerticalAlignment.VerticalAlignmentConstant vertical) {
            this.iVerticalAlignment = vertical;
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getHorizontalAlignment() {
            return this.iHorizontalAlignment;
        }

        public void setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant vertical) {
            this.iHorizontalAlignment = vertical;
        }

        public boolean getWordWrap() {
            return this.iWrap;
        }

        public void setWordWrap(boolean wrap) {
            this.iWrap = wrap;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public String toString() {
            return this.getValue();
        }

        public String getAriaLabel() {
            return this.iAriaLabel;
        }

        public void setAriaLabel(String text) {
            this.iAriaLabel = text;
        }

        public Cell aria(String text) {
            this.iAriaLabel = text;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Row
    implements HasAriaLabel {
        private String iId;
        private Cell[] iCells;
        private int iRowIdx = -1;
        private WebTable iTable;
        private boolean iSelectable = true;
        private String iAriaLabel = null;

        public Row(Cell ... cells) {
            this.iCells = cells;
        }

        public Row(ArrayList<Cell> cells) {
            this.iCells = new Cell[cells.size()];
            for (int i = 0; i < this.iCells.length; ++i) {
                this.iCells[i] = cells.get(i);
            }
        }

        public Row(String ... cells) {
            this.iCells = new Cell[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                this.iCells[i] = new Cell(cells[i]);
            }
        }

        public int getNrCells() {
            return this.iCells.length;
        }

        public Cell getCell(int idx) {
            return this.iCells[idx];
        }

        public Cell[] getCells() {
            return this.iCells;
        }

        public String getId() {
            return this.iId;
        }

        public void setId(String id) {
            this.iId = id;
        }

        public int getRowIdx() {
            return this.iRowIdx;
        }

        public void setRowIdx(int rowIdx) {
            this.iRowIdx = rowIdx;
        }

        public void setTable(WebTable table) {
            this.iTable = table;
        }

        public WebTable getTable() {
            return this.iTable;
        }

        public boolean isSelectable() {
            return this.iSelectable;
        }

        public void setSelectable(boolean selectable) {
            this.iSelectable = selectable;
        }

        public void setCell(int col, Cell cell) {
            this.iCells[col] = cell;
            if (this.iTable != null) {
                RowSelectingFlexTable t = this.iTable.iTable;
                cell.setColIdx(col);
                cell.setRow(this);
                if (cell.getWidget() == null) {
                    t.setHTML(this.getRowIdx() + this.iTable.getHeaderRowsCount(), col, cell.getValue() == null || cell.getValue().isEmpty() ? "&nbsp;" : cell.getValue());
                } else {
                    t.setWidget(this.getRowIdx() + this.iTable.getHeaderRowsCount(), col, cell.getWidget());
                }
                t.getFlexCellFormatter().setWordWrap(this.getRowIdx() + this.iTable.getHeaderRowsCount(), col, cell.getWordWrap());
                t.getFlexCellFormatter().setColSpan(this.getRowIdx() + this.iTable.getHeaderRowsCount(), col, cell.getColSpan());
                t.getFlexCellFormatter().setStyleName(this.getRowIdx() + this.iTable.getHeaderRowsCount(), col, cell.getStyleName());
                t.getFlexCellFormatter().setWidth(this.getRowIdx() + this.iTable.getHeaderRowsCount(), col, cell.getWidth());
                t.getFlexCellFormatter().setVerticalAlignment(this.getRowIdx() + this.iTable.getHeaderRowsCount(), col, cell.getVerticalAlignment());
                t.getFlexCellFormatter().setHorizontalAlignment(this.getRowIdx() + this.iTable.getHeaderRowsCount(), col, cell.getHorizontalAlignment());
                t.getFlexCellFormatter().getElement(this.getRowIdx() + this.iTable.getHeaderRowsCount(), col).setTitle(cell.getTitle());
            }
        }

        @Override
        public String getAriaLabel() {
            return this.iAriaLabel;
        }

        @Override
        public void setAriaLabel(String text) {
            this.iAriaLabel = text;
        }
    }
}

