/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.widgets.OpenCloseSectionImage;
import org.unitime.timetable.gwt.resources.GwtResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniTimeHeaderPanel
extends Composite {
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private static RegExp sAcessKeyRegExp = RegExp.compile((String)"<u>(\\w)</u>", (String)"i");
    private static RegExp sStripAcessKeyRegExp = RegExp.compile((String)"(.*)<u>(\\w)</u>(.*)", (String)"i");
    private HashMap<String, Integer> iOperations = new HashMap();
    private HashMap<String, ClickHandler> iClickHandlers = new HashMap();
    private HTML iMessage;
    private HTML iTitle;
    private HorizontalPanel iButtons;
    private HorizontalPanel iPanel;
    private Image iLoadingImage;
    private OpenCloseSectionImage iOpenCloseImage;
    private boolean iRotateFocus = false;
    private KeyDownHandler iKeyDownHandler = null;
    private List<UniTimeHeaderPanel> iClones = new ArrayList<UniTimeHeaderPanel>();

    public UniTimeHeaderPanel(String title) {
        this.iPanel = new HorizontalPanel();
        this.iOpenCloseImage = new OpenCloseSectionImage(true);
        this.iOpenCloseImage.setVisible(false);
        this.iPanel.add((Widget)this.iOpenCloseImage);
        this.iPanel.setCellHorizontalAlignment((Widget)this.iOpenCloseImage, HasHorizontalAlignment.ALIGN_LEFT);
        this.iPanel.setCellVerticalAlignment((Widget)this.iOpenCloseImage, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iTitle = new HTML(title, false);
        this.iTitle.setStyleName("unitime-MainHeader");
        this.iPanel.add((Widget)this.iTitle);
        this.iPanel.setCellHorizontalAlignment((Widget)this.iTitle, HasHorizontalAlignment.ALIGN_LEFT);
        this.iPanel.setCellVerticalAlignment((Widget)this.iTitle, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iMessage = new HTML("", false);
        this.iMessage.setStyleName("unitime-Message");
        this.iMessage.setVisible(false);
        this.iPanel.add((Widget)this.iMessage);
        this.iPanel.setCellHorizontalAlignment((Widget)this.iMessage, HasHorizontalAlignment.ALIGN_CENTER);
        this.iPanel.setCellVerticalAlignment((Widget)this.iMessage, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iPanel.setCellWidth((Widget)this.iMessage, "100%");
        this.iLoadingImage = new Image(RESOURCES.loading_small());
        this.iLoadingImage.setVisible(false);
        this.iPanel.add((Widget)this.iLoadingImage);
        this.iPanel.setCellHorizontalAlignment((Widget)this.iLoadingImage, HasHorizontalAlignment.ALIGN_CENTER);
        this.iPanel.setCellVerticalAlignment((Widget)this.iLoadingImage, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iButtons = new HorizontalPanel();
        this.iButtons.addStyleName("unitime-NoPrint");
        this.iPanel.add((Widget)this.iButtons);
        this.iPanel.setCellHorizontalAlignment((Widget)this.iButtons, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iPanel.setWidth("100%");
        this.iKeyDownHandler = new KeyDownHandler(){

            private void focus(KeyDownEvent event, final Button buttonToFocus) {
                event.preventDefault();
                event.stopPropagation();
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        buttonToFocus.setFocus(true);
                    }
                });
            }

            public void onKeyDown(KeyDownEvent event) {
                if (UniTimeHeaderPanel.this.iRotateFocus && event.getNativeKeyCode() == 9 && event.getSource() != null && event.getSource() instanceof Button) {
                    HorizontalPanel panel = UniTimeHeaderPanel.this.iButtons;
                    Button firstButton = null;
                    for (int i = 0; i < panel.getWidgetCount(); ++i) {
                        Button button = (Button)panel.getWidget(i);
                        if (!button.isEnabled()) continue;
                        firstButton = button;
                        break;
                    }
                    if (firstButton == null) {
                        return;
                    }
                    if (!UniTimeHeaderPanel.this.iClones.isEmpty()) {
                        panel = ((UniTimeHeaderPanel)((Object)UniTimeHeaderPanel.this.iClones.get(UniTimeHeaderPanel.this.iClones.size() - 1))).iButtons;
                    }
                    Object lastButton = null;
                    for (int i = panel.getWidgetCount() - 1; i >= 0; --i) {
                        Button button = (Button)panel.getWidget(i);
                        if (!button.isEnabled()) continue;
                        lastButton = button;
                        break;
                    }
                    if (lastButton == null) {
                        return;
                    }
                    if (lastButton.equals(event.getSource()) && !event.isShiftKeyDown()) {
                        this.focus(event, firstButton);
                    }
                    if (firstButton.equals(event.getSource()) && event.isShiftKeyDown()) {
                        this.focus(event, (Button)lastButton);
                    }
                }
            }
        };
        this.initWidget((Widget)this.iPanel);
    }

    public void setRotateFocus(boolean rotateFocus) {
        this.iRotateFocus = rotateFocus;
    }

    public void setTitleStyleName(String styleName) {
        this.iTitle.setStyleName(styleName);
    }

    public void addCollapsibleHandler(ValueChangeHandler<Boolean> handler) {
        this.iOpenCloseImage.addValueChangeHandler(handler);
    }

    public void setCollapsible(Boolean opened) {
        this.iOpenCloseImage.setVisible(opened != null);
        if (opened != null) {
            this.iOpenCloseImage.setValue(opened, false);
        }
    }

    public Boolean isCollapsible() {
        return this.iOpenCloseImage.isVisible() ? this.iOpenCloseImage.getValue() : null;
    }

    public void setHeaderTitle(String title) {
        this.iTitle.setHTML(title);
    }

    public String getHeaderTitle() {
        return this.iTitle.getHTML();
    }

    public UniTimeHeaderPanel() {
        this("&nbsp;");
    }

    public void clearMessage() {
        this.iMessage.setHTML("");
        this.iMessage.setVisible(false);
        this.iLoadingImage.setVisible(false);
        for (UniTimeHeaderPanel clone : this.iClones) {
            clone.clearMessage();
        }
    }

    public void setErrorMessage(String message, boolean wrap) {
        if (message == null || message.isEmpty()) {
            this.clearMessage();
        } else {
            this.iLoadingImage.setVisible(false);
            this.iMessage.setHTML(message);
            this.iMessage.setStyleName("unitime-ErrorMessage");
            this.iMessage.setVisible(true);
            this.iMessage.setWordWrap(wrap);
            for (UniTimeHeaderPanel clone : this.iClones) {
                clone.setErrorMessage(message, wrap);
            }
        }
    }

    public void setErrorMessage(String message) {
        if (message == null || message.isEmpty()) {
            this.clearMessage();
        } else {
            this.iLoadingImage.setVisible(false);
            this.iMessage.setHTML(message);
            this.iMessage.setStyleName("unitime-ErrorMessage");
            this.iMessage.setVisible(true);
            for (UniTimeHeaderPanel clone : this.iClones) {
                clone.setErrorMessage(message);
            }
        }
    }

    public void setWarningMessage(String message) {
        this.setWarningMessage(message, false);
    }

    public void setWarningMessage(String message, boolean wrap) {
        if (message == null || message.isEmpty()) {
            this.clearMessage();
        } else {
            this.iLoadingImage.setVisible(false);
            this.iMessage.setHTML(message);
            this.iMessage.setStyleName("unitime-WarningMessage");
            this.iMessage.setVisible(true);
            this.iMessage.setWordWrap(wrap);
            for (UniTimeHeaderPanel clone : this.iClones) {
                clone.setWarningMessage(message, wrap);
            }
        }
    }

    public void setMessage(String message) {
        if (message == null || message.isEmpty()) {
            this.clearMessage();
        } else {
            this.iLoadingImage.setVisible(false);
            this.iMessage.setHTML(message);
            this.iMessage.setStyleName("unitime-Message");
            this.iMessage.setVisible(true);
            for (UniTimeHeaderPanel clone : this.iClones) {
                clone.setMessage(message);
            }
        }
    }

    public void showLoading() {
        this.iMessage.setHTML("");
        this.iMessage.setVisible(false);
        this.iLoadingImage.setVisible(true);
        for (UniTimeHeaderPanel clone : this.iClones) {
            clone.showLoading();
        }
    }

    public void addButton(String operation, String name, ClickHandler clickHandler) {
        this.addButton(operation, name, null, clickHandler);
    }

    public void addButton(String operation, String name, Integer width, ClickHandler clickHandler) {
        this.addButton(operation, name, UniTimeHeaderPanel.guessAccessKey(name), width == null ? null : width + "px", clickHandler);
    }

    public static Character guessAccessKey(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        MatchResult result = sAcessKeyRegExp.exec(name);
        return result == null ? null : Character.valueOf(result.getGroup(1).toLowerCase().charAt(0));
    }

    public static String stripAccessKey(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        MatchResult result = sStripAcessKeyRegExp.exec(name);
        return result == null ? name : result.getGroup(1) + result.getGroup(2) + result.getGroup(3);
    }

    private Button addButton(String operation, String name, Character accessKey, String width, ClickHandler clickHandler) {
        Button button = new Button(name, clickHandler);
        ToolBox.setWhiteSpace(button.getElement().getStyle(), "nowrap");
        if (accessKey != null) {
            button.setAccessKey(accessKey.charValue());
        }
        if (width != null) {
            ToolBox.setMinWidth(button.getElement().getStyle(), width);
        }
        this.iOperations.put(operation, this.iButtons.getWidgetCount());
        this.iClickHandlers.put(operation, clickHandler);
        this.iButtons.add((Widget)button);
        button.getElement().getStyle().setMarginLeft(4.0, Style.Unit.PX);
        for (UniTimeHeaderPanel clone : this.iClones) {
            Button clonedButton = clone.addButton(operation, name, null, width, clickHandler);
            clonedButton.addKeyDownHandler(this.iKeyDownHandler);
        }
        button.addKeyDownHandler(this.iKeyDownHandler);
        return button;
    }

    public void setEnabled(int button, boolean enabled) {
        Button b = (Button)this.iButtons.getWidget(button);
        b.setVisible(enabled);
        b.setEnabled(enabled);
        for (UniTimeHeaderPanel clone : this.iClones) {
            clone.setEnabled(button, enabled);
        }
    }

    public void setEnabled(String operation, boolean enabled) {
        Integer op = this.iOperations.get(operation);
        if (op != null) {
            this.setEnabled(this.iOperations.get(operation), enabled);
        }
    }

    public boolean isEnabled(int button) {
        return ((Button)this.iButtons.getWidget(button)).isVisible();
    }

    public Boolean isEnabled(String operation) {
        Integer op = this.iOperations.get(operation);
        return op == null ? null : Boolean.valueOf(this.isEnabled(op));
    }

    public UniTimeHeaderPanel clonePanel(String newTitle) {
        UniTimeHeaderPanel clone = new UniTimeHeaderPanel(newTitle == null ? "&nbsp;" : newTitle);
        this.iClones.add(clone);
        clone.iMessage.setHTML(this.iMessage.getHTML());
        clone.iMessage.setVisible(this.iMessage.isVisible());
        clone.iMessage.setStyleName(this.iMessage.getStyleName());
        for (int i = 0; i < this.iOperations.size(); ++i) {
            String op = null;
            for (Map.Entry<String, Integer> entry : this.iOperations.entrySet()) {
                if (entry.getValue() != i) continue;
                op = entry.getKey();
            }
            if (op == null) continue;
            final Button button = (Button)this.iButtons.getWidget(i);
            ClickHandler clickHandler = this.iClickHandlers.get(op);
            if (clickHandler == null) {
                clickHandler = new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        button.click();
                    }
                };
            }
            String width = ToolBox.getMinWidth(button.getElement().getStyle());
            Button clonedButton = clone.addButton(op, button.getHTML(), null, width, clickHandler);
            clonedButton.addKeyDownHandler(this.iKeyDownHandler);
            if (button.isVisible()) continue;
            clone.setEnabled(op, false);
        }
        return clone;
    }

    public UniTimeHeaderPanel clonePanel() {
        return this.clonePanel(this.iTitle.getHTML());
    }

    public void setVisible(boolean visible, boolean propagate) {
        super.setVisible(visible);
        if (propagate) {
            for (UniTimeHeaderPanel clone : this.iClones) {
                clone.setVisible(visible, propagate);
            }
        }
    }

    public void setVisible(boolean visible) {
        this.setVisible(visible, false);
    }

    public HorizontalPanel getPanel() {
        return this.iPanel;
    }
}

