/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.BodyElement;
import com.google.gwt.dom.client.FrameElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialogDisplay;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;

public class UniTimeFrameDialogImpl
extends UniTimeDialogBox
implements UniTimeFrameDialogDisplay {
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private Frame iFrame = null;
    private Timer iCheckLoadingWidgetIsShowing = null;

    public UniTimeFrameDialogImpl() {
        super(true, true);
        this.setEscapeToHide(true);
        this.iFrame = new Frame();
        this.iFrame.getElement().getStyle().setBorderWidth(0.0, Style.Unit.PX);
        UniTimeFrameDialogImpl.hookFrameLoaded((FrameElement)this.iFrame.getElement().cast());
        this.setWidget((Widget)this.iFrame);
        this.iCheckLoadingWidgetIsShowing = new Timer(){

            public void run() {
                if (LoadingWidget.getInstance().isShowing()) {
                    LoadingWidget.getInstance().hide();
                    UniTimeNotifications.error(UniTimeFrameDialogImpl.this.getText() + " does not seem to load, " + "please check <a href='" + UniTimeFrameDialogImpl.this.iFrame.getUrl() + "' style='white-space: nowrap;'>" + UniTimeFrameDialogImpl.this.iFrame.getUrl() + "</a> for yourself.");
                }
            }
        };
        this.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                if (LoadingWidget.getInstance().isShowing()) {
                    LoadingWidget.getInstance().hide();
                }
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
            }
        });
        this.iFrame.addLoadHandler(new LoadHandler(){

            public void onLoad(LoadEvent event) {
                LoadingWidget.getInstance().hide();
                try {
                    FrameElement frame = (FrameElement)UniTimeFrameDialogImpl.this.iFrame.getElement().cast();
                    BodyElement body = frame.getContentDocument().getBody();
                    if (body.getScrollWidth() > body.getClientWidth()) {
                        UniTimeFrameDialogImpl.this.iFrame.setWidth(Math.min(frame.getClientWidth() + body.getScrollWidth() - body.getClientWidth(), Window.getClientWidth() * 95 / 100) + "px");
                        UniTimeFrameDialogImpl.this.setPopupPosition(Math.max(Window.getScrollLeft() + (Window.getClientWidth() - UniTimeFrameDialogImpl.this.getOffsetWidth()) / 2, 0), Math.max(Window.getScrollTop() + (Window.getClientHeight() - UniTimeFrameDialogImpl.this.getOffsetHeight()) / 2, 0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setFrameSize(String width, String height) {
        try {
            this.iFrame.getElement().getStyle().setWidth(Double.parseDouble(width), Style.Unit.PX);
        }
        catch (NumberFormatException e) {
            this.iFrame.setWidth(width);
        }
        try {
            this.iFrame.getElement().getStyle().setHeight(Double.parseDouble(height), Style.Unit.PX);
        }
        catch (NumberFormatException e) {
            this.iFrame.setHeight(height);
        }
    }

    public void center() {
        super.center();
        this.iCheckLoadingWidgetIsShowing.schedule(30000);
        RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
        AriaStatus.getInstance().setText(ARIA.dialogOpened(this.getText()));
    }

    public void openDialog(String title, String source, String width, String height) {
        String h;
        if (this.isShowing()) {
            this.hide();
        }
        GwtHint.hideHint();
        LoadingWidget.getInstance().show("Loading " + title + " ...");
        this.setText(title);
        String hash = null;
        int hashIdx = source.lastIndexOf(35);
        if (hashIdx >= 0) {
            hash = source.substring(hashIdx);
            source = source.substring(0, hashIdx);
        }
        this.iFrame.setUrl(source + (source.indexOf(63) >= 0 ? "&" : "?") + "noCacheTS=" + new Date().getTime() + (hash == null ? "" : hash));
        String w = width == null || width.isEmpty() ? String.valueOf(Window.getClientWidth() * 3 / 4) : width;
        String string = h = height == null || height.isEmpty() ? String.valueOf(Window.getClientHeight() * 3 / 4) : height;
        if (w.endsWith("%")) {
            w = String.valueOf(Integer.parseInt(w.substring(0, w.length() - 1)) * Window.getClientWidth() / 100);
        }
        if (h.endsWith("%")) {
            h = String.valueOf(Integer.parseInt(h.substring(0, h.length() - 1)) * Window.getClientHeight() / 100);
        }
        this.setFrameSize(w, h);
        this.center();
    }

    public void hideDialog() {
        this.hide();
    }

    public static void notifyFrameLoaded() {
        LoadingWidget.getInstance().hide();
    }

    public static native void hookFrameLoaded(FrameElement var0);
}

