/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseFinderClasses
extends WebTable
implements CourseFinder.CourseFinderCourseDetails<Collection<ClassAssignmentInterface.ClassAssignment>> {
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private String iValue = null;
    private DataProvider<String, Collection<ClassAssignmentInterface.ClassAssignment>> iDataProvider = null;

    public CourseFinderClasses() {
        this.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colSubpart(), 1, "50px"), new WebTable.Cell(MESSAGES.colClass(), 1, "90px"), new WebTable.Cell(MESSAGES.colLimit(), 1, "60px"), new WebTable.Cell(MESSAGES.colDays(), 1, "60px"), new WebTable.Cell(MESSAGES.colStart(), 1, "60px"), new WebTable.Cell(MESSAGES.colEnd(), 1, "60px"), new WebTable.Cell(MESSAGES.colDate(), 1, "100px"), new WebTable.Cell(MESSAGES.colRoom(), 1, "100px"), new WebTable.Cell(MESSAGES.colInstructor(), 1, "120px"), new WebTable.Cell(MESSAGES.colParent(), 1, "90px"), new WebTable.Cell(MESSAGES.colHighDemand(), 1, "10px"), new WebTable.Cell(MESSAGES.colNoteIcon(), 1, "10px")));
        this.setEmptyMessage(MESSAGES.courseSelectionNoCourseSelected());
    }

    public Widget asWidget() {
        return this;
    }

    public void setValue(String value) {
        if (value == null || value.isEmpty()) {
            this.iValue = value;
            this.setEmptyMessage(MESSAGES.courseSelectionNoCourseSelected());
            this.clearData(true);
        } else if (!value.equals(this.iValue)) {
            this.iValue = value;
            this.setEmptyMessage(MESSAGES.courseSelectionLoadingClasses());
            this.clearData(true);
            this.iDataProvider.getData(value, new AsyncCallback<Collection<ClassAssignmentInterface.ClassAssignment>>(){

                public void onFailure(Throwable caught) {
                    CourseFinderClasses.this.setEmptyMessage(caught.getMessage());
                }

                public void onSuccess(Collection<ClassAssignmentInterface.ClassAssignment> result) {
                    if (!result.isEmpty()) {
                        WebTable.Row[] rows = new WebTable.Row[result.size()];
                        int idx = 0;
                        Long lastSubpartId = null;
                        for (ClassAssignmentInterface.ClassAssignment clazz : result) {
                            WebTable.Row row = null;
                            row = clazz.isAssigned() ? new WebTable.Row(new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays())), new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getDatePattern()), new WebTable.Cell(clazz.getRooms(", ")), new WebTable.Cell(clazz.getInstructors(", ")), new WebTable.Cell(clazz.getParentSection()), clazz.isSaved() ? new WebTable.IconCell(WebTable.RESOURCES.saved(), null, null) : (clazz.isOfHighDemand() ? new WebTable.IconCell(WebTable.RESOURCES.highDemand(), MESSAGES.highDemand(clazz.getExpected(), clazz.getAvailableLimit()), null) : new WebTable.Cell("")), clazz.hasNote() ? new WebTable.IconCell(WebTable.RESOURCES.note(), clazz.getNote(), "") : new WebTable.Cell("")) : new WebTable.Row(new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell(MESSAGES.arrangeHours(), 4, null), new WebTable.Cell(clazz.getRooms(", ")), new WebTable.Cell(clazz.getInstructors(", ")), new WebTable.Cell(clazz.getParentSection()), clazz.isSaved() ? new WebTable.IconCell(WebTable.RESOURCES.saved(), null, null) : (clazz.isOfHighDemand() ? new WebTable.IconCell(WebTable.RESOURCES.highDemand(), MESSAGES.highDemand(clazz.getExpected(), clazz.getAvailableLimit()), null) : new WebTable.Cell("")), clazz.hasNote() ? new WebTable.IconCell(WebTable.RESOURCES.note(), clazz.getNote(), "") : new WebTable.Cell(""));
                            row.setId(clazz.getClassId().toString());
                            String styleName = "";
                            if (lastSubpartId != null && !clazz.getSubpartId().equals(lastSubpartId)) {
                                styleName = styleName + "top-border-dashed";
                            }
                            if (!clazz.isSaved() && !clazz.isAvailable()) {
                                styleName = styleName + " text-gray";
                            }
                            for (WebTable.Cell cell : row.getCells()) {
                                cell.setStyleName(styleName.trim());
                            }
                            rows[idx++] = row;
                            lastSubpartId = clazz.getSubpartId();
                            if (!clazz.isSaved() && !clazz.isAvailable()) {
                                row.setAriaLabel(ARIA.courseFinderClassNotAvailable(MESSAGES.clazz(clazz.getSubject(), clazz.getCourseNbr(), clazz.getSubpart(), clazz.getSection()), clazz.isAssigned() ? clazz.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + clazz.getRooms(",") : ARIA.arrangeHours()));
                                continue;
                            }
                            row.setAriaLabel(ARIA.courseFinderClassAvailable(MESSAGES.clazz(clazz.getSubject(), clazz.getCourseNbr(), clazz.getSubpart(), clazz.getSection()), clazz.isAssigned() ? clazz.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + clazz.getRooms(",") : ARIA.arrangeHours(), clazz.getLimitString()));
                        }
                        CourseFinderClasses.this.setData(rows);
                    } else {
                        CourseFinderClasses.this.setEmptyMessage(MESSAGES.courseSelectionNoClasses(CourseFinderClasses.this.iValue));
                    }
                }
            });
        }
    }

    public String getValue() {
        return this.iValue;
    }

    @Override
    public void setDataProvider(DataProvider<String, Collection<ClassAssignmentInterface.ClassAssignment>> provider) {
        this.iDataProvider = provider;
    }

    @Override
    public String getName() {
        return MESSAGES.courseSelectionClasses();
    }
}

