/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.aria.client.Id;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.sectioning.TimeGrid;
import org.unitime.timetable.gwt.client.widgets.HorizontalPanelWithHint;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsBox
extends UniTimeDialogBox {
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    public static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private ClassAssignmentInterface.ClassAssignment iAssignment;
    private AsyncCallback<Collection<ClassAssignmentInterface>> iCallback = null;
    private ArrayList<ClassAssignmentInterface.ClassAssignment> iCurrent = null;
    private ArrayList<ClassAssignmentInterface> iResult = null;
    private ArrayList<SuggestionSelectedHandler> iSuggestionSelectedHandlers = new ArrayList();
    private WebTable iSuggestions;
    private HTML iMessages;
    private HTML iLegend;
    private ScrollPanel iSuggestionsScroll;
    private String iSource;
    private AriaTextBox iFilter;
    private int iIndex;
    private CourseRequestInterface iRequest;
    private HorizontalPanelWithHint iFilterPanel;
    private Button iSearch;
    private boolean iOnline;
    private TimeGrid iGrid;
    private PopupPanel iHint;
    private String iHintId = null;
    private Timer iHideHint;

    public SuggestionsBox(TimeGrid.ColorProvider color, boolean online) {
        super(true, false);
        this.iOnline = online;
        this.setText("Alternatives");
        this.setAnimationEnabled(true);
        this.setAutoHideEnabled(true);
        this.setGlassEnabled(true);
        this.setModal(false);
        VerticalPanel suggestionPanel = new VerticalPanel();
        suggestionPanel.setSpacing(5);
        this.iFilterPanel = new HorizontalPanelWithHint((Widget)new HTML(MESSAGES.suggestionsFilterHint(), false));
        this.iFilterPanel.setSpacing(3);
        Label filterLabel = new Label("Filter:");
        this.iFilterPanel.add((Widget)filterLabel);
        this.iFilterPanel.setCellVerticalAlignment((Widget)filterLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iFilter = new AriaTextBox();
        this.iFilter.setStyleName("gwt-SuggestBox");
        this.iFilter.getElement().getStyle().setWidth(600.0, Style.Unit.PX);
        this.iFilter.getElement().getStyle().setHeight(26.0, Style.Unit.PX);
        this.iFilterPanel.add((Widget)this.iFilter);
        HTML ariaDescription = new HTML(MESSAGES.suggestionsFilterHint(), false);
        ariaDescription.setStyleName("unitime-AriaHiddenLabel");
        ariaDescription.getElement().setId(DOM.createUniqueId());
        this.iFilterPanel.add((Widget)ariaDescription);
        Roles.getTextboxRole().setAriaDescribedbyProperty((Element)this.iFilter.getElement(), new Id[]{Id.of((Element)ariaDescription.getElement())});
        this.iSearch = new Button(MESSAGES.buttonSearch());
        this.iSearch.setAccessKey('s');
        this.iSearch.addStyleName("unitime-NoPrint");
        this.iFilterPanel.add((Widget)this.iSearch);
        this.iFilterPanel.setCellVerticalAlignment((Widget)this.iSearch, HasVerticalAlignment.ALIGN_MIDDLE);
        suggestionPanel.add((Widget)this.iFilterPanel);
        suggestionPanel.setCellHorizontalAlignment((Widget)this.iFilter, HasHorizontalAlignment.ALIGN_CENTER);
        this.iSuggestions = new WebTable();
        this.iSuggestions.setHeader(new WebTable.Row(new WebTable.Cell("", 1, "10px"), new WebTable.Cell(MESSAGES.colSubject(), 1, "50px"), new WebTable.Cell(MESSAGES.colCourse(), 1, "50px"), new WebTable.Cell(MESSAGES.colSubpart(), 1, "40px"), new WebTable.Cell(MESSAGES.colClass(), 1, "40px"), new WebTable.Cell(MESSAGES.colTime(), 1, "75px").aria(ARIA.colTimeCurrent()), new WebTable.Cell("", 1, "1px").aria(ARIA.colTimeNew()), new WebTable.Cell(MESSAGES.colDate(), 1, "50px").aria(ARIA.colDateCurrent()), new WebTable.Cell("", 1, "1px").aria(ARIA.colDateNew()), new WebTable.Cell(MESSAGES.colRoom(), 1, "50px").aria(ARIA.colRoomCurrent()), new WebTable.Cell("", 1, "1px").aria(ARIA.colRoomNew()), new WebTable.Cell(MESSAGES.colInstructor(), 1, "100px"), new WebTable.Cell(MESSAGES.colParent(), 1, "50px"), new WebTable.Cell(MESSAGES.colIcons(), 1, "10px")));
        this.iSuggestions.setSelectSameIdRows(true);
        this.iSuggestions.setEmptyMessage(MESSAGES.suggestionsLoading());
        this.iSuggestionsScroll = new ScrollPanel((Widget)this.iSuggestions);
        this.iSuggestionsScroll.getElement().getStyle().setHeight(400.0, Style.Unit.PX);
        this.iSuggestionsScroll.setStyleName("unitime-ScrollPanel");
        suggestionPanel.add((Widget)this.iSuggestionsScroll);
        this.iLegend = new HTML();
        this.iLegend.setStyleName("unitime-SuggestionsLegend");
        suggestionPanel.add((Widget)this.iLegend);
        this.iMessages = new HTML();
        this.iMessages.setStyleName("unitime-SuggestionsMessage");
        suggestionPanel.add((Widget)this.iMessages);
        this.iCallback = new AsyncCallback<Collection<ClassAssignmentInterface>>(){

            public void onFailure(Throwable caught) {
                SuggestionsBox.this.iSuggestions.clearData(true);
                SuggestionsBox.this.iSuggestions.setEmptyMessage("<font color='red'>" + caught.getMessage() + "</font>");
                SuggestionsBox.this.iMessages.setHTML("");
                LoadingWidget.getInstance().hide();
                SuggestionsBox.this.center();
                AriaStatus.getInstance().setHTML(caught.getMessage());
            }

            public void onSuccess(Collection<ClassAssignmentInterface> result) {
                SuggestionsBox.this.iResult = (ArrayList)result;
                SuggestionsBox.this.iMessages.setHTML("");
                String ariaStatus = null;
                if (result.isEmpty()) {
                    SuggestionsBox.this.iSuggestions.clearData(true);
                    if (SuggestionsBox.this.iFilter.getText().isEmpty()) {
                        SuggestionsBox.this.iSuggestions.setEmptyMessage(MESSAGES.suggestionsNoAlternative(SuggestionsBox.this.iSource));
                        ariaStatus = ARIA.suggestionsNoAlternative(SuggestionsBox.this.iSource);
                    } else {
                        SuggestionsBox.this.iSuggestions.setEmptyMessage(MESSAGES.suggestionsNoAlternativeWithFilter(SuggestionsBox.this.iSource, SuggestionsBox.this.iFilter.getText()));
                        ariaStatus = ARIA.suggestionsNoAlternativeWithFilter(SuggestionsBox.this.iSource, SuggestionsBox.this.iFilter.getText());
                    }
                    LoadingWidget.getInstance().hide();
                    SuggestionsBox.this.center();
                } else {
                    ArrayList<WebTable.Row> rows = new ArrayList<WebTable.Row>();
                    int lastSize = 0;
                    int suggestionId = 0;
                    for (ClassAssignmentInterface suggestion : result) {
                        if (suggestion.hasMessages()) {
                            SuggestionsBox.this.iMessages.setHTML(suggestion.getMessages("<br>"));
                        }
                        if (suggestion.getCourseAssignments().isEmpty()) {
                            ++suggestionId;
                            continue;
                        }
                        for (ClassAssignmentInterface.CourseAssignment courseAssignment : suggestion.getCourseAssignments()) {
                            ArrayList<Object> sameCourse = new ArrayList<Object>();
                            if (!courseAssignment.isFreeTime()) {
                                for (Object x : SuggestionsBox.this.iCurrent) {
                                    if (x == null || !courseAssignment.getCourseId().equals(((ClassAssignmentInterface.ClassAssignment)x).getCourseId())) continue;
                                    sameCourse.add(x);
                                }
                            } else {
                                Object x;
                                ClassAssignmentInterface.ClassAssignment clazz = courseAssignment.getClassAssignments().get(0);
                                x = SuggestionsBox.this.iCurrent.iterator();
                                while (x.hasNext()) {
                                    ClassAssignmentInterface.ClassAssignment x2 = (ClassAssignmentInterface.ClassAssignment)x.next();
                                    if (x2 == null || !x2.isFreeTime() || !x2.getDaysString(CONSTANTS.shortDays()).equals(clazz.getDaysString(CONSTANTS.shortDays())) || x2.getStart() != clazz.getStart() || x2.getLength() != clazz.getLength()) continue;
                                    sameCourse.add(x2);
                                }
                            }
                            boolean selected = false;
                            if (SuggestionsBox.this.iAssignment.isFreeTime() && courseAssignment.isFreeTime() && courseAssignment.getClassAssignments().get(0).getDaysString(CONSTANTS.shortDays()).equals(SuggestionsBox.this.iAssignment.getDaysString(CONSTANTS.shortDays())) && courseAssignment.getClassAssignments().get(0).getStart() == SuggestionsBox.this.iAssignment.getStart() && courseAssignment.getClassAssignments().get(0).getLength() == SuggestionsBox.this.iAssignment.getLength()) {
                                selected = true;
                            }
                            if (!SuggestionsBox.this.iAssignment.isFreeTime() && !SuggestionsBox.this.iAssignment.isAssigned() && SuggestionsBox.this.iAssignment.getCourseId().equals(courseAssignment.getCourseId())) {
                                selected = true;
                            }
                            if (courseAssignment.isAssigned()) {
                                int clazzIdx = 0;
                                Long selectClassId = null;
                                String selectSubpart = null;
                                if (SuggestionsBox.this.iAssignment.getSubpartId() != null && SuggestionsBox.this.iAssignment.getCourseId().equals(courseAssignment.getCourseId())) {
                                    for (ClassAssignmentInterface.ClassAssignment clazz : courseAssignment.getClassAssignments()) {
                                        if (!SuggestionsBox.this.iAssignment.getSubpartId().equals(clazz.getSubpartId())) continue;
                                        selectClassId = clazz.getClassId();
                                    }
                                    if (selectClassId == null) {
                                        for (ClassAssignmentInterface.ClassAssignment clazz : courseAssignment.getClassAssignments()) {
                                            if (!SuggestionsBox.this.iAssignment.getSubpart().equals(clazz.getSubpart())) continue;
                                            selectSubpart = clazz.getSubpart();
                                        }
                                    }
                                    if (selectClassId == null && selectSubpart == null) {
                                        selected = true;
                                    }
                                }
                                block6: for (ClassAssignmentInterface.ClassAssignment clazz : courseAssignment.getClassAssignments()) {
                                    if (selectClassId != null) {
                                        selected = selectClassId.equals(clazz.getClassId());
                                    }
                                    if (selectSubpart != null) {
                                        selected = selectSubpart.equals(clazz.getSubpart());
                                    }
                                    ClassAssignmentInterface.ClassAssignment old = null;
                                    for (ClassAssignmentInterface.ClassAssignment x : SuggestionsBox.this.iCurrent) {
                                        if (x == null) continue;
                                        if (courseAssignment.isFreeTime()) {
                                            if (!x.isFreeTime() || !x.isCourseAssigned() || !x.getDaysString(CONSTANTS.shortDays()).equals(clazz.getDaysString(CONSTANTS.shortDays())) || x.getStart() != clazz.getStart() || x.getLength() != clazz.getLength()) continue;
                                            continue block6;
                                        }
                                        if (clazz.getCourseId().equals(x.getCourseId()) && clazz.getClassId().equals(x.getClassId())) continue block6;
                                        if (!clazz.getCourseId().equals(x.getCourseId()) || !clazz.getSubpartId().equals(x.getSubpartId())) continue;
                                        old = x;
                                        break;
                                    }
                                    if (old == null && clazzIdx < sameCourse.size()) {
                                        old = (ClassAssignmentInterface.ClassAssignment)sameCourse.get(clazzIdx);
                                    }
                                    if (old == null && sameCourse.size() == 1 && !((ClassAssignmentInterface.ClassAssignment)sameCourse.get(0)).isAssigned()) {
                                        old = (ClassAssignmentInterface.ClassAssignment)sameCourse.get(0);
                                    }
                                    WebTable.Cell[] icons = new WebTable.IconsCell();
                                    if (clazz != null && clazz.isSaved()) {
                                        icons.add(RESOURCES.saved(), MESSAGES.saved(MESSAGES.clazz(clazz.getSubject(), clazz.getCourseNbr(), clazz.getSubpart(), clazz.getSection())));
                                    }
                                    if (courseAssignment.isLocked()) {
                                        icons.add(RESOURCES.courseLocked(), MESSAGES.courseLocked(courseAssignment.getSubject() + " " + courseAssignment.getCourseNbr()));
                                    }
                                    if (clazz != null && clazz.isOfHighDemand()) {
                                        icons.add(RESOURCES.highDemand(), MESSAGES.highDemand(clazz.getExpected(), clazz.getAvailableLimit()));
                                    }
                                    if (clazz != null && clazz.hasNote()) {
                                        icons.add(RESOURCES.note(), clazz.getNote());
                                    }
                                    if (clazz != null && clazz.hasOverlapNote()) {
                                        icons.add(RESOURCES.overlap(), clazz.getOverlapNote());
                                    }
                                    WebTable.Row row = new WebTable.Row(new WebTable.Cell(rows.size() == lastSize ? suggestionId + "." : ""), new WebTable.Cell(clazzIdx > 0 ? "" : (courseAssignment.isFreeTime() ? MESSAGES.freeTimeSubject() : courseAssignment.getSubject())).aria(clazzIdx == 0 ? "" : (courseAssignment.isFreeTime() ? MESSAGES.freeTimeSubject() : courseAssignment.getSubject())), new WebTable.Cell(clazzIdx > 0 ? "" : (courseAssignment.isFreeTime() ? MESSAGES.freeTimeCourse() : courseAssignment.getCourseNbr())).aria(clazzIdx == 0 ? "" : (courseAssignment.isFreeTime() ? MESSAGES.freeTimeCourse() : courseAssignment.getCourseNbr())), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getSubpart(), clazz == null ? null : clazz.getSubpart(), CmpMode.SINGLE, selected, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getSection(), clazz == null ? null : clazz.getSection(), CmpMode.SINGLE, selected, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()), clazz == null ? null : clazz.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()), CmpMode.BOTH_OLD, selected, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()), clazz == null ? null : clazz.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()), CmpMode.BOTH_NEW, selected, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getDatePattern(), clazz == null ? null : clazz.getDatePattern(), CmpMode.BOTH_OLD, selected, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getDatePattern(), clazz == null ? null : clazz.getDatePattern(), CmpMode.BOTH_NEW, selected, clazz == null)), clazz != null && clazz.hasDistanceConflict() ? new WebTable.IconCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), SuggestionsBox.this.compare(old == null ? null : old.getRooms(", "), clazz == null ? null : clazz.getRooms(", "), CmpMode.BOTH_OLD, selected, clazz == null)) : new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getRooms(", "), clazz == null ? null : clazz.getRooms(", "), CmpMode.BOTH_OLD, selected, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getRooms(", "), clazz == null ? null : clazz.getRooms(", "), CmpMode.BOTH_NEW, selected, clazz == null)), new WebTable.InstructorCell(clazz == null ? null : clazz.getInstructors(), clazz == null ? null : clazz.getInstructorEmails(), ", "), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getParentSection(), clazz == null ? null : clazz.getParentSection(), CmpMode.SINGLE, selected, clazz == null)), icons);
                                    String style = (selected ? "text-blue" : "") + (lastSize > 0 && rows.size() == lastSize ? " top-border-solid" : (clazzIdx == 0 && !rows.isEmpty() ? " top-border-dashed" : ""));
                                    row.setId(String.valueOf(suggestionId));
                                    for (WebTable.Cell cell : row.getCells()) {
                                        cell.setStyleName(style.trim());
                                    }
                                    row.getCell(0).setStyleName(lastSize > 0 && rows.size() == lastSize ? "top-border-solid" : "");
                                    rows.add(row);
                                    row.setAriaLabel(ARIA.assigned((courseAssignment.isFreeTime() ? MESSAGES.course(MESSAGES.freeTimeSubject(), MESSAGES.freeTimeCourse()) : MESSAGES.clazz(clazz.getSubject(), clazz.getCourseNbr(), clazz.getSubpart(), clazz.getSection())) + " " + clazz.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + clazz.getRooms(", ")));
                                    ++clazzIdx;
                                }
                                continue;
                            }
                            if (sameCourse.isEmpty() || !((ClassAssignmentInterface.ClassAssignment)sameCourse.get(0)).isCourseAssigned()) continue;
                            for (int idx = 0; idx < sameCourse.size(); ++idx) {
                                ClassAssignmentInterface.ClassAssignment old = (ClassAssignmentInterface.ClassAssignment)sameCourse.get(idx);
                                ClassAssignmentInterface.ClassAssignment clazz = null;
                                WebTable.IconsCell icons = new WebTable.IconsCell();
                                if (old != null && old.isSaved()) {
                                    icons.add(RESOURCES.saved(), MESSAGES.saved(MESSAGES.clazz(old.getSubject(), old.getCourseNbr(), old.getSubpart(), old.getSection())));
                                }
                                if (courseAssignment.isLocked()) {
                                    icons.add(RESOURCES.courseLocked(), MESSAGES.courseLocked(courseAssignment.getSubject() + " " + courseAssignment.getCourseNbr()));
                                }
                                if (old != null && old.isOfHighDemand()) {
                                    icons.add(RESOURCES.highDemand(), MESSAGES.highDemand(old.getExpected(), old.getAvailableLimit()));
                                }
                                if (old != null && old.hasNote()) {
                                    icons.add(RESOURCES.note(), old.getNote());
                                }
                                WebTable.Row row = new WebTable.Row(new WebTable.Cell(rows.size() == lastSize ? suggestionId + "." : ""), new WebTable.Cell(idx > 0 ? "" : (courseAssignment.isFreeTime() ? MESSAGES.freeTimeSubject() : courseAssignment.getSubject())).aria(idx == 0 ? "" : (courseAssignment.isFreeTime() ? MESSAGES.freeTimeSubject() : courseAssignment.getSubject())), new WebTable.Cell(idx > 0 ? "" : (courseAssignment.isFreeTime() ? MESSAGES.freeTimeCourse() : courseAssignment.getCourseNbr())).aria(idx == 0 ? "" : (courseAssignment.isFreeTime() ? MESSAGES.freeTimeCourse() : courseAssignment.getCourseNbr())), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getSubpart(), clazz == null ? null : clazz.getSubpart(), CmpMode.SINGLE, false, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getSection(), clazz == null ? null : clazz.getSection(), CmpMode.SINGLE, false, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()), clazz == null ? null : clazz.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()), CmpMode.BOTH_OLD, false, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()), clazz == null ? null : clazz.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()), CmpMode.BOTH_NEW, false, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getDatePattern(), clazz == null ? null : clazz.getDatePattern(), CmpMode.BOTH_OLD, false, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getDatePattern(), clazz == null ? null : clazz.getDatePattern(), CmpMode.BOTH_NEW, false, clazz == null)), old != null && old.hasDistanceConflict() ? new WebTable.IconCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(old.getBackToBackRooms(), old.getBackToBackDistance()), SuggestionsBox.this.compare(old == null ? null : old.getRooms(", "), clazz == null ? null : clazz.getRooms(", "), CmpMode.BOTH_OLD, false, clazz == null)) : new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getRooms(", "), clazz == null ? null : clazz.getRooms(", "), CmpMode.BOTH_OLD, false, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getRooms(", "), clazz == null ? null : clazz.getRooms(", "), CmpMode.BOTH_NEW, false, clazz == null)), new WebTable.InstructorCell(old == null ? null : old.getInstructors(), old == null ? null : old.getInstructorEmails(), ", "), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getParentSection(), clazz == null ? null : clazz.getParentSection(), CmpMode.SINGLE, false, clazz == null)), icons);
                                row.setId(String.valueOf(suggestionId));
                                String style = "text-red" + (lastSize > 0 && rows.size() == lastSize ? " top-border-solid" : (idx == 0 && !rows.isEmpty() ? " top-border-dashed" : ""));
                                for (WebTable.Cell cell : row.getCells()) {
                                    cell.setStyleName(style);
                                }
                                row.getCell(0).setStyleName(lastSize > 0 && rows.size() == lastSize ? "top-border-solid" : "");
                                row.setAriaLabel(ARIA.unassigned((courseAssignment.isFreeTime() ? MESSAGES.course(MESSAGES.freeTimeSubject(), MESSAGES.freeTimeCourse()) : MESSAGES.clazz(old.getSubject(), old.getCourseNbr(), old.getSubpart(), old.getSection())) + " " + old.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + old.getRooms(", ")));
                                rows.add(row);
                            }
                        }
                        Long lastCourseId = null;
                        block11: for (ClassAssignmentInterface.ClassAssignment old : SuggestionsBox.this.iCurrent) {
                            if (old == null || old.isFreeTime()) continue;
                            for (ClassAssignmentInterface.CourseAssignment course3 : suggestion.getCourseAssignments()) {
                                if (!old.getCourseId().equals(course3.getCourseId())) continue;
                                continue block11;
                            }
                            ClassAssignmentInterface.ClassAssignment clazz = null;
                            WebTable.IconsCell icons = new WebTable.IconsCell();
                            if (old != null && old.isSaved()) {
                                icons.add(RESOURCES.saved(), MESSAGES.saved(MESSAGES.clazz(old.getSubject(), old.getCourseNbr(), old.getSubpart(), old.getSection())));
                            }
                            if (old != null && old.isOfHighDemand()) {
                                icons.add(RESOURCES.highDemand(), MESSAGES.highDemand(old.getExpected(), old.getAvailableLimit()));
                            }
                            if (old != null && old.hasNote()) {
                                icons.add(RESOURCES.note(), old.getNote());
                            }
                            WebTable.Row row = new WebTable.Row(new WebTable.Cell(rows.size() == lastSize ? suggestionId + "." : ""), new WebTable.Cell(old.getCourseId().equals(lastCourseId) ? "" : (old.isFreeTime() ? MESSAGES.freeTimeSubject() : old.getSubject())).aria(!old.getCourseId().equals(lastCourseId) ? "" : (old.isFreeTime() ? MESSAGES.freeTimeSubject() : old.getSubject())), new WebTable.Cell(old.getCourseId().equals(lastCourseId) ? "" : (old.isFreeTime() ? MESSAGES.freeTimeCourse() : old.getCourseNbr())).aria(!old.getCourseId().equals(lastCourseId) ? "" : (old.isFreeTime() ? MESSAGES.freeTimeCourse() : old.getCourseNbr())), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getSubpart(), clazz == null ? null : clazz.getSubpart(), CmpMode.SINGLE, false, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getSection(), clazz == null ? null : clazz.getSection(), CmpMode.SINGLE, false, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()), clazz == null ? null : clazz.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()), CmpMode.BOTH_OLD, false, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()), clazz == null ? null : clazz.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()), CmpMode.BOTH_NEW, false, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getDatePattern(), clazz == null ? null : clazz.getDatePattern(), CmpMode.BOTH_OLD, false, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getDatePattern(), clazz == null ? null : clazz.getDatePattern(), CmpMode.BOTH_NEW, false, clazz == null)), old != null && old.hasDistanceConflict() ? new WebTable.IconCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(old.getBackToBackRooms(), old.getBackToBackDistance()), SuggestionsBox.this.compare(old == null ? null : old.getRooms(", "), clazz == null ? null : clazz.getRooms(", "), CmpMode.BOTH_OLD, false, clazz == null)) : new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getRooms(", "), clazz == null ? null : clazz.getRooms(", "), CmpMode.BOTH_OLD, false, clazz == null)), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getRooms(", "), clazz == null ? null : clazz.getRooms(", "), CmpMode.BOTH_NEW, false, clazz == null)), new WebTable.InstructorCell(old == null ? null : old.getInstructors(), old == null ? null : old.getInstructorEmails(), ", "), new WebTable.Cell(SuggestionsBox.this.compare(old == null ? null : old.getParentSection(), clazz == null ? null : clazz.getParentSection(), CmpMode.SINGLE, false, clazz == null)), icons);
                            row.setId(String.valueOf(suggestionId));
                            String style = "text-red" + (lastSize > 0 && rows.size() == lastSize ? " top-border-solid" : (!old.getCourseId().equals(lastCourseId) && !rows.isEmpty() ? " top-border-dashed" : ""));
                            for (WebTable.Cell cell : row.getCells()) {
                                cell.setStyleName(style);
                            }
                            row.getCell(0).setStyleName(lastSize > 0 && rows.size() == lastSize ? " top-border-solid" : "");
                            row.setAriaLabel(ARIA.unassigned((old.isFreeTime() ? MESSAGES.course(MESSAGES.freeTimeSubject(), MESSAGES.freeTimeCourse()) : MESSAGES.clazz(old.getSubject(), old.getCourseNbr(), old.getSubpart(), old.getSection())) + " " + old.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + old.getRooms(", ")));
                            rows.add(row);
                            lastCourseId = old.getCourseId();
                        }
                        lastSize = rows.size();
                        ++suggestionId;
                    }
                    WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
                    int idx = 0;
                    for (WebTable.Row row : rows) {
                        rowArray[idx++] = row;
                    }
                    SuggestionsBox.this.iSuggestions.setData(rowArray);
                    if (rows.isEmpty()) {
                        if (SuggestionsBox.this.iFilter.getText().isEmpty()) {
                            SuggestionsBox.this.iSuggestions.setEmptyMessage(MESSAGES.suggestionsNoAlternative(SuggestionsBox.this.iSource));
                            ariaStatus = ARIA.suggestionsNoAlternative(SuggestionsBox.this.iSource);
                        } else {
                            SuggestionsBox.this.iSuggestions.setEmptyMessage(MESSAGES.suggestionsNoAlternativeWithFilter(SuggestionsBox.this.iSource, SuggestionsBox.this.iFilter.getText()));
                            ariaStatus = ARIA.suggestionsNoAlternativeWithFilter(SuggestionsBox.this.iSource, SuggestionsBox.this.iFilter.getText());
                        }
                    } else {
                        ariaStatus = ARIA.showingAlternatives(Integer.valueOf(((WebTable.Row)rows.get(rows.size() - 1)).getId()), SuggestionsBox.this.iSource);
                    }
                    LoadingWidget.getInstance().hide();
                    SuggestionsBox.this.center();
                    if (ariaStatus != null) {
                        AriaStatus.getInstance().setHTML(ariaStatus);
                    }
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SuggestionsBox.this.iFilter.setFocus(true);
                        }
                    });
                }
            }
        };
        this.iSuggestions.addRowClickHandler(new WebTable.RowClickHandler(){

            public void onRowClick(WebTable.RowClickEvent event) {
                ClassAssignmentInterface suggestion = (ClassAssignmentInterface)SuggestionsBox.this.iResult.get(Integer.parseInt(event.getRow().getId()));
                SuggestionSelectedEvent e = new SuggestionSelectedEvent(suggestion);
                for (SuggestionSelectedHandler h : SuggestionsBox.this.iSuggestionSelectedHandlers) {
                    h.onSuggestionSelected(e);
                }
                SuggestionsBox.this.hide();
            }
        });
        this.iFilter.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeEvent().getKeyCode() == 13) {
                    if (SuggestionsBox.this.iSuggestions.getSelectedRow() >= 0) {
                        ClassAssignmentInterface suggestion = (ClassAssignmentInterface)SuggestionsBox.this.iResult.get(Integer.parseInt(SuggestionsBox.this.iSuggestions.getRows()[SuggestionsBox.this.iSuggestions.getSelectedRow()].getId()));
                        SuggestionSelectedEvent e = new SuggestionSelectedEvent(suggestion);
                        for (SuggestionSelectedHandler h : SuggestionsBox.this.iSuggestionSelectedHandlers) {
                            h.onSuggestionSelected(e);
                        }
                        SuggestionsBox.this.hide();
                    } else {
                        LoadingWidget.getInstance().show(MESSAGES.suggestionsLoading());
                        SuggestionsBox.this.iSectioningService.computeSuggestions(SuggestionsBox.this.iOnline, SuggestionsBox.this.iRequest, SuggestionsBox.this.iCurrent, SuggestionsBox.this.iIndex, SuggestionsBox.this.iFilter.getText(), (AsyncCallback<Collection<ClassAssignmentInterface>>)SuggestionsBox.this.iCallback);
                    }
                }
            }
        });
        this.iSearch.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LoadingWidget.getInstance().show(MESSAGES.suggestionsLoading());
                SuggestionsBox.this.iSectioningService.computeSuggestions(SuggestionsBox.this.iOnline, SuggestionsBox.this.iRequest, SuggestionsBox.this.iCurrent, SuggestionsBox.this.iIndex, SuggestionsBox.this.iFilter.getText(), (AsyncCallback<Collection<ClassAssignmentInterface>>)SuggestionsBox.this.iCallback);
            }
        });
        this.iGrid = new TimeGrid(color);
        this.iHint = new PopupPanel();
        this.iHint.setStyleName("unitime-SuggestionsHint");
        this.iHideHint = new Timer(){

            public void run() {
                if (SuggestionsBox.this.iHint.isShowing()) {
                    SuggestionsBox.this.iHint.hide();
                }
            }
        };
        this.iSuggestions.addRowOverHandler(new WebTable.RowOverHandler(){

            public void onRowOver(final WebTable.RowOverEvent event) {
                SuggestionsBox.this.iHideHint.cancel();
                if (SuggestionsBox.this.iHint.isShowing() && event.getRow().getId().equals(SuggestionsBox.this.iHintId)) {
                    return;
                }
                if (!event.getRow().getId().equals(SuggestionsBox.this.iHintId)) {
                    ClassAssignmentInterface suggestion = (ClassAssignmentInterface)SuggestionsBox.this.iResult.get(Integer.parseInt(event.getRow().getId()));
                    int index = 0;
                    SuggestionsBox.this.iGrid.clear(false);
                    for (ClassAssignmentInterface.CourseAssignment course : suggestion.getCourseAssignments()) {
                        for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                            if (clazz.isFreeTime()) {
                                CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                                ft.setLength(clazz.getLength());
                                ft.setStart(clazz.getStart());
                                for (int d : clazz.getDays()) {
                                    ft.addDay(d);
                                }
                                SuggestionsBox.this.iGrid.addFreeTime(ft);
                                continue;
                            }
                            if (!clazz.isAssigned()) continue;
                            SuggestionsBox.this.iGrid.addClass(clazz, index++);
                        }
                    }
                    TimeGrid w = (TimeGrid)SuggestionsBox.this.iGrid.getPrintWidget();
                    w.addStyleName("unitime-SuggestionsHintWidget");
                    SuggestionsBox.this.iHint.setWidget((Widget)new SimplePanel((Widget)w));
                    SuggestionsBox.this.iHint.setSize(w.getWidth() / 2 + "px", w.getHeight() / 2 + "px");
                    SuggestionsBox.this.iHintId = event.getRow().getId();
                }
                SuggestionsBox.this.iHint.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

                    public void setPosition(int offsetWidth, int offsetHeight) {
                        com.google.gwt.user.client.Element tr = SuggestionsBox.this.iSuggestions.getTable().getRowFormatter().getElement(event.getRowIdx());
                        boolean top = tr.getAbsoluteBottom() - Window.getScrollTop() + 30 + offsetHeight > Window.getClientHeight();
                        SuggestionsBox.this.iHint.setPopupPosition(Math.max(Math.min(event.getEvent().getClientX() + 15, tr.getAbsoluteRight() - offsetWidth - 15), tr.getAbsoluteLeft() + 15), top ? tr.getAbsoluteTop() - offsetHeight - 30 : tr.getAbsoluteBottom() + 30);
                    }
                });
            }
        });
        this.iSuggestions.addRowOutHandler(new WebTable.RowOutHandler(){

            public void onRowOut(WebTable.RowOutEvent event) {
                if (SuggestionsBox.this.iHint.isShowing()) {
                    SuggestionsBox.this.iHideHint.schedule(500);
                }
            }
        });
        this.iSuggestions.addRowMoveHandler(new WebTable.RowMoveHandler(){

            public void onRowMove(WebTable.RowMoveEvent event) {
                if (SuggestionsBox.this.iHint.isShowing()) {
                    if (event.getRowIdx() < 0) {
                        SuggestionsBox.this.iHint.hide();
                        return;
                    }
                    com.google.gwt.user.client.Element tr = SuggestionsBox.this.iSuggestions.getTable().getRowFormatter().getElement(event.getRowIdx());
                    boolean top = tr.getAbsoluteBottom() - Window.getScrollTop() + 30 + SuggestionsBox.this.iHint.getOffsetHeight() > Window.getClientHeight();
                    SuggestionsBox.this.iHint.setPopupPosition(Math.max(Math.min(event.getEvent().getClientX() + 15, tr.getAbsoluteRight() - SuggestionsBox.this.iHint.getOffsetWidth() - 15), tr.getAbsoluteLeft() + 15), top ? tr.getAbsoluteTop() - SuggestionsBox.this.iHint.getOffsetHeight() - 30 : tr.getAbsoluteBottom() + 30);
                }
            }
        });
        this.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                if (SuggestionsBox.this.iHint.isShowing()) {
                    SuggestionsBox.this.iHint.hide();
                }
                SuggestionsBox.this.iHideHint.cancel();
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
                SuggestionsBox.this.iFilterPanel.hideHint();
            }
        });
        this.setWidget((Widget)suggestionPanel);
    }

    @Override
    public void center() {
        super.center();
        RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
    }

    private String compare(String oldVal, String newVal, CmpMode mode, boolean selected, boolean conflict) {
        switch (mode) {
            case ARIA: {
                return newVal != null && !newVal.isEmpty() ? newVal : (oldVal != null ? oldVal : "");
            }
            case SINGLE: {
                return newVal != null && !newVal.isEmpty() ? newVal : (oldVal != null ? "<font color='" + (conflict ? "red" : (selected ? "#9999FF" : "#999999")) + "'>" + oldVal + "</font>" : null);
            }
            case BOTH_OLD: {
                return oldVal == null || oldVal.isEmpty() ? newVal : (newVal == null || newVal.isEmpty() ? "<font color='" + (conflict ? "red" : (selected ? "#9999FF" : "#999999")) + "'>" + oldVal + "</font>" : (oldVal.equals(newVal) ? oldVal : "<font color='" + (selected ? "#9999FF" : "#999999") + "'>" + oldVal + "</font>"));
            }
            case BOTH_NEW: {
                return oldVal != null && !oldVal.isEmpty() && newVal != null && !newVal.isEmpty() && !newVal.equals(oldVal) ? "<font color='#" + (selected ? "#9999FF" : "#999999") + "'>&rarr;</font> " + newVal : null;
            }
        }
        return newVal;
    }

    public void open(CourseRequestInterface request, ArrayList<ClassAssignmentInterface.ClassAssignment> rows, int index) {
        ClassAssignmentInterface.ClassAssignment row;
        LoadingWidget.getInstance().show(MESSAGES.suggestionsLoading());
        this.iAssignment = row = rows.get(index);
        this.iCurrent = rows;
        this.iSource = null;
        this.iRequest = request;
        this.iIndex = index;
        this.iHintId = null;
        this.iSource = row.isFreeTime() ? MESSAGES.freeTime(row.getDaysString(CONSTANTS.shortDays()), row.getStartString(CONSTANTS.useAmPm()), row.getEndString(CONSTANTS.useAmPm())) : (row.getSubpart() == null ? MESSAGES.course(row.getSubject(), row.getCourseNbr()) : MESSAGES.clazz(row.getSubject(), row.getCourseNbr(), row.getSubpart(), row.getSection()));
        this.setText(MESSAGES.suggestionsAlternatives(this.iSource));
        this.iSuggestions.setSelectedRow(-1);
        this.iSuggestions.clearData(true);
        this.iSuggestions.setEmptyMessage(MESSAGES.suggestionsLoading());
        this.iLegend.setHTML(row.isFreeTime() ? MESSAGES.suggestionsLegendOnFreeTime(row.getDaysString(CONSTANTS.shortDays()) + " " + row.getStartString(CONSTANTS.useAmPm()) + " - " + row.getEndString(CONSTANTS.useAmPm())) : (row.isAssigned() ? MESSAGES.suggestionsLegendOnClass(MESSAGES.clazz(row.getSubject(), row.getCourseNbr(), row.getSubpart(), row.getSection())) : MESSAGES.suggestionsLegendOnCourse(MESSAGES.course(row.getSubject(), row.getCourseNbr()))));
        this.iMessages.setHTML("");
        this.iFilter.setText("");
        this.iSectioningService.computeSuggestions(this.iOnline, request, rows, index, this.iFilter.getText(), this.iCallback);
    }

    @Override
    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        super.onPreviewNativeEvent(event);
        switch (DOM.eventGetType((Event)((Event)event.getNativeEvent()))) {
            case 512: {
                ClassAssignmentInterface suggestion;
                if (event.getNativeEvent().getKeyCode() == 27) {
                    this.hide();
                }
                if (event.getNativeEvent().getKeyCode() == 40 && this.iSuggestions.getRowsCount() > 0) {
                    String id = this.iSuggestions.getSelectedRow() < 0 ? null : this.iSuggestions.getRows()[this.iSuggestions.getSelectedRow()].getId();
                    int row = this.iSuggestions.getSelectedRow() + 1;
                    while (id != null && id.equals(this.iSuggestions.getRows()[row % this.iSuggestions.getRowsCount()].getId())) {
                        ++row;
                    }
                    this.iSuggestions.setSelectedRow(row % this.iSuggestions.getRowsCount());
                    suggestion = this.iResult.get(Integer.parseInt(this.iSuggestions.getRows()[this.iSuggestions.getSelectedRow()].getId()));
                    AriaStatus.getInstance().setText(ARIA.showingAlternative(Integer.parseInt(this.iSuggestions.getRows()[this.iSuggestions.getSelectedRow()].getId()), Integer.parseInt(this.iSuggestions.getRows()[this.iSuggestions.getRows().length - 1].getId()), this.toString(suggestion)));
                }
                if (event.getNativeEvent().getKeyCode() == 38 && this.iSuggestions.getRowsCount() > 0) {
                    int row = this.iSuggestions.getSelectedRow() <= 0 ? this.iSuggestions.getRowsCount() - 1 : this.iSuggestions.getSelectedRow() - 1;
                    String id = this.iSuggestions.getRows()[row % this.iSuggestions.getRowsCount()].getId();
                    while (id.equals(this.iSuggestions.getRows()[(this.iSuggestions.getRowsCount() + row - 1) % this.iSuggestions.getRowsCount()].getId())) {
                        --row;
                    }
                    this.iSuggestions.setSelectedRow((this.iSuggestions.getRowsCount() + row) % this.iSuggestions.getRowsCount());
                    suggestion = this.iResult.get(Integer.parseInt(this.iSuggestions.getRows()[this.iSuggestions.getSelectedRow()].getId()));
                    AriaStatus.getInstance().setText(ARIA.showingAlternative(Integer.parseInt(this.iSuggestions.getRows()[this.iSuggestions.getSelectedRow()].getId()), Integer.parseInt(this.iSuggestions.getRows()[this.iSuggestions.getRows().length - 1].getId()), this.toString(suggestion)));
                }
                if (event.getNativeEvent().getKeyCode() != 13 || this.iSuggestions.getSelectedRow() < 0) break;
                ClassAssignmentInterface suggestion2 = this.iResult.get(Integer.parseInt(this.iSuggestions.getRows()[this.iSuggestions.getSelectedRow()].getId()));
                AriaStatus.getInstance().setText(ARIA.selectedAlternative(this.toString(suggestion2)));
                SuggestionSelectedEvent e = new SuggestionSelectedEvent(suggestion2);
                for (SuggestionSelectedHandler h : this.iSuggestionSelectedHandlers) {
                    h.onSuggestionSelected(e);
                }
                this.hide();
            }
        }
    }

    private String toString(ClassAssignmentInterface suggestion) {
        String ret = "";
        for (ClassAssignmentInterface.CourseAssignment course : suggestion.getCourseAssignments()) {
            ArrayList<ClassAssignmentInterface.ClassAssignment> sameCourse = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
            if (!course.isFreeTime()) {
                for (ClassAssignmentInterface.ClassAssignment classAssignment : this.iCurrent) {
                    if (classAssignment == null || !course.getCourseId().equals(classAssignment.getCourseId())) continue;
                    sameCourse.add(classAssignment);
                }
            } else {
                ClassAssignmentInterface.ClassAssignment clazz = course.getClassAssignments().get(0);
                for (ClassAssignmentInterface.ClassAssignment x2 : this.iCurrent) {
                    if (x2 == null || !x2.isFreeTime() || !x2.getDaysString(CONSTANTS.shortDays()).equals(clazz.getDaysString(CONSTANTS.shortDays())) || x2.getStart() != clazz.getStart() || x2.getLength() != clazz.getLength()) continue;
                    sameCourse.add(x2);
                }
            }
            if (course.isAssigned()) {
                block3: for (ClassAssignmentInterface.ClassAssignment classAssignment : course.getClassAssignments()) {
                    for (ClassAssignmentInterface.ClassAssignment x : this.iCurrent) {
                        if (x == null) continue;
                        if (course.isFreeTime()) {
                            if (!x.isFreeTime() || !x.isCourseAssigned() || !x.getDaysString(CONSTANTS.shortDays()).equals(classAssignment.getDaysString(CONSTANTS.shortDays())) || x.getStart() != classAssignment.getStart() || x.getLength() != classAssignment.getLength()) continue;
                            continue block3;
                        }
                        if (classAssignment.getCourseId().equals(x.getCourseId()) && classAssignment.getClassId().equals(x.getClassId())) continue block3;
                        if (!classAssignment.getCourseId().equals(x.getCourseId()) || !classAssignment.getSubpartId().equals(x.getSubpartId())) continue;
                        break;
                    }
                    ret = ret + ARIA.assigned((course.isFreeTime() ? MESSAGES.course(MESSAGES.freeTimeSubject(), MESSAGES.freeTimeCourse()) : MESSAGES.clazz(classAssignment.getSubject(), classAssignment.getCourseNbr(), classAssignment.getSubpart(), classAssignment.getSection())) + " " + classAssignment.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + classAssignment.getRooms(", "));
                }
                continue;
            }
            if (sameCourse.isEmpty() || !((ClassAssignmentInterface.ClassAssignment)sameCourse.get(0)).isCourseAssigned()) continue;
            for (int idx = 0; idx < sameCourse.size(); ++idx) {
                ClassAssignmentInterface.ClassAssignment classAssignment = (ClassAssignmentInterface.ClassAssignment)sameCourse.get(idx);
                ret = ret + ARIA.unassigned((course.isFreeTime() ? MESSAGES.course(MESSAGES.freeTimeSubject(), MESSAGES.freeTimeCourse()) : MESSAGES.clazz(classAssignment.getSubject(), classAssignment.getCourseNbr(), classAssignment.getSubpart(), classAssignment.getSection())) + " " + classAssignment.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + classAssignment.getRooms(", "));
            }
        }
        block6: for (ClassAssignmentInterface.ClassAssignment old : this.iCurrent) {
            if (old == null || old.isFreeTime()) continue;
            for (ClassAssignmentInterface.CourseAssignment course : suggestion.getCourseAssignments()) {
                if (!old.getCourseId().equals(course.getCourseId())) continue;
                continue block6;
            }
            ret = ret + ARIA.unassigned((old.isFreeTime() ? MESSAGES.course(MESSAGES.freeTimeSubject(), MESSAGES.freeTimeCourse()) : MESSAGES.clazz(old.getSubject(), old.getCourseNbr(), old.getSubpart(), old.getSection())) + " " + old.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + old.getRooms(", "));
        }
        return ret;
    }

    public void addSuggestionSelectedHandler(SuggestionSelectedHandler h) {
        this.iSuggestionSelectedHandlers.add(h);
    }

    public class SuggestionSelectedEvent {
        private ClassAssignmentInterface iSuggestion;

        private SuggestionSelectedEvent(ClassAssignmentInterface suggestion) {
            this.iSuggestion = suggestion;
        }

        public ClassAssignmentInterface getSuggestion() {
            return this.iSuggestion;
        }
    }

    public static interface SuggestionSelectedHandler {
        public void onSuggestionSelected(SuggestionSelectedEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CmpMode {
        SINGLE,
        BOTH_OLD,
        BOTH_NEW,
        ARIA;

    }
}

